/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * An interconnect group resource allows customers to create, analyze, and expand their redundant connections.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.InterconnectGroup}
 */
public final class InterconnectGroup extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectGroup)
    InterconnectGroupOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectGroup.newBuilder() to construct.
  private InterconnectGroup(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectGroup() {
    creationTimestamp_ = "";
    description_ = "";
    etag_ = "";
    kind_ = "";
    name_ = "";
    selfLink_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectGroup();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroup_descriptor;
  }

  @SuppressWarnings({"rawtypes"})
  @java.lang.Override
  protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
      int number) {
    switch (number) {
      case 520187301:
        return internalGetInterconnects();
      default:
        throw new RuntimeException("Invalid map field number: " + number);
    }
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectGroup_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.InterconnectGroup.class,
            com.google.cloud.compute.v1.InterconnectGroup.Builder.class);
  }

  private int bitField0_;
  public static final int CONFIGURED_FIELD_NUMBER = 295631422;
  private com.google.cloud.compute.v1.InterconnectGroupConfigured configured_;

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
   * </code>
   *
   * @return Whether the configured field is set.
   */
  @java.lang.Override
  public boolean hasConfigured() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
   * </code>
   *
   * @return The configured.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupConfigured getConfigured() {
    return configured_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupConfigured.getDefaultInstance()
        : configured_;
  }

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupConfiguredOrBuilder getConfiguredOrBuilder() {
    return configured_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupConfigured.getDefaultInstance()
        : configured_;
  }

  public static final int CREATION_TIMESTAMP_FIELD_NUMBER = 30525366;

  @SuppressWarnings("serial")
  private volatile java.lang.Object creationTimestamp_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  @java.lang.Override
  public boolean hasCreationTimestamp() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  @java.lang.Override
  public java.lang.String getCreationTimestamp() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      creationTimestamp_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCreationTimestampBytes() {
    java.lang.Object ref = creationTimestamp_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      creationTimestamp_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 422937596;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  @java.lang.Override
  public boolean hasDescription() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ETAG_FIELD_NUMBER = 3123477;

  @SuppressWarnings("serial")
  private volatile java.lang.Object etag_ = "";

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return Whether the etag field is set.
   */
  @java.lang.Override
  public boolean hasEtag() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The etag.
   */
  @java.lang.Override
  public java.lang.String getEtag() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      etag_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
   * </pre>
   *
   * <code>optional string etag = 3123477;</code>
   *
   * @return The bytes for etag.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getEtagBytes() {
    java.lang.Object ref = etag_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      etag_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ID_FIELD_NUMBER = 3355;
  private long id_ = 0L;

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  @java.lang.Override
  public boolean hasId() {
    return ((bitField0_ & 0x00000010) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource type. The server generates this identifier.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  @java.lang.Override
  public long getId() {
    return id_;
  }

  public static final int INTENT_FIELD_NUMBER = 426849948;
  private com.google.cloud.compute.v1.InterconnectGroupIntent intent_;

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
   *
   * @return Whether the intent field is set.
   */
  @java.lang.Override
  public boolean hasIntent() {
    return ((bitField0_ & 0x00000020) != 0);
  }

  /**
   * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
   *
   * @return The intent.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupIntent getIntent() {
    return intent_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupIntent.getDefaultInstance()
        : intent_;
  }

  /** <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code> */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupIntentOrBuilder getIntentOrBuilder() {
    return intent_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupIntent.getDefaultInstance()
        : intent_;
  }

  public static final int INTERCONNECTS_FIELD_NUMBER = 520187301;

  private static final class InterconnectsDefaultEntryHolder {
    static final com.google.protobuf.MapEntry<
            java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
        defaultEntry =
            com.google.protobuf.MapEntry
                .<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
                    newDefaultInstance(
                        com.google.cloud.compute.v1.Compute
                            .internal_static_google_cloud_compute_v1_InterconnectGroup_InterconnectsEntry_descriptor,
                        com.google.protobuf.WireFormat.FieldType.STRING,
                        "",
                        com.google.protobuf.WireFormat.FieldType.MESSAGE,
                        com.google.cloud.compute.v1.InterconnectGroupInterconnect
                            .getDefaultInstance());
  }

  @SuppressWarnings("serial")
  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
      interconnects_;

  private com.google.protobuf.MapField<
          java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
      internalGetInterconnects() {
    if (interconnects_ == null) {
      return com.google.protobuf.MapField.emptyMapField(
          InterconnectsDefaultEntryHolder.defaultEntry);
    }
    return interconnects_;
  }

  public int getInterconnectsCount() {
    return internalGetInterconnects().getMap().size();
  }

  /**
   *
   *
   * <pre>
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
   * </code>
   */
  @java.lang.Override
  public boolean containsInterconnects(java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    return internalGetInterconnects().getMap().containsKey(key);
  }

  /** Use {@link #getInterconnectsMap()} instead. */
  @java.lang.Override
  @java.lang.Deprecated
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
      getInterconnects() {
    return getInterconnectsMap();
  }

  /**
   *
   *
   * <pre>
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
   * </code>
   */
  @java.lang.Override
  public java.util.Map<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
      getInterconnectsMap() {
    return internalGetInterconnects().getMap();
  }

  /**
   *
   *
   * <pre>
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
   * </code>
   */
  @java.lang.Override
  public /* nullable */ com.google.cloud.compute.v1.InterconnectGroupInterconnect
      getInterconnectsOrDefault(
          java.lang.String key,
          /* nullable */
          com.google.cloud.compute.v1.InterconnectGroupInterconnect defaultValue) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect> map =
        internalGetInterconnects().getMap();
    return map.containsKey(key) ? map.get(key) : defaultValue;
  }

  /**
   *
   *
   * <pre>
   * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
   * </pre>
   *
   * <code>
   * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupInterconnect getInterconnectsOrThrow(
      java.lang.String key) {
    if (key == null) {
      throw new NullPointerException("map key");
    }
    java.util.Map<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect> map =
        internalGetInterconnects().getMap();
    if (!map.containsKey(key)) {
      throw new java.lang.IllegalArgumentException();
    }
    return map.get(key);
  }

  public static final int KIND_FIELD_NUMBER = 3292052;

  @SuppressWarnings("serial")
  private volatile java.lang.Object kind_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  @java.lang.Override
  public boolean hasKind() {
    return ((bitField0_ & 0x00000040) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  @java.lang.Override
  public java.lang.String getKind() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      kind_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Type of the resource. Always compute#InterconnectGroup
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getKindBytes() {
    java.lang.Object ref = kind_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      kind_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int NAME_FIELD_NUMBER = 3373707;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  @java.lang.Override
  public boolean hasName() {
    return ((bitField0_ & 0x00000080) != 0);
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int PHYSICAL_STRUCTURE_FIELD_NUMBER = 195307531;
  private com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure physicalStructure_;

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
   * </code>
   *
   * @return Whether the physicalStructure field is set.
   */
  @java.lang.Override
  public boolean hasPhysicalStructure() {
    return ((bitField0_ & 0x00000100) != 0);
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
   * </code>
   *
   * @return The physicalStructure.
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure getPhysicalStructure() {
    return physicalStructure_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.getDefaultInstance()
        : physicalStructure_;
  }

  /**
   * <code>
   * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroupPhysicalStructureOrBuilder
      getPhysicalStructureOrBuilder() {
    return physicalStructure_ == null
        ? com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.getDefaultInstance()
        : physicalStructure_;
  }

  public static final int SELF_LINK_FIELD_NUMBER = 456214797;

  @SuppressWarnings("serial")
  private volatile java.lang.Object selfLink_ = "";

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  @java.lang.Override
  public boolean hasSelfLink() {
    return ((bitField0_ & 0x00000200) != 0);
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  @java.lang.Override
  public java.lang.String getSelfLink() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      selfLink_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getSelfLinkBytes() {
    java.lang.Object ref = selfLink_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      selfLink_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000010) != 0)) {
      output.writeUInt64(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3123477, etag_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      output.writeMessage(195307531, getPhysicalStructure());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(295631422, getConfigured());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 422937596, description_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      output.writeMessage(426849948, getIntent());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 456214797, selfLink_);
    }
    com.google.protobuf.GeneratedMessageV3.serializeStringMapTo(
        output,
        internalGetInterconnects(),
        InterconnectsDefaultEntryHolder.defaultEntry,
        520187301);
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000010) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeUInt64Size(3355, id_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3123477, etag_);
    }
    if (((bitField0_ & 0x00000040) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3292052, kind_);
    }
    if (((bitField0_ & 0x00000080) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3373707, name_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size +=
          com.google.protobuf.GeneratedMessageV3.computeStringSize(30525366, creationTimestamp_);
    }
    if (((bitField0_ & 0x00000100) != 0)) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              195307531, getPhysicalStructure());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(295631422, getConfigured());
    }
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(422937596, description_);
    }
    if (((bitField0_ & 0x00000020) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(426849948, getIntent());
    }
    if (((bitField0_ & 0x00000200) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(456214797, selfLink_);
    }
    for (java.util.Map.Entry<
            java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
        entry : internalGetInterconnects().getMap().entrySet()) {
      com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
          interconnects__ =
              InterconnectsDefaultEntryHolder.defaultEntry
                  .newBuilderForType()
                  .setKey(entry.getKey())
                  .setValue(entry.getValue())
                  .build();
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(520187301, interconnects__);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.InterconnectGroup)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectGroup other =
        (com.google.cloud.compute.v1.InterconnectGroup) obj;

    if (hasConfigured() != other.hasConfigured()) return false;
    if (hasConfigured()) {
      if (!getConfigured().equals(other.getConfigured())) return false;
    }
    if (hasCreationTimestamp() != other.hasCreationTimestamp()) return false;
    if (hasCreationTimestamp()) {
      if (!getCreationTimestamp().equals(other.getCreationTimestamp())) return false;
    }
    if (hasDescription() != other.hasDescription()) return false;
    if (hasDescription()) {
      if (!getDescription().equals(other.getDescription())) return false;
    }
    if (hasEtag() != other.hasEtag()) return false;
    if (hasEtag()) {
      if (!getEtag().equals(other.getEtag())) return false;
    }
    if (hasId() != other.hasId()) return false;
    if (hasId()) {
      if (getId() != other.getId()) return false;
    }
    if (hasIntent() != other.hasIntent()) return false;
    if (hasIntent()) {
      if (!getIntent().equals(other.getIntent())) return false;
    }
    if (!internalGetInterconnects().equals(other.internalGetInterconnects())) return false;
    if (hasKind() != other.hasKind()) return false;
    if (hasKind()) {
      if (!getKind().equals(other.getKind())) return false;
    }
    if (hasName() != other.hasName()) return false;
    if (hasName()) {
      if (!getName().equals(other.getName())) return false;
    }
    if (hasPhysicalStructure() != other.hasPhysicalStructure()) return false;
    if (hasPhysicalStructure()) {
      if (!getPhysicalStructure().equals(other.getPhysicalStructure())) return false;
    }
    if (hasSelfLink() != other.hasSelfLink()) return false;
    if (hasSelfLink()) {
      if (!getSelfLink().equals(other.getSelfLink())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasConfigured()) {
      hash = (37 * hash) + CONFIGURED_FIELD_NUMBER;
      hash = (53 * hash) + getConfigured().hashCode();
    }
    if (hasCreationTimestamp()) {
      hash = (37 * hash) + CREATION_TIMESTAMP_FIELD_NUMBER;
      hash = (53 * hash) + getCreationTimestamp().hashCode();
    }
    if (hasDescription()) {
      hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
      hash = (53 * hash) + getDescription().hashCode();
    }
    if (hasEtag()) {
      hash = (37 * hash) + ETAG_FIELD_NUMBER;
      hash = (53 * hash) + getEtag().hashCode();
    }
    if (hasId()) {
      hash = (37 * hash) + ID_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getId());
    }
    if (hasIntent()) {
      hash = (37 * hash) + INTENT_FIELD_NUMBER;
      hash = (53 * hash) + getIntent().hashCode();
    }
    if (!internalGetInterconnects().getMap().isEmpty()) {
      hash = (37 * hash) + INTERCONNECTS_FIELD_NUMBER;
      hash = (53 * hash) + internalGetInterconnects().hashCode();
    }
    if (hasKind()) {
      hash = (37 * hash) + KIND_FIELD_NUMBER;
      hash = (53 * hash) + getKind().hashCode();
    }
    if (hasName()) {
      hash = (37 * hash) + NAME_FIELD_NUMBER;
      hash = (53 * hash) + getName().hashCode();
    }
    if (hasPhysicalStructure()) {
      hash = (37 * hash) + PHYSICAL_STRUCTURE_FIELD_NUMBER;
      hash = (53 * hash) + getPhysicalStructure().hashCode();
    }
    if (hasSelfLink()) {
      hash = (37 * hash) + SELF_LINK_FIELD_NUMBER;
      hash = (53 * hash) + getSelfLink().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.InterconnectGroup parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.InterconnectGroup prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * An interconnect group resource allows customers to create, analyze, and expand their redundant connections.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.InterconnectGroup}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectGroup)
      com.google.cloud.compute.v1.InterconnectGroupOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroup_descriptor;
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMapFieldReflection(
        int number) {
      switch (number) {
        case 520187301:
          return internalGetInterconnects();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @SuppressWarnings({"rawtypes"})
    protected com.google.protobuf.MapFieldReflectionAccessor internalGetMutableMapFieldReflection(
        int number) {
      switch (number) {
        case 520187301:
          return internalGetMutableInterconnects();
        default:
          throw new RuntimeException("Invalid map field number: " + number);
      }
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroup_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.InterconnectGroup.class,
              com.google.cloud.compute.v1.InterconnectGroup.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.InterconnectGroup.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getConfiguredFieldBuilder();
        getIntentFieldBuilder();
        getPhysicalStructureFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      configured_ = null;
      if (configuredBuilder_ != null) {
        configuredBuilder_.dispose();
        configuredBuilder_ = null;
      }
      creationTimestamp_ = "";
      description_ = "";
      etag_ = "";
      id_ = 0L;
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      internalGetMutableInterconnects().clear();
      kind_ = "";
      name_ = "";
      physicalStructure_ = null;
      if (physicalStructureBuilder_ != null) {
        physicalStructureBuilder_.dispose();
        physicalStructureBuilder_ = null;
      }
      selfLink_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectGroup_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroup getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.InterconnectGroup.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroup build() {
      com.google.cloud.compute.v1.InterconnectGroup result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroup buildPartial() {
      com.google.cloud.compute.v1.InterconnectGroup result =
          new com.google.cloud.compute.v1.InterconnectGroup(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.InterconnectGroup result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.configured_ = configuredBuilder_ == null ? configured_ : configuredBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.creationTimestamp_ = creationTimestamp_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.etag_ = etag_;
        to_bitField0_ |= 0x00000008;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.id_ = id_;
        to_bitField0_ |= 0x00000010;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.intent_ = intentBuilder_ == null ? intent_ : intentBuilder_.build();
        to_bitField0_ |= 0x00000020;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.interconnects_ =
            internalGetInterconnects().build(InterconnectsDefaultEntryHolder.defaultEntry);
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.kind_ = kind_;
        to_bitField0_ |= 0x00000040;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.name_ = name_;
        to_bitField0_ |= 0x00000080;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.physicalStructure_ =
            physicalStructureBuilder_ == null
                ? physicalStructure_
                : physicalStructureBuilder_.build();
        to_bitField0_ |= 0x00000100;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.selfLink_ = selfLink_;
        to_bitField0_ |= 0x00000200;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.InterconnectGroup) {
        return mergeFrom((com.google.cloud.compute.v1.InterconnectGroup) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.InterconnectGroup other) {
      if (other == com.google.cloud.compute.v1.InterconnectGroup.getDefaultInstance()) return this;
      if (other.hasConfigured()) {
        mergeConfigured(other.getConfigured());
      }
      if (other.hasCreationTimestamp()) {
        creationTimestamp_ = other.creationTimestamp_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDescription()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasEtag()) {
        etag_ = other.etag_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      if (other.hasId()) {
        setId(other.getId());
      }
      if (other.hasIntent()) {
        mergeIntent(other.getIntent());
      }
      internalGetMutableInterconnects().mergeFrom(other.internalGetInterconnects());
      bitField0_ |= 0x00000040;
      if (other.hasKind()) {
        kind_ = other.kind_;
        bitField0_ |= 0x00000080;
        onChanged();
      }
      if (other.hasName()) {
        name_ = other.name_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasPhysicalStructure()) {
        mergePhysicalStructure(other.getPhysicalStructure());
      }
      if (other.hasSelfLink()) {
        selfLink_ = other.selfLink_;
        bitField0_ |= 0x00000400;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 26840:
              {
                id_ = input.readUInt64();
                bitField0_ |= 0x00000010;
                break;
              } // case 26840
            case 24987818:
              {
                etag_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 24987818
            case 26336418:
              {
                kind_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000080;
                break;
              } // case 26336418
            case 26989658:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 26989658
            case 244202930:
              {
                creationTimestamp_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 244202930
            case 1562460250:
              {
                input.readMessage(
                    getPhysicalStructureFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 1562460250
            case -1929915918:
              {
                input.readMessage(getConfiguredFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case -1929915918
            case -911466526:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case -911466526
            case -880167710:
              {
                input.readMessage(getIntentFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000020;
                break;
              } // case -880167710
            case -645248918:
              {
                selfLink_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000400;
                break;
              } // case -645248918
            case -133468886:
              {
                com.google.protobuf.MapEntry<
                        java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
                    interconnects__ =
                        input.readMessage(
                            InterconnectsDefaultEntryHolder.defaultEntry.getParserForType(),
                            extensionRegistry);
                internalGetMutableInterconnects()
                    .ensureBuilderMap()
                    .put(interconnects__.getKey(), interconnects__.getValue());
                bitField0_ |= 0x00000040;
                break;
              } // case -133468886
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.cloud.compute.v1.InterconnectGroupConfigured configured_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupConfigured,
            com.google.cloud.compute.v1.InterconnectGroupConfigured.Builder,
            com.google.cloud.compute.v1.InterconnectGroupConfiguredOrBuilder>
        configuredBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     *
     * @return Whether the configured field is set.
     */
    public boolean hasConfigured() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     *
     * @return The configured.
     */
    public com.google.cloud.compute.v1.InterconnectGroupConfigured getConfigured() {
      if (configuredBuilder_ == null) {
        return configured_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupConfigured.getDefaultInstance()
            : configured_;
      } else {
        return configuredBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder setConfigured(com.google.cloud.compute.v1.InterconnectGroupConfigured value) {
      if (configuredBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        configured_ = value;
      } else {
        configuredBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder setConfigured(
        com.google.cloud.compute.v1.InterconnectGroupConfigured.Builder builderForValue) {
      if (configuredBuilder_ == null) {
        configured_ = builderForValue.build();
      } else {
        configuredBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder mergeConfigured(com.google.cloud.compute.v1.InterconnectGroupConfigured value) {
      if (configuredBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && configured_ != null
            && configured_
                != com.google.cloud.compute.v1.InterconnectGroupConfigured.getDefaultInstance()) {
          getConfiguredBuilder().mergeFrom(value);
        } else {
          configured_ = value;
        }
      } else {
        configuredBuilder_.mergeFrom(value);
      }
      if (configured_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public Builder clearConfigured() {
      bitField0_ = (bitField0_ & ~0x00000001);
      configured_ = null;
      if (configuredBuilder_ != null) {
        configuredBuilder_.dispose();
        configuredBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupConfigured.Builder getConfiguredBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getConfiguredFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupConfiguredOrBuilder
        getConfiguredOrBuilder() {
      if (configuredBuilder_ != null) {
        return configuredBuilder_.getMessageOrBuilder();
      } else {
        return configured_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupConfigured.getDefaultInstance()
            : configured_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupConfigured configured = 295631422;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupConfigured,
            com.google.cloud.compute.v1.InterconnectGroupConfigured.Builder,
            com.google.cloud.compute.v1.InterconnectGroupConfiguredOrBuilder>
        getConfiguredFieldBuilder() {
      if (configuredBuilder_ == null) {
        configuredBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectGroupConfigured,
                com.google.cloud.compute.v1.InterconnectGroupConfigured.Builder,
                com.google.cloud.compute.v1.InterconnectGroupConfiguredOrBuilder>(
                getConfigured(), getParentForChildren(), isClean());
        configured_ = null;
      }
      return configuredBuilder_;
    }

    private java.lang.Object creationTimestamp_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return Whether the creationTimestamp field is set.
     */
    public boolean hasCreationTimestamp() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The creationTimestamp.
     */
    public java.lang.String getCreationTimestamp() {
      java.lang.Object ref = creationTimestamp_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        creationTimestamp_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return The bytes for creationTimestamp.
     */
    public com.google.protobuf.ByteString getCreationTimestampBytes() {
      java.lang.Object ref = creationTimestamp_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        creationTimestamp_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestamp(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCreationTimestamp() {
      creationTimestamp_ = getDefaultInstance().getCreationTimestamp();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Creation timestamp in RFC3339 text format.
     * </pre>
     *
     * <code>optional string creation_timestamp = 30525366;</code>
     *
     * @param value The bytes for creationTimestamp to set.
     * @return This builder for chaining.
     */
    public Builder setCreationTimestampBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      creationTimestamp_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return Whether the description field is set.
     */
    public boolean hasDescription() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * An optional description of this resource. Provide this property when you create the resource.
     * </pre>
     *
     * <code>optional string description = 422937596;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object etag_ = "";

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return Whether the etag field is set.
     */
    public boolean hasEtag() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The etag.
     */
    public java.lang.String getEtag() {
      java.lang.Object ref = etag_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        etag_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return The bytes for etag.
     */
    public com.google.protobuf.ByteString getEtagBytes() {
      java.lang.Object ref = etag_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        etag_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtag(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearEtag() {
      etag_ = getDefaultInstance().getEtag();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Opaque system-generated token that uniquely identifies the configuration. If provided when patching a configuration in update mode, the provided token must match the current token or the update is rejected. This provides a reliable means of doing read-modify-write (optimistic locking) as described by API 154.
     * </pre>
     *
     * <code>optional string etag = 3123477;</code>
     *
     * @param value The bytes for etag to set.
     * @return This builder for chaining.
     */
    public Builder setEtagBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      etag_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    private long id_;

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return Whether the id field is set.
     */
    @java.lang.Override
    public boolean hasId() {
      return ((bitField0_ & 0x00000010) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return The id.
     */
    @java.lang.Override
    public long getId() {
      return id_;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @param value The id to set.
     * @return This builder for chaining.
     */
    public Builder setId(long value) {

      id_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] The unique identifier for the resource type. The server generates this identifier.
     * </pre>
     *
     * <code>optional uint64 id = 3355;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearId() {
      bitField0_ = (bitField0_ & ~0x00000010);
      id_ = 0L;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectGroupIntent intent_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupIntent,
            com.google.cloud.compute.v1.InterconnectGroupIntent.Builder,
            com.google.cloud.compute.v1.InterconnectGroupIntentOrBuilder>
        intentBuilder_;

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     *
     * @return Whether the intent field is set.
     */
    public boolean hasIntent() {
      return ((bitField0_ & 0x00000020) != 0);
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     *
     * @return The intent.
     */
    public com.google.cloud.compute.v1.InterconnectGroupIntent getIntent() {
      if (intentBuilder_ == null) {
        return intent_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupIntent.getDefaultInstance()
            : intent_;
      } else {
        return intentBuilder_.getMessage();
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public Builder setIntent(com.google.cloud.compute.v1.InterconnectGroupIntent value) {
      if (intentBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        intent_ = value;
      } else {
        intentBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public Builder setIntent(
        com.google.cloud.compute.v1.InterconnectGroupIntent.Builder builderForValue) {
      if (intentBuilder_ == null) {
        intent_ = builderForValue.build();
      } else {
        intentBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public Builder mergeIntent(com.google.cloud.compute.v1.InterconnectGroupIntent value) {
      if (intentBuilder_ == null) {
        if (((bitField0_ & 0x00000020) != 0)
            && intent_ != null
            && intent_
                != com.google.cloud.compute.v1.InterconnectGroupIntent.getDefaultInstance()) {
          getIntentBuilder().mergeFrom(value);
        } else {
          intent_ = value;
        }
      } else {
        intentBuilder_.mergeFrom(value);
      }
      if (intent_ != null) {
        bitField0_ |= 0x00000020;
        onChanged();
      }
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public Builder clearIntent() {
      bitField0_ = (bitField0_ & ~0x00000020);
      intent_ = null;
      if (intentBuilder_ != null) {
        intentBuilder_.dispose();
        intentBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupIntent.Builder getIntentBuilder() {
      bitField0_ |= 0x00000020;
      onChanged();
      return getIntentFieldBuilder().getBuilder();
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupIntentOrBuilder getIntentOrBuilder() {
      if (intentBuilder_ != null) {
        return intentBuilder_.getMessageOrBuilder();
      } else {
        return intent_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupIntent.getDefaultInstance()
            : intent_;
      }
    }

    /**
     * <code>optional .google.cloud.compute.v1.InterconnectGroupIntent intent = 426849948;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupIntent,
            com.google.cloud.compute.v1.InterconnectGroupIntent.Builder,
            com.google.cloud.compute.v1.InterconnectGroupIntentOrBuilder>
        getIntentFieldBuilder() {
      if (intentBuilder_ == null) {
        intentBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectGroupIntent,
                com.google.cloud.compute.v1.InterconnectGroupIntent.Builder,
                com.google.cloud.compute.v1.InterconnectGroupIntentOrBuilder>(
                getIntent(), getParentForChildren(), isClean());
        intent_ = null;
      }
      return intentBuilder_;
    }

    private static final class InterconnectsConverter
        implements com.google.protobuf.MapFieldBuilder.Converter<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect> {
      @java.lang.Override
      public com.google.cloud.compute.v1.InterconnectGroupInterconnect build(
          com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder val) {
        if (val instanceof com.google.cloud.compute.v1.InterconnectGroupInterconnect) {
          return (com.google.cloud.compute.v1.InterconnectGroupInterconnect) val;
        }
        return ((com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder) val).build();
      }

      @java.lang.Override
      public com.google.protobuf.MapEntry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
          defaultEntry() {
        return InterconnectsDefaultEntryHolder.defaultEntry;
      }
    }
    ;

    private static final InterconnectsConverter interconnectsConverter =
        new InterconnectsConverter();

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder>
        interconnects_;

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder>
        internalGetInterconnects() {
      if (interconnects_ == null) {
        return new com.google.protobuf.MapFieldBuilder<>(interconnectsConverter);
      }
      return interconnects_;
    }

    private com.google.protobuf.MapFieldBuilder<
            java.lang.String,
            com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect,
            com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder>
        internalGetMutableInterconnects() {
      if (interconnects_ == null) {
        interconnects_ = new com.google.protobuf.MapFieldBuilder<>(interconnectsConverter);
      }
      bitField0_ |= 0x00000040;
      onChanged();
      return interconnects_;
    }

    public int getInterconnectsCount() {
      return internalGetInterconnects().ensureBuilderMap().size();
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    @java.lang.Override
    public boolean containsInterconnects(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      return internalGetInterconnects().ensureBuilderMap().containsKey(key);
    }

    /** Use {@link #getInterconnectsMap()} instead. */
    @java.lang.Override
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
        getInterconnects() {
      return getInterconnectsMap();
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    @java.lang.Override
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
        getInterconnectsMap() {
      return internalGetInterconnects().getImmutableMap();
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    @java.lang.Override
    public /* nullable */ com.google.cloud.compute.v1.InterconnectGroupInterconnect
        getInterconnectsOrDefault(
            java.lang.String key,
            /* nullable */
            com.google.cloud.compute.v1.InterconnectGroupInterconnect defaultValue) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder>
          map = internalGetMutableInterconnects().ensureBuilderMap();
      return map.containsKey(key) ? interconnectsConverter.build(map.get(key)) : defaultValue;
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectGroupInterconnect getInterconnectsOrThrow(
        java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      java.util.Map<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder>
          map = internalGetMutableInterconnects().ensureBuilderMap();
      if (!map.containsKey(key)) {
        throw new java.lang.IllegalArgumentException();
      }
      return interconnectsConverter.build(map.get(key));
    }

    public Builder clearInterconnects() {
      bitField0_ = (bitField0_ & ~0x00000040);
      internalGetMutableInterconnects().clear();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    public Builder removeInterconnects(java.lang.String key) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      internalGetMutableInterconnects().ensureBuilderMap().remove(key);
      return this;
    }

    /** Use alternate mutation accessors instead. */
    @java.lang.Deprecated
    public java.util.Map<
            java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
        getMutableInterconnects() {
      bitField0_ |= 0x00000040;
      return internalGetMutableInterconnects().ensureMessageMap();
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    public Builder putInterconnects(
        java.lang.String key, com.google.cloud.compute.v1.InterconnectGroupInterconnect value) {
      if (key == null) {
        throw new NullPointerException("map key");
      }
      if (value == null) {
        throw new NullPointerException("map value");
      }
      internalGetMutableInterconnects().ensureBuilderMap().put(key, value);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    public Builder putAllInterconnects(
        java.util.Map<java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
            values) {
      for (java.util.Map.Entry<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnect>
          e : values.entrySet()) {
        if (e.getKey() == null || e.getValue() == null) {
          throw new NullPointerException();
        }
      }
      internalGetMutableInterconnects().ensureBuilderMap().putAll(values);
      bitField0_ |= 0x00000040;
      return this;
    }

    /**
     *
     *
     * <pre>
     * Interconnects in the InterconnectGroup. Keys are arbitrary user-specified strings. Users are encouraged, but not required, to use their preferred format for resource links as keys. Note that there are add-members and remove-members methods in gcloud. The size of this map is limited by an "Interconnects per group" quota.
     * </pre>
     *
     * <code>
     * map&lt;string, .google.cloud.compute.v1.InterconnectGroupInterconnect&gt; interconnects = 520187301;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder
        putInterconnectsBuilderIfAbsent(java.lang.String key) {
      java.util.Map<
              java.lang.String, com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder>
          builderMap = internalGetMutableInterconnects().ensureBuilderMap();
      com.google.cloud.compute.v1.InterconnectGroupInterconnectOrBuilder entry =
          builderMap.get(key);
      if (entry == null) {
        entry = com.google.cloud.compute.v1.InterconnectGroupInterconnect.newBuilder();
        builderMap.put(key, entry);
      }
      if (entry instanceof com.google.cloud.compute.v1.InterconnectGroupInterconnect) {
        entry = ((com.google.cloud.compute.v1.InterconnectGroupInterconnect) entry).toBuilder();
        builderMap.put(key, entry);
      }
      return (com.google.cloud.compute.v1.InterconnectGroupInterconnect.Builder) entry;
    }

    private java.lang.Object kind_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return Whether the kind field is set.
     */
    public boolean hasKind() {
      return ((bitField0_ & 0x00000080) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The kind.
     */
    public java.lang.String getKind() {
      java.lang.Object ref = kind_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        kind_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return The bytes for kind.
     */
    public com.google.protobuf.ByteString getKindBytes() {
      java.lang.Object ref = kind_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        kind_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The kind to set.
     * @return This builder for chaining.
     */
    public Builder setKind(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearKind() {
      kind_ = getDefaultInstance().getKind();
      bitField0_ = (bitField0_ & ~0x00000080);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Type of the resource. Always compute#InterconnectGroup
     * </pre>
     *
     * <code>optional string kind = 3292052;</code>
     *
     * @param value The bytes for kind to set.
     * @return This builder for chaining.
     */
    public Builder setKindBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      kind_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return Whether the name field is set.
     */
    public boolean hasName() {
      return ((bitField0_ & 0x00000100) != 0);
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
     * </pre>
     *
     * <code>optional string name = 3373707;</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure physicalStructure_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure,
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.Builder,
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructureOrBuilder>
        physicalStructureBuilder_;

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     *
     * @return Whether the physicalStructure field is set.
     */
    public boolean hasPhysicalStructure() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     *
     * @return The physicalStructure.
     */
    public com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure getPhysicalStructure() {
      if (physicalStructureBuilder_ == null) {
        return physicalStructure_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.getDefaultInstance()
            : physicalStructure_;
      } else {
        return physicalStructureBuilder_.getMessage();
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public Builder setPhysicalStructure(
        com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure value) {
      if (physicalStructureBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        physicalStructure_ = value;
      } else {
        physicalStructureBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public Builder setPhysicalStructure(
        com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.Builder builderForValue) {
      if (physicalStructureBuilder_ == null) {
        physicalStructure_ = builderForValue.build();
      } else {
        physicalStructureBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public Builder mergePhysicalStructure(
        com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure value) {
      if (physicalStructureBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && physicalStructure_ != null
            && physicalStructure_
                != com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure
                    .getDefaultInstance()) {
          getPhysicalStructureBuilder().mergeFrom(value);
        } else {
          physicalStructure_ = value;
        }
      } else {
        physicalStructureBuilder_.mergeFrom(value);
      }
      if (physicalStructure_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public Builder clearPhysicalStructure() {
      bitField0_ = (bitField0_ & ~0x00000200);
      physicalStructure_ = null;
      if (physicalStructureBuilder_ != null) {
        physicalStructureBuilder_.dispose();
        physicalStructureBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.Builder
        getPhysicalStructureBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getPhysicalStructureFieldBuilder().getBuilder();
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    public com.google.cloud.compute.v1.InterconnectGroupPhysicalStructureOrBuilder
        getPhysicalStructureOrBuilder() {
      if (physicalStructureBuilder_ != null) {
        return physicalStructureBuilder_.getMessageOrBuilder();
      } else {
        return physicalStructure_ == null
            ? com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.getDefaultInstance()
            : physicalStructure_;
      }
    }

    /**
     * <code>
     * optional .google.cloud.compute.v1.InterconnectGroupPhysicalStructure physical_structure = 195307531;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure,
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.Builder,
            com.google.cloud.compute.v1.InterconnectGroupPhysicalStructureOrBuilder>
        getPhysicalStructureFieldBuilder() {
      if (physicalStructureBuilder_ == null) {
        physicalStructureBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure,
                com.google.cloud.compute.v1.InterconnectGroupPhysicalStructure.Builder,
                com.google.cloud.compute.v1.InterconnectGroupPhysicalStructureOrBuilder>(
                getPhysicalStructure(), getParentForChildren(), isClean());
        physicalStructure_ = null;
      }
      return physicalStructureBuilder_;
    }

    private java.lang.Object selfLink_ = "";

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return Whether the selfLink field is set.
     */
    public boolean hasSelfLink() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The selfLink.
     */
    public java.lang.String getSelfLink() {
      java.lang.Object ref = selfLink_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        selfLink_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return The bytes for selfLink.
     */
    public com.google.protobuf.ByteString getSelfLinkBytes() {
      java.lang.Object ref = selfLink_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        selfLink_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLink(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearSelfLink() {
      selfLink_ = getDefaultInstance().getSelfLink();
      bitField0_ = (bitField0_ & ~0x00000400);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * [Output Only] Server-defined URL for the resource.
     * </pre>
     *
     * <code>optional string self_link = 456214797;</code>
     *
     * @param value The bytes for selfLink to set.
     * @return This builder for chaining.
     */
    public Builder setSelfLinkBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      selfLink_ = value;
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectGroup)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectGroup)
  private static final com.google.cloud.compute.v1.InterconnectGroup DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.InterconnectGroup();
  }

  public static com.google.cloud.compute.v1.InterconnectGroup getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<InterconnectGroup> PARSER =
      new com.google.protobuf.AbstractParser<InterconnectGroup>() {
        @java.lang.Override
        public InterconnectGroup parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<InterconnectGroup> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectGroup> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectGroup getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
