/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * The status of one Attachment in the group. List order is arbitrary.
 * </pre>
 *
 * Protobuf type {@code
 * google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus}
 */
public final class InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
    extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
    InterconnectAttachmentGroupsOperationalStatusAttachmentStatusOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.newBuilder() to construct.
  private InterconnectAttachmentGroupsOperationalStatusAttachmentStatus(
      com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private InterconnectAttachmentGroupsOperationalStatusAttachmentStatus() {
    attachment_ = "";
    isActive_ = "";
    status_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new InterconnectAttachmentGroupsOperationalStatusAttachmentStatus();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1
                .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.class,
            com.google.cloud.compute.v1
                .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.IsActive}
   */
  public enum IsActive implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IS_ACTIVE = 0;</code>
     */
    UNDEFINED_IS_ACTIVE(0),
    /** <code>ACTIVE = 314733318;</code> */
    ACTIVE(314733318),
    /** <code>INACTIVE = 270421099;</code> */
    INACTIVE(270421099),
    /** <code>UNSPECIFIED = 526786327;</code> */
    UNSPECIFIED(526786327),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_IS_ACTIVE = 0;</code>
     */
    public static final int UNDEFINED_IS_ACTIVE_VALUE = 0;

    /** <code>ACTIVE = 314733318;</code> */
    public static final int ACTIVE_VALUE = 314733318;

    /** <code>INACTIVE = 270421099;</code> */
    public static final int INACTIVE_VALUE = 270421099;

    /** <code>UNSPECIFIED = 526786327;</code> */
    public static final int UNSPECIFIED_VALUE = 526786327;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static IsActive valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static IsActive forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_IS_ACTIVE;
        case 314733318:
          return ACTIVE;
        case 270421099:
          return INACTIVE;
        case 526786327:
          return UNSPECIFIED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<IsActive> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<IsActive> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<IsActive>() {
          public IsActive findValueByNumber(int number) {
            return IsActive.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final IsActive[] VALUES = values();

    public static IsActive valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private IsActive(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.IsActive)
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is active, and if so, whether BGP is up.
   * </pre>
   *
   * Protobuf enum {@code
   * google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.Status}
   */
  public enum Status implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    UNDEFINED_STATUS(0),
    /** <code>ATTACHMENT_STATUS_UNKNOWN = 472477561;</code> */
    ATTACHMENT_STATUS_UNKNOWN(472477561),
    /** <code>CONNECTION_DISABLED = 432687805;</code> */
    CONNECTION_DISABLED(432687805),
    /** <code>CONNECTION_DOWN = 267552099;</code> */
    CONNECTION_DOWN(267552099),
    /** <code>CONNECTION_UP = 455585692;</code> */
    CONNECTION_UP(455585692),
    /** <code>DEFUNCT = 115891759;</code> */
    DEFUNCT(115891759),
    /** <code>IPSEC_CONFIGURATION_NEEDED_STATUS = 455203582;</code> */
    IPSEC_CONFIGURATION_NEEDED_STATUS(455203582),
    /** <code>IPSEC_READY_TO_RESUME_FLOW_STATUS = 384830596;</code> */
    IPSEC_READY_TO_RESUME_FLOW_STATUS(384830596),
    /** <code>IPV4_DOWN_IPV6_UP = 277490992;</code> */
    IPV4_DOWN_IPV6_UP(277490992),
    /** <code>IPV4_UP_IPV6_DOWN = 316051248;</code> */
    IPV4_UP_IPV6_DOWN(316051248),
    /** <code>PARTNER_REQUEST_RECEIVED = 513587304;</code> */
    PARTNER_REQUEST_RECEIVED(513587304),
    /** <code>PENDING_CUSTOMER = 167494054;</code> */
    PENDING_CUSTOMER(167494054),
    /** <code>PENDING_PARTNER = 387890656;</code> */
    PENDING_PARTNER(387890656),
    /** <code>PROVISIONED = 355751956;</code> */
    PROVISIONED(355751956),
    /** <code>ROUTER_CONFIGURATION_BROKEN = 150505108;</code> */
    ROUTER_CONFIGURATION_BROKEN(150505108),
    /** <code>UNPROVISIONED = 517333979;</code> */
    UNPROVISIONED(517333979),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_STATUS = 0;</code>
     */
    public static final int UNDEFINED_STATUS_VALUE = 0;

    /** <code>ATTACHMENT_STATUS_UNKNOWN = 472477561;</code> */
    public static final int ATTACHMENT_STATUS_UNKNOWN_VALUE = 472477561;

    /** <code>CONNECTION_DISABLED = 432687805;</code> */
    public static final int CONNECTION_DISABLED_VALUE = 432687805;

    /** <code>CONNECTION_DOWN = 267552099;</code> */
    public static final int CONNECTION_DOWN_VALUE = 267552099;

    /** <code>CONNECTION_UP = 455585692;</code> */
    public static final int CONNECTION_UP_VALUE = 455585692;

    /** <code>DEFUNCT = 115891759;</code> */
    public static final int DEFUNCT_VALUE = 115891759;

    /** <code>IPSEC_CONFIGURATION_NEEDED_STATUS = 455203582;</code> */
    public static final int IPSEC_CONFIGURATION_NEEDED_STATUS_VALUE = 455203582;

    /** <code>IPSEC_READY_TO_RESUME_FLOW_STATUS = 384830596;</code> */
    public static final int IPSEC_READY_TO_RESUME_FLOW_STATUS_VALUE = 384830596;

    /** <code>IPV4_DOWN_IPV6_UP = 277490992;</code> */
    public static final int IPV4_DOWN_IPV6_UP_VALUE = 277490992;

    /** <code>IPV4_UP_IPV6_DOWN = 316051248;</code> */
    public static final int IPV4_UP_IPV6_DOWN_VALUE = 316051248;

    /** <code>PARTNER_REQUEST_RECEIVED = 513587304;</code> */
    public static final int PARTNER_REQUEST_RECEIVED_VALUE = 513587304;

    /** <code>PENDING_CUSTOMER = 167494054;</code> */
    public static final int PENDING_CUSTOMER_VALUE = 167494054;

    /** <code>PENDING_PARTNER = 387890656;</code> */
    public static final int PENDING_PARTNER_VALUE = 387890656;

    /** <code>PROVISIONED = 355751956;</code> */
    public static final int PROVISIONED_VALUE = 355751956;

    /** <code>ROUTER_CONFIGURATION_BROKEN = 150505108;</code> */
    public static final int ROUTER_CONFIGURATION_BROKEN_VALUE = 150505108;

    /** <code>UNPROVISIONED = 517333979;</code> */
    public static final int UNPROVISIONED_VALUE = 517333979;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Status valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Status forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_STATUS;
        case 472477561:
          return ATTACHMENT_STATUS_UNKNOWN;
        case 432687805:
          return CONNECTION_DISABLED;
        case 267552099:
          return CONNECTION_DOWN;
        case 455585692:
          return CONNECTION_UP;
        case 115891759:
          return DEFUNCT;
        case 455203582:
          return IPSEC_CONFIGURATION_NEEDED_STATUS;
        case 384830596:
          return IPSEC_READY_TO_RESUME_FLOW_STATUS;
        case 277490992:
          return IPV4_DOWN_IPV6_UP;
        case 316051248:
          return IPV4_UP_IPV6_DOWN;
        case 513587304:
          return PARTNER_REQUEST_RECEIVED;
        case 167494054:
          return PENDING_CUSTOMER;
        case 387890656:
          return PENDING_PARTNER;
        case 355751956:
          return PROVISIONED;
        case 150505108:
          return ROUTER_CONFIGURATION_BROKEN;
        case 517333979:
          return UNPROVISIONED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Status> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Status> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Status>() {
          public Status findValueByNumber(int number) {
            return Status.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Status[] VALUES = values();

    public static Status valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Status(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.Status)
  }

  private int bitField0_;
  public static final int ADMIN_ENABLED_FIELD_NUMBER = 445675089;
  private boolean adminEnabled_ = false;

  /**
   *
   *
   * <pre>
   * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return Whether the adminEnabled field is set.
   */
  @java.lang.Override
  public boolean hasAdminEnabled() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
   * </pre>
   *
   * <code>optional bool admin_enabled = 445675089;</code>
   *
   * @return The adminEnabled.
   */
  @java.lang.Override
  public boolean getAdminEnabled() {
    return adminEnabled_;
  }

  public static final int ATTACHMENT_FIELD_NUMBER = 183982371;

  @SuppressWarnings("serial")
  private volatile java.lang.Object attachment_ = "";

  /**
   *
   *
   * <pre>
   * The URL of the Attachment being described.
   * </pre>
   *
   * <code>optional string attachment = 183982371;</code>
   *
   * @return Whether the attachment field is set.
   */
  @java.lang.Override
  public boolean hasAttachment() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The URL of the Attachment being described.
   * </pre>
   *
   * <code>optional string attachment = 183982371;</code>
   *
   * @return The attachment.
   */
  @java.lang.Override
  public java.lang.String getAttachment() {
    java.lang.Object ref = attachment_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      attachment_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The URL of the Attachment being described.
   * </pre>
   *
   * <code>optional string attachment = 183982371;</code>
   *
   * @return The bytes for attachment.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getAttachmentBytes() {
    java.lang.Object ref = attachment_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      attachment_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IS_ACTIVE_FIELD_NUMBER = 114830267;

  @SuppressWarnings("serial")
  private volatile java.lang.Object isActive_ = "";

  /**
   *
   *
   * <pre>
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return Whether the isActive field is set.
   */
  @java.lang.Override
  public boolean hasIsActive() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return The isActive.
   */
  @java.lang.Override
  public java.lang.String getIsActive() {
    java.lang.Object ref = isActive_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      isActive_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
   * Check the IsActive enum for the list of possible values.
   * </pre>
   *
   * <code>optional string is_active = 114830267;</code>
   *
   * @return The bytes for isActive.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getIsActiveBytes() {
    java.lang.Object ref = isActive_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      isActive_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int STATUS_FIELD_NUMBER = 181260274;

  @SuppressWarnings("serial")
  private volatile java.lang.Object status_ = "";

  /**
   *
   *
   * <pre>
   * Whether this Attachment is active, and if so, whether BGP is up.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return Whether the status field is set.
   */
  @java.lang.Override
  public boolean hasStatus() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is active, and if so, whether BGP is up.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The status.
   */
  @java.lang.Override
  public java.lang.String getStatus() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      status_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Whether this Attachment is active, and if so, whether BGP is up.
   * Check the Status enum for the list of possible values.
   * </pre>
   *
   * <code>optional string status = 181260274;</code>
   *
   * @return The bytes for status.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getStatusBytes() {
    java.lang.Object ref = status_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      status_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 114830267, isActive_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 181260274, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 183982371, attachment_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(445675089, adminEnabled_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(114830267, isActive_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(181260274, status_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(183982371, attachment_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(445675089, adminEnabled_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj
        instanceof
        com.google.cloud.compute.v1
            .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
        other =
            (com.google.cloud.compute.v1
                    .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
                obj;

    if (hasAdminEnabled() != other.hasAdminEnabled()) return false;
    if (hasAdminEnabled()) {
      if (getAdminEnabled() != other.getAdminEnabled()) return false;
    }
    if (hasAttachment() != other.hasAttachment()) return false;
    if (hasAttachment()) {
      if (!getAttachment().equals(other.getAttachment())) return false;
    }
    if (hasIsActive() != other.hasIsActive()) return false;
    if (hasIsActive()) {
      if (!getIsActive().equals(other.getIsActive())) return false;
    }
    if (hasStatus() != other.hasStatus()) return false;
    if (hasStatus()) {
      if (!getStatus().equals(other.getStatus())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAdminEnabled()) {
      hash = (37 * hash) + ADMIN_ENABLED_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAdminEnabled());
    }
    if (hasAttachment()) {
      hash = (37 * hash) + ATTACHMENT_FIELD_NUMBER;
      hash = (53 * hash) + getAttachment().hashCode();
    }
    if (hasIsActive()) {
      hash = (37 * hash) + IS_ACTIVE_FIELD_NUMBER;
      hash = (53 * hash) + getIsActive().hashCode();
    }
    if (hasStatus()) {
      hash = (37 * hash) + STATUS_FIELD_NUMBER;
      hash = (53 * hash) + getStatus().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(java.nio.ByteBuffer data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(
          java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(com.google.protobuf.ByteString data)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(
          com.google.protobuf.ByteString data,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseDelimitedFrom(
          java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      parseFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
          prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The status of one Attachment in the group. List order is arbitrary.
   * </pre>
   *
   * Protobuf type {@code
   * google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
      com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatusOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.class,
              com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.Builder.class);
    }

    // Construct using
    // com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      adminEnabled_ = false;
      attachment_ = "";
      isActive_ = "";
      status_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_InterconnectAttachmentGroupsOperationalStatusAttachmentStatus_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
        getDefaultInstanceForType() {
      return com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
        build() {
      com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
          result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
        buildPartial() {
      com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
          result =
              new com.google.cloud.compute.v1
                  .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
            result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.adminEnabled_ = adminEnabled_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.attachment_ = attachment_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.isActive_ = isActive_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.status_ = status_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other
          instanceof
          com.google.cloud.compute.v1
              .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus) {
        return mergeFrom(
            (com.google.cloud.compute.v1
                    .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
                other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(
        com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
            other) {
      if (other
          == com.google.cloud.compute.v1
              .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus.getDefaultInstance())
        return this;
      if (other.hasAdminEnabled()) {
        setAdminEnabled(other.getAdminEnabled());
      }
      if (other.hasAttachment()) {
        attachment_ = other.attachment_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasIsActive()) {
        isActive_ = other.isActive_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasStatus()) {
        status_ = other.status_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 918642138:
              {
                isActive_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 918642138
            case 1450082194:
              {
                status_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case 1450082194
            case 1471858970:
              {
                attachment_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1471858970
            case -729566584:
              {
                adminEnabled_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -729566584
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean adminEnabled_;

    /**
     *
     *
     * <pre>
     * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return Whether the adminEnabled field is set.
     */
    @java.lang.Override
    public boolean hasAdminEnabled() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return The adminEnabled.
     */
    @java.lang.Override
    public boolean getAdminEnabled() {
      return adminEnabled_;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @param value The adminEnabled to set.
     * @return This builder for chaining.
     */
    public Builder setAdminEnabled(boolean value) {

      adminEnabled_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is enabled. This becomes false when the customer drains their Attachment.
     * </pre>
     *
     * <code>optional bool admin_enabled = 445675089;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAdminEnabled() {
      bitField0_ = (bitField0_ & ~0x00000001);
      adminEnabled_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object attachment_ = "";

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @return Whether the attachment field is set.
     */
    public boolean hasAttachment() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @return The attachment.
     */
    public java.lang.String getAttachment() {
      java.lang.Object ref = attachment_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        attachment_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @return The bytes for attachment.
     */
    public com.google.protobuf.ByteString getAttachmentBytes() {
      java.lang.Object ref = attachment_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        attachment_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @param value The attachment to set.
     * @return This builder for chaining.
     */
    public Builder setAttachment(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      attachment_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAttachment() {
      attachment_ = getDefaultInstance().getAttachment();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The URL of the Attachment being described.
     * </pre>
     *
     * <code>optional string attachment = 183982371;</code>
     *
     * @param value The bytes for attachment to set.
     * @return This builder for chaining.
     */
    public Builder setAttachmentBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      attachment_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object isActive_ = "";

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return Whether the isActive field is set.
     */
    public boolean hasIsActive() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return The isActive.
     */
    public java.lang.String getIsActive() {
      java.lang.Object ref = isActive_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        isActive_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return The bytes for isActive.
     */
    public com.google.protobuf.ByteString getIsActiveBytes() {
      java.lang.Object ref = isActive_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        isActive_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @param value The isActive to set.
     * @return This builder for chaining.
     */
    public Builder setIsActive(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      isActive_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearIsActive() {
      isActive_ = getDefaultInstance().getIsActive();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is participating in the redundant configuration. This will be ACTIVE if and only if the status below is CONNECTION_UP. Any INACTIVE Attachments are excluded from the analysis that generates operational.availabilitySLA.
     * Check the IsActive enum for the list of possible values.
     * </pre>
     *
     * <code>optional string is_active = 114830267;</code>
     *
     * @param value The bytes for isActive to set.
     * @return This builder for chaining.
     */
    public Builder setIsActiveBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      isActive_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object status_ = "";

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return Whether the status field is set.
     */
    public boolean hasStatus() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The status.
     */
    public java.lang.String getStatus() {
      java.lang.Object ref = status_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        status_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return The bytes for status.
     */
    public com.google.protobuf.ByteString getStatusBytes() {
      java.lang.Object ref = status_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        status_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The status to set.
     * @return This builder for chaining.
     */
    public Builder setStatus(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearStatus() {
      status_ = getDefaultInstance().getStatus();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Whether this Attachment is active, and if so, whether BGP is up.
     * Check the Status enum for the list of possible values.
     * </pre>
     *
     * <code>optional string status = 181260274;</code>
     *
     * @param value The bytes for status to set.
     * @return This builder for chaining.
     */
    public Builder setStatusBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      status_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus)
  private static final com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE =
        new com.google.cloud.compute.v1
            .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus();
  }

  public static com.google.cloud.compute.v1
          .InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<
          InterconnectAttachmentGroupsOperationalStatusAttachmentStatus>
      PARSER =
          new com.google.protobuf.AbstractParser<
              InterconnectAttachmentGroupsOperationalStatusAttachmentStatus>() {
            @java.lang.Override
            public InterconnectAttachmentGroupsOperationalStatusAttachmentStatus parsePartialFrom(
                com.google.protobuf.CodedInputStream input,
                com.google.protobuf.ExtensionRegistryLite extensionRegistry)
                throws com.google.protobuf.InvalidProtocolBufferException {
              Builder builder = newBuilder();
              try {
                builder.mergeFrom(input, extensionRegistry);
              } catch (com.google.protobuf.InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage(builder.buildPartial());
              } catch (com.google.protobuf.UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException()
                    .setUnfinishedMessage(builder.buildPartial());
              } catch (java.io.IOException e) {
                throw new com.google.protobuf.InvalidProtocolBufferException(e)
                    .setUnfinishedMessage(builder.buildPartial());
              }
              return builder.buildPartial();
            }
          };

  public static com.google.protobuf.Parser<
          InterconnectAttachmentGroupsOperationalStatusAttachmentStatus>
      parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<InterconnectAttachmentGroupsOperationalStatusAttachmentStatus>
      getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.InterconnectAttachmentGroupsOperationalStatusAttachmentStatus
      getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
