/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

/**
 *
 *
 * <pre>
 * A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
 * </pre>
 *
 * Protobuf type {@code google.cloud.compute.v1.DiskInstantiationConfig}
 */
public final class DiskInstantiationConfig extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.compute.v1.DiskInstantiationConfig)
    DiskInstantiationConfigOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use DiskInstantiationConfig.newBuilder() to construct.
  private DiskInstantiationConfig(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DiskInstantiationConfig() {
    customImage_ = "";
    deviceName_ = "";
    instantiateFrom_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DiskInstantiationConfig();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DiskInstantiationConfig_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.compute.v1.Compute
        .internal_static_google_cloud_compute_v1_DiskInstantiationConfig_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.compute.v1.DiskInstantiationConfig.class,
            com.google.cloud.compute.v1.DiskInstantiationConfig.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.compute.v1.DiskInstantiationConfig.InstantiateFrom}
   */
  public enum InstantiateFrom implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANTIATE_FROM = 0;</code>
     */
    UNDEFINED_INSTANTIATE_FROM(0),
    /**
     *
     *
     * <pre>
     * Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
     * </pre>
     *
     * <code>ATTACH_READ_ONLY = 513775419;</code>
     */
    ATTACH_READ_ONLY(513775419),
    /**
     *
     *
     * <pre>
     * Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
     * </pre>
     *
     * <code>BLANK = 63281460;</code>
     */
    BLANK(63281460),
    /**
     *
     *
     * <pre>
     * Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>CUSTOM_IMAGE = 196311789;</code>
     */
    CUSTOM_IMAGE(196311789),
    /**
     *
     *
     * <pre>
     * Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    DEFAULT(115302945),
    /**
     *
     *
     * <pre>
     * Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
     * </pre>
     *
     * <code>DO_NOT_INCLUDE = 104218952;</code>
     */
    DO_NOT_INCLUDE(104218952),
    /**
     *
     *
     * <pre>
     * Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>SOURCE_IMAGE = 62631959;</code>
     */
    SOURCE_IMAGE(62631959),
    /**
     *
     *
     * <pre>
     * Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>SOURCE_IMAGE_FAMILY = 76850316;</code>
     */
    SOURCE_IMAGE_FAMILY(76850316),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * A value indicating that the enum field is not set.
     * </pre>
     *
     * <code>UNDEFINED_INSTANTIATE_FROM = 0;</code>
     */
    public static final int UNDEFINED_INSTANTIATE_FROM_VALUE = 0;

    /**
     *
     *
     * <pre>
     * Attach the existing disk in read-only mode. The request will fail if the disk was attached in read-write mode on the source instance. Applicable to: read-only disks.
     * </pre>
     *
     * <code>ATTACH_READ_ONLY = 513775419;</code>
     */
    public static final int ATTACH_READ_ONLY_VALUE = 513775419;

    /**
     *
     *
     * <pre>
     * Create a blank disk. The disk will be created unformatted. Applicable to: additional read-write disks, local SSDs.
     * </pre>
     *
     * <code>BLANK = 63281460;</code>
     */
    public static final int BLANK_VALUE = 63281460;

    /**
     *
     *
     * <pre>
     * Use the custom image specified in the custom_image field. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>CUSTOM_IMAGE = 196311789;</code>
     */
    public static final int CUSTOM_IMAGE_VALUE = 196311789;

    /**
     *
     *
     * <pre>
     * Use the default instantiation option for the corresponding type of disk. For boot disk and any other R/W disks, new custom images will be created from each disk. For read-only disks, they will be attached in read-only mode. Local SSD disks will be created as blank volumes.
     * </pre>
     *
     * <code>DEFAULT = 115302945;</code>
     */
    public static final int DEFAULT_VALUE = 115302945;

    /**
     *
     *
     * <pre>
     * Do not include the disk in the instance template. Applicable to: additional read-write disks, local SSDs, read-only disks.
     * </pre>
     *
     * <code>DO_NOT_INCLUDE = 104218952;</code>
     */
    public static final int DO_NOT_INCLUDE_VALUE = 104218952;

    /**
     *
     *
     * <pre>
     * Use the same source image used for creation of the source instance's corresponding disk. The request will fail if the source VM's disk was created from a snapshot. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>SOURCE_IMAGE = 62631959;</code>
     */
    public static final int SOURCE_IMAGE_VALUE = 62631959;

    /**
     *
     *
     * <pre>
     * Use the same source image family used for creation of the source instance's corresponding disk. The request will fail if the source image of the source disk does not belong to any image family. Applicable to: boot disk, additional read-write disks.
     * </pre>
     *
     * <code>SOURCE_IMAGE_FAMILY = 76850316;</code>
     */
    public static final int SOURCE_IMAGE_FAMILY_VALUE = 76850316;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static InstantiateFrom valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static InstantiateFrom forNumber(int value) {
      switch (value) {
        case 0:
          return UNDEFINED_INSTANTIATE_FROM;
        case 513775419:
          return ATTACH_READ_ONLY;
        case 63281460:
          return BLANK;
        case 196311789:
          return CUSTOM_IMAGE;
        case 115302945:
          return DEFAULT;
        case 104218952:
          return DO_NOT_INCLUDE;
        case 62631959:
          return SOURCE_IMAGE;
        case 76850316:
          return SOURCE_IMAGE_FAMILY;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<InstantiateFrom> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<InstantiateFrom>
        internalValueMap =
            new com.google.protobuf.Internal.EnumLiteMap<InstantiateFrom>() {
              public InstantiateFrom findValueByNumber(int number) {
                return InstantiateFrom.forNumber(number);
              }
            };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.compute.v1.DiskInstantiationConfig.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final InstantiateFrom[] VALUES = values();

    public static InstantiateFrom valueOf(
        com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private InstantiateFrom(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.compute.v1.DiskInstantiationConfig.InstantiateFrom)
  }

  private int bitField0_;
  public static final int AUTO_DELETE_FIELD_NUMBER = 464761403;
  private boolean autoDelete_ = false;

  /**
   *
   *
   * <pre>
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
   * </pre>
   *
   * <code>optional bool auto_delete = 464761403;</code>
   *
   * @return Whether the autoDelete field is set.
   */
  @java.lang.Override
  public boolean hasAutoDelete() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
   * </pre>
   *
   * <code>optional bool auto_delete = 464761403;</code>
   *
   * @return The autoDelete.
   */
  @java.lang.Override
  public boolean getAutoDelete() {
    return autoDelete_;
  }

  public static final int CUSTOM_IMAGE_FIELD_NUMBER = 184123149;

  @SuppressWarnings("serial")
  private volatile java.lang.Object customImage_ = "";

  /**
   *
   *
   * <pre>
   * The custom source image to be used to restore this disk when instantiating this instance template.
   * </pre>
   *
   * <code>optional string custom_image = 184123149;</code>
   *
   * @return Whether the customImage field is set.
   */
  @java.lang.Override
  public boolean hasCustomImage() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * The custom source image to be used to restore this disk when instantiating this instance template.
   * </pre>
   *
   * <code>optional string custom_image = 184123149;</code>
   *
   * @return The customImage.
   */
  @java.lang.Override
  public java.lang.String getCustomImage() {
    java.lang.Object ref = customImage_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      customImage_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * The custom source image to be used to restore this disk when instantiating this instance template.
   * </pre>
   *
   * <code>optional string custom_image = 184123149;</code>
   *
   * @return The bytes for customImage.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getCustomImageBytes() {
    java.lang.Object ref = customImage_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      customImage_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DEVICE_NAME_FIELD_NUMBER = 67541716;

  @SuppressWarnings("serial")
  private volatile java.lang.Object deviceName_ = "";

  /**
   *
   *
   * <pre>
   * Specifies the device name of the disk to which the configurations apply to.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return Whether the deviceName field is set.
   */
  @java.lang.Override
  public boolean hasDeviceName() {
    return ((bitField0_ & 0x00000004) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies the device name of the disk to which the configurations apply to.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return The deviceName.
   */
  @java.lang.Override
  public java.lang.String getDeviceName() {
    java.lang.Object ref = deviceName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      deviceName_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies the device name of the disk to which the configurations apply to.
   * </pre>
   *
   * <code>optional string device_name = 67541716;</code>
   *
   * @return The bytes for deviceName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDeviceNameBytes() {
    java.lang.Object ref = deviceName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      deviceName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int INSTANTIATE_FROM_FIELD_NUMBER = 393383903;

  @SuppressWarnings("serial")
  private volatile java.lang.Object instantiateFrom_ = "";

  /**
   *
   *
   * <pre>
   * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
   * Check the InstantiateFrom enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instantiate_from = 393383903;</code>
   *
   * @return Whether the instantiateFrom field is set.
   */
  @java.lang.Override
  public boolean hasInstantiateFrom() {
    return ((bitField0_ & 0x00000008) != 0);
  }

  /**
   *
   *
   * <pre>
   * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
   * Check the InstantiateFrom enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instantiate_from = 393383903;</code>
   *
   * @return The instantiateFrom.
   */
  @java.lang.Override
  public java.lang.String getInstantiateFrom() {
    java.lang.Object ref = instantiateFrom_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      instantiateFrom_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
   * Check the InstantiateFrom enum for the list of possible values.
   * </pre>
   *
   * <code>optional string instantiate_from = 393383903;</code>
   *
   * @return The bytes for instantiateFrom.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getInstantiateFromBytes() {
    java.lang.Object ref = instantiateFrom_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      instantiateFrom_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000004) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 67541716, deviceName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 184123149, customImage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 393383903, instantiateFrom_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeBool(464761403, autoDelete_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000004) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(67541716, deviceName_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(184123149, customImage_);
    }
    if (((bitField0_ & 0x00000008) != 0)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(393383903, instantiateFrom_);
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(464761403, autoDelete_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.compute.v1.DiskInstantiationConfig)) {
      return super.equals(obj);
    }
    com.google.cloud.compute.v1.DiskInstantiationConfig other =
        (com.google.cloud.compute.v1.DiskInstantiationConfig) obj;

    if (hasAutoDelete() != other.hasAutoDelete()) return false;
    if (hasAutoDelete()) {
      if (getAutoDelete() != other.getAutoDelete()) return false;
    }
    if (hasCustomImage() != other.hasCustomImage()) return false;
    if (hasCustomImage()) {
      if (!getCustomImage().equals(other.getCustomImage())) return false;
    }
    if (hasDeviceName() != other.hasDeviceName()) return false;
    if (hasDeviceName()) {
      if (!getDeviceName().equals(other.getDeviceName())) return false;
    }
    if (hasInstantiateFrom() != other.hasInstantiateFrom()) return false;
    if (hasInstantiateFrom()) {
      if (!getInstantiateFrom().equals(other.getInstantiateFrom())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasAutoDelete()) {
      hash = (37 * hash) + AUTO_DELETE_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getAutoDelete());
    }
    if (hasCustomImage()) {
      hash = (37 * hash) + CUSTOM_IMAGE_FIELD_NUMBER;
      hash = (53 * hash) + getCustomImage().hashCode();
    }
    if (hasDeviceName()) {
      hash = (37 * hash) + DEVICE_NAME_FIELD_NUMBER;
      hash = (53 * hash) + getDeviceName().hashCode();
    }
    if (hasInstantiateFrom()) {
      hash = (37 * hash) + INSTANTIATE_FROM_FIELD_NUMBER;
      hash = (53 * hash) + getInstantiateFrom().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.compute.v1.DiskInstantiationConfig prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * A specification of the desired way to instantiate a disk in the instance template when its created from a source instance.
   * </pre>
   *
   * Protobuf type {@code google.cloud.compute.v1.DiskInstantiationConfig}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.compute.v1.DiskInstantiationConfig)
      com.google.cloud.compute.v1.DiskInstantiationConfigOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DiskInstantiationConfig_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DiskInstantiationConfig_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.compute.v1.DiskInstantiationConfig.class,
              com.google.cloud.compute.v1.DiskInstantiationConfig.Builder.class);
    }

    // Construct using com.google.cloud.compute.v1.DiskInstantiationConfig.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      autoDelete_ = false;
      customImage_ = "";
      deviceName_ = "";
      instantiateFrom_ = "";
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.compute.v1.Compute
          .internal_static_google_cloud_compute_v1_DiskInstantiationConfig_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DiskInstantiationConfig getDefaultInstanceForType() {
      return com.google.cloud.compute.v1.DiskInstantiationConfig.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DiskInstantiationConfig build() {
      com.google.cloud.compute.v1.DiskInstantiationConfig result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.compute.v1.DiskInstantiationConfig buildPartial() {
      com.google.cloud.compute.v1.DiskInstantiationConfig result =
          new com.google.cloud.compute.v1.DiskInstantiationConfig(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.compute.v1.DiskInstantiationConfig result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.autoDelete_ = autoDelete_;
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.customImage_ = customImage_;
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.deviceName_ = deviceName_;
        to_bitField0_ |= 0x00000004;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.instantiateFrom_ = instantiateFrom_;
        to_bitField0_ |= 0x00000008;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.compute.v1.DiskInstantiationConfig) {
        return mergeFrom((com.google.cloud.compute.v1.DiskInstantiationConfig) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.compute.v1.DiskInstantiationConfig other) {
      if (other == com.google.cloud.compute.v1.DiskInstantiationConfig.getDefaultInstance())
        return this;
      if (other.hasAutoDelete()) {
        setAutoDelete(other.getAutoDelete());
      }
      if (other.hasCustomImage()) {
        customImage_ = other.customImage_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (other.hasDeviceName()) {
        deviceName_ = other.deviceName_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.hasInstantiateFrom()) {
        instantiateFrom_ = other.instantiateFrom_;
        bitField0_ |= 0x00000008;
        onChanged();
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 540333730:
              {
                deviceName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 540333730
            case 1472985194:
              {
                customImage_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 1472985194
            case -1147896070:
              {
                instantiateFrom_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000008;
                break;
              } // case -1147896070
            case -576876072:
              {
                autoDelete_ = input.readBool();
                bitField0_ |= 0x00000001;
                break;
              } // case -576876072
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private boolean autoDelete_;

    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return Whether the autoDelete field is set.
     */
    @java.lang.Override
    public boolean hasAutoDelete() {
      return ((bitField0_ & 0x00000001) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return The autoDelete.
     */
    @java.lang.Override
    public boolean getAutoDelete() {
      return autoDelete_;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @param value The autoDelete to set.
     * @return This builder for chaining.
     */
    public Builder setAutoDelete(boolean value) {

      autoDelete_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether the disk will be auto-deleted when the instance is deleted (but not when the disk is detached from the instance).
     * </pre>
     *
     * <code>optional bool auto_delete = 464761403;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAutoDelete() {
      bitField0_ = (bitField0_ & ~0x00000001);
      autoDelete_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object customImage_ = "";

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @return Whether the customImage field is set.
     */
    public boolean hasCustomImage() {
      return ((bitField0_ & 0x00000002) != 0);
    }

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @return The customImage.
     */
    public java.lang.String getCustomImage() {
      java.lang.Object ref = customImage_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        customImage_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @return The bytes for customImage.
     */
    public com.google.protobuf.ByteString getCustomImageBytes() {
      java.lang.Object ref = customImage_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        customImage_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @param value The customImage to set.
     * @return This builder for chaining.
     */
    public Builder setCustomImage(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      customImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCustomImage() {
      customImage_ = getDefaultInstance().getCustomImage();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The custom source image to be used to restore this disk when instantiating this instance template.
     * </pre>
     *
     * <code>optional string custom_image = 184123149;</code>
     *
     * @param value The bytes for customImage to set.
     * @return This builder for chaining.
     */
    public Builder setCustomImageBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      customImage_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object deviceName_ = "";

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return Whether the deviceName field is set.
     */
    public boolean hasDeviceName() {
      return ((bitField0_ & 0x00000004) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return The deviceName.
     */
    public java.lang.String getDeviceName() {
      java.lang.Object ref = deviceName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        deviceName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return The bytes for deviceName.
     */
    public com.google.protobuf.ByteString getDeviceNameBytes() {
      java.lang.Object ref = deviceName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        deviceName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @param value The deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      deviceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeviceName() {
      deviceName_ = getDefaultInstance().getDeviceName();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies the device name of the disk to which the configurations apply to.
     * </pre>
     *
     * <code>optional string device_name = 67541716;</code>
     *
     * @param value The bytes for deviceName to set.
     * @return This builder for chaining.
     */
    public Builder setDeviceNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      deviceName_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.lang.Object instantiateFrom_ = "";

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @return Whether the instantiateFrom field is set.
     */
    public boolean hasInstantiateFrom() {
      return ((bitField0_ & 0x00000008) != 0);
    }

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @return The instantiateFrom.
     */
    public java.lang.String getInstantiateFrom() {
      java.lang.Object ref = instantiateFrom_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        instantiateFrom_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @return The bytes for instantiateFrom.
     */
    public com.google.protobuf.ByteString getInstantiateFromBytes() {
      java.lang.Object ref = instantiateFrom_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        instantiateFrom_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @param value The instantiateFrom to set.
     * @return This builder for chaining.
     */
    public Builder setInstantiateFrom(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      instantiateFrom_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearInstantiateFrom() {
      instantiateFrom_ = getDefaultInstance().getInstantiateFrom();
      bitField0_ = (bitField0_ & ~0x00000008);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Specifies whether to include the disk and what image to use. Possible values are: - source-image: to use the same image that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - source-image-family: to use the same image family that was used to create the source instance's corresponding disk. Applicable to the boot disk and additional read-write disks. - custom-image: to use a user-provided image url for disk creation. Applicable to the boot disk and additional read-write disks. - attach-read-only: to attach a read-only disk. Applicable to read-only disks. - do-not-include: to exclude a disk from the template. Applicable to additional read-write disks, local SSDs, and read-only disks.
     * Check the InstantiateFrom enum for the list of possible values.
     * </pre>
     *
     * <code>optional string instantiate_from = 393383903;</code>
     *
     * @param value The bytes for instantiateFrom to set.
     * @return This builder for chaining.
     */
    public Builder setInstantiateFromBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      instantiateFrom_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.compute.v1.DiskInstantiationConfig)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.compute.v1.DiskInstantiationConfig)
  private static final com.google.cloud.compute.v1.DiskInstantiationConfig DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.compute.v1.DiskInstantiationConfig();
  }

  public static com.google.cloud.compute.v1.DiskInstantiationConfig getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DiskInstantiationConfig> PARSER =
      new com.google.protobuf.AbstractParser<DiskInstantiationConfig>() {
        @java.lang.Override
        public DiskInstantiationConfig parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DiskInstantiationConfig> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DiskInstantiationConfig> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.compute.v1.DiskInstantiationConfig getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
