/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/compute/v1/compute.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.compute.v1;

public interface BackendServiceOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.compute.v1.BackendService)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
   *
   * @return Whether the affinityCookieTtlSec field is set.
   */
  boolean hasAffinityCookieTtlSec();

  /**
   *
   *
   * <pre>
   * Lifetime of cookies in seconds. This setting is applicable to Application Load Balancers and Traffic Director and requires GENERATED_COOKIE or HTTP_COOKIE session affinity. If set to 0, the cookie is non-persistent and lasts only until the end of the browser session (or equivalent). The maximum allowed value is two weeks (1,209,600). Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional int32 affinity_cookie_ttl_sec = 369996954;</code>
   *
   * @return The affinityCookieTtlSec.
   */
  int getAffinityCookieTtlSec();

  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  java.util.List<com.google.cloud.compute.v1.Backend> getBackendsList();

  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  com.google.cloud.compute.v1.Backend getBackends(int index);

  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  int getBackendsCount();

  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.BackendOrBuilder> getBackendsOrBuilderList();

  /**
   *
   *
   * <pre>
   * The list of backends that serve this BackendService.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.Backend backends = 510839903;</code>
   */
  com.google.cloud.compute.v1.BackendOrBuilder getBackendsOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return Whether the cdnPolicy field is set.
   */
  boolean hasCdnPolicy();

  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   *
   * @return The cdnPolicy.
   */
  com.google.cloud.compute.v1.BackendServiceCdnPolicy getCdnPolicy();

  /**
   *
   *
   * <pre>
   * Cloud CDN configuration for this BackendService. Only available for specified load balancer types.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceCdnPolicy cdn_policy = 213976452;</code>
   */
  com.google.cloud.compute.v1.BackendServiceCdnPolicyOrBuilder getCdnPolicyOrBuilder();

  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   *
   * @return Whether the circuitBreakers field is set.
   */
  boolean hasCircuitBreakers();

  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   *
   * @return The circuitBreakers.
   */
  com.google.cloud.compute.v1.CircuitBreakers getCircuitBreakers();

  /**
   * <code>optional .google.cloud.compute.v1.CircuitBreakers circuit_breakers = 421340061;</code>
   */
  com.google.cloud.compute.v1.CircuitBreakersOrBuilder getCircuitBreakersOrBuilder();

  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return Whether the compressionMode field is set.
   */
  boolean hasCompressionMode();

  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The compressionMode.
   */
  java.lang.String getCompressionMode();

  /**
   *
   *
   * <pre>
   * Compress text responses using Brotli or gzip compression, based on the client's Accept-Encoding header.
   * Check the CompressionMode enum for the list of possible values.
   * </pre>
   *
   * <code>optional string compression_mode = 95520988;</code>
   *
   * @return The bytes for compressionMode.
   */
  com.google.protobuf.ByteString getCompressionModeBytes();

  /**
   *
   *
   * <pre>
   * connectionDraining cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   *
   * @return Whether the connectionDraining field is set.
   */
  boolean hasConnectionDraining();

  /**
   *
   *
   * <pre>
   * connectionDraining cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   *
   * @return The connectionDraining.
   */
  com.google.cloud.compute.v1.ConnectionDraining getConnectionDraining();

  /**
   *
   *
   * <pre>
   * connectionDraining cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.ConnectionDraining connection_draining = 461096747;
   * </code>
   */
  com.google.cloud.compute.v1.ConnectionDrainingOrBuilder getConnectionDrainingOrBuilder();

  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   *
   * @return Whether the connectionTrackingPolicy field is set.
   */
  boolean hasConnectionTrackingPolicy();

  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   *
   * @return The connectionTrackingPolicy.
   */
  com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy getConnectionTrackingPolicy();

  /**
   *
   *
   * <pre>
   * Connection Tracking configuration for this BackendService. Connection tracking policy settings are only available for external passthrough Network Load Balancers and internal passthrough Network Load Balancers. connectionTrackingPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceConnectionTrackingPolicy connection_tracking_policy = 143994969;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceConnectionTrackingPolicyOrBuilder
      getConnectionTrackingPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   *
   * @return Whether the consistentHash field is set.
   */
  boolean hasConsistentHash();

  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   *
   * @return The consistentHash.
   */
  com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettings getConsistentHash();

  /**
   *
   *
   * <pre>
   * Consistent Hash-based load balancing can be used to provide soft session affinity based on HTTP headers, cookies or other properties. This load balancing policy is applicable only for HTTP connections. The affinity to a particular destination host will be lost when one or more hosts are added/removed from the destination service. This field specifies parameters that control consistent hashing. This field is only applicable when localityLbPolicy is set to MAGLEV or RING_HASH. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.ConsistentHashLoadBalancerSettings consistent_hash = 905883;
   * </code>
   */
  com.google.cloud.compute.v1.ConsistentHashLoadBalancerSettingsOrBuilder
      getConsistentHashOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return Whether the creationTimestamp field is set.
   */
  boolean hasCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The creationTimestamp.
   */
  java.lang.String getCreationTimestamp();

  /**
   *
   *
   * <pre>
   * [Output Only] Creation timestamp in RFC3339 text format.
   * </pre>
   *
   * <code>optional string creation_timestamp = 30525366;</code>
   *
   * @return The bytes for creationTimestamp.
   */
  com.google.protobuf.ByteString getCreationTimestampBytes();

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.BackendServiceCustomMetric> getCustomMetricsList();

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceCustomMetric getCustomMetrics(int index);

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;
   * </code>
   */
  int getCustomMetricsCount();

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;
   * </code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.BackendServiceCustomMetricOrBuilder>
      getCustomMetricsOrBuilderList();

  /**
   *
   *
   * <pre>
   * List of custom metrics that are used for the WEIGHTED_ROUND_ROBIN locality_lb_policy.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceCustomMetric custom_metrics = 429453813;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceCustomMetricOrBuilder getCustomMetricsOrBuilder(
      int index);

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @return A list containing the customRequestHeaders.
   */
  java.util.List<java.lang.String> getCustomRequestHeadersList();

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @return The count of customRequestHeaders.
   */
  int getCustomRequestHeadersCount();

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @param index The index of the element to return.
   * @return The customRequestHeaders at the given index.
   */
  java.lang.String getCustomRequestHeaders(int index);

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied requests. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_request_headers = 27977992;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customRequestHeaders at the given index.
   */
  com.google.protobuf.ByteString getCustomRequestHeadersBytes(int index);

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return A list containing the customResponseHeaders.
   */
  java.util.List<java.lang.String> getCustomResponseHeadersList();

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @return The count of customResponseHeaders.
   */
  int getCustomResponseHeadersCount();

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the element to return.
   * @return The customResponseHeaders at the given index.
   */
  java.lang.String getCustomResponseHeaders(int index);

  /**
   *
   *
   * <pre>
   * Headers that the load balancer adds to proxied responses. See [Creating custom headers](https://cloud.google.com/load-balancing/docs/custom-headers).
   * </pre>
   *
   * <code>repeated string custom_response_headers = 387539094;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the customResponseHeaders at the given index.
   */
  com.google.protobuf.ByteString getCustomResponseHeadersBytes(int index);

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return Whether the description field is set.
   */
  boolean hasDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The description.
   */
  java.lang.String getDescription();

  /**
   *
   *
   * <pre>
   * An optional description of this resource. Provide this property when you create the resource.
   * </pre>
   *
   * <code>optional string description = 422937596;</code>
   *
   * @return The bytes for description.
   */
  com.google.protobuf.ByteString getDescriptionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return Whether the edgeSecurityPolicy field is set.
   */
  boolean hasEdgeSecurityPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The edgeSecurityPolicy.
   */
  java.lang.String getEdgeSecurityPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the edge security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string edge_security_policy = 41036943;</code>
   *
   * @return The bytes for edgeSecurityPolicy.
   */
  com.google.protobuf.ByteString getEdgeSecurityPolicyBytes();

  /**
   *
   *
   * <pre>
   * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
   * </pre>
   *
   * <code>optional bool enable_c_d_n = 250733499;</code>
   *
   * @return Whether the enableCDN field is set.
   */
  boolean hasEnableCDN();

  /**
   *
   *
   * <pre>
   * If true, enables Cloud CDN for the backend service of a global external Application Load Balancer.
   * </pre>
   *
   * <code>optional bool enable_c_d_n = 250733499;</code>
   *
   * @return The enableCDN.
   */
  boolean getEnableCDN();

  /**
   *
   *
   * <pre>
   * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
   * Check the ExternalManagedMigrationState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string external_managed_migration_state = 66947020;</code>
   *
   * @return Whether the externalManagedMigrationState field is set.
   */
  boolean hasExternalManagedMigrationState();

  /**
   *
   *
   * <pre>
   * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
   * Check the ExternalManagedMigrationState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string external_managed_migration_state = 66947020;</code>
   *
   * @return The externalManagedMigrationState.
   */
  java.lang.String getExternalManagedMigrationState();

  /**
   *
   *
   * <pre>
   * Specifies the canary migration state. Possible values are PREPARE, TEST_BY_PERCENTAGE, and TEST_ALL_TRAFFIC. To begin the migration from EXTERNAL to EXTERNAL_MANAGED, the state must be changed to PREPARE. The state must be changed to TEST_ALL_TRAFFIC before the loadBalancingScheme can be changed to EXTERNAL_MANAGED. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate traffic by percentage using externalManagedMigrationTestingPercentage. Rolling back a migration requires the states to be set in reverse order. So changing the scheme from EXTERNAL_MANAGED to EXTERNAL requires the state to be set to TEST_ALL_TRAFFIC at the same time. Optionally, the TEST_BY_PERCENTAGE state can be used to migrate some traffic back to EXTERNAL or PREPARE can be used to migrate all traffic back to EXTERNAL.
   * Check the ExternalManagedMigrationState enum for the list of possible values.
   * </pre>
   *
   * <code>optional string external_managed_migration_state = 66947020;</code>
   *
   * @return The bytes for externalManagedMigrationState.
   */
  com.google.protobuf.ByteString getExternalManagedMigrationStateBytes();

  /**
   *
   *
   * <pre>
   * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
   * </pre>
   *
   * <code>optional float external_managed_migration_testing_percentage = 507232462;</code>
   *
   * @return Whether the externalManagedMigrationTestingPercentage field is set.
   */
  boolean hasExternalManagedMigrationTestingPercentage();

  /**
   *
   *
   * <pre>
   * Determines the fraction of requests that should be processed by the Global external Application Load Balancer. The value of this field must be in the range [0, 100]. Session affinity options will slightly affect this routing behavior, for more details, see: Session Affinity. This value can only be set if the loadBalancingScheme in the BackendService is set to EXTERNAL (when using the classic Application Load Balancer) and the migration state is TEST_BY_PERCENTAGE.
   * </pre>
   *
   * <code>optional float external_managed_migration_testing_percentage = 507232462;</code>
   *
   * @return The externalManagedMigrationTestingPercentage.
   */
  float getExternalManagedMigrationTestingPercentage();

  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   *
   * @return Whether the failoverPolicy field is set.
   */
  boolean hasFailoverPolicy();

  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   *
   * @return The failoverPolicy.
   */
  com.google.cloud.compute.v1.BackendServiceFailoverPolicy getFailoverPolicy();

  /**
   *
   *
   * <pre>
   * Requires at least one backend instance group to be defined as a backup (failover) backend. For load balancers that have configurable failover: [Internal passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/internal/failover-overview) and [external passthrough Network Load Balancers](https://cloud.google.com/load-balancing/docs/network/networklb-failover-overview). failoverPolicy cannot be specified with haPolicy.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceFailoverPolicy failover_policy = 105658655;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceFailoverPolicyOrBuilder getFailoverPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return Whether the fingerprint field is set.
   */
  boolean hasFingerprint();

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The fingerprint.
   */
  java.lang.String getFingerprint();

  /**
   *
   *
   * <pre>
   * Fingerprint of this resource. A hash of the contents stored in this object. This field is used in optimistic locking. This field will be ignored when inserting a BackendService. An up-to-date fingerprint must be provided in order to update the BackendService, otherwise the request will fail with error 412 conditionNotMet. To see the latest fingerprint, make a get() request to retrieve a BackendService.
   * </pre>
   *
   * <code>optional string fingerprint = 234678500;</code>
   *
   * @return The bytes for fingerprint.
   */
  com.google.protobuf.ByteString getFingerprintBytes();

  /**
   *
   *
   * <pre>
   * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
   *
   * @return Whether the haPolicy field is set.
   */
  boolean hasHaPolicy();

  /**
   *
   *
   * <pre>
   * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
   *
   * @return The haPolicy.
   */
  com.google.cloud.compute.v1.BackendServiceHAPolicy getHaPolicy();

  /**
   *
   *
   * <pre>
   * Configures self-managed High Availability (HA) for External and Internal Protocol Forwarding. The backends of this regional backend service must only specify zonal network endpoint groups (NEGs) of type GCE_VM_IP. When haPolicy is set for an Internal Passthrough Network Load Balancer, the regional backend service must set the network field. All zonal NEGs must belong to the same network. However, individual NEGs can belong to different subnetworks of that network. When haPolicy is specified, the set of attached network endpoints across all backends comprise an High Availability domain from which one endpoint is selected as the active endpoint (the leader) that receives all traffic. haPolicy can be added only at backend service creation time. Once set up, it cannot be deleted. Note that haPolicy is not for load balancing, and therefore cannot be specified with sessionAffinity, connectionTrackingPolicy, and failoverPolicy. haPolicy requires customers to be responsible for tracking backend endpoint health and electing a leader among the healthy endpoints. Therefore, haPolicy cannot be specified with healthChecks. haPolicy can only be specified for External Passthrough Network Load Balancers and Internal Passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceHAPolicy ha_policy = 519879480;</code>
   */
  com.google.cloud.compute.v1.BackendServiceHAPolicyOrBuilder getHaPolicyOrBuilder();

  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @return A list containing the healthChecks.
   */
  java.util.List<java.lang.String> getHealthChecksList();

  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @return The count of healthChecks.
   */
  int getHealthChecksCount();

  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @param index The index of the element to return.
   * @return The healthChecks at the given index.
   */
  java.lang.String getHealthChecks(int index);

  /**
   *
   *
   * <pre>
   * The list of URLs to the healthChecks, httpHealthChecks (legacy), or httpsHealthChecks (legacy) resource for health checking this backend service. Not all backend services support legacy health checks. See Load balancer guide. Currently, at most one health check can be specified for each backend service. Backend services with instance group or zonal NEG backends must have a health check unless haPolicy is specified. Backend services with internet or serverless NEG backends must not have a health check. healthChecks[] cannot be specified with haPolicy.
   * </pre>
   *
   * <code>repeated string health_checks = 448370606;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the healthChecks at the given index.
   */
  com.google.protobuf.ByteString getHealthChecksBytes(int index);

  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   *
   * @return Whether the iap field is set.
   */
  boolean hasIap();

  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   *
   * @return The iap.
   */
  com.google.cloud.compute.v1.BackendServiceIAP getIap();

  /**
   *
   *
   * <pre>
   * The configurations for Identity-Aware Proxy on this resource. Not available for internal passthrough Network Load Balancers and external passthrough Network Load Balancers.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceIAP iap = 104024;</code>
   */
  com.google.cloud.compute.v1.BackendServiceIAPOrBuilder getIapOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return Whether the id field is set.
   */
  boolean hasId();

  /**
   *
   *
   * <pre>
   * [Output Only] The unique identifier for the resource. This identifier is defined by the server.
   * </pre>
   *
   * <code>optional uint64 id = 3355;</code>
   *
   * @return The id.
   */
  long getId();

  /**
   *
   *
   * <pre>
   * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
   * Check the IpAddressSelectionPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_address_selection_policy = 77600840;</code>
   *
   * @return Whether the ipAddressSelectionPolicy field is set.
   */
  boolean hasIpAddressSelectionPolicy();

  /**
   *
   *
   * <pre>
   * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
   * Check the IpAddressSelectionPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_address_selection_policy = 77600840;</code>
   *
   * @return The ipAddressSelectionPolicy.
   */
  java.lang.String getIpAddressSelectionPolicy();

  /**
   *
   *
   * <pre>
   * Specifies a preference for traffic sent from the proxy to the backend (or from the client to the backend for proxyless gRPC). The possible values are: - IPV4_ONLY: Only send IPv4 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv4 health checks are used to check the health of the backends. This is the default setting. - PREFER_IPV6: Prioritize the connection to the endpoint's IPv6 address over its IPv4 address (provided there is a healthy IPv6 address). - IPV6_ONLY: Only send IPv6 traffic to the backends of the backend service (Instance Group, Managed Instance Group, Network Endpoint Group), regardless of traffic from the client to the proxy. Only IPv6 health checks are used to check the health of the backends. This field is applicable to either: - Advanced global external Application Load Balancer (load balancing scheme EXTERNAL_MANAGED), - Regional external Application Load Balancer, - Internal proxy Network Load Balancer (load balancing scheme INTERNAL_MANAGED), - Regional internal Application Load Balancer (load balancing scheme INTERNAL_MANAGED), - Traffic Director with Envoy proxies and proxyless gRPC (load balancing scheme INTERNAL_SELF_MANAGED).
   * Check the IpAddressSelectionPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string ip_address_selection_policy = 77600840;</code>
   *
   * @return The bytes for ipAddressSelectionPolicy.
   */
  com.google.protobuf.ByteString getIpAddressSelectionPolicyBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return Whether the kind field is set.
   */
  boolean hasKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The kind.
   */
  java.lang.String getKind();

  /**
   *
   *
   * <pre>
   * [Output Only] Type of resource. Always compute#backendService for backend services.
   * </pre>
   *
   * <code>optional string kind = 3292052;</code>
   *
   * @return The bytes for kind.
   */
  com.google.protobuf.ByteString getKindBytes();

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return Whether the loadBalancingScheme field is set.
   */
  boolean hasLoadBalancingScheme();

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The loadBalancingScheme.
   */
  java.lang.String getLoadBalancingScheme();

  /**
   *
   *
   * <pre>
   * Specifies the load balancer type. A backend service created for one type of load balancer cannot be used with another. For more information, refer to Choosing a load balancer.
   * Check the LoadBalancingScheme enum for the list of possible values.
   * </pre>
   *
   * <code>optional string load_balancing_scheme = 363890244;</code>
   *
   * @return The bytes for loadBalancingScheme.
   */
  com.google.protobuf.ByteString getLoadBalancingSchemeBytes();

  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  java.util.List<com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig>
      getLocalityLbPoliciesList();

  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig getLocalityLbPolicies(
      int index);

  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  int getLocalityLbPoliciesCount();

  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  java.util.List<
          ? extends
              com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder>
      getLocalityLbPoliciesOrBuilderList();

  /**
   *
   *
   * <pre>
   * A list of locality load-balancing policies to be used in order of preference. When you use localityLbPolicies, you must set at least one value for either the localityLbPolicies[].policy or the localityLbPolicies[].customPolicy field. localityLbPolicies overrides any value set in the localityLbPolicy field. For an example of how to use this field, see Define a list of preferred policies. Caution: This field and its children are intended for use in a service mesh that includes gRPC clients only. Envoy proxies can't use backend services that have this configuration.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfig locality_lb_policies = 140982557;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceLocalityLoadBalancingPolicyConfigOrBuilder
      getLocalityLbPoliciesOrBuilder(int index);

  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return Whether the localityLbPolicy field is set.
   */
  boolean hasLocalityLbPolicy();

  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return The localityLbPolicy.
   */
  java.lang.String getLocalityLbPolicy();

  /**
   *
   *
   * <pre>
   * The load balancing algorithm used within the scope of the locality. The possible values are: - ROUND_ROBIN: This is a simple policy in which each healthy backend is selected in round robin order. This is the default. - LEAST_REQUEST: An O(1) algorithm which selects two random healthy hosts and picks the host which has fewer active requests. - RING_HASH: The ring/modulo hash load balancer implements consistent hashing to backends. The algorithm has the property that the addition/removal of a host from a set of N hosts only affects 1/N of the requests. - RANDOM: The load balancer selects a random healthy host. - ORIGINAL_DESTINATION: Backend host is selected based on the client connection metadata, i.e., connections are opened to the same address as the destination address of the incoming connection before the connection was redirected to the load balancer. - MAGLEV: used as a drop in replacement for the ring hash load balancer. Maglev is not as stable as ring hash but has faster table lookup build times and host selection times. For more information about Maglev, see Maglev: A Fast and Reliable Software Network Load Balancer. - WEIGHTED_ROUND_ROBIN: Per-endpoint Weighted Round Robin Load Balancing using weights computed from Backend reported Custom Metrics. If set, the Backend Service responses are expected to contain non-standard HTTP response header field Endpoint-Load-Metrics. The reported metrics to use for computing the weights are specified via the customMetrics field. This field is applicable to either: - A regional backend service with the service_protocol set to HTTP, HTTPS, HTTP2 or H2C, and load_balancing_scheme set to INTERNAL_MANAGED. - A global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED, INTERNAL_MANAGED, or EXTERNAL_MANAGED. If sessionAffinity is not configured—that is, if session affinity remains at the default value of NONE—then the default value for localityLbPolicy is ROUND_ROBIN. If session affinity is set to a value other than NONE, then the default value for localityLbPolicy is MAGLEV. Only ROUND_ROBIN and RING_HASH are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. localityLbPolicy cannot be specified with haPolicy.
   * Check the LocalityLbPolicy enum for the list of possible values.
   * </pre>
   *
   * <code>optional string locality_lb_policy = 131431487;</code>
   *
   * @return The bytes for localityLbPolicy.
   */
  com.google.protobuf.ByteString getLocalityLbPolicyBytes();

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   *
   * @return Whether the logConfig field is set.
   */
  boolean hasLogConfig();

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   *
   * @return The logConfig.
   */
  com.google.cloud.compute.v1.BackendServiceLogConfig getLogConfig();

  /**
   *
   *
   * <pre>
   * This field denotes the logging options for the load balancer traffic served by this backend service. If logging is enabled, logs will be exported to Stackdriver.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceLogConfig log_config = 351299741;</code>
   */
  com.google.cloud.compute.v1.BackendServiceLogConfigOrBuilder getLogConfigOrBuilder();

  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return Whether the maxStreamDuration field is set.
   */
  boolean hasMaxStreamDuration();

  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   *
   * @return The maxStreamDuration.
   */
  com.google.cloud.compute.v1.Duration getMaxStreamDuration();

  /**
   *
   *
   * <pre>
   * Specifies the default maximum duration (timeout) for streams to this service. Duration is computed from the beginning of the stream until the response has been completely processed, including all retries. A stream that does not complete in this duration is closed. If not specified, there will be no timeout limit, i.e. the maximum duration is infinite. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. This field is only allowed when the loadBalancingScheme of the backend service is INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Duration max_stream_duration = 61428376;</code>
   */
  com.google.cloud.compute.v1.DurationOrBuilder getMaxStreamDurationOrBuilder();

  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  int getMetadatasCount();

  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  boolean containsMetadatas(java.lang.String key);

  /** Use {@link #getMetadatasMap()} instead. */
  @java.lang.Deprecated
  java.util.Map<java.lang.String, java.lang.String> getMetadatas();

  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  java.util.Map<java.lang.String, java.lang.String> getMetadatasMap();

  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  /* nullable */
  java.lang.String getMetadatasOrDefault(
      java.lang.String key,
      /* nullable */
      java.lang.String defaultValue);

  /**
   *
   *
   * <pre>
   * Deployment metadata associated with the resource to be set by a GKE hub controller and read by the backend RCTH
   * </pre>
   *
   * <code>map&lt;string, string&gt; metadatas = 8514340;</code>
   */
  java.lang.String getMetadatasOrThrow(java.lang.String key);

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return Whether the name field is set.
   */
  boolean hasName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The name.
   */
  java.lang.String getName();

  /**
   *
   *
   * <pre>
   * Name of the resource. Provided by the client when the resource is created. The name must be 1-63 characters long, and comply with RFC1035. Specifically, the name must be 1-63 characters long and match the regular expression `[a-z]([-a-z0-9]*[a-z0-9])?` which means the first character must be a lowercase letter, and all following characters must be a dash, lowercase letter, or digit, except the last character, which cannot be a dash.
   * </pre>
   *
   * <code>optional string name = 3373707;</code>
   *
   * @return The bytes for name.
   */
  com.google.protobuf.ByteString getNameBytes();

  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return Whether the network field is set.
   */
  boolean hasNetwork();

  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The network.
   */
  java.lang.String getNetwork();

  /**
   *
   *
   * <pre>
   * The URL of the network to which this backend service belongs. This field must be set for Internal Passthrough Network Load Balancers when the haPolicy is enabled, and for External Passthrough Network Load Balancers when the haPolicy fastIpMove is enabled. This field can only be specified when the load balancing scheme is set to INTERNAL, or when the load balancing scheme is set to EXTERNAL and haPolicy fastIpMove is enabled.
   * </pre>
   *
   * <code>optional string network = 232872494;</code>
   *
   * @return The bytes for network.
   */
  com.google.protobuf.ByteString getNetworkBytes();

  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   *
   * @return Whether the outlierDetection field is set.
   */
  boolean hasOutlierDetection();

  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   *
   * @return The outlierDetection.
   */
  com.google.cloud.compute.v1.OutlierDetection getOutlierDetection();

  /**
   *
   *
   * <pre>
   * Settings controlling the ejection of unhealthy backend endpoints from the load balancing pool of each individual proxy instance that processes the traffic for the given backend service. If not set, this feature is considered disabled. Results of the outlier detection algorithm (ejection of endpoints from the load balancing pool and returning them back to the pool) are executed independently by each proxy instance of the load balancer. In most cases, more than one proxy instance handles the traffic received by a backend service. Thus, it is possible that an unhealthy endpoint is detected and ejected by only some of the proxies, and while this happens, other proxies may continue to send requests to the same unhealthy endpoint until they detect and eject the unhealthy endpoint. Applicable backend endpoints can be: - VM instances in an Instance Group - Endpoints in a Zonal NEG (GCE_VM_IP, GCE_VM_IP_PORT) - Endpoints in a Hybrid Connectivity NEG (NON_GCP_PRIVATE_IP_PORT) - Serverless NEGs, that resolve to Cloud Run, App Engine, or Cloud Functions Services - Private Service Connect NEGs, that resolve to Google-managed regional API endpoints or managed services published using Private Service Connect Applicable backend service types can be: - A global backend service with the loadBalancingScheme set to INTERNAL_SELF_MANAGED or EXTERNAL_MANAGED. - A regional backend service with the serviceProtocol set to HTTP, HTTPS, HTTP2 or H2C, and loadBalancingScheme set to INTERNAL_MANAGED or EXTERNAL_MANAGED. Not supported for Serverless NEGs. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.OutlierDetection outlier_detection = 354625086;</code>
   */
  com.google.cloud.compute.v1.OutlierDetectionOrBuilder getOutlierDetectionOrBuilder();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
   *
   * @return Whether the params field is set.
   */
  boolean hasParams();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
   *
   * @return The params.
   */
  com.google.cloud.compute.v1.BackendServiceParams getParams();

  /**
   *
   *
   * <pre>
   * Input only. [Input Only] Additional params passed with the request, but not persisted as part of resource payload.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceParams params = 78313862;</code>
   */
  com.google.cloud.compute.v1.BackendServiceParamsOrBuilder getParamsOrBuilder();

  /**
   *
   *
   * <pre>
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return Whether the port field is set.
   */
  boolean hasPort();

  /**
   *
   *
   * <pre>
   * Deprecated in favor of portName. The TCP port to connect on the backend. The default value is 80. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port.
   * </pre>
   *
   * <code>optional int32 port = 3446913;</code>
   *
   * @return The port.
   */
  int getPort();

  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return Whether the portName field is set.
   */
  boolean hasPortName();

  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The portName.
   */
  java.lang.String getPortName();

  /**
   *
   *
   * <pre>
   * A named port on a backend instance group representing the port for communication to the backend VMs in that group. The named port must be [defined on each backend instance group](https://cloud.google.com/load-balancing/docs/backend-service#named_ports). This parameter has no meaning if the backends are NEGs. For internal passthrough Network Load Balancers and external passthrough Network Load Balancers, omit port_name.
   * </pre>
   *
   * <code>optional string port_name = 41534345;</code>
   *
   * @return The bytes for portName.
   */
  com.google.protobuf.ByteString getPortNameBytes();

  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return Whether the protocol field is set.
   */
  boolean hasProtocol();

  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return The protocol.
   */
  java.lang.String getProtocol();

  /**
   *
   *
   * <pre>
   * The protocol this BackendService uses to communicate with backends. Possible values are HTTP, HTTPS, HTTP2, H2C, TCP, SSL, UDP or GRPC. depending on the chosen load balancer or Traffic Director configuration. Refer to the documentation for the load balancers or for Traffic Director for more information. Must be set to GRPC when the backend service is referenced by a URL map that is bound to target gRPC proxy.
   * Check the Protocol enum for the list of possible values.
   * </pre>
   *
   * <code>optional string protocol = 84577944;</code>
   *
   * @return The bytes for protocol.
   */
  com.google.protobuf.ByteString getProtocolBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return Whether the region field is set.
   */
  boolean hasRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The region.
   */
  java.lang.String getRegion();

  /**
   *
   *
   * <pre>
   * [Output Only] URL of the region where the regional backend service resides. This field is not applicable to global backend services. You must specify this field as part of the HTTP request URL. It is not settable as a field in the request body.
   * </pre>
   *
   * <code>optional string region = 138946292;</code>
   *
   * @return The bytes for region.
   */
  com.google.protobuf.ByteString getRegionBytes();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return Whether the securityPolicy field is set.
   */
  boolean hasSecurityPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The securityPolicy.
   */
  java.lang.String getSecurityPolicy();

  /**
   *
   *
   * <pre>
   * [Output Only] The resource URL for the security policy associated with this backend service.
   * </pre>
   *
   * <code>optional string security_policy = 171082513;</code>
   *
   * @return The bytes for securityPolicy.
   */
  com.google.protobuf.ByteString getSecurityPolicyBytes();

  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   *
   * @return Whether the securitySettings field is set.
   */
  boolean hasSecuritySettings();

  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   *
   * @return The securitySettings.
   */
  com.google.cloud.compute.v1.SecuritySettings getSecuritySettings();

  /**
   *
   *
   * <pre>
   * This field specifies the security settings that apply to this backend service. This field is applicable to a global backend service with the load_balancing_scheme set to INTERNAL_SELF_MANAGED.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.SecuritySettings security_settings = 478649922;</code>
   */
  com.google.cloud.compute.v1.SecuritySettingsOrBuilder getSecuritySettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return Whether the selfLink field is set.
   */
  boolean hasSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The selfLink.
   */
  java.lang.String getSelfLink();

  /**
   *
   *
   * <pre>
   * [Output Only] Server-defined URL for the resource.
   * </pre>
   *
   * <code>optional string self_link = 456214797;</code>
   *
   * @return The bytes for selfLink.
   */
  com.google.protobuf.ByteString getSelfLinkBytes();

  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @return A list containing the serviceBindings.
   */
  java.util.List<java.lang.String> getServiceBindingsList();

  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @return The count of serviceBindings.
   */
  int getServiceBindingsCount();

  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @param index The index of the element to return.
   * @return The serviceBindings at the given index.
   */
  java.lang.String getServiceBindings(int index);

  /**
   *
   *
   * <pre>
   * URLs of networkservices.ServiceBinding resources. Can only be set if load balancing scheme is INTERNAL_SELF_MANAGED. If set, lists of backends and health checks must be both empty.
   * </pre>
   *
   * <code>repeated string service_bindings = 133581016;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the serviceBindings at the given index.
   */
  com.google.protobuf.ByteString getServiceBindingsBytes(int index);

  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return Whether the serviceLbPolicy field is set.
   */
  boolean hasServiceLbPolicy();

  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return The serviceLbPolicy.
   */
  java.lang.String getServiceLbPolicy();

  /**
   *
   *
   * <pre>
   * URL to networkservices.ServiceLbPolicy resource. Can only be set if load balancing scheme is EXTERNAL_MANAGED, INTERNAL_MANAGED or INTERNAL_SELF_MANAGED and the scope is global.
   * </pre>
   *
   * <code>optional string service_lb_policy = 94848785;</code>
   *
   * @return The bytes for serviceLbPolicy.
   */
  com.google.protobuf.ByteString getServiceLbPolicyBytes();

  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return Whether the sessionAffinity field is set.
   */
  boolean hasSessionAffinity();

  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return The sessionAffinity.
   */
  java.lang.String getSessionAffinity();

  /**
   *
   *
   * <pre>
   * Type of session affinity to use. The default is NONE. Only NONE and HEADER_FIELD are supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. For more details, see: [Session Affinity](https://cloud.google.com/load-balancing/docs/backend-service#session_affinity). sessionAffinity cannot be specified with haPolicy.
   * Check the SessionAffinity enum for the list of possible values.
   * </pre>
   *
   * <code>optional string session_affinity = 463888561;</code>
   *
   * @return The bytes for sessionAffinity.
   */
  com.google.protobuf.ByteString getSessionAffinityBytes();

  /**
   *
   *
   * <pre>
   * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;
   * </code>
   *
   * @return Whether the strongSessionAffinityCookie field is set.
   */
  boolean hasStrongSessionAffinityCookie();

  /**
   *
   *
   * <pre>
   * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;
   * </code>
   *
   * @return The strongSessionAffinityCookie.
   */
  com.google.cloud.compute.v1.BackendServiceHttpCookie getStrongSessionAffinityCookie();

  /**
   *
   *
   * <pre>
   * Describes the HTTP cookie used for stateful session affinity. This field is applicable and required if the sessionAffinity is set to STRONG_COOKIE_AFFINITY.
   * </pre>
   *
   * <code>
   * optional .google.cloud.compute.v1.BackendServiceHttpCookie strong_session_affinity_cookie = 238195722;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceHttpCookieOrBuilder
      getStrongSessionAffinityCookieOrBuilder();

  /**
   *
   *
   * <pre>
   * subsetting cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
   *
   * @return Whether the subsetting field is set.
   */
  boolean hasSubsetting();

  /**
   *
   *
   * <pre>
   * subsetting cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
   *
   * @return The subsetting.
   */
  com.google.cloud.compute.v1.Subsetting getSubsetting();

  /**
   *
   *
   * <pre>
   * subsetting cannot be specified with haPolicy.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.Subsetting subsetting = 450283536;</code>
   */
  com.google.cloud.compute.v1.SubsettingOrBuilder getSubsettingOrBuilder();

  /**
   *
   *
   * <pre>
   * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return Whether the timeoutSec field is set.
   */
  boolean hasTimeoutSec();

  /**
   *
   *
   * <pre>
   * The backend service timeout has a different meaning depending on the type of load balancer. For more information see, Backend service settings. The default is 30 seconds. The full range of timeout values allowed goes from 1 through 2,147,483,647 seconds. This value can be overridden in the PathMatcher configuration of the UrlMap that references this backend service. Not supported when the backend service is referenced by a URL map that is bound to target gRPC proxy that has validateForProxyless field set to true. Instead, use maxStreamDuration.
   * </pre>
   *
   * <code>optional int32 timeout_sec = 79994995;</code>
   *
   * @return The timeoutSec.
   */
  int getTimeoutSec();

  /**
   *
   *
   * <pre>
   * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;
   * </code>
   *
   * @return Whether the tlsSettings field is set.
   */
  boolean hasTlsSettings();

  /**
   *
   *
   * <pre>
   * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;
   * </code>
   *
   * @return The tlsSettings.
   */
  com.google.cloud.compute.v1.BackendServiceTlsSettings getTlsSettings();

  /**
   *
   *
   * <pre>
   * Configuration for Backend Authenticated TLS and mTLS. May only be specified when the backend protocol is SSL, HTTPS or HTTP2.
   * </pre>
   *
   * <code>optional .google.cloud.compute.v1.BackendServiceTlsSettings tls_settings = 81794791;
   * </code>
   */
  com.google.cloud.compute.v1.BackendServiceTlsSettingsOrBuilder getTlsSettingsOrBuilder();

  /**
   *
   *
   * <pre>
   * [Output Only] List of resources referencing given backend service.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
   */
  java.util.List<com.google.cloud.compute.v1.BackendServiceUsedBy> getUsedByList();

  /**
   *
   *
   * <pre>
   * [Output Only] List of resources referencing given backend service.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
   */
  com.google.cloud.compute.v1.BackendServiceUsedBy getUsedBy(int index);

  /**
   *
   *
   * <pre>
   * [Output Only] List of resources referencing given backend service.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
   */
  int getUsedByCount();

  /**
   *
   *
   * <pre>
   * [Output Only] List of resources referencing given backend service.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
   */
  java.util.List<? extends com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder>
      getUsedByOrBuilderList();

  /**
   *
   *
   * <pre>
   * [Output Only] List of resources referencing given backend service.
   * </pre>
   *
   * <code>repeated .google.cloud.compute.v1.BackendServiceUsedBy used_by = 389320729;</code>
   */
  com.google.cloud.compute.v1.BackendServiceUsedByOrBuilder getUsedByOrBuilder(int index);
}
