/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.compute.v1;

import com.google.cloud.compute.v1.Compute;
import com.google.cloud.compute.v1.RouterAdvertisedIpRange;
import com.google.cloud.compute.v1.RouterAdvertisedIpRangeOrBuilder;
import com.google.cloud.compute.v1.RouterBgpPeerOrBuilder;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class RouterBgpPeer
extends GeneratedMessageV3
implements RouterBgpPeerOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ADVERTISE_MODE_FIELD_NUMBER = 43698875;
    private int advertiseMode_;
    public static final int ADVERTISED_GROUPS_FIELD_NUMBER = 21065526;
    private List<Integer> advertisedGroups_;
    private static final Internal.ListAdapter.Converter<Integer, AdvertisedGroups> advertisedGroups_converter_ = new Internal.ListAdapter.Converter<Integer, AdvertisedGroups>(){

        public AdvertisedGroups convert(Integer from) {
            AdvertisedGroups result = AdvertisedGroups.valueOf(from);
            return result == null ? AdvertisedGroups.UNRECOGNIZED : result;
        }
    };
    private int advertisedGroupsMemoizedSerializedSize;
    public static final int ADVERTISED_IP_RANGES_FIELD_NUMBER = 35449932;
    private List<RouterAdvertisedIpRange> advertisedIpRanges_;
    public static final int ADVERTISED_ROUTE_PRIORITY_FIELD_NUMBER = 186486332;
    private int advertisedRoutePriority_;
    public static final int INTERFACE_NAME_FIELD_NUMBER = 169419217;
    private volatile Object interfaceName_;
    public static final int IP_ADDRESS_FIELD_NUMBER = 137836764;
    private volatile Object ipAddress_;
    public static final int MANAGEMENT_TYPE_FIELD_NUMBER = 173703606;
    private int managementType_;
    public static final int NAME_FIELD_NUMBER = 3373707;
    private volatile Object name_;
    public static final int PEER_ASN_FIELD_NUMBER = 69573151;
    private int peerAsn_;
    public static final int PEER_IP_ADDRESS_FIELD_NUMBER = 207735769;
    private volatile Object peerIpAddress_;
    private byte memoizedIsInitialized = (byte)-1;
    private static final RouterBgpPeer DEFAULT_INSTANCE = new RouterBgpPeer();
    private static final Parser<RouterBgpPeer> PARSER = new AbstractParser<RouterBgpPeer>(){

        public RouterBgpPeer parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return new RouterBgpPeer(input, extensionRegistry);
        }
    };

    private RouterBgpPeer(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private RouterBgpPeer() {
        this.advertiseMode_ = 0;
        this.advertisedGroups_ = Collections.emptyList();
        this.advertisedIpRanges_ = Collections.emptyList();
        this.interfaceName_ = "";
        this.ipAddress_ = "";
        this.managementType_ = 0;
        this.name_ = "";
        this.peerIpAddress_ = "";
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new RouterBgpPeer();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    private RouterBgpPeer(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        this();
        if (extensionRegistry == null) {
            throw new NullPointerException();
        }
        int mutable_bitField0_ = 0;
        UnknownFieldSet.Builder unknownFields = UnknownFieldSet.newBuilder();
        try {
            boolean done = false;
            block20: while (!done) {
                int tag = input.readTag();
                switch (tag) {
                    case 0: {
                        done = true;
                        continue block20;
                    }
                    case 26989658: {
                        String s = input.readStringRequireUtf8();
                        this.name_ = s;
                        continue block20;
                    }
                    case 168524208: {
                        int rawValue = input.readEnum();
                        if ((mutable_bitField0_ & 1) == 0) {
                            this.advertisedGroups_ = new ArrayList<Integer>();
                            mutable_bitField0_ |= 1;
                        }
                        this.advertisedGroups_.add(rawValue);
                        continue block20;
                    }
                    case 168524210: {
                        int length = input.readRawVarint32();
                        int oldLimit = input.pushLimit(length);
                        while (input.getBytesUntilLimit() > 0) {
                            int rawValue = input.readEnum();
                            if ((mutable_bitField0_ & 1) == 0) {
                                this.advertisedGroups_ = new ArrayList<Integer>();
                                mutable_bitField0_ |= 1;
                            }
                            this.advertisedGroups_.add(rawValue);
                        }
                        input.popLimit(oldLimit);
                        continue block20;
                    }
                    case 283599458: {
                        if ((mutable_bitField0_ & 2) == 0) {
                            this.advertisedIpRanges_ = new ArrayList<RouterAdvertisedIpRange>();
                            mutable_bitField0_ |= 2;
                        }
                        this.advertisedIpRanges_.add((RouterAdvertisedIpRange)input.readMessage(RouterAdvertisedIpRange.parser(), extensionRegistry));
                        continue block20;
                    }
                    case 349591000: {
                        int rawValue;
                        this.advertiseMode_ = rawValue = input.readEnum();
                        continue block20;
                    }
                    case 556585208: {
                        this.peerAsn_ = input.readUInt32();
                        continue block20;
                    }
                    case 1102694114: {
                        String s = input.readStringRequireUtf8();
                        this.ipAddress_ = s;
                        continue block20;
                    }
                    case 1355353738: {
                        String s = input.readStringRequireUtf8();
                        this.interfaceName_ = s;
                        continue block20;
                    }
                    case 1389628848: {
                        int rawValue;
                        this.managementType_ = rawValue = input.readEnum();
                        continue block20;
                    }
                    case 1491890656: {
                        this.advertisedRoutePriority_ = input.readUInt32();
                        continue block20;
                    }
                    case 1661886154: {
                        String s = input.readStringRequireUtf8();
                        this.peerIpAddress_ = s;
                        continue block20;
                    }
                }
                if (this.parseUnknownField(input, unknownFields, extensionRegistry, tag)) continue;
                done = true;
            }
        }
        catch (InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage((MessageLite)this);
        }
        catch (IOException e) {
            throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)this);
        }
        finally {
            if (mutable_bitField0_ & true) {
                this.advertisedGroups_ = Collections.unmodifiableList(this.advertisedGroups_);
            }
            if ((mutable_bitField0_ & 2) != 0) {
                this.advertisedIpRanges_ = Collections.unmodifiableList(this.advertisedIpRanges_);
            }
            this.unknownFields = unknownFields.build();
            this.makeExtensionsImmutable();
        }
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return Compute.internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return Compute.internal_static_google_cloud_compute_v1_RouterBgpPeer_fieldAccessorTable.ensureFieldAccessorsInitialized(RouterBgpPeer.class, Builder.class);
    }

    @Override
    public int getAdvertiseModeValue() {
        return this.advertiseMode_;
    }

    @Override
    public AdvertiseMode getAdvertiseMode() {
        AdvertiseMode result = AdvertiseMode.valueOf(this.advertiseMode_);
        return result == null ? AdvertiseMode.UNRECOGNIZED : result;
    }

    @Override
    public List<AdvertisedGroups> getAdvertisedGroupsList() {
        return new Internal.ListAdapter(this.advertisedGroups_, advertisedGroups_converter_);
    }

    @Override
    public int getAdvertisedGroupsCount() {
        return this.advertisedGroups_.size();
    }

    @Override
    public AdvertisedGroups getAdvertisedGroups(int index) {
        return (AdvertisedGroups)((Object)advertisedGroups_converter_.convert((Object)this.advertisedGroups_.get(index)));
    }

    @Override
    public List<Integer> getAdvertisedGroupsValueList() {
        return this.advertisedGroups_;
    }

    @Override
    public int getAdvertisedGroupsValue(int index) {
        return this.advertisedGroups_.get(index);
    }

    @Override
    public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
        return this.advertisedIpRanges_;
    }

    @Override
    public List<? extends RouterAdvertisedIpRangeOrBuilder> getAdvertisedIpRangesOrBuilderList() {
        return this.advertisedIpRanges_;
    }

    @Override
    public int getAdvertisedIpRangesCount() {
        return this.advertisedIpRanges_.size();
    }

    @Override
    public RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
        return this.advertisedIpRanges_.get(index);
    }

    @Override
    public RouterAdvertisedIpRangeOrBuilder getAdvertisedIpRangesOrBuilder(int index) {
        return this.advertisedIpRanges_.get(index);
    }

    @Override
    public int getAdvertisedRoutePriority() {
        return this.advertisedRoutePriority_;
    }

    @Override
    public String getInterfaceName() {
        Object ref = this.interfaceName_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.interfaceName_ = s;
        return s;
    }

    @Override
    public ByteString getInterfaceNameBytes() {
        Object ref = this.interfaceName_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.interfaceName_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public String getIpAddress() {
        Object ref = this.ipAddress_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.ipAddress_ = s;
        return s;
    }

    @Override
    public ByteString getIpAddressBytes() {
        Object ref = this.ipAddress_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.ipAddress_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getManagementTypeValue() {
        return this.managementType_;
    }

    @Override
    public ManagementType getManagementType() {
        ManagementType result = ManagementType.valueOf(this.managementType_);
        return result == null ? ManagementType.UNRECOGNIZED : result;
    }

    @Override
    public String getName() {
        Object ref = this.name_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.name_ = s;
        return s;
    }

    @Override
    public ByteString getNameBytes() {
        Object ref = this.name_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.name_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    @Override
    public int getPeerAsn() {
        return this.peerAsn_;
    }

    @Override
    public String getPeerIpAddress() {
        Object ref = this.peerIpAddress_;
        if (ref instanceof String) {
            return (String)ref;
        }
        ByteString bs = (ByteString)ref;
        String s = bs.toStringUtf8();
        this.peerIpAddress_ = s;
        return s;
    }

    @Override
    public ByteString getPeerIpAddressBytes() {
        Object ref = this.peerIpAddress_;
        if (ref instanceof String) {
            ByteString b = ByteString.copyFromUtf8((String)((String)ref));
            this.peerIpAddress_ = b;
            return b;
        }
        return (ByteString)ref;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        int i;
        this.getSerializedSize();
        if (!this.getNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)3373707, (Object)this.name_);
        }
        if (this.getAdvertisedGroupsList().size() > 0) {
            output.writeUInt32NoTag(168524210);
            output.writeUInt32NoTag(this.advertisedGroupsMemoizedSerializedSize);
        }
        for (i = 0; i < this.advertisedGroups_.size(); ++i) {
            output.writeEnumNoTag(this.advertisedGroups_.get(i).intValue());
        }
        for (i = 0; i < this.advertisedIpRanges_.size(); ++i) {
            output.writeMessage(35449932, (MessageLite)this.advertisedIpRanges_.get(i));
        }
        if (this.advertiseMode_ != AdvertiseMode.UNDEFINED_ADVERTISE_MODE.getNumber()) {
            output.writeEnum(43698875, this.advertiseMode_);
        }
        if (this.peerAsn_ != 0) {
            output.writeUInt32(69573151, this.peerAsn_);
        }
        if (!this.getIpAddressBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)137836764, (Object)this.ipAddress_);
        }
        if (!this.getInterfaceNameBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)169419217, (Object)this.interfaceName_);
        }
        if (this.managementType_ != ManagementType.UNDEFINED_MANAGEMENT_TYPE.getNumber()) {
            output.writeEnum(173703606, this.managementType_);
        }
        if (this.advertisedRoutePriority_ != 0) {
            output.writeUInt32(186486332, this.advertisedRoutePriority_);
        }
        if (!this.getPeerIpAddressBytes().isEmpty()) {
            GeneratedMessageV3.writeString((CodedOutputStream)output, (int)207735769, (Object)this.peerIpAddress_);
        }
        this.unknownFields.writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        if (!this.getNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)3373707, (Object)this.name_);
        }
        int dataSize = 0;
        for (int i = 0; i < this.advertisedGroups_.size(); ++i) {
            dataSize += CodedOutputStream.computeEnumSizeNoTag((int)this.advertisedGroups_.get(i));
        }
        size += dataSize;
        if (!this.getAdvertisedGroupsList().isEmpty()) {
            size += 4;
            size += CodedOutputStream.computeUInt32SizeNoTag((int)dataSize);
        }
        this.advertisedGroupsMemoizedSerializedSize = dataSize;
        for (int i = 0; i < this.advertisedIpRanges_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)35449932, (MessageLite)((MessageLite)this.advertisedIpRanges_.get(i)));
        }
        if (this.advertiseMode_ != AdvertiseMode.UNDEFINED_ADVERTISE_MODE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)43698875, (int)this.advertiseMode_);
        }
        if (this.peerAsn_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)69573151, (int)this.peerAsn_);
        }
        if (!this.getIpAddressBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)137836764, (Object)this.ipAddress_);
        }
        if (!this.getInterfaceNameBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)169419217, (Object)this.interfaceName_);
        }
        if (this.managementType_ != ManagementType.UNDEFINED_MANAGEMENT_TYPE.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)173703606, (int)this.managementType_);
        }
        if (this.advertisedRoutePriority_ != 0) {
            size += CodedOutputStream.computeUInt32Size((int)186486332, (int)this.advertisedRoutePriority_);
        }
        if (!this.getPeerIpAddressBytes().isEmpty()) {
            size += GeneratedMessageV3.computeStringSize((int)207735769, (Object)this.peerIpAddress_);
        }
        this.memoizedSize = size += this.unknownFields.getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof RouterBgpPeer)) {
            return super.equals(obj);
        }
        RouterBgpPeer other = (RouterBgpPeer)obj;
        if (this.advertiseMode_ != other.advertiseMode_) {
            return false;
        }
        if (!this.advertisedGroups_.equals(other.advertisedGroups_)) {
            return false;
        }
        if (!this.getAdvertisedIpRangesList().equals(other.getAdvertisedIpRangesList())) {
            return false;
        }
        if (this.getAdvertisedRoutePriority() != other.getAdvertisedRoutePriority()) {
            return false;
        }
        if (!this.getInterfaceName().equals(other.getInterfaceName())) {
            return false;
        }
        if (!this.getIpAddress().equals(other.getIpAddress())) {
            return false;
        }
        if (this.managementType_ != other.managementType_) {
            return false;
        }
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        if (this.getPeerAsn() != other.getPeerAsn()) {
            return false;
        }
        if (!this.getPeerIpAddress().equals(other.getPeerIpAddress())) {
            return false;
        }
        return this.unknownFields.equals((Object)other.unknownFields);
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + RouterBgpPeer.getDescriptor().hashCode();
        hash = 37 * hash + 43698875;
        hash = 53 * hash + this.advertiseMode_;
        if (this.getAdvertisedGroupsCount() > 0) {
            hash = 37 * hash + 21065526;
            hash = 53 * hash + this.advertisedGroups_.hashCode();
        }
        if (this.getAdvertisedIpRangesCount() > 0) {
            hash = 37 * hash + 35449932;
            hash = 53 * hash + this.getAdvertisedIpRangesList().hashCode();
        }
        hash = 37 * hash + 186486332;
        hash = 53 * hash + this.getAdvertisedRoutePriority();
        hash = 37 * hash + 169419217;
        hash = 53 * hash + this.getInterfaceName().hashCode();
        hash = 37 * hash + 137836764;
        hash = 53 * hash + this.getIpAddress().hashCode();
        hash = 37 * hash + 173703606;
        hash = 53 * hash + this.managementType_;
        hash = 37 * hash + 3373707;
        hash = 53 * hash + this.getName().hashCode();
        hash = 37 * hash + 69573151;
        hash = 53 * hash + this.getPeerAsn();
        hash = 37 * hash + 207735769;
        hash = 53 * hash + this.getPeerIpAddress().hashCode();
        this.memoizedHashCode = hash = 29 * hash + this.unknownFields.hashCode();
        return hash;
    }

    public static RouterBgpPeer parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data);
    }

    public static RouterBgpPeer parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RouterBgpPeer parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data);
    }

    public static RouterBgpPeer parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RouterBgpPeer parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data);
    }

    public static RouterBgpPeer parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (RouterBgpPeer)PARSER.parseFrom(data, extensionRegistry);
    }

    public static RouterBgpPeer parseFrom(InputStream input) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static RouterBgpPeer parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static RouterBgpPeer parseDelimitedFrom(InputStream input) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static RouterBgpPeer parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static RouterBgpPeer parseFrom(CodedInputStream input) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static RouterBgpPeer parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (RouterBgpPeer)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return RouterBgpPeer.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(RouterBgpPeer prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static RouterBgpPeer getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<RouterBgpPeer> parser() {
        return PARSER;
    }

    public Parser<RouterBgpPeer> getParserForType() {
        return PARSER;
    }

    public RouterBgpPeer getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements RouterBgpPeerOrBuilder {
        private int bitField0_;
        private int advertiseMode_ = 0;
        private List<Integer> advertisedGroups_ = Collections.emptyList();
        private List<RouterAdvertisedIpRange> advertisedIpRanges_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<RouterAdvertisedIpRange, RouterAdvertisedIpRange.Builder, RouterAdvertisedIpRangeOrBuilder> advertisedIpRangesBuilder_;
        private int advertisedRoutePriority_;
        private Object interfaceName_ = "";
        private Object ipAddress_ = "";
        private int managementType_ = 0;
        private Object name_ = "";
        private int peerAsn_;
        private Object peerIpAddress_ = "";

        public static final Descriptors.Descriptor getDescriptor() {
            return Compute.internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return Compute.internal_static_google_cloud_compute_v1_RouterBgpPeer_fieldAccessorTable.ensureFieldAccessorsInitialized(RouterBgpPeer.class, Builder.class);
        }

        private Builder() {
            this.maybeForceBuilderInitialization();
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
            this.maybeForceBuilderInitialization();
        }

        private void maybeForceBuilderInitialization() {
            if (alwaysUseFieldBuilders) {
                this.getAdvertisedIpRangesFieldBuilder();
            }
        }

        public Builder clear() {
            super.clear();
            this.advertiseMode_ = 0;
            this.advertisedGroups_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            if (this.advertisedIpRangesBuilder_ == null) {
                this.advertisedIpRanges_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
            } else {
                this.advertisedIpRangesBuilder_.clear();
            }
            this.advertisedRoutePriority_ = 0;
            this.interfaceName_ = "";
            this.ipAddress_ = "";
            this.managementType_ = 0;
            this.name_ = "";
            this.peerAsn_ = 0;
            this.peerIpAddress_ = "";
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return Compute.internal_static_google_cloud_compute_v1_RouterBgpPeer_descriptor;
        }

        public RouterBgpPeer getDefaultInstanceForType() {
            return RouterBgpPeer.getDefaultInstance();
        }

        public RouterBgpPeer build() {
            RouterBgpPeer result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public RouterBgpPeer buildPartial() {
            RouterBgpPeer result = new RouterBgpPeer(this);
            int from_bitField0_ = this.bitField0_;
            result.advertiseMode_ = this.advertiseMode_;
            if ((this.bitField0_ & 1) != 0) {
                this.advertisedGroups_ = Collections.unmodifiableList(this.advertisedGroups_);
                this.bitField0_ &= 0xFFFFFFFE;
            }
            result.advertisedGroups_ = this.advertisedGroups_;
            if (this.advertisedIpRangesBuilder_ == null) {
                if ((this.bitField0_ & 2) != 0) {
                    this.advertisedIpRanges_ = Collections.unmodifiableList(this.advertisedIpRanges_);
                    this.bitField0_ &= 0xFFFFFFFD;
                }
                result.advertisedIpRanges_ = this.advertisedIpRanges_;
            } else {
                result.advertisedIpRanges_ = this.advertisedIpRangesBuilder_.build();
            }
            result.advertisedRoutePriority_ = this.advertisedRoutePriority_;
            result.interfaceName_ = this.interfaceName_;
            result.ipAddress_ = this.ipAddress_;
            result.managementType_ = this.managementType_;
            result.name_ = this.name_;
            result.peerAsn_ = this.peerAsn_;
            result.peerIpAddress_ = this.peerIpAddress_;
            this.onBuilt();
            return result;
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof RouterBgpPeer) {
                return this.mergeFrom((RouterBgpPeer)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(RouterBgpPeer other) {
            if (other == RouterBgpPeer.getDefaultInstance()) {
                return this;
            }
            if (other.advertiseMode_ != 0) {
                this.setAdvertiseModeValue(other.getAdvertiseModeValue());
            }
            if (!other.advertisedGroups_.isEmpty()) {
                if (this.advertisedGroups_.isEmpty()) {
                    this.advertisedGroups_ = other.advertisedGroups_;
                    this.bitField0_ &= 0xFFFFFFFE;
                } else {
                    this.ensureAdvertisedGroupsIsMutable();
                    this.advertisedGroups_.addAll(other.advertisedGroups_);
                }
                this.onChanged();
            }
            if (this.advertisedIpRangesBuilder_ == null) {
                if (!other.advertisedIpRanges_.isEmpty()) {
                    if (this.advertisedIpRanges_.isEmpty()) {
                        this.advertisedIpRanges_ = other.advertisedIpRanges_;
                        this.bitField0_ &= 0xFFFFFFFD;
                    } else {
                        this.ensureAdvertisedIpRangesIsMutable();
                        this.advertisedIpRanges_.addAll(other.advertisedIpRanges_);
                    }
                    this.onChanged();
                }
            } else if (!other.advertisedIpRanges_.isEmpty()) {
                if (this.advertisedIpRangesBuilder_.isEmpty()) {
                    this.advertisedIpRangesBuilder_.dispose();
                    this.advertisedIpRangesBuilder_ = null;
                    this.advertisedIpRanges_ = other.advertisedIpRanges_;
                    this.bitField0_ &= 0xFFFFFFFD;
                    this.advertisedIpRangesBuilder_ = alwaysUseFieldBuilders ? this.getAdvertisedIpRangesFieldBuilder() : null;
                } else {
                    this.advertisedIpRangesBuilder_.addAllMessages((Iterable)other.advertisedIpRanges_);
                }
            }
            if (other.getAdvertisedRoutePriority() != 0) {
                this.setAdvertisedRoutePriority(other.getAdvertisedRoutePriority());
            }
            if (!other.getInterfaceName().isEmpty()) {
                this.interfaceName_ = other.interfaceName_;
                this.onChanged();
            }
            if (!other.getIpAddress().isEmpty()) {
                this.ipAddress_ = other.ipAddress_;
                this.onChanged();
            }
            if (other.managementType_ != 0) {
                this.setManagementTypeValue(other.getManagementTypeValue());
            }
            if (!other.getName().isEmpty()) {
                this.name_ = other.name_;
                this.onChanged();
            }
            if (other.getPeerAsn() != 0) {
                this.setPeerAsn(other.getPeerAsn());
            }
            if (!other.getPeerIpAddress().isEmpty()) {
                this.peerIpAddress_ = other.peerIpAddress_;
                this.onChanged();
            }
            this.mergeUnknownFields(other.unknownFields);
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            RouterBgpPeer parsedMessage = null;
            try {
                parsedMessage = (RouterBgpPeer)PARSER.parsePartialFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                parsedMessage = (RouterBgpPeer)e.getUnfinishedMessage();
                throw e.unwrapIOException();
            }
            finally {
                if (parsedMessage != null) {
                    this.mergeFrom(parsedMessage);
                }
            }
            return this;
        }

        @Override
        public int getAdvertiseModeValue() {
            return this.advertiseMode_;
        }

        public Builder setAdvertiseModeValue(int value) {
            this.advertiseMode_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public AdvertiseMode getAdvertiseMode() {
            AdvertiseMode result = AdvertiseMode.valueOf(this.advertiseMode_);
            return result == null ? AdvertiseMode.UNRECOGNIZED : result;
        }

        public Builder setAdvertiseMode(AdvertiseMode value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.advertiseMode_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearAdvertiseMode() {
            this.advertiseMode_ = 0;
            this.onChanged();
            return this;
        }

        private void ensureAdvertisedGroupsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.advertisedGroups_ = new ArrayList<Integer>(this.advertisedGroups_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<AdvertisedGroups> getAdvertisedGroupsList() {
            return new Internal.ListAdapter(this.advertisedGroups_, advertisedGroups_converter_);
        }

        @Override
        public int getAdvertisedGroupsCount() {
            return this.advertisedGroups_.size();
        }

        @Override
        public AdvertisedGroups getAdvertisedGroups(int index) {
            return (AdvertisedGroups)((Object)advertisedGroups_converter_.convert((Object)this.advertisedGroups_.get(index)));
        }

        public Builder setAdvertisedGroups(int index, AdvertisedGroups value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdvertisedGroupsIsMutable();
            this.advertisedGroups_.set(index, value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAdvertisedGroups(AdvertisedGroups value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ensureAdvertisedGroupsIsMutable();
            this.advertisedGroups_.add(value.getNumber());
            this.onChanged();
            return this;
        }

        public Builder addAllAdvertisedGroups(Iterable<? extends AdvertisedGroups> values) {
            this.ensureAdvertisedGroupsIsMutable();
            for (AdvertisedGroups advertisedGroups : values) {
                this.advertisedGroups_.add(advertisedGroups.getNumber());
            }
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisedGroups() {
            this.advertisedGroups_ = Collections.emptyList();
            this.bitField0_ &= 0xFFFFFFFE;
            this.onChanged();
            return this;
        }

        @Override
        public List<Integer> getAdvertisedGroupsValueList() {
            return Collections.unmodifiableList(this.advertisedGroups_);
        }

        @Override
        public int getAdvertisedGroupsValue(int index) {
            return this.advertisedGroups_.get(index);
        }

        public Builder setAdvertisedGroupsValue(int index, int value) {
            this.ensureAdvertisedGroupsIsMutable();
            this.advertisedGroups_.set(index, value);
            this.onChanged();
            return this;
        }

        public Builder addAdvertisedGroupsValue(int value) {
            this.ensureAdvertisedGroupsIsMutable();
            this.advertisedGroups_.add(value);
            this.onChanged();
            return this;
        }

        public Builder addAllAdvertisedGroupsValue(Iterable<Integer> values) {
            this.ensureAdvertisedGroupsIsMutable();
            for (int value : values) {
                this.advertisedGroups_.add(value);
            }
            this.onChanged();
            return this;
        }

        private void ensureAdvertisedIpRangesIsMutable() {
            if ((this.bitField0_ & 2) == 0) {
                this.advertisedIpRanges_ = new ArrayList<RouterAdvertisedIpRange>(this.advertisedIpRanges_);
                this.bitField0_ |= 2;
            }
        }

        @Override
        public List<RouterAdvertisedIpRange> getAdvertisedIpRangesList() {
            if (this.advertisedIpRangesBuilder_ == null) {
                return Collections.unmodifiableList(this.advertisedIpRanges_);
            }
            return this.advertisedIpRangesBuilder_.getMessageList();
        }

        @Override
        public int getAdvertisedIpRangesCount() {
            if (this.advertisedIpRangesBuilder_ == null) {
                return this.advertisedIpRanges_.size();
            }
            return this.advertisedIpRangesBuilder_.getCount();
        }

        @Override
        public RouterAdvertisedIpRange getAdvertisedIpRanges(int index) {
            if (this.advertisedIpRangesBuilder_ == null) {
                return this.advertisedIpRanges_.get(index);
            }
            return (RouterAdvertisedIpRange)this.advertisedIpRangesBuilder_.getMessage(index);
        }

        public Builder setAdvertisedIpRanges(int index, RouterAdvertisedIpRange value) {
            if (this.advertisedIpRangesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.set(index, value);
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAdvertisedIpRanges(int index, RouterAdvertisedIpRange.Builder builderForValue) {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdvertisedIpRanges(RouterAdvertisedIpRange value) {
            if (this.advertisedIpRangesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.add(value);
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdvertisedIpRanges(int index, RouterAdvertisedIpRange value) {
            if (this.advertisedIpRangesBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.add(index, value);
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAdvertisedIpRanges(RouterAdvertisedIpRange.Builder builderForValue) {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAdvertisedIpRanges(int index, RouterAdvertisedIpRange.Builder builderForValue) {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAdvertisedIpRanges(Iterable<? extends RouterAdvertisedIpRange> values) {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.ensureAdvertisedIpRangesIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.advertisedIpRanges_);
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAdvertisedIpRanges() {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.advertisedIpRanges_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFD;
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.clear();
            }
            return this;
        }

        public Builder removeAdvertisedIpRanges(int index) {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.ensureAdvertisedIpRangesIsMutable();
                this.advertisedIpRanges_.remove(index);
                this.onChanged();
            } else {
                this.advertisedIpRangesBuilder_.remove(index);
            }
            return this;
        }

        public RouterAdvertisedIpRange.Builder getAdvertisedIpRangesBuilder(int index) {
            return (RouterAdvertisedIpRange.Builder)this.getAdvertisedIpRangesFieldBuilder().getBuilder(index);
        }

        @Override
        public RouterAdvertisedIpRangeOrBuilder getAdvertisedIpRangesOrBuilder(int index) {
            if (this.advertisedIpRangesBuilder_ == null) {
                return this.advertisedIpRanges_.get(index);
            }
            return (RouterAdvertisedIpRangeOrBuilder)this.advertisedIpRangesBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends RouterAdvertisedIpRangeOrBuilder> getAdvertisedIpRangesOrBuilderList() {
            if (this.advertisedIpRangesBuilder_ != null) {
                return this.advertisedIpRangesBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.advertisedIpRanges_);
        }

        public RouterAdvertisedIpRange.Builder addAdvertisedIpRangesBuilder() {
            return (RouterAdvertisedIpRange.Builder)this.getAdvertisedIpRangesFieldBuilder().addBuilder((AbstractMessage)RouterAdvertisedIpRange.getDefaultInstance());
        }

        public RouterAdvertisedIpRange.Builder addAdvertisedIpRangesBuilder(int index) {
            return (RouterAdvertisedIpRange.Builder)this.getAdvertisedIpRangesFieldBuilder().addBuilder(index, (AbstractMessage)RouterAdvertisedIpRange.getDefaultInstance());
        }

        public List<RouterAdvertisedIpRange.Builder> getAdvertisedIpRangesBuilderList() {
            return this.getAdvertisedIpRangesFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<RouterAdvertisedIpRange, RouterAdvertisedIpRange.Builder, RouterAdvertisedIpRangeOrBuilder> getAdvertisedIpRangesFieldBuilder() {
            if (this.advertisedIpRangesBuilder_ == null) {
                this.advertisedIpRangesBuilder_ = new RepeatedFieldBuilderV3(this.advertisedIpRanges_, (this.bitField0_ & 2) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.advertisedIpRanges_ = null;
            }
            return this.advertisedIpRangesBuilder_;
        }

        @Override
        public int getAdvertisedRoutePriority() {
            return this.advertisedRoutePriority_;
        }

        public Builder setAdvertisedRoutePriority(int value) {
            this.advertisedRoutePriority_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearAdvertisedRoutePriority() {
            this.advertisedRoutePriority_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getInterfaceName() {
            Object ref = this.interfaceName_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.interfaceName_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getInterfaceNameBytes() {
            Object ref = this.interfaceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.interfaceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setInterfaceName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.interfaceName_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearInterfaceName() {
            this.interfaceName_ = RouterBgpPeer.getDefaultInstance().getInterfaceName();
            this.onChanged();
            return this;
        }

        public Builder setInterfaceNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RouterBgpPeer.checkByteStringIsUtf8((ByteString)value);
            this.interfaceName_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public String getIpAddress() {
            Object ref = this.ipAddress_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.ipAddress_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getIpAddressBytes() {
            Object ref = this.ipAddress_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.ipAddress_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setIpAddress(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.ipAddress_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearIpAddress() {
            this.ipAddress_ = RouterBgpPeer.getDefaultInstance().getIpAddress();
            this.onChanged();
            return this;
        }

        public Builder setIpAddressBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RouterBgpPeer.checkByteStringIsUtf8((ByteString)value);
            this.ipAddress_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getManagementTypeValue() {
            return this.managementType_;
        }

        public Builder setManagementTypeValue(int value) {
            this.managementType_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public ManagementType getManagementType() {
            ManagementType result = ManagementType.valueOf(this.managementType_);
            return result == null ? ManagementType.UNRECOGNIZED : result;
        }

        public Builder setManagementType(ManagementType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.managementType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearManagementType() {
            this.managementType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getName() {
            Object ref = this.name_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.name_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getNameBytes() {
            Object ref = this.name_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.name_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setName(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.name_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearName() {
            this.name_ = RouterBgpPeer.getDefaultInstance().getName();
            this.onChanged();
            return this;
        }

        public Builder setNameBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RouterBgpPeer.checkByteStringIsUtf8((ByteString)value);
            this.name_ = value;
            this.onChanged();
            return this;
        }

        @Override
        public int getPeerAsn() {
            return this.peerAsn_;
        }

        public Builder setPeerAsn(int value) {
            this.peerAsn_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPeerAsn() {
            this.peerAsn_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public String getPeerIpAddress() {
            Object ref = this.peerIpAddress_;
            if (!(ref instanceof String)) {
                ByteString bs = (ByteString)ref;
                String s = bs.toStringUtf8();
                this.peerIpAddress_ = s;
                return s;
            }
            return (String)ref;
        }

        @Override
        public ByteString getPeerIpAddressBytes() {
            Object ref = this.peerIpAddress_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.peerIpAddress_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        public Builder setPeerIpAddress(String value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.peerIpAddress_ = value;
            this.onChanged();
            return this;
        }

        public Builder clearPeerIpAddress() {
            this.peerIpAddress_ = RouterBgpPeer.getDefaultInstance().getPeerIpAddress();
            this.onChanged();
            return this;
        }

        public Builder setPeerIpAddressBytes(ByteString value) {
            if (value == null) {
                throw new NullPointerException();
            }
            RouterBgpPeer.checkByteStringIsUtf8((ByteString)value);
            this.peerIpAddress_ = value;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static enum ManagementType implements ProtocolMessageEnum
    {
        UNDEFINED_MANAGEMENT_TYPE(0),
        MANAGED_BY_ATTACHMENT(190490955),
        MANAGED_BY_USER(48858611),
        UNRECOGNIZED(-1);

        public static final int UNDEFINED_MANAGEMENT_TYPE_VALUE = 0;
        public static final int MANAGED_BY_ATTACHMENT_VALUE = 190490955;
        public static final int MANAGED_BY_USER_VALUE = 48858611;
        private static final Internal.EnumLiteMap<ManagementType> internalValueMap;
        private static final ManagementType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static ManagementType valueOf(int value) {
            return ManagementType.forNumber(value);
        }

        public static ManagementType forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNDEFINED_MANAGEMENT_TYPE;
                }
                case 190490955: {
                    return MANAGED_BY_ATTACHMENT;
                }
                case 48858611: {
                    return MANAGED_BY_USER;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<ManagementType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)ManagementType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return ManagementType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)RouterBgpPeer.getDescriptor().getEnumTypes().get(2);
        }

        public static ManagementType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != ManagementType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private ManagementType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<ManagementType>(){

                public ManagementType findValueByNumber(int number) {
                    return ManagementType.forNumber(number);
                }
            };
            VALUES = ManagementType.values();
        }
    }

    public static enum AdvertisedGroups implements ProtocolMessageEnum
    {
        UNDEFINED_ADVERTISED_GROUPS(0),
        ALL_SUBNETS(3622872),
        UNRECOGNIZED(-1);

        public static final int UNDEFINED_ADVERTISED_GROUPS_VALUE = 0;
        public static final int ALL_SUBNETS_VALUE = 3622872;
        private static final Internal.EnumLiteMap<AdvertisedGroups> internalValueMap;
        private static final AdvertisedGroups[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AdvertisedGroups valueOf(int value) {
            return AdvertisedGroups.forNumber(value);
        }

        public static AdvertisedGroups forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNDEFINED_ADVERTISED_GROUPS;
                }
                case 3622872: {
                    return ALL_SUBNETS;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AdvertisedGroups> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AdvertisedGroups.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AdvertisedGroups.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)RouterBgpPeer.getDescriptor().getEnumTypes().get(1);
        }

        public static AdvertisedGroups valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AdvertisedGroups.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AdvertisedGroups(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<AdvertisedGroups>(){

                public AdvertisedGroups findValueByNumber(int number) {
                    return AdvertisedGroups.forNumber(number);
                }
            };
            VALUES = AdvertisedGroups.values();
        }
    }

    public static enum AdvertiseMode implements ProtocolMessageEnum
    {
        UNDEFINED_ADVERTISE_MODE(0),
        CUSTOM(120160113),
        DEFAULT(115302945),
        UNRECOGNIZED(-1);

        public static final int UNDEFINED_ADVERTISE_MODE_VALUE = 0;
        public static final int CUSTOM_VALUE = 120160113;
        public static final int DEFAULT_VALUE = 115302945;
        private static final Internal.EnumLiteMap<AdvertiseMode> internalValueMap;
        private static final AdvertiseMode[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static AdvertiseMode valueOf(int value) {
            return AdvertiseMode.forNumber(value);
        }

        public static AdvertiseMode forNumber(int value) {
            switch (value) {
                case 0: {
                    return UNDEFINED_ADVERTISE_MODE;
                }
                case 120160113: {
                    return CUSTOM;
                }
                case 115302945: {
                    return DEFAULT;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<AdvertiseMode> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)AdvertiseMode.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return AdvertiseMode.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)RouterBgpPeer.getDescriptor().getEnumTypes().get(0);
        }

        public static AdvertiseMode valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != AdvertiseMode.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private AdvertiseMode(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<AdvertiseMode>(){

                public AdvertiseMode findValueByNumber(int number) {
                    return AdvertiseMode.forNumber(number);
                }
            };
            VALUES = AdvertiseMode.values();
        }
    }
}

