/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class FrameworkComplianceSummaryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/frameworkComplianceSummaries/{framework_compliance_summary}");
    private static final PathTemplate FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/frameworkComplianceSummaries/{framework_compliance_summary}");
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworkComplianceSummaries/{framework_compliance_summary}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String frameworkComplianceSummary;
    private final String folder;
    private final String organization;

    @Deprecated
    protected FrameworkComplianceSummaryName() {
        this.project = null;
        this.location = null;
        this.frameworkComplianceSummary = null;
        this.folder = null;
        this.organization = null;
    }

    private FrameworkComplianceSummaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceSummary());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY;
    }

    private FrameworkComplianceSummaryName(FolderLocationFrameworkComplianceSummaryBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceSummary());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY;
    }

    private FrameworkComplianceSummaryName(OrganizationLocationFrameworkComplianceSummaryBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceSummary());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameworkComplianceSummary() {
        return this.frameworkComplianceSummary;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationFrameworkComplianceSummaryBuilder() {
        return new Builder();
    }

    public static FolderLocationFrameworkComplianceSummaryBuilder newFolderLocationFrameworkComplianceSummaryBuilder() {
        return new FolderLocationFrameworkComplianceSummaryBuilder();
    }

    public static OrganizationLocationFrameworkComplianceSummaryBuilder newOrganizationLocationFrameworkComplianceSummaryBuilder() {
        return new OrganizationLocationFrameworkComplianceSummaryBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static FrameworkComplianceSummaryName of(String project, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build();
    }

    public static FrameworkComplianceSummaryName ofProjectLocationFrameworkComplianceSummaryName(String project, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build();
    }

    public static FrameworkComplianceSummaryName ofFolderLocationFrameworkComplianceSummaryName(String folder, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newFolderLocationFrameworkComplianceSummaryBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build();
    }

    public static FrameworkComplianceSummaryName ofOrganizationLocationFrameworkComplianceSummaryName(String organization, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newOrganizationLocationFrameworkComplianceSummaryBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build();
    }

    public static String format(String project, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build().toString();
    }

    public static String formatProjectLocationFrameworkComplianceSummaryName(String project, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build().toString();
    }

    public static String formatFolderLocationFrameworkComplianceSummaryName(String folder, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newFolderLocationFrameworkComplianceSummaryBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build().toString();
    }

    public static String formatOrganizationLocationFrameworkComplianceSummaryName(String organization, String location, String frameworkComplianceSummary) {
        return FrameworkComplianceSummaryName.newOrganizationLocationFrameworkComplianceSummaryBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceSummary(frameworkComplianceSummary).build().toString();
    }

    public static FrameworkComplianceSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.match(formattedString);
            return FrameworkComplianceSummaryName.ofProjectLocationFrameworkComplianceSummaryName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_summary"));
        }
        if (FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.match(formattedString);
            return FrameworkComplianceSummaryName.ofFolderLocationFrameworkComplianceSummaryName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_summary"));
        }
        if (ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.match(formattedString);
            return FrameworkComplianceSummaryName.ofOrganizationLocationFrameworkComplianceSummaryName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_summary"));
        }
        throw new ValidationException("FrameworkComplianceSummaryName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<FrameworkComplianceSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<FrameworkComplianceSummaryName> list = new ArrayList<FrameworkComplianceSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(FrameworkComplianceSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<FrameworkComplianceSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (FrameworkComplianceSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString) || FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString) || ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            FrameworkComplianceSummaryName frameworkComplianceSummaryName = this;
            synchronized (frameworkComplianceSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.frameworkComplianceSummary != null) {
                        fieldMapBuilder.put((Object)"framework_compliance_summary", (Object)this.frameworkComplianceSummary);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            FrameworkComplianceSummaryName that = (FrameworkComplianceSummaryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.frameworkComplianceSummary, that.frameworkComplianceSummary) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.frameworkComplianceSummary);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationFrameworkComplianceSummaryBuilder {
        private String organization;
        private String location;
        private String frameworkComplianceSummary;

        protected OrganizationLocationFrameworkComplianceSummaryBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceSummary() {
            return this.frameworkComplianceSummary;
        }

        public OrganizationLocationFrameworkComplianceSummaryBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationFrameworkComplianceSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationFrameworkComplianceSummaryBuilder setFrameworkComplianceSummary(String frameworkComplianceSummary) {
            this.frameworkComplianceSummary = frameworkComplianceSummary;
            return this;
        }

        public FrameworkComplianceSummaryName build() {
            return new FrameworkComplianceSummaryName(this);
        }
    }

    public static class FolderLocationFrameworkComplianceSummaryBuilder {
        private String folder;
        private String location;
        private String frameworkComplianceSummary;

        protected FolderLocationFrameworkComplianceSummaryBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceSummary() {
            return this.frameworkComplianceSummary;
        }

        public FolderLocationFrameworkComplianceSummaryBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationFrameworkComplianceSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationFrameworkComplianceSummaryBuilder setFrameworkComplianceSummary(String frameworkComplianceSummary) {
            this.frameworkComplianceSummary = frameworkComplianceSummary;
            return this;
        }

        public FrameworkComplianceSummaryName build() {
            return new FrameworkComplianceSummaryName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String frameworkComplianceSummary;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceSummary() {
            return this.frameworkComplianceSummary;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFrameworkComplianceSummary(String frameworkComplianceSummary) {
            this.frameworkComplianceSummary = frameworkComplianceSummary;
            return this;
        }

        private Builder(FrameworkComplianceSummaryName frameworkComplianceSummaryName) {
            Preconditions.checkArgument((boolean)Objects.equals(frameworkComplianceSummaryName.pathTemplate, PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_SUMMARY), (Object)"toBuilder is only supported when FrameworkComplianceSummaryName has the pattern of projects/{project}/locations/{location}/frameworkComplianceSummaries/{framework_compliance_summary}");
            this.project = frameworkComplianceSummaryName.project;
            this.location = frameworkComplianceSummaryName.location;
            this.frameworkComplianceSummary = frameworkComplianceSummaryName.frameworkComplianceSummary;
        }

        public FrameworkComplianceSummaryName build() {
            return new FrameworkComplianceSummaryName(this);
        }
    }
}

