/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ControlComplianceSummaryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}/controlComplianceSummaries/{control_compliance_summary}");
    private static final PathTemplate FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"folders/{folder}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}/controlComplianceSummaries/{control_compliance_summary}");
    private static final PathTemplate ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}/controlComplianceSummaries/{control_compliance_summary}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String location;
    private final String frameworkComplianceReport;
    private final String controlComplianceSummary;
    private final String folder;
    private final String organization;

    @Deprecated
    protected ControlComplianceSummaryName() {
        this.project = null;
        this.location = null;
        this.frameworkComplianceReport = null;
        this.controlComplianceSummary = null;
        this.folder = null;
        this.organization = null;
    }

    private ControlComplianceSummaryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.controlComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getControlComplianceSummary());
        this.folder = null;
        this.organization = null;
        this.pathTemplate = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY;
    }

    private ControlComplianceSummaryName(FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder builder) {
        this.folder = (String)Preconditions.checkNotNull((Object)builder.getFolder());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.controlComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getControlComplianceSummary());
        this.project = null;
        this.organization = null;
        this.pathTemplate = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY;
    }

    private ControlComplianceSummaryName(OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.frameworkComplianceReport = (String)Preconditions.checkNotNull((Object)builder.getFrameworkComplianceReport());
        this.controlComplianceSummary = (String)Preconditions.checkNotNull((Object)builder.getControlComplianceSummary());
        this.project = null;
        this.folder = null;
        this.pathTemplate = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY;
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getFrameworkComplianceReport() {
        return this.frameworkComplianceReport;
    }

    public String getControlComplianceSummary() {
        return this.controlComplianceSummary;
    }

    public String getFolder() {
        return this.folder;
    }

    public String getOrganization() {
        return this.organization;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectLocationFrameworkComplianceReportControlComplianceSummaryBuilder() {
        return new Builder();
    }

    public static FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder newFolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder() {
        return new FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder();
    }

    public static OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder newOrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder() {
        return new OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ControlComplianceSummaryName of(String project, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build();
    }

    public static ControlComplianceSummaryName ofProjectLocationFrameworkComplianceReportControlComplianceSummaryName(String project, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build();
    }

    public static ControlComplianceSummaryName ofFolderLocationFrameworkComplianceReportControlComplianceSummaryName(String folder, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newFolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build();
    }

    public static ControlComplianceSummaryName ofOrganizationLocationFrameworkComplianceReportControlComplianceSummaryName(String organization, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newOrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build();
    }

    public static String format(String project, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build().toString();
    }

    public static String formatProjectLocationFrameworkComplianceReportControlComplianceSummaryName(String project, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newBuilder().setProject(project).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build().toString();
    }

    public static String formatFolderLocationFrameworkComplianceReportControlComplianceSummaryName(String folder, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newFolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder().setFolder(folder).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build().toString();
    }

    public static String formatOrganizationLocationFrameworkComplianceReportControlComplianceSummaryName(String organization, String location, String frameworkComplianceReport, String controlComplianceSummary) {
        return ControlComplianceSummaryName.newOrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder().setOrganization(organization).setLocation(location).setFrameworkComplianceReport(frameworkComplianceReport).setControlComplianceSummary(controlComplianceSummary).build().toString();
    }

    public static ControlComplianceSummaryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.match(formattedString);
            return ControlComplianceSummaryName.ofProjectLocationFrameworkComplianceReportControlComplianceSummaryName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"), (String)matchMap.get("control_compliance_summary"));
        }
        if (FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.match(formattedString);
            return ControlComplianceSummaryName.ofFolderLocationFrameworkComplianceReportControlComplianceSummaryName((String)matchMap.get("folder"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"), (String)matchMap.get("control_compliance_summary"));
        }
        if (ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString)) {
            Map matchMap = ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.match(formattedString);
            return ControlComplianceSummaryName.ofOrganizationLocationFrameworkComplianceReportControlComplianceSummaryName((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("framework_compliance_report"), (String)matchMap.get("control_compliance_summary"));
        }
        throw new ValidationException("ControlComplianceSummaryName.parse: formattedString not in valid format", new Object[0]);
    }

    public static List<ControlComplianceSummaryName> parseList(List<String> formattedStrings) {
        ArrayList<ControlComplianceSummaryName> list = new ArrayList<ControlComplianceSummaryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ControlComplianceSummaryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ControlComplianceSummaryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ControlComplianceSummaryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString) || FOLDER_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString) || ORGANIZATION_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ControlComplianceSummaryName controlComplianceSummaryName = this;
            synchronized (controlComplianceSummaryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.frameworkComplianceReport != null) {
                        fieldMapBuilder.put((Object)"framework_compliance_report", (Object)this.frameworkComplianceReport);
                    }
                    if (this.controlComplianceSummary != null) {
                        fieldMapBuilder.put((Object)"control_compliance_summary", (Object)this.controlComplianceSummary);
                    }
                    if (this.folder != null) {
                        fieldMapBuilder.put((Object)"folder", (Object)this.folder);
                    }
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ControlComplianceSummaryName that = (ControlComplianceSummaryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.frameworkComplianceReport, that.frameworkComplianceReport) && Objects.equals(this.controlComplianceSummary, that.controlComplianceSummary) && Objects.equals(this.folder, that.folder) && Objects.equals(this.organization, that.organization);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.frameworkComplianceReport);
        h *= 1000003;
        h ^= Objects.hashCode(this.controlComplianceSummary);
        h *= 1000003;
        h ^= Objects.hashCode(this.folder);
        h *= 1000003;
        return h ^= Objects.hashCode(this.organization);
    }

    public static class OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder {
        private String organization;
        private String location;
        private String frameworkComplianceReport;
        private String controlComplianceSummary;

        protected OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public String getControlComplianceSummary() {
            return this.controlComplianceSummary;
        }

        public OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        public OrganizationLocationFrameworkComplianceReportControlComplianceSummaryBuilder setControlComplianceSummary(String controlComplianceSummary) {
            this.controlComplianceSummary = controlComplianceSummary;
            return this;
        }

        public ControlComplianceSummaryName build() {
            return new ControlComplianceSummaryName(this);
        }
    }

    public static class FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder {
        private String folder;
        private String location;
        private String frameworkComplianceReport;
        private String controlComplianceSummary;

        protected FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder() {
        }

        public String getFolder() {
            return this.folder;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public String getControlComplianceSummary() {
            return this.controlComplianceSummary;
        }

        public FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder setFolder(String folder) {
            this.folder = folder;
            return this;
        }

        public FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        public FolderLocationFrameworkComplianceReportControlComplianceSummaryBuilder setControlComplianceSummary(String controlComplianceSummary) {
            this.controlComplianceSummary = controlComplianceSummary;
            return this;
        }

        public ControlComplianceSummaryName build() {
            return new ControlComplianceSummaryName(this);
        }
    }

    public static class Builder {
        private String project;
        private String location;
        private String frameworkComplianceReport;
        private String controlComplianceSummary;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getFrameworkComplianceReport() {
            return this.frameworkComplianceReport;
        }

        public String getControlComplianceSummary() {
            return this.controlComplianceSummary;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setFrameworkComplianceReport(String frameworkComplianceReport) {
            this.frameworkComplianceReport = frameworkComplianceReport;
            return this;
        }

        public Builder setControlComplianceSummary(String controlComplianceSummary) {
            this.controlComplianceSummary = controlComplianceSummary;
            return this;
        }

        private Builder(ControlComplianceSummaryName controlComplianceSummaryName) {
            Preconditions.checkArgument((boolean)Objects.equals(controlComplianceSummaryName.pathTemplate, PROJECT_LOCATION_FRAMEWORK_COMPLIANCE_REPORT_CONTROL_COMPLIANCE_SUMMARY), (Object)"toBuilder is only supported when ControlComplianceSummaryName has the pattern of projects/{project}/locations/{location}/frameworkComplianceReports/{framework_compliance_report}/controlComplianceSummaries/{control_compliance_summary}");
            this.project = controlComplianceSummaryName.project;
            this.location = controlComplianceSummaryName.location;
            this.frameworkComplianceReport = controlComplianceSummaryName.frameworkComplianceReport;
            this.controlComplianceSummary = controlComplianceSummaryName.controlComplianceSummary;
        }

        public ControlComplianceSummaryName build() {
            return new ControlComplianceSummaryName(this);
        }
    }
}

