/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.cloudsecuritycompliance.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CloudControlName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_CLOUD_CONTROL = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/cloudControls/{cloud_control}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String cloudControl;

    @Deprecated
    protected CloudControlName() {
        this.organization = null;
        this.location = null;
        this.cloudControl = null;
    }

    private CloudControlName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.cloudControl = (String)Preconditions.checkNotNull((Object)builder.getCloudControl());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getCloudControl() {
        return this.cloudControl;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CloudControlName of(String organization, String location, String cloudControl) {
        return CloudControlName.newBuilder().setOrganization(organization).setLocation(location).setCloudControl(cloudControl).build();
    }

    public static String format(String organization, String location, String cloudControl) {
        return CloudControlName.newBuilder().setOrganization(organization).setLocation(location).setCloudControl(cloudControl).build().toString();
    }

    public static CloudControlName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_CLOUD_CONTROL.validatedMatch(formattedString, "CloudControlName.parse: formattedString not in valid format");
        return CloudControlName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("cloud_control"));
    }

    public static List<CloudControlName> parseList(List<String> formattedStrings) {
        ArrayList<CloudControlName> list = new ArrayList<CloudControlName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CloudControlName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CloudControlName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CloudControlName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_CLOUD_CONTROL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CloudControlName cloudControlName = this;
            synchronized (cloudControlName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.cloudControl != null) {
                        fieldMapBuilder.put((Object)"cloud_control", (Object)this.cloudControl);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_CLOUD_CONTROL.instantiate(new String[]{"organization", this.organization, "location", this.location, "cloud_control", this.cloudControl});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            CloudControlName that = (CloudControlName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.cloudControl, that.cloudControl);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.cloudControl);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String cloudControl;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getCloudControl() {
            return this.cloudControl;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setCloudControl(String cloudControl) {
            this.cloudControl = cloudControl;
            return this;
        }

        private Builder(CloudControlName cloudControlName) {
            this.organization = cloudControlName.organization;
            this.location = cloudControlName.location;
            this.cloudControl = cloudControlName.cloudControl;
        }

        public CloudControlName build() {
            return new CloudControlName(this);
        }
    }
}

