/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class MessageName
implements ResourceName {
    private static final PathTemplate SPACE_MESSAGE = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}/messages/{message}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;
    private final String message;

    @Deprecated
    protected MessageName() {
        this.space = null;
        this.message = null;
    }

    private MessageName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.message = (String)Preconditions.checkNotNull((Object)builder.getMessage());
    }

    public String getSpace() {
        return this.space;
    }

    public String getMessage() {
        return this.message;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static MessageName of(String space, String message) {
        return MessageName.newBuilder().setSpace(space).setMessage(message).build();
    }

    public static String format(String space, String message) {
        return MessageName.newBuilder().setSpace(space).setMessage(message).build().toString();
    }

    public static MessageName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE_MESSAGE.validatedMatch(formattedString, "MessageName.parse: formattedString not in valid format");
        return MessageName.of((String)matchMap.get("space"), (String)matchMap.get("message"));
    }

    public static List<MessageName> parseList(List<String> formattedStrings) {
        ArrayList<MessageName> list = new ArrayList<MessageName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(MessageName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<MessageName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (MessageName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE_MESSAGE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            MessageName messageName = this;
            synchronized (messageName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.message != null) {
                        fieldMapBuilder.put((Object)"message", (Object)this.message);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE_MESSAGE.instantiate(new String[]{"space", this.space, "message", this.message});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            MessageName that = (MessageName)o;
            return Objects.equals(this.space, that.space) && Objects.equals(this.message, that.message);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        return h ^= Objects.hashCode(this.message);
    }

    public static class Builder {
        private String space;
        private String message;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public String getMessage() {
            return this.message;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setMessage(String message) {
            this.message = message;
            return this;
        }

        private Builder(MessageName messageName) {
            this.space = messageName.space;
            this.message = messageName.message;
        }

        public MessageName build() {
            return new MessageName(this);
        }
    }
}

