/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpaceName
implements ResourceName {
    private static final PathTemplate SPACE = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;

    @Deprecated
    protected SpaceName() {
        this.space = null;
    }

    private SpaceName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
    }

    public String getSpace() {
        return this.space;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpaceName of(String space) {
        return SpaceName.newBuilder().setSpace(space).build();
    }

    public static String format(String space) {
        return SpaceName.newBuilder().setSpace(space).build().toString();
    }

    public static SpaceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE.validatedMatch(formattedString, "SpaceName.parse: formattedString not in valid format");
        return SpaceName.of((String)matchMap.get("space"));
    }

    public static List<SpaceName> parseList(List<String> formattedStrings) {
        ArrayList<SpaceName> list = new ArrayList<SpaceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpaceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpaceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpaceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpaceName spaceName = this;
            synchronized (spaceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE.instantiate(new String[]{"space", this.space});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SpaceName that = (SpaceName)o;
            return Objects.equals(this.space, that.space);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.space);
    }

    public static class Builder {
        private String space;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        private Builder(SpaceName spaceName) {
            this.space = spaceName.space;
        }

        public SpaceName build() {
            return new SpaceName(this);
        }
    }
}

