/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SpaceEventName
implements ResourceName {
    private static final PathTemplate SPACE_SPACE_EVENT = PathTemplate.createWithoutUrlEncoding((String)"spaces/{space}/spaceEvents/{space_event}");
    private volatile Map<String, String> fieldValuesMap;
    private final String space;
    private final String spaceEvent;

    @Deprecated
    protected SpaceEventName() {
        this.space = null;
        this.spaceEvent = null;
    }

    private SpaceEventName(Builder builder) {
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.spaceEvent = (String)Preconditions.checkNotNull((Object)builder.getSpaceEvent());
    }

    public String getSpace() {
        return this.space;
    }

    public String getSpaceEvent() {
        return this.spaceEvent;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SpaceEventName of(String space, String spaceEvent) {
        return SpaceEventName.newBuilder().setSpace(space).setSpaceEvent(spaceEvent).build();
    }

    public static String format(String space, String spaceEvent) {
        return SpaceEventName.newBuilder().setSpace(space).setSpaceEvent(spaceEvent).build().toString();
    }

    public static SpaceEventName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = SPACE_SPACE_EVENT.validatedMatch(formattedString, "SpaceEventName.parse: formattedString not in valid format");
        return SpaceEventName.of((String)matchMap.get("space"), (String)matchMap.get("space_event"));
    }

    public static List<SpaceEventName> parseList(List<String> formattedStrings) {
        ArrayList<SpaceEventName> list = new ArrayList<SpaceEventName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SpaceEventName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SpaceEventName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SpaceEventName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return SPACE_SPACE_EVENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SpaceEventName spaceEventName = this;
            synchronized (spaceEventName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.spaceEvent != null) {
                        fieldMapBuilder.put((Object)"space_event", (Object)this.spaceEvent);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return SPACE_SPACE_EVENT.instantiate(new String[]{"space", this.space, "space_event", this.spaceEvent});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SpaceEventName that = (SpaceEventName)o;
            return Objects.equals(this.space, that.space) && Objects.equals(this.spaceEvent, that.spaceEvent);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        return h ^= Objects.hashCode(this.spaceEvent);
    }

    public static class Builder {
        private String space;
        private String spaceEvent;

        protected Builder() {
        }

        public String getSpace() {
            return this.space;
        }

        public String getSpaceEvent() {
            return this.spaceEvent;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setSpaceEvent(String spaceEvent) {
            this.spaceEvent = spaceEvent;
            return this;
        }

        private Builder(SpaceEventName spaceEventName) {
            this.space = spaceEventName.space;
            this.spaceEvent = spaceEventName.spaceEvent;
        }

        public SpaceEventName build() {
            return new SpaceEventName(this);
        }
    }
}

