/*
 * Decompiled with CFR 0.152.
 */
package com.google.chat.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ThreadReadStateName
implements ResourceName {
    private static final PathTemplate USER_SPACE_THREAD = PathTemplate.createWithoutUrlEncoding((String)"users/{user}/spaces/{space}/threads/{thread}/threadReadState");
    private volatile Map<String, String> fieldValuesMap;
    private final String user;
    private final String space;
    private final String thread;

    @Deprecated
    protected ThreadReadStateName() {
        this.user = null;
        this.space = null;
        this.thread = null;
    }

    private ThreadReadStateName(Builder builder) {
        this.user = (String)Preconditions.checkNotNull((Object)builder.getUser());
        this.space = (String)Preconditions.checkNotNull((Object)builder.getSpace());
        this.thread = (String)Preconditions.checkNotNull((Object)builder.getThread());
    }

    public String getUser() {
        return this.user;
    }

    public String getSpace() {
        return this.space;
    }

    public String getThread() {
        return this.thread;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ThreadReadStateName of(String user, String space, String thread) {
        return ThreadReadStateName.newBuilder().setUser(user).setSpace(space).setThread(thread).build();
    }

    public static String format(String user, String space, String thread) {
        return ThreadReadStateName.newBuilder().setUser(user).setSpace(space).setThread(thread).build().toString();
    }

    public static ThreadReadStateName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = USER_SPACE_THREAD.validatedMatch(formattedString, "ThreadReadStateName.parse: formattedString not in valid format");
        return ThreadReadStateName.of((String)matchMap.get("user"), (String)matchMap.get("space"), (String)matchMap.get("thread"));
    }

    public static List<ThreadReadStateName> parseList(List<String> formattedStrings) {
        ArrayList<ThreadReadStateName> list = new ArrayList<ThreadReadStateName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ThreadReadStateName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ThreadReadStateName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ThreadReadStateName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return USER_SPACE_THREAD.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ThreadReadStateName threadReadStateName = this;
            synchronized (threadReadStateName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.user != null) {
                        fieldMapBuilder.put((Object)"user", (Object)this.user);
                    }
                    if (this.space != null) {
                        fieldMapBuilder.put((Object)"space", (Object)this.space);
                    }
                    if (this.thread != null) {
                        fieldMapBuilder.put((Object)"thread", (Object)this.thread);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return USER_SPACE_THREAD.instantiate(new String[]{"user", this.user, "space", this.space, "thread", this.thread});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ThreadReadStateName that = (ThreadReadStateName)o;
            return Objects.equals(this.user, that.user) && Objects.equals(this.space, that.space) && Objects.equals(this.thread, that.thread);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.user);
        h *= 1000003;
        h ^= Objects.hashCode(this.space);
        h *= 1000003;
        return h ^= Objects.hashCode(this.thread);
    }

    public static class Builder {
        private String user;
        private String space;
        private String thread;

        protected Builder() {
        }

        public String getUser() {
            return this.user;
        }

        public String getSpace() {
            return this.space;
        }

        public String getThread() {
            return this.thread;
        }

        public Builder setUser(String user) {
            this.user = user;
            return this;
        }

        public Builder setSpace(String space) {
            this.space = space;
            return this;
        }

        public Builder setThread(String thread) {
            this.thread = thread;
            return this;
        }

        private Builder(ThreadReadStateName threadReadStateName) {
            this.user = threadReadStateName.user;
            this.space = threadReadStateName.space;
            this.thread = threadReadStateName.thread;
        }

        public ThreadReadStateName build() {
            return new ThreadReadStateName(this);
        }
    }
}

