/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/space.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

/**
 *
 *
 * <pre>
 * A request to update a single space.
 * </pre>
 *
 * Protobuf type {@code google.chat.v1.UpdateSpaceRequest}
 */
public final class UpdateSpaceRequest extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.chat.v1.UpdateSpaceRequest)
    UpdateSpaceRequestOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use UpdateSpaceRequest.newBuilder() to construct.
  private UpdateSpaceRequest(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private UpdateSpaceRequest() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new UpdateSpaceRequest();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_UpdateSpaceRequest_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.chat.v1.SpaceProto
        .internal_static_google_chat_v1_UpdateSpaceRequest_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.chat.v1.UpdateSpaceRequest.class,
            com.google.chat.v1.UpdateSpaceRequest.Builder.class);
  }

  private int bitField0_;
  public static final int SPACE_FIELD_NUMBER = 1;
  private com.google.chat.v1.Space space_;
  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return Whether the space field is set.
   */
  @java.lang.Override
  public boolean hasSpace() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The space.
   */
  @java.lang.Override
  public com.google.chat.v1.Space getSpace() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }
  /**
   *
   *
   * <pre>
   * Required. Space with fields to be updated. `Space.name` must be
   * populated in the form of `spaces/{space}`. Only fields
   * specified by `update_mask` are updated.
   * </pre>
   *
   * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   */
  @java.lang.Override
  public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
    return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
  }

  public static final int UPDATE_MASK_FIELD_NUMBER = 2;
  private com.google.protobuf.FieldMask updateMask_;
  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * Currently supported field paths:
   *
   * - `display_name` (Only supports changing the display name of a space with
   * the `SPACE` type, or when also including the `space_type` mask to change a
   * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
   * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
   * error. If you receive the error message `ALREADY_EXISTS` when updating the
   * `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name.)
   *
   * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together with `space_type` in the update
   * mask and ensure that the specified space has a non-empty display name and
   * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
   * type in the specified space when updating the display name is optional if
   * the existing space already has the `SPACE` type. Trying to update the
   * space type in other ways results in an invalid argument error).
   *
   * - `space_details`
   *
   * - `space_history_state` (Supports [turning history on or off for the
   * space](https://support.google.com/chat/answer/7664687) if [the organization
   * allows users to change their history
   * setting](https://support.google.com/a/answer/7664184).
   * Warning: mutually exclusive with all other field paths.)
   * - Developer Preview: `access_settings.audience` (Supports changing the
   * [access setting](https://support.google.com/chat/answer/11971020) of a
   * space. If no audience is specified in the access setting, the space's
   * access setting is updated to restricted. Warning: mutually exclusive with
   * all other field paths.)
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2;</code>
   *
   * @return Whether the updateMask field is set.
   */
  @java.lang.Override
  public boolean hasUpdateMask() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * Currently supported field paths:
   *
   * - `display_name` (Only supports changing the display name of a space with
   * the `SPACE` type, or when also including the `space_type` mask to change a
   * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
   * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
   * error. If you receive the error message `ALREADY_EXISTS` when updating the
   * `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name.)
   *
   * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together with `space_type` in the update
   * mask and ensure that the specified space has a non-empty display name and
   * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
   * type in the specified space when updating the display name is optional if
   * the existing space already has the `SPACE` type. Trying to update the
   * space type in other ways results in an invalid argument error).
   *
   * - `space_details`
   *
   * - `space_history_state` (Supports [turning history on or off for the
   * space](https://support.google.com/chat/answer/7664687) if [the organization
   * allows users to change their history
   * setting](https://support.google.com/a/answer/7664184).
   * Warning: mutually exclusive with all other field paths.)
   * - Developer Preview: `access_settings.audience` (Supports changing the
   * [access setting](https://support.google.com/chat/answer/11971020) of a
   * space. If no audience is specified in the access setting, the space's
   * access setting is updated to restricted. Warning: mutually exclusive with
   * all other field paths.)
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2;</code>
   *
   * @return The updateMask.
   */
  @java.lang.Override
  public com.google.protobuf.FieldMask getUpdateMask() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }
  /**
   *
   *
   * <pre>
   * Required. The updated field paths, comma separated if there are
   * multiple.
   *
   * Currently supported field paths:
   *
   * - `display_name` (Only supports changing the display name of a space with
   * the `SPACE` type, or when also including the `space_type` mask to change a
   * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
   * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
   * error. If you receive the error message `ALREADY_EXISTS` when updating the
   * `displayName`, try a different `displayName`. An existing space within the
   * Google Workspace organization might already use this display name.)
   *
   * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
   * `SPACE`. Include `display_name` together with `space_type` in the update
   * mask and ensure that the specified space has a non-empty display name and
   * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
   * type in the specified space when updating the display name is optional if
   * the existing space already has the `SPACE` type. Trying to update the
   * space type in other ways results in an invalid argument error).
   *
   * - `space_details`
   *
   * - `space_history_state` (Supports [turning history on or off for the
   * space](https://support.google.com/chat/answer/7664687) if [the organization
   * allows users to change their history
   * setting](https://support.google.com/a/answer/7664184).
   * Warning: mutually exclusive with all other field paths.)
   * - Developer Preview: `access_settings.audience` (Supports changing the
   * [access setting](https://support.google.com/chat/answer/11971020) of a
   * space. If no audience is specified in the access setting, the space's
   * access setting is updated to restricted. Warning: mutually exclusive with
   * all other field paths.)
   * </pre>
   *
   * <code>.google.protobuf.FieldMask update_mask = 2;</code>
   */
  @java.lang.Override
  public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
    return updateMask_ == null ? com.google.protobuf.FieldMask.getDefaultInstance() : updateMask_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(1, getSpace());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(2, getUpdateMask());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, getSpace());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getUpdateMask());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.chat.v1.UpdateSpaceRequest)) {
      return super.equals(obj);
    }
    com.google.chat.v1.UpdateSpaceRequest other = (com.google.chat.v1.UpdateSpaceRequest) obj;

    if (hasSpace() != other.hasSpace()) return false;
    if (hasSpace()) {
      if (!getSpace().equals(other.getSpace())) return false;
    }
    if (hasUpdateMask() != other.hasUpdateMask()) return false;
    if (hasUpdateMask()) {
      if (!getUpdateMask().equals(other.getUpdateMask())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (hasSpace()) {
      hash = (37 * hash) + SPACE_FIELD_NUMBER;
      hash = (53 * hash) + getSpace().hashCode();
    }
    if (hasUpdateMask()) {
      hash = (37 * hash) + UPDATE_MASK_FIELD_NUMBER;
      hash = (53 * hash) + getUpdateMask().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseDelimitedFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.chat.v1.UpdateSpaceRequest parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.chat.v1.UpdateSpaceRequest prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A request to update a single space.
   * </pre>
   *
   * Protobuf type {@code google.chat.v1.UpdateSpaceRequest}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.chat.v1.UpdateSpaceRequest)
      com.google.chat.v1.UpdateSpaceRequestOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_UpdateSpaceRequest_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_UpdateSpaceRequest_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.chat.v1.UpdateSpaceRequest.class,
              com.google.chat.v1.UpdateSpaceRequest.Builder.class);
    }

    // Construct using com.google.chat.v1.UpdateSpaceRequest.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getSpaceFieldBuilder();
        getUpdateMaskFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.chat.v1.SpaceProto
          .internal_static_google_chat_v1_UpdateSpaceRequest_descriptor;
    }

    @java.lang.Override
    public com.google.chat.v1.UpdateSpaceRequest getDefaultInstanceForType() {
      return com.google.chat.v1.UpdateSpaceRequest.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.chat.v1.UpdateSpaceRequest build() {
      com.google.chat.v1.UpdateSpaceRequest result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.chat.v1.UpdateSpaceRequest buildPartial() {
      com.google.chat.v1.UpdateSpaceRequest result =
          new com.google.chat.v1.UpdateSpaceRequest(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.chat.v1.UpdateSpaceRequest result) {
      int from_bitField0_ = bitField0_;
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.space_ = spaceBuilder_ == null ? space_ : spaceBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.updateMask_ = updateMaskBuilder_ == null ? updateMask_ : updateMaskBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.chat.v1.UpdateSpaceRequest) {
        return mergeFrom((com.google.chat.v1.UpdateSpaceRequest) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.chat.v1.UpdateSpaceRequest other) {
      if (other == com.google.chat.v1.UpdateSpaceRequest.getDefaultInstance()) return this;
      if (other.hasSpace()) {
        mergeSpace(other.getSpace());
      }
      if (other.hasUpdateMask()) {
        mergeUpdateMask(other.getUpdateMask());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(getSpaceFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getUpdateMaskFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private com.google.chat.v1.Space space_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        spaceBuilder_;
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return Whether the space field is set.
     */
    public boolean hasSpace() {
      return ((bitField0_ & 0x00000001) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The space.
     */
    public com.google.chat.v1.Space getSpace() {
      if (spaceBuilder_ == null) {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      } else {
        return spaceBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        space_ = value;
      } else {
        spaceBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder setSpace(com.google.chat.v1.Space.Builder builderForValue) {
      if (spaceBuilder_ == null) {
        space_ = builderForValue.build();
      } else {
        spaceBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder mergeSpace(com.google.chat.v1.Space value) {
      if (spaceBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)
            && space_ != null
            && space_ != com.google.chat.v1.Space.getDefaultInstance()) {
          getSpaceBuilder().mergeFrom(value);
        } else {
          space_ = value;
        }
      } else {
        spaceBuilder_.mergeFrom(value);
      }
      if (space_ != null) {
        bitField0_ |= 0x00000001;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public Builder clearSpace() {
      bitField0_ = (bitField0_ & ~0x00000001);
      space_ = null;
      if (spaceBuilder_ != null) {
        spaceBuilder_.dispose();
        spaceBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.Space.Builder getSpaceBuilder() {
      bitField0_ |= 0x00000001;
      onChanged();
      return getSpaceFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    public com.google.chat.v1.SpaceOrBuilder getSpaceOrBuilder() {
      if (spaceBuilder_ != null) {
        return spaceBuilder_.getMessageOrBuilder();
      } else {
        return space_ == null ? com.google.chat.v1.Space.getDefaultInstance() : space_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. Space with fields to be updated. `Space.name` must be
     * populated in the form of `spaces/{space}`. Only fields
     * specified by `update_mask` are updated.
     * </pre>
     *
     * <code>.google.chat.v1.Space space = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.chat.v1.Space,
            com.google.chat.v1.Space.Builder,
            com.google.chat.v1.SpaceOrBuilder>
        getSpaceFieldBuilder() {
      if (spaceBuilder_ == null) {
        spaceBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.chat.v1.Space,
                com.google.chat.v1.Space.Builder,
                com.google.chat.v1.SpaceOrBuilder>(getSpace(), getParentForChildren(), isClean());
        space_ = null;
      }
      return spaceBuilder_;
    }

    private com.google.protobuf.FieldMask updateMask_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        updateMaskBuilder_;
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return Whether the updateMask field is set.
     */
    public boolean hasUpdateMask() {
      return ((bitField0_ & 0x00000002) != 0);
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     *
     * @return The updateMask.
     */
    public com.google.protobuf.FieldMask getUpdateMask() {
      if (updateMaskBuilder_ == null) {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      } else {
        return updateMaskBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        updateMask_ = value;
      } else {
        updateMaskBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public Builder setUpdateMask(com.google.protobuf.FieldMask.Builder builderForValue) {
      if (updateMaskBuilder_ == null) {
        updateMask_ = builderForValue.build();
      } else {
        updateMaskBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public Builder mergeUpdateMask(com.google.protobuf.FieldMask value) {
      if (updateMaskBuilder_ == null) {
        if (((bitField0_ & 0x00000002) != 0)
            && updateMask_ != null
            && updateMask_ != com.google.protobuf.FieldMask.getDefaultInstance()) {
          getUpdateMaskBuilder().mergeFrom(value);
        } else {
          updateMask_ = value;
        }
      } else {
        updateMaskBuilder_.mergeFrom(value);
      }
      if (updateMask_ != null) {
        bitField0_ |= 0x00000002;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public Builder clearUpdateMask() {
      bitField0_ = (bitField0_ & ~0x00000002);
      updateMask_ = null;
      if (updateMaskBuilder_ != null) {
        updateMaskBuilder_.dispose();
        updateMaskBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public com.google.protobuf.FieldMask.Builder getUpdateMaskBuilder() {
      bitField0_ |= 0x00000002;
      onChanged();
      return getUpdateMaskFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    public com.google.protobuf.FieldMaskOrBuilder getUpdateMaskOrBuilder() {
      if (updateMaskBuilder_ != null) {
        return updateMaskBuilder_.getMessageOrBuilder();
      } else {
        return updateMask_ == null
            ? com.google.protobuf.FieldMask.getDefaultInstance()
            : updateMask_;
      }
    }
    /**
     *
     *
     * <pre>
     * Required. The updated field paths, comma separated if there are
     * multiple.
     *
     * Currently supported field paths:
     *
     * - `display_name` (Only supports changing the display name of a space with
     * the `SPACE` type, or when also including the `space_type` mask to change a
     * `GROUP_CHAT` space type to `SPACE`. Trying to update the display name of a
     * `GROUP_CHAT` or a `DIRECT_MESSAGE` space results in an invalid argument
     * error. If you receive the error message `ALREADY_EXISTS` when updating the
     * `displayName`, try a different `displayName`. An existing space within the
     * Google Workspace organization might already use this display name.)
     *
     * - `space_type` (Only supports changing a `GROUP_CHAT` space type to
     * `SPACE`. Include `display_name` together with `space_type` in the update
     * mask and ensure that the specified space has a non-empty display name and
     * the `SPACE` space type. Including the `space_type` mask and the `SPACE`
     * type in the specified space when updating the display name is optional if
     * the existing space already has the `SPACE` type. Trying to update the
     * space type in other ways results in an invalid argument error).
     *
     * - `space_details`
     *
     * - `space_history_state` (Supports [turning history on or off for the
     * space](https://support.google.com/chat/answer/7664687) if [the organization
     * allows users to change their history
     * setting](https://support.google.com/a/answer/7664184).
     * Warning: mutually exclusive with all other field paths.)
     * - Developer Preview: `access_settings.audience` (Supports changing the
     * [access setting](https://support.google.com/chat/answer/11971020) of a
     * space. If no audience is specified in the access setting, the space's
     * access setting is updated to restricted. Warning: mutually exclusive with
     * all other field paths.)
     * </pre>
     *
     * <code>.google.protobuf.FieldMask update_mask = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.FieldMask,
            com.google.protobuf.FieldMask.Builder,
            com.google.protobuf.FieldMaskOrBuilder>
        getUpdateMaskFieldBuilder() {
      if (updateMaskBuilder_ == null) {
        updateMaskBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.FieldMask,
                com.google.protobuf.FieldMask.Builder,
                com.google.protobuf.FieldMaskOrBuilder>(
                getUpdateMask(), getParentForChildren(), isClean());
        updateMask_ = null;
      }
      return updateMaskBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.chat.v1.UpdateSpaceRequest)
  }

  // @@protoc_insertion_point(class_scope:google.chat.v1.UpdateSpaceRequest)
  private static final com.google.chat.v1.UpdateSpaceRequest DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.chat.v1.UpdateSpaceRequest();
  }

  public static com.google.chat.v1.UpdateSpaceRequest getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<UpdateSpaceRequest> PARSER =
      new com.google.protobuf.AbstractParser<UpdateSpaceRequest>() {
        @java.lang.Override
        public UpdateSpaceRequest parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<UpdateSpaceRequest> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<UpdateSpaceRequest> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.chat.v1.UpdateSpaceRequest getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
