/*
 * Copyright 2024 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/chat/v1/membership.proto

// Protobuf Java Version: 3.25.2
package com.google.chat.v1;

public interface CreateMembershipRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.chat.v1.CreateMembershipRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to create the
   * membership.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();
  /**
   *
   *
   * <pre>
   * Required. The resource name of the space for which to create the
   * membership.
   *
   * Format: spaces/{space}
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return Whether the membership field is set.
   */
  boolean hasMembership();
  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The membership.
   */
  com.google.chat.v1.Membership getMembership();
  /**
   *
   *
   * <pre>
   * Required. The membership relation to create.
   * The `memberType` field must contain a user with the `user.name` and
   * `user.type` fields populated. The server will assign a resource name
   * and overwrite anything specified.
   * When a Chat app creates a membership relation for a human user, it must use
   * the `chat.memberships` scope, set `user.type` to `HUMAN`, and set
   * `user.name` with format `users/{user}`, where `{user}` can be the email
   * address for the user. For users in the same Workspace organization `{user}`
   * can also be the `id` of the
   * [person](https://developers.google.com/people/api/rest/v1/people) from the
   * People API, or the `id` for the user in the Directory API. For example, if
   * the People API Person profile ID for `user&#64;example.com` is `123456789`, you
   * can add the user to the space by setting the `membership.member.name` to
   * `users/user&#64;example.com` or `users/123456789`. When a Chat app creates a
   * membership relation for itself, it must use the `chat.memberships.app`
   * scope, set `user.type` to `BOT`, and set `user.name` to `users/app`.
   * </pre>
   *
   * <code>.google.chat.v1.Membership membership = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   */
  com.google.chat.v1.MembershipOrBuilder getMembershipOrBuilder();
}
