/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloudbuild.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class CryptoKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_KEYRING_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/keyRings/{keyring}/cryptoKeys/{key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String keyring;
    private final String key;

    @Deprecated
    protected CryptoKeyName() {
        this.project = null;
        this.location = null;
        this.keyring = null;
        this.key = null;
    }

    private CryptoKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.keyring = (String)Preconditions.checkNotNull((Object)builder.getKeyring());
        this.key = (String)Preconditions.checkNotNull((Object)builder.getKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getKeyring() {
        return this.keyring;
    }

    public String getKey() {
        return this.key;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static CryptoKeyName of(String project, String location, String keyring, String key) {
        return CryptoKeyName.newBuilder().setProject(project).setLocation(location).setKeyring(keyring).setKey(key).build();
    }

    public static String format(String project, String location, String keyring, String key) {
        return CryptoKeyName.newBuilder().setProject(project).setLocation(location).setKeyring(keyring).setKey(key).build().toString();
    }

    public static CryptoKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_KEYRING_KEY.validatedMatch(formattedString, "CryptoKeyName.parse: formattedString not in valid format");
        return CryptoKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("keyring"), (String)matchMap.get("key"));
    }

    public static List<CryptoKeyName> parseList(List<String> formattedStrings) {
        ArrayList<CryptoKeyName> list = new ArrayList<CryptoKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(CryptoKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<CryptoKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (CryptoKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_KEYRING_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            CryptoKeyName cryptoKeyName = this;
            synchronized (cryptoKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.keyring != null) {
                        fieldMapBuilder.put((Object)"keyring", (Object)this.keyring);
                    }
                    if (this.key != null) {
                        fieldMapBuilder.put((Object)"key", (Object)this.key);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_KEYRING_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "keyring", this.keyring, "key", this.key});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            CryptoKeyName that = (CryptoKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.keyring, that.keyring) && Objects.equals(this.key, that.key);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.keyring);
        h *= 1000003;
        return h ^= Objects.hashCode(this.key);
    }

    public static class Builder {
        private String project;
        private String location;
        private String keyring;
        private String key;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getKeyring() {
            return this.keyring;
        }

        public String getKey() {
            return this.key;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setKeyring(String keyring) {
            this.keyring = keyring;
            return this;
        }

        public Builder setKey(String key) {
            this.key = key;
            return this;
        }

        private Builder(CryptoKeyName cryptoKeyName) {
            this.project = cryptoKeyName.project;
            this.location = cryptoKeyName.location;
            this.keyring = cryptoKeyName.keyring;
            this.key = cryptoKeyName.key;
        }

        public CryptoKeyName build() {
            return new CryptoKeyName(this);
        }
    }
}

