/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.budgets.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class BudgetName
implements ResourceName {
    private static final PathTemplate BILLING_ACCOUNT_BUDGET = PathTemplate.createWithoutUrlEncoding((String)"billingAccounts/{billing_account}/budgets/{budget}");
    private volatile Map<String, String> fieldValuesMap;
    private final String billingAccount;
    private final String budget;

    @Deprecated
    protected BudgetName() {
        this.billingAccount = null;
        this.budget = null;
    }

    private BudgetName(Builder builder) {
        this.billingAccount = (String)Preconditions.checkNotNull((Object)builder.getBillingAccount());
        this.budget = (String)Preconditions.checkNotNull((Object)builder.getBudget());
    }

    public String getBillingAccount() {
        return this.billingAccount;
    }

    public String getBudget() {
        return this.budget;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static BudgetName of(String billingAccount, String budget) {
        return BudgetName.newBuilder().setBillingAccount(billingAccount).setBudget(budget).build();
    }

    public static String format(String billingAccount, String budget) {
        return BudgetName.newBuilder().setBillingAccount(billingAccount).setBudget(budget).build().toString();
    }

    public static BudgetName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = BILLING_ACCOUNT_BUDGET.validatedMatch(formattedString, "BudgetName.parse: formattedString not in valid format");
        return BudgetName.of((String)matchMap.get("billing_account"), (String)matchMap.get("budget"));
    }

    public static List<BudgetName> parseList(List<String> formattedStrings) {
        ArrayList<BudgetName> list = new ArrayList<BudgetName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(BudgetName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<BudgetName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (BudgetName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return BILLING_ACCOUNT_BUDGET.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            BudgetName budgetName = this;
            synchronized (budgetName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.billingAccount != null) {
                        fieldMapBuilder.put((Object)"billing_account", (Object)this.billingAccount);
                    }
                    if (this.budget != null) {
                        fieldMapBuilder.put((Object)"budget", (Object)this.budget);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return BILLING_ACCOUNT_BUDGET.instantiate(new String[]{"billing_account", this.billingAccount, "budget", this.budget});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            BudgetName that = (BudgetName)o;
            return Objects.equals(this.billingAccount, that.billingAccount) && Objects.equals(this.budget, that.budget);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.billingAccount);
        h *= 1000003;
        return h ^= Objects.hashCode(this.budget);
    }

    public static class Builder {
        private String billingAccount;
        private String budget;

        protected Builder() {
        }

        public String getBillingAccount() {
            return this.billingAccount;
        }

        public String getBudget() {
            return this.budget;
        }

        public Builder setBillingAccount(String billingAccount) {
            this.billingAccount = billingAccount;
            return this;
        }

        public Builder setBudget(String budget) {
            this.budget = budget;
            return this;
        }

        private Builder(BudgetName budgetName) {
            this.billingAccount = budgetName.billingAccount;
            this.budget = budgetName.budget;
        }

        public BudgetName build() {
            return new BudgetName(this);
        }
    }
}

