/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.billing.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProjectBillingInfoName
implements ResourceName {
    private static final PathTemplate PROJECT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/billingInfo");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;

    @Deprecated
    protected ProjectBillingInfoName() {
        this.project = null;
    }

    private ProjectBillingInfoName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
    }

    public String getProject() {
        return this.project;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProjectBillingInfoName of(String project) {
        return ProjectBillingInfoName.newBuilder().setProject(project).build();
    }

    public static String format(String project) {
        return ProjectBillingInfoName.newBuilder().setProject(project).build().toString();
    }

    public static ProjectBillingInfoName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT.validatedMatch(formattedString, "ProjectBillingInfoName.parse: formattedString not in valid format");
        return ProjectBillingInfoName.of((String)matchMap.get("project"));
    }

    public static List<ProjectBillingInfoName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectBillingInfoName> list = new ArrayList<ProjectBillingInfoName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectBillingInfoName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectBillingInfoName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectBillingInfoName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectBillingInfoName projectBillingInfoName = this;
            synchronized (projectBillingInfoName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT.instantiate(new String[]{"project", this.project});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            ProjectBillingInfoName that = (ProjectBillingInfoName)o;
            return Objects.equals(this.project, that.project);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        return h ^= Objects.hashCode(this.project);
    }

    public static class Builder {
        private String project;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        private Builder(ProjectBillingInfoName projectBillingInfoName) {
            this.project = projectBillingInfoName.project;
        }

        public ProjectBillingInfoName build() {
            return new ProjectBillingInfoName(this);
        }
    }
}

