/*
 * Copyright 2020 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/bigtable/v2/bigtable.proto

package com.google.bigtable.v2;

/**
 *
 *
 * <pre>
 * Response message for Bigtable.ReadRows.
 * </pre>
 *
 * Protobuf type {@code google.bigtable.v2.ReadRowsResponse}
 */
public final class ReadRowsResponse extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadRowsResponse)
    ReadRowsResponseOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ReadRowsResponse.newBuilder() to construct.
  private ReadRowsResponse(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ReadRowsResponse() {
    chunks_ = java.util.Collections.emptyList();
    lastScannedRowKey_ = com.google.protobuf.ByteString.EMPTY;
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ReadRowsResponse();
  }

  @java.lang.Override
  public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
    return this.unknownFields;
  }

  private ReadRowsResponse(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    this();
    if (extensionRegistry == null) {
      throw new java.lang.NullPointerException();
    }
    int mutable_bitField0_ = 0;
    com.google.protobuf.UnknownFieldSet.Builder unknownFields =
        com.google.protobuf.UnknownFieldSet.newBuilder();
    try {
      boolean done = false;
      while (!done) {
        int tag = input.readTag();
        switch (tag) {
          case 0:
            done = true;
            break;
          case 10:
            {
              if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                chunks_ =
                    new java.util.ArrayList<com.google.bigtable.v2.ReadRowsResponse.CellChunk>();
                mutable_bitField0_ |= 0x00000001;
              }
              chunks_.add(
                  input.readMessage(
                      com.google.bigtable.v2.ReadRowsResponse.CellChunk.parser(),
                      extensionRegistry));
              break;
            }
          case 18:
            {
              lastScannedRowKey_ = input.readBytes();
              break;
            }
          default:
            {
              if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                done = true;
              }
              break;
            }
        }
      }
    } catch (com.google.protobuf.InvalidProtocolBufferException e) {
      throw e.setUnfinishedMessage(this);
    } catch (java.io.IOException e) {
      throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
    } finally {
      if (((mutable_bitField0_ & 0x00000001) != 0)) {
        chunks_ = java.util.Collections.unmodifiableList(chunks_);
      }
      this.unknownFields = unknownFields.build();
      makeExtensionsImmutable();
    }
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsResponse_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.bigtable.v2.BigtableProto
        .internal_static_google_bigtable_v2_ReadRowsResponse_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.bigtable.v2.ReadRowsResponse.class,
            com.google.bigtable.v2.ReadRowsResponse.Builder.class);
  }

  public interface CellChunkOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.bigtable.v2.ReadRowsResponse.CellChunk)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * The row key for this chunk of data.  If the row key is empty,
     * this CellChunk is a continuation of the same row as the previous
     * CellChunk in the response stream, even if that CellChunk was in a
     * previous ReadRowsResponse message.
     * </pre>
     *
     * <code>bytes row_key = 1;</code>
     *
     * @return The rowKey.
     */
    com.google.protobuf.ByteString getRowKey();

    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     *
     * @return Whether the familyName field is set.
     */
    boolean hasFamilyName();
    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     *
     * @return The familyName.
     */
    com.google.protobuf.StringValue getFamilyName();
    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     */
    com.google.protobuf.StringValueOrBuilder getFamilyNameOrBuilder();

    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     *
     * @return Whether the qualifier field is set.
     */
    boolean hasQualifier();
    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     *
     * @return The qualifier.
     */
    com.google.protobuf.BytesValue getQualifier();
    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     */
    com.google.protobuf.BytesValueOrBuilder getQualifierOrBuilder();

    /**
     *
     *
     * <pre>
     * The cell's stored timestamp, which also uniquely identifies it
     * within its column.  Values are always expressed in
     * microseconds, but individual tables may set a coarser
     * granularity to further restrict the allowed values. For
     * example, a table which specifies millisecond granularity will
     * only allow values of `timestamp_micros` which are multiples of
     * 1000.  Timestamps are only set in the first CellChunk per cell
     * (for cells split into multiple chunks).
     * </pre>
     *
     * <code>int64 timestamp_micros = 4;</code>
     *
     * @return The timestampMicros.
     */
    long getTimestampMicros();

    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @return A list containing the labels.
     */
    java.util.List<java.lang.String> getLabelsList();
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @return The count of labels.
     */
    int getLabelsCount();
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The labels at the given index.
     */
    java.lang.String getLabels(int index);
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the labels at the given index.
     */
    com.google.protobuf.ByteString getLabelsBytes(int index);

    /**
     *
     *
     * <pre>
     * The value stored in the cell.  Cell values can be split across
     * multiple CellChunks.  In that case only the value field will be
     * set in CellChunks after the first: the timestamp and labels
     * will only be present in the first CellChunk, even if the first
     * CellChunk came in a previous ReadRowsResponse.
     * </pre>
     *
     * <code>bytes value = 6;</code>
     *
     * @return The value.
     */
    com.google.protobuf.ByteString getValue();

    /**
     *
     *
     * <pre>
     * If this CellChunk is part of a chunked cell value and this is
     * not the final chunk of that cell, value_size will be set to the
     * total length of the cell value.  The client can use this size
     * to pre-allocate memory to hold the full cell value.
     * </pre>
     *
     * <code>int32 value_size = 7;</code>
     *
     * @return The valueSize.
     */
    int getValueSize();

    /**
     *
     *
     * <pre>
     * Indicates that the client should drop all previous chunks for
     * `row_key`, as it will be re-read from the beginning.
     * </pre>
     *
     * <code>bool reset_row = 8;</code>
     *
     * @return The resetRow.
     */
    boolean getResetRow();

    /**
     *
     *
     * <pre>
     * Indicates that the client can safely process all previous chunks for
     * `row_key`, as its data has been fully read.
     * </pre>
     *
     * <code>bool commit_row = 9;</code>
     *
     * @return The commitRow.
     */
    boolean getCommitRow();

    public com.google.bigtable.v2.ReadRowsResponse.CellChunk.RowStatusCase getRowStatusCase();
  }
  /**
   *
   *
   * <pre>
   * Specifies a piece of a row's contents returned as part of the read
   * response stream.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadRowsResponse.CellChunk}
   */
  public static final class CellChunk extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.bigtable.v2.ReadRowsResponse.CellChunk)
      CellChunkOrBuilder {
    private static final long serialVersionUID = 0L;
    // Use CellChunk.newBuilder() to construct.
    private CellChunk(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private CellChunk() {
      rowKey_ = com.google.protobuf.ByteString.EMPTY;
      labels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
      value_ = com.google.protobuf.ByteString.EMPTY;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new CellChunk();
    }

    @java.lang.Override
    public final com.google.protobuf.UnknownFieldSet getUnknownFields() {
      return this.unknownFields;
    }

    private CellChunk(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      this();
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      int mutable_bitField0_ = 0;
      com.google.protobuf.UnknownFieldSet.Builder unknownFields =
          com.google.protobuf.UnknownFieldSet.newBuilder();
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                rowKey_ = input.readBytes();
                break;
              }
            case 18:
              {
                com.google.protobuf.StringValue.Builder subBuilder = null;
                if (familyName_ != null) {
                  subBuilder = familyName_.toBuilder();
                }
                familyName_ =
                    input.readMessage(com.google.protobuf.StringValue.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(familyName_);
                  familyName_ = subBuilder.buildPartial();
                }

                break;
              }
            case 26:
              {
                com.google.protobuf.BytesValue.Builder subBuilder = null;
                if (qualifier_ != null) {
                  subBuilder = qualifier_.toBuilder();
                }
                qualifier_ =
                    input.readMessage(com.google.protobuf.BytesValue.parser(), extensionRegistry);
                if (subBuilder != null) {
                  subBuilder.mergeFrom(qualifier_);
                  qualifier_ = subBuilder.buildPartial();
                }

                break;
              }
            case 32:
              {
                timestampMicros_ = input.readInt64();
                break;
              }
            case 42:
              {
                java.lang.String s = input.readStringRequireUtf8();
                if (!((mutable_bitField0_ & 0x00000001) != 0)) {
                  labels_ = new com.google.protobuf.LazyStringArrayList();
                  mutable_bitField0_ |= 0x00000001;
                }
                labels_.add(s);
                break;
              }
            case 50:
              {
                value_ = input.readBytes();
                break;
              }
            case 56:
              {
                valueSize_ = input.readInt32();
                break;
              }
            case 64:
              {
                rowStatusCase_ = 8;
                rowStatus_ = input.readBool();
                break;
              }
            case 72:
              {
                rowStatusCase_ = 9;
                rowStatus_ = input.readBool();
                break;
              }
            default:
              {
                if (!parseUnknownField(input, unknownFields, extensionRegistry, tag)) {
                  done = true;
                }
                break;
              }
          }
        }
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.setUnfinishedMessage(this);
      } catch (java.io.IOException e) {
        throw new com.google.protobuf.InvalidProtocolBufferException(e).setUnfinishedMessage(this);
      } finally {
        if (((mutable_bitField0_ & 0x00000001) != 0)) {
          labels_ = labels_.getUnmodifiableView();
        }
        this.unknownFields = unknownFields.build();
        makeExtensionsImmutable();
      }
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsResponse_CellChunk_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsResponse_CellChunk_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadRowsResponse.CellChunk.class,
              com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder.class);
    }

    private int rowStatusCase_ = 0;
    private java.lang.Object rowStatus_;

    public enum RowStatusCase
        implements
            com.google.protobuf.Internal.EnumLite,
            com.google.protobuf.AbstractMessage.InternalOneOfEnum {
      RESET_ROW(8),
      COMMIT_ROW(9),
      ROWSTATUS_NOT_SET(0);
      private final int value;

      private RowStatusCase(int value) {
        this.value = value;
      }
      /**
       * @param value The number of the enum to look for.
       * @return The enum associated with the given number.
       * @deprecated Use {@link #forNumber(int)} instead.
       */
      @java.lang.Deprecated
      public static RowStatusCase valueOf(int value) {
        return forNumber(value);
      }

      public static RowStatusCase forNumber(int value) {
        switch (value) {
          case 8:
            return RESET_ROW;
          case 9:
            return COMMIT_ROW;
          case 0:
            return ROWSTATUS_NOT_SET;
          default:
            return null;
        }
      }

      public int getNumber() {
        return this.value;
      }
    };

    public RowStatusCase getRowStatusCase() {
      return RowStatusCase.forNumber(rowStatusCase_);
    }

    public static final int ROW_KEY_FIELD_NUMBER = 1;
    private com.google.protobuf.ByteString rowKey_;
    /**
     *
     *
     * <pre>
     * The row key for this chunk of data.  If the row key is empty,
     * this CellChunk is a continuation of the same row as the previous
     * CellChunk in the response stream, even if that CellChunk was in a
     * previous ReadRowsResponse message.
     * </pre>
     *
     * <code>bytes row_key = 1;</code>
     *
     * @return The rowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getRowKey() {
      return rowKey_;
    }

    public static final int FAMILY_NAME_FIELD_NUMBER = 2;
    private com.google.protobuf.StringValue familyName_;
    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     *
     * @return Whether the familyName field is set.
     */
    @java.lang.Override
    public boolean hasFamilyName() {
      return familyName_ != null;
    }
    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     *
     * @return The familyName.
     */
    @java.lang.Override
    public com.google.protobuf.StringValue getFamilyName() {
      return familyName_ == null
          ? com.google.protobuf.StringValue.getDefaultInstance()
          : familyName_;
    }
    /**
     *
     *
     * <pre>
     * The column family name for this chunk of data.  If this message
     * is not present this CellChunk is a continuation of the same column
     * family as the previous CellChunk.  The empty string can occur as a
     * column family name in a response so clients must check
     * explicitly for the presence of this message, not just for
     * `family_name.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.StringValue family_name = 2;</code>
     */
    @java.lang.Override
    public com.google.protobuf.StringValueOrBuilder getFamilyNameOrBuilder() {
      return getFamilyName();
    }

    public static final int QUALIFIER_FIELD_NUMBER = 3;
    private com.google.protobuf.BytesValue qualifier_;
    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     *
     * @return Whether the qualifier field is set.
     */
    @java.lang.Override
    public boolean hasQualifier() {
      return qualifier_ != null;
    }
    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     *
     * @return The qualifier.
     */
    @java.lang.Override
    public com.google.protobuf.BytesValue getQualifier() {
      return qualifier_ == null ? com.google.protobuf.BytesValue.getDefaultInstance() : qualifier_;
    }
    /**
     *
     *
     * <pre>
     * The column qualifier for this chunk of data.  If this message
     * is not present, this CellChunk is a continuation of the same column
     * as the previous CellChunk.  Column qualifiers may be empty so
     * clients must check for the presence of this message, not just
     * for `qualifier.value` being non-empty.
     * </pre>
     *
     * <code>.google.protobuf.BytesValue qualifier = 3;</code>
     */
    @java.lang.Override
    public com.google.protobuf.BytesValueOrBuilder getQualifierOrBuilder() {
      return getQualifier();
    }

    public static final int TIMESTAMP_MICROS_FIELD_NUMBER = 4;
    private long timestampMicros_;
    /**
     *
     *
     * <pre>
     * The cell's stored timestamp, which also uniquely identifies it
     * within its column.  Values are always expressed in
     * microseconds, but individual tables may set a coarser
     * granularity to further restrict the allowed values. For
     * example, a table which specifies millisecond granularity will
     * only allow values of `timestamp_micros` which are multiples of
     * 1000.  Timestamps are only set in the first CellChunk per cell
     * (for cells split into multiple chunks).
     * </pre>
     *
     * <code>int64 timestamp_micros = 4;</code>
     *
     * @return The timestampMicros.
     */
    @java.lang.Override
    public long getTimestampMicros() {
      return timestampMicros_;
    }

    public static final int LABELS_FIELD_NUMBER = 5;
    private com.google.protobuf.LazyStringList labels_;
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @return A list containing the labels.
     */
    public com.google.protobuf.ProtocolStringList getLabelsList() {
      return labels_;
    }
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @return The count of labels.
     */
    public int getLabelsCount() {
      return labels_.size();
    }
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @param index The index of the element to return.
     * @return The labels at the given index.
     */
    public java.lang.String getLabels(int index) {
      return labels_.get(index);
    }
    /**
     *
     *
     * <pre>
     * Labels applied to the cell by a
     * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
     * on the first CellChunk per cell.
     * </pre>
     *
     * <code>repeated string labels = 5;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the labels at the given index.
     */
    public com.google.protobuf.ByteString getLabelsBytes(int index) {
      return labels_.getByteString(index);
    }

    public static final int VALUE_FIELD_NUMBER = 6;
    private com.google.protobuf.ByteString value_;
    /**
     *
     *
     * <pre>
     * The value stored in the cell.  Cell values can be split across
     * multiple CellChunks.  In that case only the value field will be
     * set in CellChunks after the first: the timestamp and labels
     * will only be present in the first CellChunk, even if the first
     * CellChunk came in a previous ReadRowsResponse.
     * </pre>
     *
     * <code>bytes value = 6;</code>
     *
     * @return The value.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getValue() {
      return value_;
    }

    public static final int VALUE_SIZE_FIELD_NUMBER = 7;
    private int valueSize_;
    /**
     *
     *
     * <pre>
     * If this CellChunk is part of a chunked cell value and this is
     * not the final chunk of that cell, value_size will be set to the
     * total length of the cell value.  The client can use this size
     * to pre-allocate memory to hold the full cell value.
     * </pre>
     *
     * <code>int32 value_size = 7;</code>
     *
     * @return The valueSize.
     */
    @java.lang.Override
    public int getValueSize() {
      return valueSize_;
    }

    public static final int RESET_ROW_FIELD_NUMBER = 8;
    /**
     *
     *
     * <pre>
     * Indicates that the client should drop all previous chunks for
     * `row_key`, as it will be re-read from the beginning.
     * </pre>
     *
     * <code>bool reset_row = 8;</code>
     *
     * @return The resetRow.
     */
    @java.lang.Override
    public boolean getResetRow() {
      if (rowStatusCase_ == 8) {
        return (java.lang.Boolean) rowStatus_;
      }
      return false;
    }

    public static final int COMMIT_ROW_FIELD_NUMBER = 9;
    /**
     *
     *
     * <pre>
     * Indicates that the client can safely process all previous chunks for
     * `row_key`, as its data has been fully read.
     * </pre>
     *
     * <code>bool commit_row = 9;</code>
     *
     * @return The commitRow.
     */
    @java.lang.Override
    public boolean getCommitRow() {
      if (rowStatusCase_ == 9) {
        return (java.lang.Boolean) rowStatus_;
      }
      return false;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (!rowKey_.isEmpty()) {
        output.writeBytes(1, rowKey_);
      }
      if (familyName_ != null) {
        output.writeMessage(2, getFamilyName());
      }
      if (qualifier_ != null) {
        output.writeMessage(3, getQualifier());
      }
      if (timestampMicros_ != 0L) {
        output.writeInt64(4, timestampMicros_);
      }
      for (int i = 0; i < labels_.size(); i++) {
        com.google.protobuf.GeneratedMessageV3.writeString(output, 5, labels_.getRaw(i));
      }
      if (!value_.isEmpty()) {
        output.writeBytes(6, value_);
      }
      if (valueSize_ != 0) {
        output.writeInt32(7, valueSize_);
      }
      if (rowStatusCase_ == 8) {
        output.writeBool(8, (boolean) ((java.lang.Boolean) rowStatus_));
      }
      if (rowStatusCase_ == 9) {
        output.writeBool(9, (boolean) ((java.lang.Boolean) rowStatus_));
      }
      unknownFields.writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (!rowKey_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(1, rowKey_);
      }
      if (familyName_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(2, getFamilyName());
      }
      if (qualifier_ != null) {
        size += com.google.protobuf.CodedOutputStream.computeMessageSize(3, getQualifier());
      }
      if (timestampMicros_ != 0L) {
        size += com.google.protobuf.CodedOutputStream.computeInt64Size(4, timestampMicros_);
      }
      {
        int dataSize = 0;
        for (int i = 0; i < labels_.size(); i++) {
          dataSize += computeStringSizeNoTag(labels_.getRaw(i));
        }
        size += dataSize;
        size += 1 * getLabelsList().size();
      }
      if (!value_.isEmpty()) {
        size += com.google.protobuf.CodedOutputStream.computeBytesSize(6, value_);
      }
      if (valueSize_ != 0) {
        size += com.google.protobuf.CodedOutputStream.computeInt32Size(7, valueSize_);
      }
      if (rowStatusCase_ == 8) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                8, (boolean) ((java.lang.Boolean) rowStatus_));
      }
      if (rowStatusCase_ == 9) {
        size +=
            com.google.protobuf.CodedOutputStream.computeBoolSize(
                9, (boolean) ((java.lang.Boolean) rowStatus_));
      }
      size += unknownFields.getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj instanceof com.google.bigtable.v2.ReadRowsResponse.CellChunk)) {
        return super.equals(obj);
      }
      com.google.bigtable.v2.ReadRowsResponse.CellChunk other =
          (com.google.bigtable.v2.ReadRowsResponse.CellChunk) obj;

      if (!getRowKey().equals(other.getRowKey())) return false;
      if (hasFamilyName() != other.hasFamilyName()) return false;
      if (hasFamilyName()) {
        if (!getFamilyName().equals(other.getFamilyName())) return false;
      }
      if (hasQualifier() != other.hasQualifier()) return false;
      if (hasQualifier()) {
        if (!getQualifier().equals(other.getQualifier())) return false;
      }
      if (getTimestampMicros() != other.getTimestampMicros()) return false;
      if (!getLabelsList().equals(other.getLabelsList())) return false;
      if (!getValue().equals(other.getValue())) return false;
      if (getValueSize() != other.getValueSize()) return false;
      if (!getRowStatusCase().equals(other.getRowStatusCase())) return false;
      switch (rowStatusCase_) {
        case 8:
          if (getResetRow() != other.getResetRow()) return false;
          break;
        case 9:
          if (getCommitRow() != other.getCommitRow()) return false;
          break;
        case 0:
        default:
      }
      if (!unknownFields.equals(other.unknownFields)) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + ROW_KEY_FIELD_NUMBER;
      hash = (53 * hash) + getRowKey().hashCode();
      if (hasFamilyName()) {
        hash = (37 * hash) + FAMILY_NAME_FIELD_NUMBER;
        hash = (53 * hash) + getFamilyName().hashCode();
      }
      if (hasQualifier()) {
        hash = (37 * hash) + QUALIFIER_FIELD_NUMBER;
        hash = (53 * hash) + getQualifier().hashCode();
      }
      hash = (37 * hash) + TIMESTAMP_MICROS_FIELD_NUMBER;
      hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getTimestampMicros());
      if (getLabelsCount() > 0) {
        hash = (37 * hash) + LABELS_FIELD_NUMBER;
        hash = (53 * hash) + getLabelsList().hashCode();
      }
      hash = (37 * hash) + VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getValue().hashCode();
      hash = (37 * hash) + VALUE_SIZE_FIELD_NUMBER;
      hash = (53 * hash) + getValueSize();
      switch (rowStatusCase_) {
        case 8:
          hash = (37 * hash) + RESET_ROW_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getResetRow());
          break;
        case 9:
          hash = (37 * hash) + COMMIT_ROW_FIELD_NUMBER;
          hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getCommitRow());
          break;
        case 0:
        default:
      }
      hash = (29 * hash) + unknownFields.hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(byte[] data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseDelimitedFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseDelimitedFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(com.google.bigtable.v2.ReadRowsResponse.CellChunk prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }
    /**
     *
     *
     * <pre>
     * Specifies a piece of a row's contents returned as part of the read
     * response stream.
     * </pre>
     *
     * Protobuf type {@code google.bigtable.v2.ReadRowsResponse.CellChunk}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadRowsResponse.CellChunk)
        com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadRowsResponse_CellChunk_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadRowsResponse_CellChunk_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.bigtable.v2.ReadRowsResponse.CellChunk.class,
                com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder.class);
      }

      // Construct using com.google.bigtable.v2.ReadRowsResponse.CellChunk.newBuilder()
      private Builder() {
        maybeForceBuilderInitialization();
      }

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
        maybeForceBuilderInitialization();
      }

      private void maybeForceBuilderInitialization() {
        if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {}
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        rowKey_ = com.google.protobuf.ByteString.EMPTY;

        if (familyNameBuilder_ == null) {
          familyName_ = null;
        } else {
          familyName_ = null;
          familyNameBuilder_ = null;
        }
        if (qualifierBuilder_ == null) {
          qualifier_ = null;
        } else {
          qualifier_ = null;
          qualifierBuilder_ = null;
        }
        timestampMicros_ = 0L;

        labels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        value_ = com.google.protobuf.ByteString.EMPTY;

        valueSize_ = 0;

        rowStatusCase_ = 0;
        rowStatus_ = null;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.bigtable.v2.BigtableProto
            .internal_static_google_bigtable_v2_ReadRowsResponse_CellChunk_descriptor;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadRowsResponse.CellChunk getDefaultInstanceForType() {
        return com.google.bigtable.v2.ReadRowsResponse.CellChunk.getDefaultInstance();
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadRowsResponse.CellChunk build() {
        com.google.bigtable.v2.ReadRowsResponse.CellChunk result = buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.bigtable.v2.ReadRowsResponse.CellChunk buildPartial() {
        com.google.bigtable.v2.ReadRowsResponse.CellChunk result =
            new com.google.bigtable.v2.ReadRowsResponse.CellChunk(this);
        int from_bitField0_ = bitField0_;
        result.rowKey_ = rowKey_;
        if (familyNameBuilder_ == null) {
          result.familyName_ = familyName_;
        } else {
          result.familyName_ = familyNameBuilder_.build();
        }
        if (qualifierBuilder_ == null) {
          result.qualifier_ = qualifier_;
        } else {
          result.qualifier_ = qualifierBuilder_.build();
        }
        result.timestampMicros_ = timestampMicros_;
        if (((bitField0_ & 0x00000001) != 0)) {
          labels_ = labels_.getUnmodifiableView();
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.labels_ = labels_;
        result.value_ = value_;
        result.valueSize_ = valueSize_;
        if (rowStatusCase_ == 8) {
          result.rowStatus_ = rowStatus_;
        }
        if (rowStatusCase_ == 9) {
          result.rowStatus_ = rowStatus_;
        }
        result.rowStatusCase_ = rowStatusCase_;
        onBuilt();
        return result;
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other instanceof com.google.bigtable.v2.ReadRowsResponse.CellChunk) {
          return mergeFrom((com.google.bigtable.v2.ReadRowsResponse.CellChunk) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(com.google.bigtable.v2.ReadRowsResponse.CellChunk other) {
        if (other == com.google.bigtable.v2.ReadRowsResponse.CellChunk.getDefaultInstance())
          return this;
        if (other.getRowKey() != com.google.protobuf.ByteString.EMPTY) {
          setRowKey(other.getRowKey());
        }
        if (other.hasFamilyName()) {
          mergeFamilyName(other.getFamilyName());
        }
        if (other.hasQualifier()) {
          mergeQualifier(other.getQualifier());
        }
        if (other.getTimestampMicros() != 0L) {
          setTimestampMicros(other.getTimestampMicros());
        }
        if (!other.labels_.isEmpty()) {
          if (labels_.isEmpty()) {
            labels_ = other.labels_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureLabelsIsMutable();
            labels_.addAll(other.labels_);
          }
          onChanged();
        }
        if (other.getValue() != com.google.protobuf.ByteString.EMPTY) {
          setValue(other.getValue());
        }
        if (other.getValueSize() != 0) {
          setValueSize(other.getValueSize());
        }
        switch (other.getRowStatusCase()) {
          case RESET_ROW:
            {
              setResetRow(other.getResetRow());
              break;
            }
          case COMMIT_ROW:
            {
              setCommitRow(other.getCommitRow());
              break;
            }
          case ROWSTATUS_NOT_SET:
            {
              break;
            }
        }
        this.mergeUnknownFields(other.unknownFields);
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        com.google.bigtable.v2.ReadRowsResponse.CellChunk parsedMessage = null;
        try {
          parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          parsedMessage =
              (com.google.bigtable.v2.ReadRowsResponse.CellChunk) e.getUnfinishedMessage();
          throw e.unwrapIOException();
        } finally {
          if (parsedMessage != null) {
            mergeFrom(parsedMessage);
          }
        }
        return this;
      }

      private int rowStatusCase_ = 0;
      private java.lang.Object rowStatus_;

      public RowStatusCase getRowStatusCase() {
        return RowStatusCase.forNumber(rowStatusCase_);
      }

      public Builder clearRowStatus() {
        rowStatusCase_ = 0;
        rowStatus_ = null;
        onChanged();
        return this;
      }

      private int bitField0_;

      private com.google.protobuf.ByteString rowKey_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The row key for this chunk of data.  If the row key is empty,
       * this CellChunk is a continuation of the same row as the previous
       * CellChunk in the response stream, even if that CellChunk was in a
       * previous ReadRowsResponse message.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @return The rowKey.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getRowKey() {
        return rowKey_;
      }
      /**
       *
       *
       * <pre>
       * The row key for this chunk of data.  If the row key is empty,
       * this CellChunk is a continuation of the same row as the previous
       * CellChunk in the response stream, even if that CellChunk was in a
       * previous ReadRowsResponse message.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @param value The rowKey to set.
       * @return This builder for chaining.
       */
      public Builder setRowKey(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }

        rowKey_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The row key for this chunk of data.  If the row key is empty,
       * this CellChunk is a continuation of the same row as the previous
       * CellChunk in the response stream, even if that CellChunk was in a
       * previous ReadRowsResponse message.
       * </pre>
       *
       * <code>bytes row_key = 1;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearRowKey() {

        rowKey_ = getDefaultInstance().getRowKey();
        onChanged();
        return this;
      }

      private com.google.protobuf.StringValue familyName_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue,
              com.google.protobuf.StringValue.Builder,
              com.google.protobuf.StringValueOrBuilder>
          familyNameBuilder_;
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       *
       * @return Whether the familyName field is set.
       */
      public boolean hasFamilyName() {
        return familyNameBuilder_ != null || familyName_ != null;
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       *
       * @return The familyName.
       */
      public com.google.protobuf.StringValue getFamilyName() {
        if (familyNameBuilder_ == null) {
          return familyName_ == null
              ? com.google.protobuf.StringValue.getDefaultInstance()
              : familyName_;
        } else {
          return familyNameBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public Builder setFamilyName(com.google.protobuf.StringValue value) {
        if (familyNameBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          familyName_ = value;
          onChanged();
        } else {
          familyNameBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public Builder setFamilyName(com.google.protobuf.StringValue.Builder builderForValue) {
        if (familyNameBuilder_ == null) {
          familyName_ = builderForValue.build();
          onChanged();
        } else {
          familyNameBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public Builder mergeFamilyName(com.google.protobuf.StringValue value) {
        if (familyNameBuilder_ == null) {
          if (familyName_ != null) {
            familyName_ =
                com.google.protobuf.StringValue.newBuilder(familyName_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            familyName_ = value;
          }
          onChanged();
        } else {
          familyNameBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public Builder clearFamilyName() {
        if (familyNameBuilder_ == null) {
          familyName_ = null;
          onChanged();
        } else {
          familyName_ = null;
          familyNameBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public com.google.protobuf.StringValue.Builder getFamilyNameBuilder() {

        onChanged();
        return getFamilyNameFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      public com.google.protobuf.StringValueOrBuilder getFamilyNameOrBuilder() {
        if (familyNameBuilder_ != null) {
          return familyNameBuilder_.getMessageOrBuilder();
        } else {
          return familyName_ == null
              ? com.google.protobuf.StringValue.getDefaultInstance()
              : familyName_;
        }
      }
      /**
       *
       *
       * <pre>
       * The column family name for this chunk of data.  If this message
       * is not present this CellChunk is a continuation of the same column
       * family as the previous CellChunk.  The empty string can occur as a
       * column family name in a response so clients must check
       * explicitly for the presence of this message, not just for
       * `family_name.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.StringValue family_name = 2;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.StringValue,
              com.google.protobuf.StringValue.Builder,
              com.google.protobuf.StringValueOrBuilder>
          getFamilyNameFieldBuilder() {
        if (familyNameBuilder_ == null) {
          familyNameBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.StringValue,
                  com.google.protobuf.StringValue.Builder,
                  com.google.protobuf.StringValueOrBuilder>(
                  getFamilyName(), getParentForChildren(), isClean());
          familyName_ = null;
        }
        return familyNameBuilder_;
      }

      private com.google.protobuf.BytesValue qualifier_;
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BytesValue,
              com.google.protobuf.BytesValue.Builder,
              com.google.protobuf.BytesValueOrBuilder>
          qualifierBuilder_;
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       *
       * @return Whether the qualifier field is set.
       */
      public boolean hasQualifier() {
        return qualifierBuilder_ != null || qualifier_ != null;
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       *
       * @return The qualifier.
       */
      public com.google.protobuf.BytesValue getQualifier() {
        if (qualifierBuilder_ == null) {
          return qualifier_ == null
              ? com.google.protobuf.BytesValue.getDefaultInstance()
              : qualifier_;
        } else {
          return qualifierBuilder_.getMessage();
        }
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public Builder setQualifier(com.google.protobuf.BytesValue value) {
        if (qualifierBuilder_ == null) {
          if (value == null) {
            throw new NullPointerException();
          }
          qualifier_ = value;
          onChanged();
        } else {
          qualifierBuilder_.setMessage(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public Builder setQualifier(com.google.protobuf.BytesValue.Builder builderForValue) {
        if (qualifierBuilder_ == null) {
          qualifier_ = builderForValue.build();
          onChanged();
        } else {
          qualifierBuilder_.setMessage(builderForValue.build());
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public Builder mergeQualifier(com.google.protobuf.BytesValue value) {
        if (qualifierBuilder_ == null) {
          if (qualifier_ != null) {
            qualifier_ =
                com.google.protobuf.BytesValue.newBuilder(qualifier_)
                    .mergeFrom(value)
                    .buildPartial();
          } else {
            qualifier_ = value;
          }
          onChanged();
        } else {
          qualifierBuilder_.mergeFrom(value);
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public Builder clearQualifier() {
        if (qualifierBuilder_ == null) {
          qualifier_ = null;
          onChanged();
        } else {
          qualifier_ = null;
          qualifierBuilder_ = null;
        }

        return this;
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public com.google.protobuf.BytesValue.Builder getQualifierBuilder() {

        onChanged();
        return getQualifierFieldBuilder().getBuilder();
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      public com.google.protobuf.BytesValueOrBuilder getQualifierOrBuilder() {
        if (qualifierBuilder_ != null) {
          return qualifierBuilder_.getMessageOrBuilder();
        } else {
          return qualifier_ == null
              ? com.google.protobuf.BytesValue.getDefaultInstance()
              : qualifier_;
        }
      }
      /**
       *
       *
       * <pre>
       * The column qualifier for this chunk of data.  If this message
       * is not present, this CellChunk is a continuation of the same column
       * as the previous CellChunk.  Column qualifiers may be empty so
       * clients must check for the presence of this message, not just
       * for `qualifier.value` being non-empty.
       * </pre>
       *
       * <code>.google.protobuf.BytesValue qualifier = 3;</code>
       */
      private com.google.protobuf.SingleFieldBuilderV3<
              com.google.protobuf.BytesValue,
              com.google.protobuf.BytesValue.Builder,
              com.google.protobuf.BytesValueOrBuilder>
          getQualifierFieldBuilder() {
        if (qualifierBuilder_ == null) {
          qualifierBuilder_ =
              new com.google.protobuf.SingleFieldBuilderV3<
                  com.google.protobuf.BytesValue,
                  com.google.protobuf.BytesValue.Builder,
                  com.google.protobuf.BytesValueOrBuilder>(
                  getQualifier(), getParentForChildren(), isClean());
          qualifier_ = null;
        }
        return qualifierBuilder_;
      }

      private long timestampMicros_;
      /**
       *
       *
       * <pre>
       * The cell's stored timestamp, which also uniquely identifies it
       * within its column.  Values are always expressed in
       * microseconds, but individual tables may set a coarser
       * granularity to further restrict the allowed values. For
       * example, a table which specifies millisecond granularity will
       * only allow values of `timestamp_micros` which are multiples of
       * 1000.  Timestamps are only set in the first CellChunk per cell
       * (for cells split into multiple chunks).
       * </pre>
       *
       * <code>int64 timestamp_micros = 4;</code>
       *
       * @return The timestampMicros.
       */
      @java.lang.Override
      public long getTimestampMicros() {
        return timestampMicros_;
      }
      /**
       *
       *
       * <pre>
       * The cell's stored timestamp, which also uniquely identifies it
       * within its column.  Values are always expressed in
       * microseconds, but individual tables may set a coarser
       * granularity to further restrict the allowed values. For
       * example, a table which specifies millisecond granularity will
       * only allow values of `timestamp_micros` which are multiples of
       * 1000.  Timestamps are only set in the first CellChunk per cell
       * (for cells split into multiple chunks).
       * </pre>
       *
       * <code>int64 timestamp_micros = 4;</code>
       *
       * @param value The timestampMicros to set.
       * @return This builder for chaining.
       */
      public Builder setTimestampMicros(long value) {

        timestampMicros_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The cell's stored timestamp, which also uniquely identifies it
       * within its column.  Values are always expressed in
       * microseconds, but individual tables may set a coarser
       * granularity to further restrict the allowed values. For
       * example, a table which specifies millisecond granularity will
       * only allow values of `timestamp_micros` which are multiples of
       * 1000.  Timestamps are only set in the first CellChunk per cell
       * (for cells split into multiple chunks).
       * </pre>
       *
       * <code>int64 timestamp_micros = 4;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearTimestampMicros() {

        timestampMicros_ = 0L;
        onChanged();
        return this;
      }

      private com.google.protobuf.LazyStringList labels_ =
          com.google.protobuf.LazyStringArrayList.EMPTY;

      private void ensureLabelsIsMutable() {
        if (!((bitField0_ & 0x00000001) != 0)) {
          labels_ = new com.google.protobuf.LazyStringArrayList(labels_);
          bitField0_ |= 0x00000001;
        }
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @return A list containing the labels.
       */
      public com.google.protobuf.ProtocolStringList getLabelsList() {
        return labels_.getUnmodifiableView();
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @return The count of labels.
       */
      public int getLabelsCount() {
        return labels_.size();
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param index The index of the element to return.
       * @return The labels at the given index.
       */
      public java.lang.String getLabels(int index) {
        return labels_.get(index);
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param index The index of the value to return.
       * @return The bytes of the labels at the given index.
       */
      public com.google.protobuf.ByteString getLabelsBytes(int index) {
        return labels_.getByteString(index);
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param index The index to set the value at.
       * @param value The labels to set.
       * @return This builder for chaining.
       */
      public Builder setLabels(int index, java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.set(index, value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param value The labels to add.
       * @return This builder for chaining.
       */
      public Builder addLabels(java.lang.String value) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param values The labels to add.
       * @return This builder for chaining.
       */
      public Builder addAllLabels(java.lang.Iterable<java.lang.String> values) {
        ensureLabelsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, labels_);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearLabels() {
        labels_ = com.google.protobuf.LazyStringArrayList.EMPTY;
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Labels applied to the cell by a
       * [RowFilter][google.bigtable.v2.RowFilter].  Labels are only set
       * on the first CellChunk per cell.
       * </pre>
       *
       * <code>repeated string labels = 5;</code>
       *
       * @param value The bytes of the labels to add.
       * @return This builder for chaining.
       */
      public Builder addLabelsBytes(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }
        checkByteStringIsUtf8(value);
        ensureLabelsIsMutable();
        labels_.add(value);
        onChanged();
        return this;
      }

      private com.google.protobuf.ByteString value_ = com.google.protobuf.ByteString.EMPTY;
      /**
       *
       *
       * <pre>
       * The value stored in the cell.  Cell values can be split across
       * multiple CellChunks.  In that case only the value field will be
       * set in CellChunks after the first: the timestamp and labels
       * will only be present in the first CellChunk, even if the first
       * CellChunk came in a previous ReadRowsResponse.
       * </pre>
       *
       * <code>bytes value = 6;</code>
       *
       * @return The value.
       */
      @java.lang.Override
      public com.google.protobuf.ByteString getValue() {
        return value_;
      }
      /**
       *
       *
       * <pre>
       * The value stored in the cell.  Cell values can be split across
       * multiple CellChunks.  In that case only the value field will be
       * set in CellChunks after the first: the timestamp and labels
       * will only be present in the first CellChunk, even if the first
       * CellChunk came in a previous ReadRowsResponse.
       * </pre>
       *
       * <code>bytes value = 6;</code>
       *
       * @param value The value to set.
       * @return This builder for chaining.
       */
      public Builder setValue(com.google.protobuf.ByteString value) {
        if (value == null) {
          throw new NullPointerException();
        }

        value_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * The value stored in the cell.  Cell values can be split across
       * multiple CellChunks.  In that case only the value field will be
       * set in CellChunks after the first: the timestamp and labels
       * will only be present in the first CellChunk, even if the first
       * CellChunk came in a previous ReadRowsResponse.
       * </pre>
       *
       * <code>bytes value = 6;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValue() {

        value_ = getDefaultInstance().getValue();
        onChanged();
        return this;
      }

      private int valueSize_;
      /**
       *
       *
       * <pre>
       * If this CellChunk is part of a chunked cell value and this is
       * not the final chunk of that cell, value_size will be set to the
       * total length of the cell value.  The client can use this size
       * to pre-allocate memory to hold the full cell value.
       * </pre>
       *
       * <code>int32 value_size = 7;</code>
       *
       * @return The valueSize.
       */
      @java.lang.Override
      public int getValueSize() {
        return valueSize_;
      }
      /**
       *
       *
       * <pre>
       * If this CellChunk is part of a chunked cell value and this is
       * not the final chunk of that cell, value_size will be set to the
       * total length of the cell value.  The client can use this size
       * to pre-allocate memory to hold the full cell value.
       * </pre>
       *
       * <code>int32 value_size = 7;</code>
       *
       * @param value The valueSize to set.
       * @return This builder for chaining.
       */
      public Builder setValueSize(int value) {

        valueSize_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * If this CellChunk is part of a chunked cell value and this is
       * not the final chunk of that cell, value_size will be set to the
       * total length of the cell value.  The client can use this size
       * to pre-allocate memory to hold the full cell value.
       * </pre>
       *
       * <code>int32 value_size = 7;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearValueSize() {

        valueSize_ = 0;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that the client should drop all previous chunks for
       * `row_key`, as it will be re-read from the beginning.
       * </pre>
       *
       * <code>bool reset_row = 8;</code>
       *
       * @return The resetRow.
       */
      public boolean getResetRow() {
        if (rowStatusCase_ == 8) {
          return (java.lang.Boolean) rowStatus_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the client should drop all previous chunks for
       * `row_key`, as it will be re-read from the beginning.
       * </pre>
       *
       * <code>bool reset_row = 8;</code>
       *
       * @param value The resetRow to set.
       * @return This builder for chaining.
       */
      public Builder setResetRow(boolean value) {
        rowStatusCase_ = 8;
        rowStatus_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the client should drop all previous chunks for
       * `row_key`, as it will be re-read from the beginning.
       * </pre>
       *
       * <code>bool reset_row = 8;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearResetRow() {
        if (rowStatusCase_ == 8) {
          rowStatusCase_ = 0;
          rowStatus_ = null;
          onChanged();
        }
        return this;
      }

      /**
       *
       *
       * <pre>
       * Indicates that the client can safely process all previous chunks for
       * `row_key`, as its data has been fully read.
       * </pre>
       *
       * <code>bool commit_row = 9;</code>
       *
       * @return The commitRow.
       */
      public boolean getCommitRow() {
        if (rowStatusCase_ == 9) {
          return (java.lang.Boolean) rowStatus_;
        }
        return false;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the client can safely process all previous chunks for
       * `row_key`, as its data has been fully read.
       * </pre>
       *
       * <code>bool commit_row = 9;</code>
       *
       * @param value The commitRow to set.
       * @return This builder for chaining.
       */
      public Builder setCommitRow(boolean value) {
        rowStatusCase_ = 9;
        rowStatus_ = value;
        onChanged();
        return this;
      }
      /**
       *
       *
       * <pre>
       * Indicates that the client can safely process all previous chunks for
       * `row_key`, as its data has been fully read.
       * </pre>
       *
       * <code>bool commit_row = 9;</code>
       *
       * @return This builder for chaining.
       */
      public Builder clearCommitRow() {
        if (rowStatusCase_ == 9) {
          rowStatusCase_ = 0;
          rowStatus_ = null;
          onChanged();
        }
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadRowsResponse.CellChunk)
    }

    // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadRowsResponse.CellChunk)
    private static final com.google.bigtable.v2.ReadRowsResponse.CellChunk DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadRowsResponse.CellChunk();
    }

    public static com.google.bigtable.v2.ReadRowsResponse.CellChunk getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<CellChunk> PARSER =
        new com.google.protobuf.AbstractParser<CellChunk>() {
          @java.lang.Override
          public CellChunk parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            return new CellChunk(input, extensionRegistry);
          }
        };

    public static com.google.protobuf.Parser<CellChunk> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<CellChunk> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsResponse.CellChunk getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  public static final int CHUNKS_FIELD_NUMBER = 1;
  private java.util.List<com.google.bigtable.v2.ReadRowsResponse.CellChunk> chunks_;
  /**
   *
   *
   * <pre>
   * A collection of a row's contents as part of the read request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.bigtable.v2.ReadRowsResponse.CellChunk> getChunksList() {
    return chunks_;
  }
  /**
   *
   *
   * <pre>
   * A collection of a row's contents as part of the read request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder>
      getChunksOrBuilderList() {
    return chunks_;
  }
  /**
   *
   *
   * <pre>
   * A collection of a row's contents as part of the read request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
   */
  @java.lang.Override
  public int getChunksCount() {
    return chunks_.size();
  }
  /**
   *
   *
   * <pre>
   * A collection of a row's contents as part of the read request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsResponse.CellChunk getChunks(int index) {
    return chunks_.get(index);
  }
  /**
   *
   *
   * <pre>
   * A collection of a row's contents as part of the read request.
   * </pre>
   *
   * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
   */
  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder getChunksOrBuilder(int index) {
    return chunks_.get(index);
  }

  public static final int LAST_SCANNED_ROW_KEY_FIELD_NUMBER = 2;
  private com.google.protobuf.ByteString lastScannedRowKey_;
  /**
   *
   *
   * <pre>
   * Optionally the server might return the row key of the last row it
   * has scanned.  The client can use this to construct a more
   * efficient retry request if needed: any row keys or portions of
   * ranges less than this row key can be dropped from the request.
   * This is primarily useful for cases where the server has read a
   * lot of data that was filtered out since the last committed row
   * key, allowing the client to skip that work on a retry.
   * </pre>
   *
   * <code>bytes last_scanned_row_key = 2;</code>
   *
   * @return The lastScannedRowKey.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getLastScannedRowKey() {
    return lastScannedRowKey_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    for (int i = 0; i < chunks_.size(); i++) {
      output.writeMessage(1, chunks_.get(i));
    }
    if (!lastScannedRowKey_.isEmpty()) {
      output.writeBytes(2, lastScannedRowKey_);
    }
    unknownFields.writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    for (int i = 0; i < chunks_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(1, chunks_.get(i));
    }
    if (!lastScannedRowKey_.isEmpty()) {
      size += com.google.protobuf.CodedOutputStream.computeBytesSize(2, lastScannedRowKey_);
    }
    size += unknownFields.getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.bigtable.v2.ReadRowsResponse)) {
      return super.equals(obj);
    }
    com.google.bigtable.v2.ReadRowsResponse other = (com.google.bigtable.v2.ReadRowsResponse) obj;

    if (!getChunksList().equals(other.getChunksList())) return false;
    if (!getLastScannedRowKey().equals(other.getLastScannedRowKey())) return false;
    if (!unknownFields.equals(other.unknownFields)) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    if (getChunksCount() > 0) {
      hash = (37 * hash) + CHUNKS_FIELD_NUMBER;
      hash = (53 * hash) + getChunksList().hashCode();
    }
    hash = (37 * hash) + LAST_SCANNED_ROW_KEY_FIELD_NUMBER;
    hash = (53 * hash) + getLastScannedRowKey().hashCode();
    hash = (29 * hash) + unknownFields.hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.bigtable.v2.ReadRowsResponse parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.bigtable.v2.ReadRowsResponse prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * Response message for Bigtable.ReadRows.
   * </pre>
   *
   * Protobuf type {@code google.bigtable.v2.ReadRowsResponse}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.bigtable.v2.ReadRowsResponse)
      com.google.bigtable.v2.ReadRowsResponseOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsResponse_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.bigtable.v2.ReadRowsResponse.class,
              com.google.bigtable.v2.ReadRowsResponse.Builder.class);
    }

    // Construct using com.google.bigtable.v2.ReadRowsResponse.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getChunksFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      if (chunksBuilder_ == null) {
        chunks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
      } else {
        chunksBuilder_.clear();
      }
      lastScannedRowKey_ = com.google.protobuf.ByteString.EMPTY;

      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.bigtable.v2.BigtableProto
          .internal_static_google_bigtable_v2_ReadRowsResponse_descriptor;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsResponse getDefaultInstanceForType() {
      return com.google.bigtable.v2.ReadRowsResponse.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsResponse build() {
      com.google.bigtable.v2.ReadRowsResponse result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.bigtable.v2.ReadRowsResponse buildPartial() {
      com.google.bigtable.v2.ReadRowsResponse result =
          new com.google.bigtable.v2.ReadRowsResponse(this);
      int from_bitField0_ = bitField0_;
      if (chunksBuilder_ == null) {
        if (((bitField0_ & 0x00000001) != 0)) {
          chunks_ = java.util.Collections.unmodifiableList(chunks_);
          bitField0_ = (bitField0_ & ~0x00000001);
        }
        result.chunks_ = chunks_;
      } else {
        result.chunks_ = chunksBuilder_.build();
      }
      result.lastScannedRowKey_ = lastScannedRowKey_;
      onBuilt();
      return result;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.bigtable.v2.ReadRowsResponse) {
        return mergeFrom((com.google.bigtable.v2.ReadRowsResponse) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.bigtable.v2.ReadRowsResponse other) {
      if (other == com.google.bigtable.v2.ReadRowsResponse.getDefaultInstance()) return this;
      if (chunksBuilder_ == null) {
        if (!other.chunks_.isEmpty()) {
          if (chunks_.isEmpty()) {
            chunks_ = other.chunks_;
            bitField0_ = (bitField0_ & ~0x00000001);
          } else {
            ensureChunksIsMutable();
            chunks_.addAll(other.chunks_);
          }
          onChanged();
        }
      } else {
        if (!other.chunks_.isEmpty()) {
          if (chunksBuilder_.isEmpty()) {
            chunksBuilder_.dispose();
            chunksBuilder_ = null;
            chunks_ = other.chunks_;
            bitField0_ = (bitField0_ & ~0x00000001);
            chunksBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getChunksFieldBuilder()
                    : null;
          } else {
            chunksBuilder_.addAllMessages(other.chunks_);
          }
        }
      }
      if (other.getLastScannedRowKey() != com.google.protobuf.ByteString.EMPTY) {
        setLastScannedRowKey(other.getLastScannedRowKey());
      }
      this.mergeUnknownFields(other.unknownFields);
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      com.google.bigtable.v2.ReadRowsResponse parsedMessage = null;
      try {
        parsedMessage = PARSER.parsePartialFrom(input, extensionRegistry);
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        parsedMessage = (com.google.bigtable.v2.ReadRowsResponse) e.getUnfinishedMessage();
        throw e.unwrapIOException();
      } finally {
        if (parsedMessage != null) {
          mergeFrom(parsedMessage);
        }
      }
      return this;
    }

    private int bitField0_;

    private java.util.List<com.google.bigtable.v2.ReadRowsResponse.CellChunk> chunks_ =
        java.util.Collections.emptyList();

    private void ensureChunksIsMutable() {
      if (!((bitField0_ & 0x00000001) != 0)) {
        chunks_ =
            new java.util.ArrayList<com.google.bigtable.v2.ReadRowsResponse.CellChunk>(chunks_);
        bitField0_ |= 0x00000001;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.ReadRowsResponse.CellChunk,
            com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder,
            com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder>
        chunksBuilder_;

    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public java.util.List<com.google.bigtable.v2.ReadRowsResponse.CellChunk> getChunksList() {
      if (chunksBuilder_ == null) {
        return java.util.Collections.unmodifiableList(chunks_);
      } else {
        return chunksBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public int getChunksCount() {
      if (chunksBuilder_ == null) {
        return chunks_.size();
      } else {
        return chunksBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public com.google.bigtable.v2.ReadRowsResponse.CellChunk getChunks(int index) {
      if (chunksBuilder_ == null) {
        return chunks_.get(index);
      } else {
        return chunksBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder setChunks(int index, com.google.bigtable.v2.ReadRowsResponse.CellChunk value) {
      if (chunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChunksIsMutable();
        chunks_.set(index, value);
        onChanged();
      } else {
        chunksBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder setChunks(
        int index, com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder builderForValue) {
      if (chunksBuilder_ == null) {
        ensureChunksIsMutable();
        chunks_.set(index, builderForValue.build());
        onChanged();
      } else {
        chunksBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder addChunks(com.google.bigtable.v2.ReadRowsResponse.CellChunk value) {
      if (chunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChunksIsMutable();
        chunks_.add(value);
        onChanged();
      } else {
        chunksBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder addChunks(int index, com.google.bigtable.v2.ReadRowsResponse.CellChunk value) {
      if (chunksBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureChunksIsMutable();
        chunks_.add(index, value);
        onChanged();
      } else {
        chunksBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder addChunks(
        com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder builderForValue) {
      if (chunksBuilder_ == null) {
        ensureChunksIsMutable();
        chunks_.add(builderForValue.build());
        onChanged();
      } else {
        chunksBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder addChunks(
        int index, com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder builderForValue) {
      if (chunksBuilder_ == null) {
        ensureChunksIsMutable();
        chunks_.add(index, builderForValue.build());
        onChanged();
      } else {
        chunksBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder addAllChunks(
        java.lang.Iterable<? extends com.google.bigtable.v2.ReadRowsResponse.CellChunk> values) {
      if (chunksBuilder_ == null) {
        ensureChunksIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, chunks_);
        onChanged();
      } else {
        chunksBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder clearChunks() {
      if (chunksBuilder_ == null) {
        chunks_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000001);
        onChanged();
      } else {
        chunksBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public Builder removeChunks(int index) {
      if (chunksBuilder_ == null) {
        ensureChunksIsMutable();
        chunks_.remove(index);
        onChanged();
      } else {
        chunksBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder getChunksBuilder(int index) {
      return getChunksFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder getChunksOrBuilder(
        int index) {
      if (chunksBuilder_ == null) {
        return chunks_.get(index);
      } else {
        return chunksBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public java.util.List<? extends com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder>
        getChunksOrBuilderList() {
      if (chunksBuilder_ != null) {
        return chunksBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(chunks_);
      }
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder addChunksBuilder() {
      return getChunksFieldBuilder()
          .addBuilder(com.google.bigtable.v2.ReadRowsResponse.CellChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder addChunksBuilder(int index) {
      return getChunksFieldBuilder()
          .addBuilder(
              index, com.google.bigtable.v2.ReadRowsResponse.CellChunk.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * A collection of a row's contents as part of the read request.
     * </pre>
     *
     * <code>repeated .google.bigtable.v2.ReadRowsResponse.CellChunk chunks = 1;</code>
     */
    public java.util.List<com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder>
        getChunksBuilderList() {
      return getChunksFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.bigtable.v2.ReadRowsResponse.CellChunk,
            com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder,
            com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder>
        getChunksFieldBuilder() {
      if (chunksBuilder_ == null) {
        chunksBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.bigtable.v2.ReadRowsResponse.CellChunk,
                com.google.bigtable.v2.ReadRowsResponse.CellChunk.Builder,
                com.google.bigtable.v2.ReadRowsResponse.CellChunkOrBuilder>(
                chunks_, ((bitField0_ & 0x00000001) != 0), getParentForChildren(), isClean());
        chunks_ = null;
      }
      return chunksBuilder_;
    }

    private com.google.protobuf.ByteString lastScannedRowKey_ =
        com.google.protobuf.ByteString.EMPTY;
    /**
     *
     *
     * <pre>
     * Optionally the server might return the row key of the last row it
     * has scanned.  The client can use this to construct a more
     * efficient retry request if needed: any row keys or portions of
     * ranges less than this row key can be dropped from the request.
     * This is primarily useful for cases where the server has read a
     * lot of data that was filtered out since the last committed row
     * key, allowing the client to skip that work on a retry.
     * </pre>
     *
     * <code>bytes last_scanned_row_key = 2;</code>
     *
     * @return The lastScannedRowKey.
     */
    @java.lang.Override
    public com.google.protobuf.ByteString getLastScannedRowKey() {
      return lastScannedRowKey_;
    }
    /**
     *
     *
     * <pre>
     * Optionally the server might return the row key of the last row it
     * has scanned.  The client can use this to construct a more
     * efficient retry request if needed: any row keys or portions of
     * ranges less than this row key can be dropped from the request.
     * This is primarily useful for cases where the server has read a
     * lot of data that was filtered out since the last committed row
     * key, allowing the client to skip that work on a retry.
     * </pre>
     *
     * <code>bytes last_scanned_row_key = 2;</code>
     *
     * @param value The lastScannedRowKey to set.
     * @return This builder for chaining.
     */
    public Builder setLastScannedRowKey(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }

      lastScannedRowKey_ = value;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Optionally the server might return the row key of the last row it
     * has scanned.  The client can use this to construct a more
     * efficient retry request if needed: any row keys or portions of
     * ranges less than this row key can be dropped from the request.
     * This is primarily useful for cases where the server has read a
     * lot of data that was filtered out since the last committed row
     * key, allowing the client to skip that work on a retry.
     * </pre>
     *
     * <code>bytes last_scanned_row_key = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearLastScannedRowKey() {

      lastScannedRowKey_ = getDefaultInstance().getLastScannedRowKey();
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.bigtable.v2.ReadRowsResponse)
  }

  // @@protoc_insertion_point(class_scope:google.bigtable.v2.ReadRowsResponse)
  private static final com.google.bigtable.v2.ReadRowsResponse DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.bigtable.v2.ReadRowsResponse();
  }

  public static com.google.bigtable.v2.ReadRowsResponse getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ReadRowsResponse> PARSER =
      new com.google.protobuf.AbstractParser<ReadRowsResponse>() {
        @java.lang.Override
        public ReadRowsResponse parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          return new ReadRowsResponse(input, extensionRegistry);
        }
      };

  public static com.google.protobuf.Parser<ReadRowsResponse> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ReadRowsResponse> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.bigtable.v2.ReadRowsResponse getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
