/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class WriteStreamName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/datasets/{dataset}/tables/{table}/streams/{stream}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataset;
    private final String table;
    private final String stream;

    public String getProject() {
        return this.project;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getTable() {
        return this.table;
    }

    public String getStream() {
        return this.stream;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private WriteStreamName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.table = (String)Preconditions.checkNotNull((Object)builder.getTable());
        this.stream = (String)Preconditions.checkNotNull((Object)builder.getStream());
    }

    public static WriteStreamName of(String project, String dataset, String table, String stream) {
        return WriteStreamName.newBuilder().setProject(project).setDataset(dataset).setTable(table).setStream(stream).build();
    }

    public static String format(String project, String dataset, String table, String stream) {
        return WriteStreamName.newBuilder().setProject(project).setDataset(dataset).setTable(table).setStream(stream).build().toString();
    }

    public static WriteStreamName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "WriteStreamName.parse: formattedString not in valid format");
        return WriteStreamName.of((String)matchMap.get("project"), (String)matchMap.get("dataset"), (String)matchMap.get("table"), (String)matchMap.get("stream"));
    }

    public static List<WriteStreamName> parseList(List<String> formattedStrings) {
        ArrayList<WriteStreamName> list = new ArrayList<WriteStreamName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(WriteStreamName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<WriteStreamName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (WriteStreamName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            WriteStreamName writeStreamName = this;
            synchronized (writeStreamName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"table", (Object)this.table);
                    fieldMapBuilder.put((Object)"stream", (Object)this.stream);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "dataset", this.dataset, "table", this.table, "stream", this.stream});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof WriteStreamName) {
            WriteStreamName that = (WriteStreamName)o;
            return this.project.equals(that.project) && this.dataset.equals(that.dataset) && this.table.equals(that.table) && this.stream.equals(that.stream);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        h ^= this.table.hashCode();
        h *= 1000003;
        return h ^= this.stream.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataset;
        private String table;
        private String stream;

        public String getProject() {
            return this.project;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getTable() {
            return this.table;
        }

        public String getStream() {
            return this.stream;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setTable(String table) {
            this.table = table;
            return this;
        }

        public Builder setStream(String stream) {
            this.stream = stream;
            return this;
        }

        private Builder() {
        }

        private Builder(WriteStreamName writeStreamName) {
            this.project = writeStreamName.project;
            this.dataset = writeStreamName.dataset;
            this.table = writeStreamName.table;
            this.stream = writeStreamName.stream;
        }

        public WriteStreamName build() {
            return new WriteStreamName(this);
        }
    }
}

