/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.storage.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReadSessionName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sessions/{session}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String session;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSession() {
        return this.session;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ReadSessionName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.session = (String)Preconditions.checkNotNull((Object)builder.getSession());
    }

    public static ReadSessionName of(String project, String location, String session) {
        return ReadSessionName.newBuilder().setProject(project).setLocation(location).setSession(session).build();
    }

    public static String format(String project, String location, String session) {
        return ReadSessionName.newBuilder().setProject(project).setLocation(location).setSession(session).build().toString();
    }

    public static ReadSessionName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ReadSessionName.parse: formattedString not in valid format");
        return ReadSessionName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("session"));
    }

    public static List<ReadSessionName> parseList(List<String> formattedStrings) {
        ArrayList<ReadSessionName> list = new ArrayList<ReadSessionName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReadSessionName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReadSessionName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReadSessionName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReadSessionName readSessionName = this;
            synchronized (readSessionName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"session", (Object)this.session);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "session", this.session});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReadSessionName) {
            ReadSessionName that = (ReadSessionName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.session.equals(that.session);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.session.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String session;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSession() {
            return this.session;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSession(String session) {
            this.session = session;
            return this;
        }

        private Builder() {
        }

        private Builder(ReadSessionName readSessionName) {
            this.project = readSessionName.project;
            this.location = readSessionName.location;
            this.session = readSessionName.session;
        }

        public ReadSessionName build() {
            return new ReadSessionName(this);
        }
    }
}

