/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/storage/v1/table.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.storage.v1;

/**
 *
 *
 * <pre>
 * TableFieldSchema defines a single field/column within a table schema.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema}
 */
public final class TableFieldSchema extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.TableFieldSchema)
    TableFieldSchemaOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use TableFieldSchema.newBuilder() to construct.
  private TableFieldSchema(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private TableFieldSchema() {
    name_ = "";
    type_ = 0;
    mode_ = 0;
    fields_ = java.util.Collections.emptyList();
    description_ = "";
    defaultValueExpression_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new TableFieldSchema();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.storage.v1.TableProto
        .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.storage.v1.TableProto
        .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.class,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder.class);
  }

  /** Protobuf enum {@code google.cloud.bigquery.storage.v1.TableFieldSchema.Type} */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * 64K, UTF8
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * 64-bit signed
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    INT64(2),
    /**
     *
     *
     * <pre>
     * 64-bit IEEE floating point
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * Aggregate type
     * </pre>
     *
     * <code>STRUCT = 4;</code>
     */
    STRUCT(4),
    /**
     *
     *
     * <pre>
     * 64K, Binary
     * </pre>
     *
     * <code>BYTES = 5;</code>
     */
    BYTES(5),
    /**
     *
     *
     * <pre>
     * 2-valued
     * </pre>
     *
     * <code>BOOL = 6;</code>
     */
    BOOL(6),
    /**
     *
     *
     * <pre>
     * 64-bit signed usec since UTC epoch
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    TIMESTAMP(7),
    /**
     *
     *
     * <pre>
     * Civil date - Year, Month, Day
     * </pre>
     *
     * <code>DATE = 8;</code>
     */
    DATE(8),
    /**
     *
     *
     * <pre>
     * Civil time - Hour, Minute, Second, Microseconds
     * </pre>
     *
     * <code>TIME = 9;</code>
     */
    TIME(9),
    /**
     *
     *
     * <pre>
     * Combination of civil date and civil time
     * </pre>
     *
     * <code>DATETIME = 10;</code>
     */
    DATETIME(10),
    /**
     *
     *
     * <pre>
     * Geography object
     * </pre>
     *
     * <code>GEOGRAPHY = 11;</code>
     */
    GEOGRAPHY(11),
    /**
     *
     *
     * <pre>
     * Numeric value
     * </pre>
     *
     * <code>NUMERIC = 12;</code>
     */
    NUMERIC(12),
    /**
     *
     *
     * <pre>
     * BigNumeric value
     * </pre>
     *
     * <code>BIGNUMERIC = 13;</code>
     */
    BIGNUMERIC(13),
    /**
     *
     *
     * <pre>
     * Interval
     * </pre>
     *
     * <code>INTERVAL = 14;</code>
     */
    INTERVAL(14),
    /**
     *
     *
     * <pre>
     * JSON, String
     * </pre>
     *
     * <code>JSON = 15;</code>
     */
    JSON(15),
    /**
     *
     *
     * <pre>
     * RANGE
     * </pre>
     *
     * <code>RANGE = 16;</code>
     */
    RANGE(16),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;

    /**
     *
     *
     * <pre>
     * 64K, UTF8
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;

    /**
     *
     *
     * <pre>
     * 64-bit signed
     * </pre>
     *
     * <code>INT64 = 2;</code>
     */
    public static final int INT64_VALUE = 2;

    /**
     *
     *
     * <pre>
     * 64-bit IEEE floating point
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;

    /**
     *
     *
     * <pre>
     * Aggregate type
     * </pre>
     *
     * <code>STRUCT = 4;</code>
     */
    public static final int STRUCT_VALUE = 4;

    /**
     *
     *
     * <pre>
     * 64K, Binary
     * </pre>
     *
     * <code>BYTES = 5;</code>
     */
    public static final int BYTES_VALUE = 5;

    /**
     *
     *
     * <pre>
     * 2-valued
     * </pre>
     *
     * <code>BOOL = 6;</code>
     */
    public static final int BOOL_VALUE = 6;

    /**
     *
     *
     * <pre>
     * 64-bit signed usec since UTC epoch
     * </pre>
     *
     * <code>TIMESTAMP = 7;</code>
     */
    public static final int TIMESTAMP_VALUE = 7;

    /**
     *
     *
     * <pre>
     * Civil date - Year, Month, Day
     * </pre>
     *
     * <code>DATE = 8;</code>
     */
    public static final int DATE_VALUE = 8;

    /**
     *
     *
     * <pre>
     * Civil time - Hour, Minute, Second, Microseconds
     * </pre>
     *
     * <code>TIME = 9;</code>
     */
    public static final int TIME_VALUE = 9;

    /**
     *
     *
     * <pre>
     * Combination of civil date and civil time
     * </pre>
     *
     * <code>DATETIME = 10;</code>
     */
    public static final int DATETIME_VALUE = 10;

    /**
     *
     *
     * <pre>
     * Geography object
     * </pre>
     *
     * <code>GEOGRAPHY = 11;</code>
     */
    public static final int GEOGRAPHY_VALUE = 11;

    /**
     *
     *
     * <pre>
     * Numeric value
     * </pre>
     *
     * <code>NUMERIC = 12;</code>
     */
    public static final int NUMERIC_VALUE = 12;

    /**
     *
     *
     * <pre>
     * BigNumeric value
     * </pre>
     *
     * <code>BIGNUMERIC = 13;</code>
     */
    public static final int BIGNUMERIC_VALUE = 13;

    /**
     *
     *
     * <pre>
     * Interval
     * </pre>
     *
     * <code>INTERVAL = 14;</code>
     */
    public static final int INTERVAL_VALUE = 14;

    /**
     *
     *
     * <pre>
     * JSON, String
     * </pre>
     *
     * <code>JSON = 15;</code>
     */
    public static final int JSON_VALUE = 15;

    /**
     *
     *
     * <pre>
     * RANGE
     * </pre>
     *
     * <code>RANGE = 16;</code>
     */
    public static final int RANGE_VALUE = 16;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return INT64;
        case 3:
          return DOUBLE;
        case 4:
          return STRUCT;
        case 5:
          return BYTES;
        case 6:
          return BOOL;
        case 7:
          return TIMESTAMP;
        case 8:
          return DATE;
        case 9:
          return TIME;
        case 10:
          return DATETIME;
        case 11:
          return GEOGRAPHY;
        case 12:
          return NUMERIC;
        case 13:
          return BIGNUMERIC;
        case 14:
          return INTERVAL;
        case 15:
          return JSON;
        case 16:
          return RANGE;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.Type)
  }

  /** Protobuf enum {@code google.cloud.bigquery.storage.v1.TableFieldSchema.Mode} */
  public enum Mode implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    MODE_UNSPECIFIED(0),
    /** <code>NULLABLE = 1;</code> */
    NULLABLE(1),
    /** <code>REQUIRED = 2;</code> */
    REQUIRED(2),
    /** <code>REPEATED = 3;</code> */
    REPEATED(3),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Illegal value
     * </pre>
     *
     * <code>MODE_UNSPECIFIED = 0;</code>
     */
    public static final int MODE_UNSPECIFIED_VALUE = 0;

    /** <code>NULLABLE = 1;</code> */
    public static final int NULLABLE_VALUE = 1;

    /** <code>REQUIRED = 2;</code> */
    public static final int REQUIRED_VALUE = 2;

    /** <code>REPEATED = 3;</code> */
    public static final int REPEATED_VALUE = 3;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Mode valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Mode forNumber(int value) {
      switch (value) {
        case 0:
          return MODE_UNSPECIFIED;
        case 1:
          return NULLABLE;
        case 2:
          return REQUIRED;
        case 3:
          return REPEATED;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Mode> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Mode> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Mode>() {
          public Mode findValueByNumber(int number) {
            return Mode.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDescriptor()
          .getEnumTypes()
          .get(1);
    }

    private static final Mode[] VALUES = values();

    public static Mode valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Mode(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.Mode)
  }

  public interface FieldElementTypeOrBuilder
      extends
      // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)
      com.google.protobuf.MessageOrBuilder {

    /**
     *
     *
     * <pre>
     * Required. The type of a field element.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    int getTypeValue();

    /**
     *
     *
     * <pre>
     * Required. The type of a field element.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType();
  }

  /**
   *
   *
   * <pre>
   * Represents the type of a field element.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType}
   */
  public static final class FieldElementType extends com.google.protobuf.GeneratedMessageV3
      implements
      // @@protoc_insertion_point(message_implements:google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)
      FieldElementTypeOrBuilder {
    private static final long serialVersionUID = 0L;

    // Use FieldElementType.newBuilder() to construct.
    private FieldElementType(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
      super(builder);
    }

    private FieldElementType() {
      type_ = 0;
    }

    @java.lang.Override
    @SuppressWarnings({"unused"})
    protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
      return new FieldElementType();
    }

    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_FieldElementType_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_FieldElementType_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.class,
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder.class);
    }

    public static final int TYPE_FIELD_NUMBER = 1;
    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The type of a field element.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * Required. The type of a field element.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
          : result;
    }

    private byte memoizedIsInitialized = -1;

    @java.lang.Override
    public final boolean isInitialized() {
      byte isInitialized = memoizedIsInitialized;
      if (isInitialized == 1) return true;
      if (isInitialized == 0) return false;

      memoizedIsInitialized = 1;
      return true;
    }

    @java.lang.Override
    public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
      if (type_
          != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        output.writeEnum(1, type_);
      }
      getUnknownFields().writeTo(output);
    }

    @java.lang.Override
    public int getSerializedSize() {
      int size = memoizedSize;
      if (size != -1) return size;

      size = 0;
      if (type_
          != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
              .getNumber()) {
        size += com.google.protobuf.CodedOutputStream.computeEnumSize(1, type_);
      }
      size += getUnknownFields().getSerializedSize();
      memoizedSize = size;
      return size;
    }

    @java.lang.Override
    public boolean equals(final java.lang.Object obj) {
      if (obj == this) {
        return true;
      }
      if (!(obj
          instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)) {
        return super.equals(obj);
      }
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType other =
          (com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType) obj;

      if (type_ != other.type_) return false;
      if (!getUnknownFields().equals(other.getUnknownFields())) return false;
      return true;
    }

    @java.lang.Override
    public int hashCode() {
      if (memoizedHashCode != 0) {
        return memoizedHashCode;
      }
      int hash = 41;
      hash = (19 * hash) + getDescriptor().hashCode();
      hash = (37 * hash) + TYPE_FIELD_NUMBER;
      hash = (53 * hash) + type_;
      hash = (29 * hash) + getUnknownFields().hashCode();
      memoizedHashCode = hash;
      return hash;
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        com.google.protobuf.ByteString data)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        com.google.protobuf.ByteString data,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        byte[] data) throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws com.google.protobuf.InvalidProtocolBufferException {
      return PARSER.parseFrom(data, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        parseDelimitedFrom(java.io.InputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        parseDelimitedFrom(
            java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
          PARSER, input, extensionRegistry);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        com.google.protobuf.CodedInputStream input) throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType parseFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
          PARSER, input, extensionRegistry);
    }

    @java.lang.Override
    public Builder newBuilderForType() {
      return newBuilder();
    }

    public static Builder newBuilder() {
      return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType prototype) {
      return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    @java.lang.Override
    public Builder toBuilder() {
      return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    @java.lang.Override
    protected Builder newBuilderForType(
        com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      Builder builder = new Builder(parent);
      return builder;
    }

    /**
     *
     *
     * <pre>
     * Represents the type of a field element.
     * </pre>
     *
     * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType}
     */
    public static final class Builder
        extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
        implements
        // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder {
      public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
        return com.google.cloud.bigquery.storage.v1.TableProto
            .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_FieldElementType_descriptor;
      }

      @java.lang.Override
      protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
          internalGetFieldAccessorTable() {
        return com.google.cloud.bigquery.storage.v1.TableProto
            .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_FieldElementType_fieldAccessorTable
            .ensureFieldAccessorsInitialized(
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.class,
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder
                    .class);
      }

      // Construct using
      // com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.newBuilder()
      private Builder() {}

      private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
        super(parent);
      }

      @java.lang.Override
      public Builder clear() {
        super.clear();
        bitField0_ = 0;
        type_ = 0;
        return this;
      }

      @java.lang.Override
      public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
        return com.google.cloud.bigquery.storage.v1.TableProto
            .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_FieldElementType_descriptor;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
          getDefaultInstanceForType() {
        return com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
            .getDefaultInstance();
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType build() {
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType result =
            buildPartial();
        if (!result.isInitialized()) {
          throw newUninitializedMessageException(result);
        }
        return result;
      }

      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType buildPartial() {
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType result =
            new com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType(this);
        if (bitField0_ != 0) {
          buildPartial0(result);
        }
        onBuilt();
        return result;
      }

      private void buildPartial0(
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType result) {
        int from_bitField0_ = bitField0_;
        if (((from_bitField0_ & 0x00000001) != 0)) {
          result.type_ = type_;
        }
      }

      @java.lang.Override
      public Builder clone() {
        return super.clone();
      }

      @java.lang.Override
      public Builder setField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.setField(field, value);
      }

      @java.lang.Override
      public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
        return super.clearField(field);
      }

      @java.lang.Override
      public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
        return super.clearOneof(oneof);
      }

      @java.lang.Override
      public Builder setRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field,
          int index,
          java.lang.Object value) {
        return super.setRepeatedField(field, index, value);
      }

      @java.lang.Override
      public Builder addRepeatedField(
          com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
        return super.addRepeatedField(field, value);
      }

      @java.lang.Override
      public Builder mergeFrom(com.google.protobuf.Message other) {
        if (other
            instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType) {
          return mergeFrom(
              (com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType) other);
        } else {
          super.mergeFrom(other);
          return this;
        }
      }

      public Builder mergeFrom(
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType other) {
        if (other
            == com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
                .getDefaultInstance()) return this;
        if (other.type_ != 0) {
          setTypeValue(other.getTypeValue());
        }
        this.mergeUnknownFields(other.getUnknownFields());
        onChanged();
        return this;
      }

      @java.lang.Override
      public final boolean isInitialized() {
        return true;
      }

      @java.lang.Override
      public Builder mergeFrom(
          com.google.protobuf.CodedInputStream input,
          com.google.protobuf.ExtensionRegistryLite extensionRegistry)
          throws java.io.IOException {
        if (extensionRegistry == null) {
          throw new java.lang.NullPointerException();
        }
        try {
          boolean done = false;
          while (!done) {
            int tag = input.readTag();
            switch (tag) {
              case 0:
                done = true;
                break;
              case 8:
                {
                  type_ = input.readEnum();
                  bitField0_ |= 0x00000001;
                  break;
                } // case 8
              default:
                {
                  if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                    done = true; // was an endgroup tag
                  }
                  break;
                } // default:
            } // switch (tag)
          } // while (!done)
        } catch (com.google.protobuf.InvalidProtocolBufferException e) {
          throw e.unwrapIOException();
        } finally {
          onChanged();
        } // finally
        return this;
      }

      private int bitField0_;

      private int type_ = 0;

      /**
       *
       *
       * <pre>
       * Required. The type of a field element.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The enum numeric value on the wire for type.
       */
      @java.lang.Override
      public int getTypeValue() {
        return type_;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The enum numeric value on the wire for type to set.
       * @return This builder for chaining.
       */
      public Builder setTypeValue(int value) {
        type_ = value;
        bitField0_ |= 0x00000001;
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return The type.
       */
      @java.lang.Override
      public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.forNumber(type_);
        return result == null
            ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
            : result;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @param value The type to set.
       * @return This builder for chaining.
       */
      public Builder setType(com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type value) {
        if (value == null) {
          throw new NullPointerException();
        }
        bitField0_ |= 0x00000001;
        type_ = value.getNumber();
        onChanged();
        return this;
      }

      /**
       *
       *
       * <pre>
       * Required. The type of a field element.
       * </pre>
       *
       * <code>
       * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 1 [(.google.api.field_behavior) = REQUIRED];
       * </code>
       *
       * @return This builder for chaining.
       */
      public Builder clearType() {
        bitField0_ = (bitField0_ & ~0x00000001);
        type_ = 0;
        onChanged();
        return this;
      }

      @java.lang.Override
      public final Builder setUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.setUnknownFields(unknownFields);
      }

      @java.lang.Override
      public final Builder mergeUnknownFields(
          final com.google.protobuf.UnknownFieldSet unknownFields) {
        return super.mergeUnknownFields(unknownFields);
      }

      // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)
    }

    // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType)
    private static final com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        DEFAULT_INSTANCE;

    static {
      DEFAULT_INSTANCE =
          new com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType();
    }

    public static com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        getDefaultInstance() {
      return DEFAULT_INSTANCE;
    }

    private static final com.google.protobuf.Parser<FieldElementType> PARSER =
        new com.google.protobuf.AbstractParser<FieldElementType>() {
          @java.lang.Override
          public FieldElementType parsePartialFrom(
              com.google.protobuf.CodedInputStream input,
              com.google.protobuf.ExtensionRegistryLite extensionRegistry)
              throws com.google.protobuf.InvalidProtocolBufferException {
            Builder builder = newBuilder();
            try {
              builder.mergeFrom(input, extensionRegistry);
            } catch (com.google.protobuf.InvalidProtocolBufferException e) {
              throw e.setUnfinishedMessage(builder.buildPartial());
            } catch (com.google.protobuf.UninitializedMessageException e) {
              throw e.asInvalidProtocolBufferException()
                  .setUnfinishedMessage(builder.buildPartial());
            } catch (java.io.IOException e) {
              throw new com.google.protobuf.InvalidProtocolBufferException(e)
                  .setUnfinishedMessage(builder.buildPartial());
            }
            return builder.buildPartial();
          }
        };

    public static com.google.protobuf.Parser<FieldElementType> parser() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.protobuf.Parser<FieldElementType> getParserForType() {
      return PARSER;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        getDefaultInstanceForType() {
      return DEFAULT_INSTANCE;
    }
  }

  private int bitField0_;
  public static final int NAME_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object name_ = "";

  /**
   *
   *
   * <pre>
   * Required. The field name. The name must contain only letters (a-z, A-Z),
   * numbers (0-9), or underscores (_), and must start with a letter or
   * underscore. The maximum length is 128 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The name.
   */
  @java.lang.Override
  public java.lang.String getName() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      name_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The field name. The name must contain only letters (a-z, A-Z),
   * numbers (0-9), or underscores (_), and must start with a letter or
   * underscore. The maximum length is 128 characters.
   * </pre>
   *
   * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for name.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getNameBytes() {
    java.lang.Object ref = name_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      name_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 2;
  private int type_ = 0;

  /**
   *
   *
   * <pre>
   * Required. The field data type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }

  /**
   *
   *
   * <pre>
   * Required. The field data type.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
   * </code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
    com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
        : result;
  }

  public static final int MODE_FIELD_NUMBER = 3;
  private int mode_ = 0;

  /**
   *
   *
   * <pre>
   * Optional. The field mode. The default value is NULLABLE.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The enum numeric value on the wire for mode.
   */
  @java.lang.Override
  public int getModeValue() {
    return mode_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The field mode. The default value is NULLABLE.
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The mode.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode getMode() {
    com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode result =
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.forNumber(mode_);
    return result == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.UNRECOGNIZED
        : result;
  }

  public static final int FIELDS_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> fields_;

  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to
   * STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> getFieldsList() {
    return fields_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to
   * STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to
   * STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }

  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to
   * STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema getFields(int index) {
    return fields_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Optional. Describes the nested schema fields if the type property is set to
   * STRUCT.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder getFieldsOrBuilder(
      int index) {
    return fields_.get(index);
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 6;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";

  /**
   *
   *
   * <pre>
   * Optional. The field description. The maximum length is 1,024 characters.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. The field description. The maximum length is 1,024 characters.
   * </pre>
   *
   * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int MAX_LENGTH_FIELD_NUMBER = 7;
  private long maxLength_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Maximum length of values of this field for STRINGS or BYTES.
   *
   * If max_length is not specified, no maximum length constraint is imposed
   * on this field.
   *
   * If type = "STRING", then max_length represents the maximum UTF-8
   * length of strings in this field.
   *
   * If type = "BYTES", then max_length represents the maximum number of
   * bytes in this field.
   *
   * It is invalid to set this field if type is not "STRING" or "BYTES".
   * </pre>
   *
   * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The maxLength.
   */
  @java.lang.Override
  public long getMaxLength() {
    return maxLength_;
  }

  public static final int PRECISION_FIELD_NUMBER = 8;
  private long precision_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. Precision (maximum number of total digits in base 10) and scale
   * (maximum number of digits in the fractional part in base 10) constraints
   * for values of this field for NUMERIC or BIGNUMERIC.
   *
   * It is invalid to set precision or scale if type is not "NUMERIC" or
   * "BIGNUMERIC".
   *
   * If precision and scale are not specified, no value range constraint is
   * imposed on this field insofar as values are permitted by the type.
   *
   * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
   *
   * * Precision (P) and scale (S) are specified:
   *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
   * * Precision (P) is specified but not scale (and thus scale is
   *   interpreted to be equal to zero):
   *   [-10^P + 1, 10^P - 1].
   *
   * Acceptable values for precision and scale if both are specified:
   *
   * * If type = "NUMERIC":
   *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
   * * If type = "BIGNUMERIC":
   *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
   *
   * Acceptable values for precision if only precision is specified but not
   * scale (and thus scale is interpreted to be equal to zero):
   *
   * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
   * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
   *
   * If scale is specified but not precision, then it is invalid.
   * </pre>
   *
   * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The precision.
   */
  @java.lang.Override
  public long getPrecision() {
    return precision_;
  }

  public static final int SCALE_FIELD_NUMBER = 9;
  private long scale_ = 0L;

  /**
   *
   *
   * <pre>
   * Optional. See documentation for precision.
   * </pre>
   *
   * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The scale.
   */
  @java.lang.Override
  public long getScale() {
    return scale_;
  }

  public static final int DEFAULT_VALUE_EXPRESSION_FIELD_NUMBER = 10;

  @SuppressWarnings("serial")
  private volatile java.lang.Object defaultValueExpression_ = "";

  /**
   *
   *
   * <pre>
   * Optional. A SQL expression to specify the [default value]
   * (https://cloud.google.com/bigquery/docs/default-values) for this field.
   * </pre>
   *
   * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The defaultValueExpression.
   */
  @java.lang.Override
  public java.lang.String getDefaultValueExpression() {
    java.lang.Object ref = defaultValueExpression_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      defaultValueExpression_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Optional. A SQL expression to specify the [default value]
   * (https://cloud.google.com/bigquery/docs/default-values) for this field.
   * </pre>
   *
   * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
   *
   * @return The bytes for defaultValueExpression.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDefaultValueExpressionBytes() {
    java.lang.Object ref = defaultValueExpression_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      defaultValueExpression_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TIMESTAMP_PRECISION_FIELD_NUMBER = 27;
  private com.google.protobuf.Int64Value timestampPrecision_;

  /**
   *
   *
   * <pre>
   * Optional. Precision (maximum number of total digits in base 10) for seconds
   * of TIMESTAMP type.
   *
   * Possible values include:
   *
   * * 6 (Default, for TIMESTAMP type with microsecond precision)
   * * 12 (For TIMESTAMP type with picosecond precision)
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the timestampPrecision field is set.
   */
  @java.lang.Override
  public boolean hasTimestampPrecision() {
    return ((bitField0_ & 0x00000001) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. Precision (maximum number of total digits in base 10) for seconds
   * of TIMESTAMP type.
   *
   * Possible values include:
   *
   * * 6 (Default, for TIMESTAMP type with microsecond precision)
   * * 12 (For TIMESTAMP type with picosecond precision)
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The timestampPrecision.
   */
  @java.lang.Override
  public com.google.protobuf.Int64Value getTimestampPrecision() {
    return timestampPrecision_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : timestampPrecision_;
  }

  /**
   *
   *
   * <pre>
   * Optional. Precision (maximum number of total digits in base 10) for seconds
   * of TIMESTAMP type.
   *
   * Possible values include:
   *
   * * 6 (Default, for TIMESTAMP type with microsecond precision)
   * * 12 (For TIMESTAMP type with picosecond precision)
   * </pre>
   *
   * <code>
   * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.protobuf.Int64ValueOrBuilder getTimestampPrecisionOrBuilder() {
    return timestampPrecision_ == null
        ? com.google.protobuf.Int64Value.getDefaultInstance()
        : timestampPrecision_;
  }

  public static final int RANGE_ELEMENT_TYPE_FIELD_NUMBER = 11;
  private com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType rangeElementType_;

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return Whether the rangeElementType field is set.
   */
  @java.lang.Override
  public boolean hasRangeElementType() {
    return ((bitField0_ & 0x00000002) != 0);
  }

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   *
   * @return The rangeElementType.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
      getRangeElementType() {
    return rangeElementType_ == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
            .getDefaultInstance()
        : rangeElementType_;
  }

  /**
   *
   *
   * <pre>
   * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
   * the type is RANGE, this field is required. Possible values for the field
   * element type of a RANGE include:
   * * DATE
   * * DATETIME
   * * TIMESTAMP
   * </pre>
   *
   * <code>
   * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder
      getRangeElementTypeOrBuilder() {
    return rangeElementType_ == null
        ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
            .getDefaultInstance()
        : rangeElementType_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(2, type_);
    }
    if (mode_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.MODE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(3, mode_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(4, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 6, description_);
    }
    if (maxLength_ != 0L) {
      output.writeInt64(7, maxLength_);
    }
    if (precision_ != 0L) {
      output.writeInt64(8, precision_);
    }
    if (scale_ != 0L) {
      output.writeInt64(9, scale_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValueExpression_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 10, defaultValueExpression_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(11, getRangeElementType());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(27, getTimestampPrecision());
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(name_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, name_);
    }
    if (type_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(2, type_);
    }
    if (mode_
        != com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.MODE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(3, mode_);
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(6, description_);
    }
    if (maxLength_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(7, maxLength_);
    }
    if (precision_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(8, precision_);
    }
    if (scale_ != 0L) {
      size += com.google.protobuf.CodedOutputStream.computeInt64Size(9, scale_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(defaultValueExpression_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(10, defaultValueExpression_);
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, getRangeElementType());
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(27, getTimestampPrecision());
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.storage.v1.TableFieldSchema other =
        (com.google.cloud.bigquery.storage.v1.TableFieldSchema) obj;

    if (!getName().equals(other.getName())) return false;
    if (type_ != other.type_) return false;
    if (mode_ != other.mode_) return false;
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (getMaxLength() != other.getMaxLength()) return false;
    if (getPrecision() != other.getPrecision()) return false;
    if (getScale() != other.getScale()) return false;
    if (!getDefaultValueExpression().equals(other.getDefaultValueExpression())) return false;
    if (hasTimestampPrecision() != other.hasTimestampPrecision()) return false;
    if (hasTimestampPrecision()) {
      if (!getTimestampPrecision().equals(other.getTimestampPrecision())) return false;
    }
    if (hasRangeElementType() != other.hasRangeElementType()) return false;
    if (hasRangeElementType()) {
      if (!getRangeElementType().equals(other.getRangeElementType())) return false;
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + NAME_FIELD_NUMBER;
    hash = (53 * hash) + getName().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + MODE_FIELD_NUMBER;
    hash = (53 * hash) + mode_;
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + MAX_LENGTH_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getMaxLength());
    hash = (37 * hash) + PRECISION_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getPrecision());
    hash = (37 * hash) + SCALE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashLong(getScale());
    hash = (37 * hash) + DEFAULT_VALUE_EXPRESSION_FIELD_NUMBER;
    hash = (53 * hash) + getDefaultValueExpression().hashCode();
    if (hasTimestampPrecision()) {
      hash = (37 * hash) + TIMESTAMP_PRECISION_FIELD_NUMBER;
      hash = (53 * hash) + getTimestampPrecision().hashCode();
    }
    if (hasRangeElementType()) {
      hash = (37 * hash) + RANGE_ELEMENT_TYPE_FIELD_NUMBER;
      hash = (53 * hash) + getRangeElementType().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.storage.v1.TableFieldSchema prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * TableFieldSchema defines a single field/column within a table schema.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.storage.v1.TableFieldSchema}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.storage.v1.TableFieldSchema)
      com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.class,
              com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.storage.v1.TableFieldSchema.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getFieldsFieldBuilder();
        getTimestampPrecisionFieldBuilder();
        getRangeElementTypeFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      name_ = "";
      type_ = 0;
      mode_ = 0;
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      description_ = "";
      maxLength_ = 0L;
      precision_ = 0L;
      scale_ = 0L;
      defaultValueExpression_ = "";
      timestampPrecision_ = null;
      if (timestampPrecisionBuilder_ != null) {
        timestampPrecisionBuilder_.dispose();
        timestampPrecisionBuilder_ = null;
      }
      rangeElementType_ = null;
      if (rangeElementTypeBuilder_ != null) {
        rangeElementTypeBuilder_.dispose();
        rangeElementTypeBuilder_ = null;
      }
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.storage.v1.TableProto
          .internal_static_google_cloud_bigquery_storage_v1_TableFieldSchema_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstanceForType() {
      return com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema build() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema buildPartial() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema result =
          new com.google.cloud.bigquery.storage.v1.TableFieldSchema(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.bigquery.storage.v1.TableFieldSchema result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.name_ = name_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.mode_ = mode_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.maxLength_ = maxLength_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.precision_ = precision_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        result.scale_ = scale_;
      }
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.defaultValueExpression_ = defaultValueExpression_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.timestampPrecision_ =
            timestampPrecisionBuilder_ == null
                ? timestampPrecision_
                : timestampPrecisionBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000400) != 0)) {
        result.rangeElementType_ =
            rangeElementTypeBuilder_ == null ? rangeElementType_ : rangeElementTypeBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.storage.v1.TableFieldSchema) {
        return mergeFrom((com.google.cloud.bigquery.storage.v1.TableFieldSchema) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.storage.v1.TableFieldSchema other) {
      if (other == com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance())
        return this;
      if (!other.getName().isEmpty()) {
        name_ = other.name_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.mode_ != 0) {
        setModeValue(other.getModeValue());
      }
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000008);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000010;
        onChanged();
      }
      if (other.getMaxLength() != 0L) {
        setMaxLength(other.getMaxLength());
      }
      if (other.getPrecision() != 0L) {
        setPrecision(other.getPrecision());
      }
      if (other.getScale() != 0L) {
        setScale(other.getScale());
      }
      if (!other.getDefaultValueExpression().isEmpty()) {
        defaultValueExpression_ = other.defaultValueExpression_;
        bitField0_ |= 0x00000100;
        onChanged();
      }
      if (other.hasTimestampPrecision()) {
        mergeTimestampPrecision(other.getTimestampPrecision());
      }
      if (other.hasRangeElementType()) {
        mergeRangeElementType(other.getRangeElementType());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                name_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 16:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000002;
                break;
              } // case 16
            case 24:
              {
                mode_ = input.readEnum();
                bitField0_ |= 0x00000004;
                break;
              } // case 24
            case 34:
              {
                com.google.cloud.bigquery.storage.v1.TableFieldSchema m =
                    input.readMessage(
                        com.google.cloud.bigquery.storage.v1.TableFieldSchema.parser(),
                        extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 34
            case 50:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000010;
                break;
              } // case 50
            case 56:
              {
                maxLength_ = input.readInt64();
                bitField0_ |= 0x00000020;
                break;
              } // case 56
            case 64:
              {
                precision_ = input.readInt64();
                bitField0_ |= 0x00000040;
                break;
              } // case 64
            case 72:
              {
                scale_ = input.readInt64();
                bitField0_ |= 0x00000080;
                break;
              } // case 72
            case 82:
              {
                defaultValueExpression_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000100;
                break;
              } // case 82
            case 90:
              {
                input.readMessage(
                    getRangeElementTypeFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000400;
                break;
              } // case 90
            case 218:
              {
                input.readMessage(
                    getTimestampPrecisionFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 218
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object name_ = "";

    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The name.
     */
    public java.lang.String getName() {
      java.lang.Object ref = name_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        name_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for name.
     */
    public com.google.protobuf.ByteString getNameBytes() {
      java.lang.Object ref = name_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        name_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The name to set.
     * @return This builder for chaining.
     */
    public Builder setName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearName() {
      name_ = getDefaultInstance().getName();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The field name. The name must contain only letters (a-z, A-Z),
     * numbers (0-9), or underscores (_), and must start with a letter or
     * underscore. The maximum length is 128 characters.
     * </pre>
     *
     * <code>string name = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for name to set.
     * @return This builder for chaining.
     */
    public Builder setNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      name_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private int type_ = 0;

    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }

    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type getType() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type result =
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(com.google.cloud.bigquery.storage.v1.TableFieldSchema.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000002;
      type_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The field data type.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Type type = 2 [(.google.api.field_behavior) = REQUIRED];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000002);
      type_ = 0;
      onChanged();
      return this;
    }

    private int mode_ = 0;

    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The enum numeric value on the wire for mode.
     */
    @java.lang.Override
    public int getModeValue() {
      return mode_;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The enum numeric value on the wire for mode to set.
     * @return This builder for chaining.
     */
    public Builder setModeValue(int value) {
      mode_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The mode.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode getMode() {
      com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode result =
          com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.forNumber(mode_);
      return result == null
          ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode.UNRECOGNIZED
          : result;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @param value The mode to set.
     * @return This builder for chaining.
     */
    public Builder setMode(com.google.cloud.bigquery.storage.v1.TableFieldSchema.Mode value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000004;
      mode_ = value.getNumber();
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field mode. The default value is NULLABLE.
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.Mode mode = 3 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMode() {
      bitField0_ = (bitField0_ & ~0x00000004);
      mode_ = 0;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        fields_ =
            new java.util.ArrayList<com.google.cloud.bigquery.storage.v1.TableFieldSchema>(fields_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema> getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchema>
            values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder getFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder getFieldsOrBuilder(
        int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<? extends com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder addFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder()
          .addBuilder(
              index, com.google.cloud.bigquery.storage.v1.TableFieldSchema.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Optional. Describes the nested schema fields if the type property is set to
     * STRUCT.
     * </pre>
     *
     * <code>
     * repeated .google.cloud.bigquery.storage.v1.TableFieldSchema fields = 4 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public java.util.List<com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder>
        getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.TableFieldSchema,
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.Builder,
                com.google.cloud.bigquery.storage.v1.TableFieldSchemaOrBuilder>(
                fields_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private java.lang.Object description_ = "";

    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000010);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The field description. The maximum length is 1,024 characters.
     * </pre>
     *
     * <code>string description = 6 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }

    private long maxLength_;

    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     *
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     *
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     *
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     *
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The maxLength.
     */
    @java.lang.Override
    public long getMaxLength() {
      return maxLength_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     *
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     *
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     *
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     *
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The maxLength to set.
     * @return This builder for chaining.
     */
    public Builder setMaxLength(long value) {

      maxLength_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Maximum length of values of this field for STRINGS or BYTES.
     *
     * If max_length is not specified, no maximum length constraint is imposed
     * on this field.
     *
     * If type = "STRING", then max_length represents the maximum UTF-8
     * length of strings in this field.
     *
     * If type = "BYTES", then max_length represents the maximum number of
     * bytes in this field.
     *
     * It is invalid to set this field if type is not "STRING" or "BYTES".
     * </pre>
     *
     * <code>int64 max_length = 7 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearMaxLength() {
      bitField0_ = (bitField0_ & ~0x00000020);
      maxLength_ = 0L;
      onChanged();
      return this;
    }

    private long precision_;

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     *
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     *
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     *
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     *
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     *
     * Acceptable values for precision and scale if both are specified:
     *
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     *
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     *
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     *
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The precision.
     */
    @java.lang.Override
    public long getPrecision() {
      return precision_;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     *
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     *
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     *
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     *
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     *
     * Acceptable values for precision and scale if both are specified:
     *
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     *
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     *
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     *
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The precision to set.
     * @return This builder for chaining.
     */
    public Builder setPrecision(long value) {

      precision_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) and scale
     * (maximum number of digits in the fractional part in base 10) constraints
     * for values of this field for NUMERIC or BIGNUMERIC.
     *
     * It is invalid to set precision or scale if type is not "NUMERIC" or
     * "BIGNUMERIC".
     *
     * If precision and scale are not specified, no value range constraint is
     * imposed on this field insofar as values are permitted by the type.
     *
     * Values of this NUMERIC or BIGNUMERIC field must be in this range when:
     *
     * * Precision (P) and scale (S) are specified:
     *   [-10^(P-S) + 10^(-S), 10^(P-S) - 10^(-S)]
     * * Precision (P) is specified but not scale (and thus scale is
     *   interpreted to be equal to zero):
     *   [-10^P + 1, 10^P - 1].
     *
     * Acceptable values for precision and scale if both are specified:
     *
     * * If type = "NUMERIC":
     *   1 &lt;= precision - scale &lt;= 29 and 0 &lt;= scale &lt;= 9.
     * * If type = "BIGNUMERIC":
     *   1 &lt;= precision - scale &lt;= 38 and 0 &lt;= scale &lt;= 38.
     *
     * Acceptable values for precision if only precision is specified but not
     * scale (and thus scale is interpreted to be equal to zero):
     *
     * * If type = "NUMERIC": 1 &lt;= precision &lt;= 29.
     * * If type = "BIGNUMERIC": 1 &lt;= precision &lt;= 38.
     *
     * If scale is specified but not precision, then it is invalid.
     * </pre>
     *
     * <code>int64 precision = 8 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearPrecision() {
      bitField0_ = (bitField0_ & ~0x00000040);
      precision_ = 0L;
      onChanged();
      return this;
    }

    private long scale_;

    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The scale.
     */
    @java.lang.Override
    public long getScale() {
      return scale_;
    }

    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The scale to set.
     * @return This builder for chaining.
     */
    public Builder setScale(long value) {

      scale_ = value;
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. See documentation for precision.
     * </pre>
     *
     * <code>int64 scale = 9 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearScale() {
      bitField0_ = (bitField0_ & ~0x00000080);
      scale_ = 0L;
      onChanged();
      return this;
    }

    private java.lang.Object defaultValueExpression_ = "";

    /**
     *
     *
     * <pre>
     * Optional. A SQL expression to specify the [default value]
     * (https://cloud.google.com/bigquery/docs/default-values) for this field.
     * </pre>
     *
     * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The defaultValueExpression.
     */
    public java.lang.String getDefaultValueExpression() {
      java.lang.Object ref = defaultValueExpression_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        defaultValueExpression_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A SQL expression to specify the [default value]
     * (https://cloud.google.com/bigquery/docs/default-values) for this field.
     * </pre>
     *
     * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return The bytes for defaultValueExpression.
     */
    public com.google.protobuf.ByteString getDefaultValueExpressionBytes() {
      java.lang.Object ref = defaultValueExpression_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        defaultValueExpression_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. A SQL expression to specify the [default value]
     * (https://cloud.google.com/bigquery/docs/default-values) for this field.
     * </pre>
     *
     * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The defaultValueExpression to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValueExpression(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      defaultValueExpression_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A SQL expression to specify the [default value]
     * (https://cloud.google.com/bigquery/docs/default-values) for this field.
     * </pre>
     *
     * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDefaultValueExpression() {
      defaultValueExpression_ = getDefaultInstance().getDefaultValueExpression();
      bitField0_ = (bitField0_ & ~0x00000100);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. A SQL expression to specify the [default value]
     * (https://cloud.google.com/bigquery/docs/default-values) for this field.
     * </pre>
     *
     * <code>string default_value_expression = 10 [(.google.api.field_behavior) = OPTIONAL];</code>
     *
     * @param value The bytes for defaultValueExpression to set.
     * @return This builder for chaining.
     */
    public Builder setDefaultValueExpressionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      defaultValueExpression_ = value;
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }

    private com.google.protobuf.Int64Value timestampPrecision_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        timestampPrecisionBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the timestampPrecision field is set.
     */
    public boolean hasTimestampPrecision() {
      return ((bitField0_ & 0x00000200) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The timestampPrecision.
     */
    public com.google.protobuf.Int64Value getTimestampPrecision() {
      if (timestampPrecisionBuilder_ == null) {
        return timestampPrecision_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : timestampPrecision_;
      } else {
        return timestampPrecisionBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTimestampPrecision(com.google.protobuf.Int64Value value) {
      if (timestampPrecisionBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        timestampPrecision_ = value;
      } else {
        timestampPrecisionBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setTimestampPrecision(com.google.protobuf.Int64Value.Builder builderForValue) {
      if (timestampPrecisionBuilder_ == null) {
        timestampPrecision_ = builderForValue.build();
      } else {
        timestampPrecisionBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeTimestampPrecision(com.google.protobuf.Int64Value value) {
      if (timestampPrecisionBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && timestampPrecision_ != null
            && timestampPrecision_ != com.google.protobuf.Int64Value.getDefaultInstance()) {
          getTimestampPrecisionBuilder().mergeFrom(value);
        } else {
          timestampPrecision_ = value;
        }
      } else {
        timestampPrecisionBuilder_.mergeFrom(value);
      }
      if (timestampPrecision_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearTimestampPrecision() {
      bitField0_ = (bitField0_ & ~0x00000200);
      timestampPrecision_ = null;
      if (timestampPrecisionBuilder_ != null) {
        timestampPrecisionBuilder_.dispose();
        timestampPrecisionBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64Value.Builder getTimestampPrecisionBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getTimestampPrecisionFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.protobuf.Int64ValueOrBuilder getTimestampPrecisionOrBuilder() {
      if (timestampPrecisionBuilder_ != null) {
        return timestampPrecisionBuilder_.getMessageOrBuilder();
      } else {
        return timestampPrecision_ == null
            ? com.google.protobuf.Int64Value.getDefaultInstance()
            : timestampPrecision_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. Precision (maximum number of total digits in base 10) for seconds
     * of TIMESTAMP type.
     *
     * Possible values include:
     *
     * * 6 (Default, for TIMESTAMP type with microsecond precision)
     * * 12 (For TIMESTAMP type with picosecond precision)
     * </pre>
     *
     * <code>
     * .google.protobuf.Int64Value timestamp_precision = 27 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.Int64Value,
            com.google.protobuf.Int64Value.Builder,
            com.google.protobuf.Int64ValueOrBuilder>
        getTimestampPrecisionFieldBuilder() {
      if (timestampPrecisionBuilder_ == null) {
        timestampPrecisionBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.Int64Value,
                com.google.protobuf.Int64Value.Builder,
                com.google.protobuf.Int64ValueOrBuilder>(
                getTimestampPrecision(), getParentForChildren(), isClean());
        timestampPrecision_ = null;
      }
      return timestampPrecisionBuilder_;
    }

    private com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        rangeElementType_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder>
        rangeElementTypeBuilder_;

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return Whether the rangeElementType field is set.
     */
    public boolean hasRangeElementType() {
      return ((bitField0_ & 0x00000400) != 0);
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     *
     * @return The rangeElementType.
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
        getRangeElementType() {
      if (rangeElementTypeBuilder_ == null) {
        return rangeElementType_ == null
            ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
                .getDefaultInstance()
            : rangeElementType_;
      } else {
        return rangeElementTypeBuilder_.getMessage();
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRangeElementType(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType value) {
      if (rangeElementTypeBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        rangeElementType_ = value;
      } else {
        rangeElementTypeBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder setRangeElementType(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder
            builderForValue) {
      if (rangeElementTypeBuilder_ == null) {
        rangeElementType_ = builderForValue.build();
      } else {
        rangeElementTypeBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000400;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder mergeRangeElementType(
        com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType value) {
      if (rangeElementTypeBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)
            && rangeElementType_ != null
            && rangeElementType_
                != com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
                    .getDefaultInstance()) {
          getRangeElementTypeBuilder().mergeFrom(value);
        } else {
          rangeElementType_ = value;
        }
      } else {
        rangeElementTypeBuilder_.mergeFrom(value);
      }
      if (rangeElementType_ != null) {
        bitField0_ |= 0x00000400;
        onChanged();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public Builder clearRangeElementType() {
      bitField0_ = (bitField0_ & ~0x00000400);
      rangeElementType_ = null;
      if (rangeElementTypeBuilder_ != null) {
        rangeElementTypeBuilder_.dispose();
        rangeElementTypeBuilder_ = null;
      }
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder
        getRangeElementTypeBuilder() {
      bitField0_ |= 0x00000400;
      onChanged();
      return getRangeElementTypeFieldBuilder().getBuilder();
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    public com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder
        getRangeElementTypeOrBuilder() {
      if (rangeElementTypeBuilder_ != null) {
        return rangeElementTypeBuilder_.getMessageOrBuilder();
      } else {
        return rangeElementType_ == null
            ? com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType
                .getDefaultInstance()
            : rangeElementType_;
      }
    }

    /**
     *
     *
     * <pre>
     * Optional. The subtype of the RANGE, if the type of this field is RANGE. If
     * the type is RANGE, this field is required. Possible values for the field
     * element type of a RANGE include:
     * * DATE
     * * DATETIME
     * * TIMESTAMP
     * </pre>
     *
     * <code>
     * .google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType range_element_type = 11 [(.google.api.field_behavior) = OPTIONAL];
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder,
            com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder>
        getRangeElementTypeFieldBuilder() {
      if (rangeElementTypeBuilder_ == null) {
        rangeElementTypeBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType,
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementType.Builder,
                com.google.cloud.bigquery.storage.v1.TableFieldSchema.FieldElementTypeOrBuilder>(
                getRangeElementType(), getParentForChildren(), isClean());
        rangeElementType_ = null;
      }
      return rangeElementTypeBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.storage.v1.TableFieldSchema)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.storage.v1.TableFieldSchema)
  private static final com.google.cloud.bigquery.storage.v1.TableFieldSchema DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.storage.v1.TableFieldSchema();
  }

  public static com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<TableFieldSchema> PARSER =
      new com.google.protobuf.AbstractParser<TableFieldSchema>() {
        @java.lang.Override
        public TableFieldSchema parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<TableFieldSchema> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<TableFieldSchema> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.storage.v1.TableFieldSchema getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
