/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ReservationGroupName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESERVATION_GROUP = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reservationGroups/{reservation_group}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reservationGroup;

    @Deprecated
    protected ReservationGroupName() {
        this.project = null;
        this.location = null;
        this.reservationGroup = null;
    }

    private ReservationGroupName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reservationGroup = (String)Preconditions.checkNotNull((Object)builder.getReservationGroup());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReservationGroup() {
        return this.reservationGroup;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ReservationGroupName of(String project, String location, String reservationGroup) {
        return ReservationGroupName.newBuilder().setProject(project).setLocation(location).setReservationGroup(reservationGroup).build();
    }

    public static String format(String project, String location, String reservationGroup) {
        return ReservationGroupName.newBuilder().setProject(project).setLocation(location).setReservationGroup(reservationGroup).build().toString();
    }

    public static ReservationGroupName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESERVATION_GROUP.validatedMatch(formattedString, "ReservationGroupName.parse: formattedString not in valid format");
        return ReservationGroupName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reservation_group"));
    }

    public static List<ReservationGroupName> parseList(List<String> formattedStrings) {
        ArrayList<ReservationGroupName> list = new ArrayList<ReservationGroupName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReservationGroupName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReservationGroupName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReservationGroupName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESERVATION_GROUP.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReservationGroupName reservationGroupName = this;
            synchronized (reservationGroupName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reservationGroup != null) {
                        fieldMapBuilder.put((Object)"reservation_group", (Object)this.reservationGroup);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESERVATION_GROUP.instantiate(new String[]{"project", this.project, "location", this.location, "reservation_group", this.reservationGroup});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ReservationGroupName that = (ReservationGroupName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reservationGroup, that.reservationGroup);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.reservationGroup);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reservationGroup;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReservationGroup() {
            return this.reservationGroup;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReservationGroup(String reservationGroup) {
            this.reservationGroup = reservationGroup;
            return this;
        }

        private Builder(ReservationGroupName reservationGroupName) {
            this.project = reservationGroupName.project;
            this.location = reservationGroupName.location;
            this.reservationGroup = reservationGroupName.reservationGroup;
        }

        public ReservationGroupName build() {
            return new ReservationGroupName(this);
        }
    }
}

