/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class AssignmentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_RESERVATION_ASSIGNMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reservations/{reservation}/assignments/{assignment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reservation;
    private final String assignment;

    @Deprecated
    protected AssignmentName() {
        this.project = null;
        this.location = null;
        this.reservation = null;
        this.assignment = null;
    }

    private AssignmentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reservation = (String)Preconditions.checkNotNull((Object)builder.getReservation());
        this.assignment = (String)Preconditions.checkNotNull((Object)builder.getAssignment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReservation() {
        return this.reservation;
    }

    public String getAssignment() {
        return this.assignment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static AssignmentName of(String project, String location, String reservation, String assignment) {
        return AssignmentName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).setAssignment(assignment).build();
    }

    public static String format(String project, String location, String reservation, String assignment) {
        return AssignmentName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).setAssignment(assignment).build().toString();
    }

    public static AssignmentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_RESERVATION_ASSIGNMENT.validatedMatch(formattedString, "AssignmentName.parse: formattedString not in valid format");
        return AssignmentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reservation"), (String)matchMap.get("assignment"));
    }

    public static List<AssignmentName> parseList(List<String> formattedStrings) {
        ArrayList<AssignmentName> list = new ArrayList<AssignmentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AssignmentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AssignmentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AssignmentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_RESERVATION_ASSIGNMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AssignmentName assignmentName = this;
            synchronized (assignmentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.reservation != null) {
                        fieldMapBuilder.put((Object)"reservation", (Object)this.reservation);
                    }
                    if (this.assignment != null) {
                        fieldMapBuilder.put((Object)"assignment", (Object)this.assignment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_RESERVATION_ASSIGNMENT.instantiate(new String[]{"project", this.project, "location", this.location, "reservation", this.reservation, "assignment", this.assignment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            AssignmentName that = (AssignmentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.reservation, that.reservation) && Objects.equals(this.assignment, that.assignment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.reservation);
        h *= 1000003;
        return h ^= Objects.hashCode(this.assignment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String reservation;
        private String assignment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReservation() {
            return this.reservation;
        }

        public String getAssignment() {
            return this.assignment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        public Builder setAssignment(String assignment) {
            this.assignment = assignment;
            return this;
        }

        private Builder(AssignmentName assignmentName) {
            this.project = assignmentName.project;
            this.location = assignmentName.location;
            this.reservation = assignmentName.reservation;
            this.assignment = assignmentName.assignment;
        }

        public AssignmentName build() {
            return new AssignmentName(this);
        }
    }
}

