/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.reservation.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ReservationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/reservations/{reservation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String reservation;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getReservation() {
        return this.reservation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ReservationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.reservation = (String)Preconditions.checkNotNull((Object)builder.getReservation());
    }

    public static ReservationName of(String project, String location, String reservation) {
        return ReservationName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).build();
    }

    public static String format(String project, String location, String reservation) {
        return ReservationName.newBuilder().setProject(project).setLocation(location).setReservation(reservation).build().toString();
    }

    public static ReservationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ReservationName.parse: formattedString not in valid format");
        return ReservationName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("reservation"));
    }

    public static List<ReservationName> parseList(List<String> formattedStrings) {
        ArrayList<ReservationName> list = new ArrayList<ReservationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ReservationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ReservationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ReservationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ReservationName reservationName = this;
            synchronized (reservationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"reservation", (Object)this.reservation);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "reservation", this.reservation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ReservationName) {
            ReservationName that = (ReservationName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.reservation.equals(that.reservation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.reservation.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String reservation;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getReservation() {
            return this.reservation;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setReservation(String reservation) {
            this.reservation = reservation;
            return this;
        }

        private Builder() {
        }

        private Builder(ReservationName reservationName) {
            this.project = reservationName.project;
            this.location = reservationName.location;
            this.reservation = reservationName.reservation;
        }

        public ReservationName build() {
            return new ReservationName(this);
        }
    }
}

