/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

// Protobuf Java Version: 3.25.8
package com.google.cloud.bigquery.datatransfer.v1;

public interface ListTransferLogsRequestOrBuilder
    extends
    // @@protoc_insertion_point(interface_extends:google.cloud.bigquery.datatransfer.v1.ListTransferLogsRequest)
    com.google.protobuf.MessageOrBuilder {

  /**
   *
   *
   * <pre>
   * Required. Transfer run name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The parent.
   */
  java.lang.String getParent();

  /**
   *
   *
   * <pre>
   * Required. Transfer run name in the form:
   * `projects/{project_id}/transferConfigs/{config_id}/runs/{run_id}` or
   * `projects/{project_id}/locations/{location_id}/transferConfigs/{config_id}/runs/{run_id}`
   * </pre>
   *
   * <code>
   * string parent = 1 [(.google.api.field_behavior) = REQUIRED, (.google.api.resource_reference) = { ... }
   * </code>
   *
   * @return The bytes for parent.
   */
  com.google.protobuf.ByteString getParentBytes();

  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferLogsRequest` list results. For multiple-page
   * results, `ListTransferLogsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The pageToken.
   */
  java.lang.String getPageToken();

  /**
   *
   *
   * <pre>
   * Pagination token, which can be used to request a specific page
   * of `ListTransferLogsRequest` list results. For multiple-page
   * results, `ListTransferLogsResponse` outputs
   * a `next_page` token, which can be used as the
   * `page_token` value to request the next page of list results.
   * </pre>
   *
   * <code>string page_token = 4;</code>
   *
   * @return The bytes for pageToken.
   */
  com.google.protobuf.ByteString getPageTokenBytes();

  /**
   *
   *
   * <pre>
   * Page size. The default page size is the maximum value of 1000 results.
   * </pre>
   *
   * <code>int32 page_size = 5;</code>
   *
   * @return The pageSize.
   */
  int getPageSize();

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return A list containing the messageTypes.
   */
  java.util.List<com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity>
      getMessageTypesList();

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return The count of messageTypes.
   */
  int getMessageTypesCount();

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @param index The index of the element to return.
   * @return The messageTypes at the given index.
   */
  com.google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity getMessageTypes(
      int index);

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @return A list containing the enum numeric values on the wire for messageTypes.
   */
  java.util.List<java.lang.Integer> getMessageTypesValueList();

  /**
   *
   *
   * <pre>
   * Message types to return. If not populated - INFO, WARNING and ERROR
   * messages are returned.
   * </pre>
   *
   * <code>
   * repeated .google.cloud.bigquery.datatransfer.v1.TransferMessage.MessageSeverity message_types = 6;
   * </code>
   *
   * @param index The index of the value to return.
   * @return The enum numeric value on the wire of messageTypes at the given index.
   */
  int getMessageTypesValue(int index);
}
