/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/transfer.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * V2 options customizing different types of data transfer schedule.
 * This field supports existing time-based and manual transfer schedule. Also
 * supports Event-Driven transfer schedule. ScheduleOptionsV2 cannot be used
 * together with ScheduleOptions/Schedule.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2}
 */
public final class ScheduleOptionsV2 extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2)
    ScheduleOptionsV2OrBuilder {
  private static final long serialVersionUID = 0L;
  // Use ScheduleOptionsV2.newBuilder() to construct.
  private ScheduleOptionsV2(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ScheduleOptionsV2() {}

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ScheduleOptionsV2();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ScheduleOptionsV2_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.TransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_ScheduleOptionsV2_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.class,
            com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.Builder.class);
  }

  private int scheduleCase_ = 0;

  @SuppressWarnings("serial")
  private java.lang.Object schedule_;

  public enum ScheduleCase
      implements
          com.google.protobuf.Internal.EnumLite,
          com.google.protobuf.AbstractMessage.InternalOneOfEnum {
    TIME_BASED_SCHEDULE(1),
    MANUAL_SCHEDULE(2),
    EVENT_DRIVEN_SCHEDULE(3),
    SCHEDULE_NOT_SET(0);
    private final int value;

    private ScheduleCase(int value) {
      this.value = value;
    }
    /**
     * @param value The number of the enum to look for.
     * @return The enum associated with the given number.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static ScheduleCase valueOf(int value) {
      return forNumber(value);
    }

    public static ScheduleCase forNumber(int value) {
      switch (value) {
        case 1:
          return TIME_BASED_SCHEDULE;
        case 2:
          return MANUAL_SCHEDULE;
        case 3:
          return EVENT_DRIVEN_SCHEDULE;
        case 0:
          return SCHEDULE_NOT_SET;
        default:
          return null;
      }
    }

    public int getNumber() {
      return this.value;
    }
  };

  public ScheduleCase getScheduleCase() {
    return ScheduleCase.forNumber(scheduleCase_);
  }

  public static final int TIME_BASED_SCHEDULE_FIELD_NUMBER = 1;
  /**
   *
   *
   * <pre>
   * Time based transfer schedule options. This is the default schedule
   * option.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;</code>
   *
   * @return Whether the timeBasedSchedule field is set.
   */
  @java.lang.Override
  public boolean hasTimeBasedSchedule() {
    return scheduleCase_ == 1;
  }
  /**
   *
   *
   * <pre>
   * Time based transfer schedule options. This is the default schedule
   * option.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;</code>
   *
   * @return The timeBasedSchedule.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule getTimeBasedSchedule() {
    if (scheduleCase_ == 1) {
      return (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Time based transfer schedule options. This is the default schedule
   * option.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.TimeBasedScheduleOrBuilder
      getTimeBasedScheduleOrBuilder() {
    if (scheduleCase_ == 1) {
      return (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
  }

  public static final int MANUAL_SCHEDULE_FIELD_NUMBER = 2;
  /**
   *
   *
   * <pre>
   * Manual transfer schedule. If set, the transfer run will not be
   * auto-scheduled by the system, unless the client invokes
   * StartManualTransferRuns.  This is equivalent to
   * disable_auto_scheduling = true.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
   *
   * @return Whether the manualSchedule field is set.
   */
  @java.lang.Override
  public boolean hasManualSchedule() {
    return scheduleCase_ == 2;
  }
  /**
   *
   *
   * <pre>
   * Manual transfer schedule. If set, the transfer run will not be
   * auto-scheduled by the system, unless the client invokes
   * StartManualTransferRuns.  This is equivalent to
   * disable_auto_scheduling = true.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
   *
   * @return The manualSchedule.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ManualSchedule getManualSchedule() {
    if (scheduleCase_ == 2) {
      return (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Manual transfer schedule. If set, the transfer run will not be
   * auto-scheduled by the system, unless the client invokes
   * StartManualTransferRuns.  This is equivalent to
   * disable_auto_scheduling = true.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ManualScheduleOrBuilder
      getManualScheduleOrBuilder() {
    if (scheduleCase_ == 2) {
      return (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
  }

  public static final int EVENT_DRIVEN_SCHEDULE_FIELD_NUMBER = 3;
  /**
   *
   *
   * <pre>
   * Event driven transfer schedule options. If set, the transfer will be
   * scheduled upon events arrial.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
   * </code>
   *
   * @return Whether the eventDrivenSchedule field is set.
   */
  @java.lang.Override
  public boolean hasEventDrivenSchedule() {
    return scheduleCase_ == 3;
  }
  /**
   *
   *
   * <pre>
   * Event driven transfer schedule options. If set, the transfer will be
   * scheduled upon events arrial.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
   * </code>
   *
   * @return The eventDrivenSchedule.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule getEventDrivenSchedule() {
    if (scheduleCase_ == 3) {
      return (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
  }
  /**
   *
   *
   * <pre>
   * Event driven transfer schedule options. If set, the transfer will be
   * scheduled upon events arrial.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
   * </code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.EventDrivenScheduleOrBuilder
      getEventDrivenScheduleOrBuilder() {
    if (scheduleCase_ == 3) {
      return (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_;
    }
    return com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (scheduleCase_ == 1) {
      output.writeMessage(
          1, (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_);
    }
    if (scheduleCase_ == 2) {
      output.writeMessage(2, (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_);
    }
    if (scheduleCase_ == 3) {
      output.writeMessage(
          3, (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (scheduleCase_ == 1) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              1, (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_);
    }
    if (scheduleCase_ == 2) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              2, (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_);
    }
    if (scheduleCase_ == 3) {
      size +=
          com.google.protobuf.CodedOutputStream.computeMessageSize(
              3, (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 other =
        (com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2) obj;

    if (!getScheduleCase().equals(other.getScheduleCase())) return false;
    switch (scheduleCase_) {
      case 1:
        if (!getTimeBasedSchedule().equals(other.getTimeBasedSchedule())) return false;
        break;
      case 2:
        if (!getManualSchedule().equals(other.getManualSchedule())) return false;
        break;
      case 3:
        if (!getEventDrivenSchedule().equals(other.getEventDrivenSchedule())) return false;
        break;
      case 0:
      default:
    }
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    switch (scheduleCase_) {
      case 1:
        hash = (37 * hash) + TIME_BASED_SCHEDULE_FIELD_NUMBER;
        hash = (53 * hash) + getTimeBasedSchedule().hashCode();
        break;
      case 2:
        hash = (37 * hash) + MANUAL_SCHEDULE_FIELD_NUMBER;
        hash = (53 * hash) + getManualSchedule().hashCode();
        break;
      case 3:
        hash = (37 * hash) + EVENT_DRIVEN_SCHEDULE_FIELD_NUMBER;
        hash = (53 * hash) + getEventDrivenSchedule().hashCode();
        break;
      case 0:
      default:
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * V2 options customizing different types of data transfer schedule.
   * This field supports existing time-based and manual transfer schedule. Also
   * supports Event-Driven transfer schedule. ScheduleOptionsV2 cannot be used
   * together with ScheduleOptions/Schedule.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2)
      com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2OrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ScheduleOptionsV2_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ScheduleOptionsV2_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.class,
              com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      if (timeBasedScheduleBuilder_ != null) {
        timeBasedScheduleBuilder_.clear();
      }
      if (manualScheduleBuilder_ != null) {
        manualScheduleBuilder_.clear();
      }
      if (eventDrivenScheduleBuilder_ != null) {
        eventDrivenScheduleBuilder_.clear();
      }
      scheduleCase_ = 0;
      schedule_ = null;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.TransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_ScheduleOptionsV2_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 build() {
      com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 result =
          new com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2(this);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      buildPartialOneofs(result);
      onBuilt();
      return result;
    }

    private void buildPartial0(com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 result) {
      int from_bitField0_ = bitField0_;
    }

    private void buildPartialOneofs(
        com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 result) {
      result.scheduleCase_ = scheduleCase_;
      result.schedule_ = this.schedule_;
      if (scheduleCase_ == 1 && timeBasedScheduleBuilder_ != null) {
        result.schedule_ = timeBasedScheduleBuilder_.build();
      }
      if (scheduleCase_ == 2 && manualScheduleBuilder_ != null) {
        result.schedule_ = manualScheduleBuilder_.build();
      }
      if (scheduleCase_ == 3 && eventDrivenScheduleBuilder_ != null) {
        result.schedule_ = eventDrivenScheduleBuilder_.build();
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 other) {
      if (other == com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2.getDefaultInstance())
        return this;
      switch (other.getScheduleCase()) {
        case TIME_BASED_SCHEDULE:
          {
            mergeTimeBasedSchedule(other.getTimeBasedSchedule());
            break;
          }
        case MANUAL_SCHEDULE:
          {
            mergeManualSchedule(other.getManualSchedule());
            break;
          }
        case EVENT_DRIVEN_SCHEDULE:
          {
            mergeEventDrivenSchedule(other.getEventDrivenSchedule());
            break;
          }
        case SCHEDULE_NOT_SET:
          {
            break;
          }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                input.readMessage(
                    getTimeBasedScheduleFieldBuilder().getBuilder(), extensionRegistry);
                scheduleCase_ = 1;
                break;
              } // case 10
            case 18:
              {
                input.readMessage(getManualScheduleFieldBuilder().getBuilder(), extensionRegistry);
                scheduleCase_ = 2;
                break;
              } // case 18
            case 26:
              {
                input.readMessage(
                    getEventDrivenScheduleFieldBuilder().getBuilder(), extensionRegistry);
                scheduleCase_ = 3;
                break;
              } // case 26
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int scheduleCase_ = 0;
    private java.lang.Object schedule_;

    public ScheduleCase getScheduleCase() {
      return ScheduleCase.forNumber(scheduleCase_);
    }

    public Builder clearSchedule() {
      scheduleCase_ = 0;
      schedule_ = null;
      onChanged();
      return this;
    }

    private int bitField0_;

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule,
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedScheduleOrBuilder>
        timeBasedScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     *
     * @return Whether the timeBasedSchedule field is set.
     */
    @java.lang.Override
    public boolean hasTimeBasedSchedule() {
      return scheduleCase_ == 1;
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     *
     * @return The timeBasedSchedule.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule getTimeBasedSchedule() {
      if (timeBasedScheduleBuilder_ == null) {
        if (scheduleCase_ == 1) {
          return (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
      } else {
        if (scheduleCase_ == 1) {
          return timeBasedScheduleBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    public Builder setTimeBasedSchedule(
        com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule value) {
      if (timeBasedScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schedule_ = value;
        onChanged();
      } else {
        timeBasedScheduleBuilder_.setMessage(value);
      }
      scheduleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    public Builder setTimeBasedSchedule(
        com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.Builder builderForValue) {
      if (timeBasedScheduleBuilder_ == null) {
        schedule_ = builderForValue.build();
        onChanged();
      } else {
        timeBasedScheduleBuilder_.setMessage(builderForValue.build());
      }
      scheduleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    public Builder mergeTimeBasedSchedule(
        com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule value) {
      if (timeBasedScheduleBuilder_ == null) {
        if (scheduleCase_ == 1
            && schedule_
                != com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule
                    .getDefaultInstance()) {
          schedule_ =
              com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.newBuilder(
                      (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schedule_ = value;
        }
        onChanged();
      } else {
        if (scheduleCase_ == 1) {
          timeBasedScheduleBuilder_.mergeFrom(value);
        } else {
          timeBasedScheduleBuilder_.setMessage(value);
        }
      }
      scheduleCase_ = 1;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    public Builder clearTimeBasedSchedule() {
      if (timeBasedScheduleBuilder_ == null) {
        if (scheduleCase_ == 1) {
          scheduleCase_ = 0;
          schedule_ = null;
          onChanged();
        }
      } else {
        if (scheduleCase_ == 1) {
          scheduleCase_ = 0;
          schedule_ = null;
        }
        timeBasedScheduleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.Builder
        getTimeBasedScheduleBuilder() {
      return getTimeBasedScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.TimeBasedScheduleOrBuilder
        getTimeBasedScheduleOrBuilder() {
      if ((scheduleCase_ == 1) && (timeBasedScheduleBuilder_ != null)) {
        return timeBasedScheduleBuilder_.getMessageOrBuilder();
      } else {
        if (scheduleCase_ == 1) {
          return (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Time based transfer schedule options. This is the default schedule
     * option.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule time_based_schedule = 1;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule,
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.TimeBasedScheduleOrBuilder>
        getTimeBasedScheduleFieldBuilder() {
      if (timeBasedScheduleBuilder_ == null) {
        if (!(scheduleCase_ == 1)) {
          schedule_ =
              com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.getDefaultInstance();
        }
        timeBasedScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule,
                com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule.Builder,
                com.google.cloud.bigquery.datatransfer.v1.TimeBasedScheduleOrBuilder>(
                (com.google.cloud.bigquery.datatransfer.v1.TimeBasedSchedule) schedule_,
                getParentForChildren(),
                isClean());
        schedule_ = null;
      }
      scheduleCase_ = 1;
      onChanged();
      return timeBasedScheduleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ManualSchedule,
            com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ManualScheduleOrBuilder>
        manualScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     *
     * @return Whether the manualSchedule field is set.
     */
    @java.lang.Override
    public boolean hasManualSchedule() {
      return scheduleCase_ == 2;
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     *
     * @return The manualSchedule.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ManualSchedule getManualSchedule() {
      if (manualScheduleBuilder_ == null) {
        if (scheduleCase_ == 2) {
          return (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
      } else {
        if (scheduleCase_ == 2) {
          return manualScheduleBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    public Builder setManualSchedule(
        com.google.cloud.bigquery.datatransfer.v1.ManualSchedule value) {
      if (manualScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schedule_ = value;
        onChanged();
      } else {
        manualScheduleBuilder_.setMessage(value);
      }
      scheduleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    public Builder setManualSchedule(
        com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.Builder builderForValue) {
      if (manualScheduleBuilder_ == null) {
        schedule_ = builderForValue.build();
        onChanged();
      } else {
        manualScheduleBuilder_.setMessage(builderForValue.build());
      }
      scheduleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    public Builder mergeManualSchedule(
        com.google.cloud.bigquery.datatransfer.v1.ManualSchedule value) {
      if (manualScheduleBuilder_ == null) {
        if (scheduleCase_ == 2
            && schedule_
                != com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance()) {
          schedule_ =
              com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.newBuilder(
                      (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schedule_ = value;
        }
        onChanged();
      } else {
        if (scheduleCase_ == 2) {
          manualScheduleBuilder_.mergeFrom(value);
        } else {
          manualScheduleBuilder_.setMessage(value);
        }
      }
      scheduleCase_ = 2;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    public Builder clearManualSchedule() {
      if (manualScheduleBuilder_ == null) {
        if (scheduleCase_ == 2) {
          scheduleCase_ = 0;
          schedule_ = null;
          onChanged();
        }
      } else {
        if (scheduleCase_ == 2) {
          scheduleCase_ = 0;
          schedule_ = null;
        }
        manualScheduleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.Builder
        getManualScheduleBuilder() {
      return getManualScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.ManualScheduleOrBuilder
        getManualScheduleOrBuilder() {
      if ((scheduleCase_ == 2) && (manualScheduleBuilder_ != null)) {
        return manualScheduleBuilder_.getMessageOrBuilder();
      } else {
        if (scheduleCase_ == 2) {
          return (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Manual transfer schedule. If set, the transfer run will not be
     * auto-scheduled by the system, unless the client invokes
     * StartManualTransferRuns.  This is equivalent to
     * disable_auto_scheduling = true.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.ManualSchedule manual_schedule = 2;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.ManualSchedule,
            com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.ManualScheduleOrBuilder>
        getManualScheduleFieldBuilder() {
      if (manualScheduleBuilder_ == null) {
        if (!(scheduleCase_ == 2)) {
          schedule_ = com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.getDefaultInstance();
        }
        manualScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.ManualSchedule,
                com.google.cloud.bigquery.datatransfer.v1.ManualSchedule.Builder,
                com.google.cloud.bigquery.datatransfer.v1.ManualScheduleOrBuilder>(
                (com.google.cloud.bigquery.datatransfer.v1.ManualSchedule) schedule_,
                getParentForChildren(),
                isClean());
        schedule_ = null;
      }
      scheduleCase_ = 2;
      onChanged();
      return manualScheduleBuilder_;
    }

    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule,
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenScheduleOrBuilder>
        eventDrivenScheduleBuilder_;
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     *
     * @return Whether the eventDrivenSchedule field is set.
     */
    @java.lang.Override
    public boolean hasEventDrivenSchedule() {
      return scheduleCase_ == 3;
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     *
     * @return The eventDrivenSchedule.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule getEventDrivenSchedule() {
      if (eventDrivenScheduleBuilder_ == null) {
        if (scheduleCase_ == 3) {
          return (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
      } else {
        if (scheduleCase_ == 3) {
          return eventDrivenScheduleBuilder_.getMessage();
        }
        return com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    public Builder setEventDrivenSchedule(
        com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule value) {
      if (eventDrivenScheduleBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        schedule_ = value;
        onChanged();
      } else {
        eventDrivenScheduleBuilder_.setMessage(value);
      }
      scheduleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    public Builder setEventDrivenSchedule(
        com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.Builder builderForValue) {
      if (eventDrivenScheduleBuilder_ == null) {
        schedule_ = builderForValue.build();
        onChanged();
      } else {
        eventDrivenScheduleBuilder_.setMessage(builderForValue.build());
      }
      scheduleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    public Builder mergeEventDrivenSchedule(
        com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule value) {
      if (eventDrivenScheduleBuilder_ == null) {
        if (scheduleCase_ == 3
            && schedule_
                != com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule
                    .getDefaultInstance()) {
          schedule_ =
              com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.newBuilder(
                      (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_)
                  .mergeFrom(value)
                  .buildPartial();
        } else {
          schedule_ = value;
        }
        onChanged();
      } else {
        if (scheduleCase_ == 3) {
          eventDrivenScheduleBuilder_.mergeFrom(value);
        } else {
          eventDrivenScheduleBuilder_.setMessage(value);
        }
      }
      scheduleCase_ = 3;
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    public Builder clearEventDrivenSchedule() {
      if (eventDrivenScheduleBuilder_ == null) {
        if (scheduleCase_ == 3) {
          scheduleCase_ = 0;
          schedule_ = null;
          onChanged();
        }
      } else {
        if (scheduleCase_ == 3) {
          scheduleCase_ = 0;
          schedule_ = null;
        }
        eventDrivenScheduleBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.Builder
        getEventDrivenScheduleBuilder() {
      return getEventDrivenScheduleFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.EventDrivenScheduleOrBuilder
        getEventDrivenScheduleOrBuilder() {
      if ((scheduleCase_ == 3) && (eventDrivenScheduleBuilder_ != null)) {
        return eventDrivenScheduleBuilder_.getMessageOrBuilder();
      } else {
        if (scheduleCase_ == 3) {
          return (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_;
        }
        return com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
      }
    }
    /**
     *
     *
     * <pre>
     * Event driven transfer schedule options. If set, the transfer will be
     * scheduled upon events arrial.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule event_driven_schedule = 3;
     * </code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule,
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.Builder,
            com.google.cloud.bigquery.datatransfer.v1.EventDrivenScheduleOrBuilder>
        getEventDrivenScheduleFieldBuilder() {
      if (eventDrivenScheduleBuilder_ == null) {
        if (!(scheduleCase_ == 3)) {
          schedule_ =
              com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.getDefaultInstance();
        }
        eventDrivenScheduleBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule,
                com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule.Builder,
                com.google.cloud.bigquery.datatransfer.v1.EventDrivenScheduleOrBuilder>(
                (com.google.cloud.bigquery.datatransfer.v1.EventDrivenSchedule) schedule_,
                getParentForChildren(),
                isClean());
        schedule_ = null;
      }
      scheduleCase_ = 3;
      onChanged();
      return eventDrivenScheduleBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2)
  private static final com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ScheduleOptionsV2> PARSER =
      new com.google.protobuf.AbstractParser<ScheduleOptionsV2>() {
        @java.lang.Override
        public ScheduleOptionsV2 parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ScheduleOptionsV2> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ScheduleOptionsV2> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.ScheduleOptionsV2 getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
