/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/bigquery/datatransfer/v1/datatransfer.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.bigquery.datatransfer.v1;

/**
 *
 *
 * <pre>
 * A parameter used to define custom fields in a data source definition.
 * </pre>
 *
 * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSourceParameter}
 */
public final class DataSourceParameter extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.bigquery.datatransfer.v1.DataSourceParameter)
    DataSourceParameterOrBuilder {
  private static final long serialVersionUID = 0L;
  // Use DataSourceParameter.newBuilder() to construct.
  private DataSourceParameter(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private DataSourceParameter() {
    paramId_ = "";
    displayName_ = "";
    description_ = "";
    type_ = 0;
    validationRegex_ = "";
    allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
    fields_ = java.util.Collections.emptyList();
    validationDescription_ = "";
    validationHelpUrl_ = "";
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new DataSourceParameter();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceParameter_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
        .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceParameter_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.class,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder.class);
  }

  /**
   *
   *
   * <pre>
   * Parameter type.
   * </pre>
   *
   * Protobuf enum {@code google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type}
   */
  public enum Type implements com.google.protobuf.ProtocolMessageEnum {
    /**
     *
     *
     * <pre>
     * Type unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    TYPE_UNSPECIFIED(0),
    /**
     *
     *
     * <pre>
     * String parameter.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    STRING(1),
    /**
     *
     *
     * <pre>
     * Integer parameter (64-bits).
     * Will be serialized to json as string.
     * </pre>
     *
     * <code>INTEGER = 2;</code>
     */
    INTEGER(2),
    /**
     *
     *
     * <pre>
     * Double precision floating point parameter.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    DOUBLE(3),
    /**
     *
     *
     * <pre>
     * Boolean parameter.
     * </pre>
     *
     * <code>BOOLEAN = 4;</code>
     */
    BOOLEAN(4),
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>RECORD = 5;</code>
     */
    RECORD(5),
    /**
     *
     *
     * <pre>
     * Page ID for a Google+ Page.
     * </pre>
     *
     * <code>PLUS_PAGE = 6;</code>
     */
    PLUS_PAGE(6),
    /**
     *
     *
     * <pre>
     * List of strings parameter.
     * </pre>
     *
     * <code>LIST = 7;</code>
     */
    LIST(7),
    UNRECOGNIZED(-1),
    ;

    /**
     *
     *
     * <pre>
     * Type unspecified.
     * </pre>
     *
     * <code>TYPE_UNSPECIFIED = 0;</code>
     */
    public static final int TYPE_UNSPECIFIED_VALUE = 0;
    /**
     *
     *
     * <pre>
     * String parameter.
     * </pre>
     *
     * <code>STRING = 1;</code>
     */
    public static final int STRING_VALUE = 1;
    /**
     *
     *
     * <pre>
     * Integer parameter (64-bits).
     * Will be serialized to json as string.
     * </pre>
     *
     * <code>INTEGER = 2;</code>
     */
    public static final int INTEGER_VALUE = 2;
    /**
     *
     *
     * <pre>
     * Double precision floating point parameter.
     * </pre>
     *
     * <code>DOUBLE = 3;</code>
     */
    public static final int DOUBLE_VALUE = 3;
    /**
     *
     *
     * <pre>
     * Boolean parameter.
     * </pre>
     *
     * <code>BOOLEAN = 4;</code>
     */
    public static final int BOOLEAN_VALUE = 4;
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>RECORD = 5;</code>
     */
    public static final int RECORD_VALUE = 5;
    /**
     *
     *
     * <pre>
     * Page ID for a Google+ Page.
     * </pre>
     *
     * <code>PLUS_PAGE = 6;</code>
     */
    public static final int PLUS_PAGE_VALUE = 6;
    /**
     *
     *
     * <pre>
     * List of strings parameter.
     * </pre>
     *
     * <code>LIST = 7;</code>
     */
    public static final int LIST_VALUE = 7;

    public final int getNumber() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalArgumentException(
            "Can't get the number of an unknown enum value.");
      }
      return value;
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     * @deprecated Use {@link #forNumber(int)} instead.
     */
    @java.lang.Deprecated
    public static Type valueOf(int value) {
      return forNumber(value);
    }

    /**
     * @param value The numeric wire value of the corresponding enum entry.
     * @return The enum associated with the given numeric wire value.
     */
    public static Type forNumber(int value) {
      switch (value) {
        case 0:
          return TYPE_UNSPECIFIED;
        case 1:
          return STRING;
        case 2:
          return INTEGER;
        case 3:
          return DOUBLE;
        case 4:
          return BOOLEAN;
        case 5:
          return RECORD;
        case 6:
          return PLUS_PAGE;
        case 7:
          return LIST;
        default:
          return null;
      }
    }

    public static com.google.protobuf.Internal.EnumLiteMap<Type> internalGetValueMap() {
      return internalValueMap;
    }

    private static final com.google.protobuf.Internal.EnumLiteMap<Type> internalValueMap =
        new com.google.protobuf.Internal.EnumLiteMap<Type>() {
          public Type findValueByNumber(int number) {
            return Type.forNumber(number);
          }
        };

    public final com.google.protobuf.Descriptors.EnumValueDescriptor getValueDescriptor() {
      if (this == UNRECOGNIZED) {
        throw new java.lang.IllegalStateException(
            "Can't get the descriptor of an unrecognized enum value.");
      }
      return getDescriptor().getValues().get(ordinal());
    }

    public final com.google.protobuf.Descriptors.EnumDescriptor getDescriptorForType() {
      return getDescriptor();
    }

    public static final com.google.protobuf.Descriptors.EnumDescriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDescriptor()
          .getEnumTypes()
          .get(0);
    }

    private static final Type[] VALUES = values();

    public static Type valueOf(com.google.protobuf.Descriptors.EnumValueDescriptor desc) {
      if (desc.getType() != getDescriptor()) {
        throw new java.lang.IllegalArgumentException("EnumValueDescriptor is not for this type.");
      }
      if (desc.getIndex() == -1) {
        return UNRECOGNIZED;
      }
      return VALUES[desc.getIndex()];
    }

    private final int value;

    private Type(int value) {
      this.value = value;
    }

    // @@protoc_insertion_point(enum_scope:google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type)
  }

  private int bitField0_;
  public static final int PARAM_ID_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object paramId_ = "";
  /**
   *
   *
   * <pre>
   * Parameter identifier.
   * </pre>
   *
   * <code>string param_id = 1;</code>
   *
   * @return The paramId.
   */
  @java.lang.Override
  public java.lang.String getParamId() {
    java.lang.Object ref = paramId_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      paramId_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parameter identifier.
   * </pre>
   *
   * <code>string param_id = 1;</code>
   *
   * @return The bytes for paramId.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getParamIdBytes() {
    java.lang.Object ref = paramId_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      paramId_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DISPLAY_NAME_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private volatile java.lang.Object displayName_ = "";
  /**
   *
   *
   * <pre>
   * Parameter display name in the user interface.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The displayName.
   */
  @java.lang.Override
  public java.lang.String getDisplayName() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      displayName_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parameter display name in the user interface.
   * </pre>
   *
   * <code>string display_name = 2;</code>
   *
   * @return The bytes for displayName.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDisplayNameBytes() {
    java.lang.Object ref = displayName_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      displayName_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int DESCRIPTION_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private volatile java.lang.Object description_ = "";
  /**
   *
   *
   * <pre>
   * Parameter description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The description.
   */
  @java.lang.Override
  public java.lang.String getDescription() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      description_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Parameter description.
   * </pre>
   *
   * <code>string description = 3;</code>
   *
   * @return The bytes for description.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getDescriptionBytes() {
    java.lang.Object ref = description_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      description_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int TYPE_FIELD_NUMBER = 4;
  private int type_ = 0;
  /**
   *
   *
   * <pre>
   * Parameter type.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
   *
   * @return The enum numeric value on the wire for type.
   */
  @java.lang.Override
  public int getTypeValue() {
    return type_;
  }
  /**
   *
   *
   * <pre>
   * Parameter type.
   * </pre>
   *
   * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
   *
   * @return The type.
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type getType() {
    com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type result =
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.forNumber(type_);
    return result == null
        ? com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.UNRECOGNIZED
        : result;
  }

  public static final int REQUIRED_FIELD_NUMBER = 5;
  private boolean required_ = false;
  /**
   *
   *
   * <pre>
   * Is parameter required.
   * </pre>
   *
   * <code>bool required = 5;</code>
   *
   * @return The required.
   */
  @java.lang.Override
  public boolean getRequired() {
    return required_;
  }

  public static final int REPEATED_FIELD_NUMBER = 6;
  private boolean repeated_ = false;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>bool repeated = 6;</code>
   *
   * @return The repeated.
   */
  @java.lang.Override
  public boolean getRepeated() {
    return repeated_;
  }

  public static final int VALIDATION_REGEX_FIELD_NUMBER = 7;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationRegex_ = "";
  /**
   *
   *
   * <pre>
   * Regular expression which can be used for parameter validation.
   * </pre>
   *
   * <code>string validation_regex = 7;</code>
   *
   * @return The validationRegex.
   */
  @java.lang.Override
  public java.lang.String getValidationRegex() {
    java.lang.Object ref = validationRegex_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationRegex_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Regular expression which can be used for parameter validation.
   * </pre>
   *
   * <code>string validation_regex = 7;</code>
   *
   * @return The bytes for validationRegex.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationRegexBytes() {
    java.lang.Object ref = validationRegex_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationRegex_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int ALLOWED_VALUES_FIELD_NUMBER = 8;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList allowedValues_ =
      com.google.protobuf.LazyStringArrayList.emptyList();
  /**
   *
   *
   * <pre>
   * All possible values for the parameter.
   * </pre>
   *
   * <code>repeated string allowed_values = 8;</code>
   *
   * @return A list containing the allowedValues.
   */
  public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
    return allowedValues_;
  }
  /**
   *
   *
   * <pre>
   * All possible values for the parameter.
   * </pre>
   *
   * <code>repeated string allowed_values = 8;</code>
   *
   * @return The count of allowedValues.
   */
  public int getAllowedValuesCount() {
    return allowedValues_.size();
  }
  /**
   *
   *
   * <pre>
   * All possible values for the parameter.
   * </pre>
   *
   * <code>repeated string allowed_values = 8;</code>
   *
   * @param index The index of the element to return.
   * @return The allowedValues at the given index.
   */
  public java.lang.String getAllowedValues(int index) {
    return allowedValues_.get(index);
  }
  /**
   *
   *
   * <pre>
   * All possible values for the parameter.
   * </pre>
   *
   * <code>repeated string allowed_values = 8;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the allowedValues at the given index.
   */
  public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
    return allowedValues_.getByteString(index);
  }

  public static final int MIN_VALUE_FIELD_NUMBER = 9;
  private com.google.protobuf.DoubleValue minValue_;
  /**
   *
   *
   * <pre>
   * For integer and double values specifies minimum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue min_value = 9;</code>
   *
   * @return Whether the minValue field is set.
   */
  @java.lang.Override
  public boolean hasMinValue() {
    return ((bitField0_ & 0x00000001) != 0);
  }
  /**
   *
   *
   * <pre>
   * For integer and double values specifies minimum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue min_value = 9;</code>
   *
   * @return The minValue.
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValue getMinValue() {
    return minValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : minValue_;
  }
  /**
   *
   *
   * <pre>
   * For integer and double values specifies minimum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue min_value = 9;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValueOrBuilder getMinValueOrBuilder() {
    return minValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : minValue_;
  }

  public static final int MAX_VALUE_FIELD_NUMBER = 10;
  private com.google.protobuf.DoubleValue maxValue_;
  /**
   *
   *
   * <pre>
   * For integer and double values specifies maximum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue max_value = 10;</code>
   *
   * @return Whether the maxValue field is set.
   */
  @java.lang.Override
  public boolean hasMaxValue() {
    return ((bitField0_ & 0x00000002) != 0);
  }
  /**
   *
   *
   * <pre>
   * For integer and double values specifies maximum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue max_value = 10;</code>
   *
   * @return The maxValue.
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValue getMaxValue() {
    return maxValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : maxValue_;
  }
  /**
   *
   *
   * <pre>
   * For integer and double values specifies maximum allowed value.
   * </pre>
   *
   * <code>.google.protobuf.DoubleValue max_value = 10;</code>
   */
  @java.lang.Override
  public com.google.protobuf.DoubleValueOrBuilder getMaxValueOrBuilder() {
    return maxValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : maxValue_;
  }

  public static final int FIELDS_FIELD_NUMBER = 11;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter> fields_;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
      getFieldsList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
   */
  @java.lang.Override
  public java.util.List<
          ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
      getFieldsOrBuilderList() {
    return fields_;
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
   */
  @java.lang.Override
  public int getFieldsCount() {
    return fields_.size();
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getFields(int index) {
    return fields_.get(index);
  }
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
   */
  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder getFieldsOrBuilder(
      int index) {
    return fields_.get(index);
  }

  public static final int VALIDATION_DESCRIPTION_FIELD_NUMBER = 12;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationDescription_ = "";
  /**
   *
   *
   * <pre>
   * Description of the requirements for this field, in case the user input does
   * not fulfill the regex pattern or min/max values.
   * </pre>
   *
   * <code>string validation_description = 12;</code>
   *
   * @return The validationDescription.
   */
  @java.lang.Override
  public java.lang.String getValidationDescription() {
    java.lang.Object ref = validationDescription_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationDescription_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * Description of the requirements for this field, in case the user input does
   * not fulfill the regex pattern or min/max values.
   * </pre>
   *
   * <code>string validation_description = 12;</code>
   *
   * @return The bytes for validationDescription.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationDescriptionBytes() {
    java.lang.Object ref = validationDescription_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationDescription_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int VALIDATION_HELP_URL_FIELD_NUMBER = 13;

  @SuppressWarnings("serial")
  private volatile java.lang.Object validationHelpUrl_ = "";
  /**
   *
   *
   * <pre>
   * URL to a help document to further explain the naming requirements.
   * </pre>
   *
   * <code>string validation_help_url = 13;</code>
   *
   * @return The validationHelpUrl.
   */
  @java.lang.Override
  public java.lang.String getValidationHelpUrl() {
    java.lang.Object ref = validationHelpUrl_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      validationHelpUrl_ = s;
      return s;
    }
  }
  /**
   *
   *
   * <pre>
   * URL to a help document to further explain the naming requirements.
   * </pre>
   *
   * <code>string validation_help_url = 13;</code>
   *
   * @return The bytes for validationHelpUrl.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getValidationHelpUrlBytes() {
    java.lang.Object ref = validationHelpUrl_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      validationHelpUrl_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int IMMUTABLE_FIELD_NUMBER = 14;
  private boolean immutable_ = false;
  /**
   *
   *
   * <pre>
   * Cannot be changed after initial creation.
   * </pre>
   *
   * <code>bool immutable = 14;</code>
   *
   * @return The immutable.
   */
  @java.lang.Override
  public boolean getImmutable() {
    return immutable_;
  }

  public static final int RECURSE_FIELD_NUMBER = 15;
  private boolean recurse_ = false;
  /**
   *
   *
   * <pre>
   * Deprecated. This field has no effect.
   * </pre>
   *
   * <code>bool recurse = 15;</code>
   *
   * @return The recurse.
   */
  @java.lang.Override
  public boolean getRecurse() {
    return recurse_;
  }

  public static final int DEPRECATED_FIELD_NUMBER = 20;
  private boolean deprecated_ = false;
  /**
   *
   *
   * <pre>
   * If true, it should not be used in new transfers, and it should not be
   * visible to users.
   * </pre>
   *
   * <code>bool deprecated = 20;</code>
   *
   * @return The deprecated.
   */
  @java.lang.Override
  public boolean getDeprecated() {
    return deprecated_;
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(paramId_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, paramId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, description_);
    }
    if (type_
        != com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      output.writeEnum(4, type_);
    }
    if (required_ != false) {
      output.writeBool(5, required_);
    }
    if (repeated_ != false) {
      output.writeBool(6, repeated_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationRegex_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 7, validationRegex_);
    }
    for (int i = 0; i < allowedValues_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 8, allowedValues_.getRaw(i));
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      output.writeMessage(9, getMinValue());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      output.writeMessage(10, getMaxValue());
    }
    for (int i = 0; i < fields_.size(); i++) {
      output.writeMessage(11, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDescription_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 12, validationDescription_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationHelpUrl_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 13, validationHelpUrl_);
    }
    if (immutable_ != false) {
      output.writeBool(14, immutable_);
    }
    if (recurse_ != false) {
      output.writeBool(15, recurse_);
    }
    if (deprecated_ != false) {
      output.writeBool(20, deprecated_);
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(paramId_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, paramId_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(displayName_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(2, displayName_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(description_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(3, description_);
    }
    if (type_
        != com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.TYPE_UNSPECIFIED
            .getNumber()) {
      size += com.google.protobuf.CodedOutputStream.computeEnumSize(4, type_);
    }
    if (required_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(5, required_);
    }
    if (repeated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(6, repeated_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationRegex_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(7, validationRegex_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < allowedValues_.size(); i++) {
        dataSize += computeStringSizeNoTag(allowedValues_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getAllowedValuesList().size();
    }
    if (((bitField0_ & 0x00000001) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(9, getMinValue());
    }
    if (((bitField0_ & 0x00000002) != 0)) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(10, getMaxValue());
    }
    for (int i = 0; i < fields_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(11, fields_.get(i));
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationDescription_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(12, validationDescription_);
    }
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(validationHelpUrl_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(13, validationHelpUrl_);
    }
    if (immutable_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(14, immutable_);
    }
    if (recurse_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(15, recurse_);
    }
    if (deprecated_ != false) {
      size += com.google.protobuf.CodedOutputStream.computeBoolSize(20, deprecated_);
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter)) {
      return super.equals(obj);
    }
    com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter other =
        (com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter) obj;

    if (!getParamId().equals(other.getParamId())) return false;
    if (!getDisplayName().equals(other.getDisplayName())) return false;
    if (!getDescription().equals(other.getDescription())) return false;
    if (type_ != other.type_) return false;
    if (getRequired() != other.getRequired()) return false;
    if (getRepeated() != other.getRepeated()) return false;
    if (!getValidationRegex().equals(other.getValidationRegex())) return false;
    if (!getAllowedValuesList().equals(other.getAllowedValuesList())) return false;
    if (hasMinValue() != other.hasMinValue()) return false;
    if (hasMinValue()) {
      if (!getMinValue().equals(other.getMinValue())) return false;
    }
    if (hasMaxValue() != other.hasMaxValue()) return false;
    if (hasMaxValue()) {
      if (!getMaxValue().equals(other.getMaxValue())) return false;
    }
    if (!getFieldsList().equals(other.getFieldsList())) return false;
    if (!getValidationDescription().equals(other.getValidationDescription())) return false;
    if (!getValidationHelpUrl().equals(other.getValidationHelpUrl())) return false;
    if (getImmutable() != other.getImmutable()) return false;
    if (getRecurse() != other.getRecurse()) return false;
    if (getDeprecated() != other.getDeprecated()) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + PARAM_ID_FIELD_NUMBER;
    hash = (53 * hash) + getParamId().hashCode();
    hash = (37 * hash) + DISPLAY_NAME_FIELD_NUMBER;
    hash = (53 * hash) + getDisplayName().hashCode();
    hash = (37 * hash) + DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getDescription().hashCode();
    hash = (37 * hash) + TYPE_FIELD_NUMBER;
    hash = (53 * hash) + type_;
    hash = (37 * hash) + REQUIRED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRequired());
    hash = (37 * hash) + REPEATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRepeated());
    hash = (37 * hash) + VALIDATION_REGEX_FIELD_NUMBER;
    hash = (53 * hash) + getValidationRegex().hashCode();
    if (getAllowedValuesCount() > 0) {
      hash = (37 * hash) + ALLOWED_VALUES_FIELD_NUMBER;
      hash = (53 * hash) + getAllowedValuesList().hashCode();
    }
    if (hasMinValue()) {
      hash = (37 * hash) + MIN_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getMinValue().hashCode();
    }
    if (hasMaxValue()) {
      hash = (37 * hash) + MAX_VALUE_FIELD_NUMBER;
      hash = (53 * hash) + getMaxValue().hashCode();
    }
    if (getFieldsCount() > 0) {
      hash = (37 * hash) + FIELDS_FIELD_NUMBER;
      hash = (53 * hash) + getFieldsList().hashCode();
    }
    hash = (37 * hash) + VALIDATION_DESCRIPTION_FIELD_NUMBER;
    hash = (53 * hash) + getValidationDescription().hashCode();
    hash = (37 * hash) + VALIDATION_HELP_URL_FIELD_NUMBER;
    hash = (53 * hash) + getValidationHelpUrl().hashCode();
    hash = (37 * hash) + IMMUTABLE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getImmutable());
    hash = (37 * hash) + RECURSE_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getRecurse());
    hash = (37 * hash) + DEPRECATED_FIELD_NUMBER;
    hash = (53 * hash) + com.google.protobuf.Internal.hashBoolean(getDeprecated());
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      java.nio.ByteBuffer data) throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(
      com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }
  /**
   *
   *
   * <pre>
   * A parameter used to define custom fields in a data source definition.
   * </pre>
   *
   * Protobuf type {@code google.cloud.bigquery.datatransfer.v1.DataSourceParameter}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.bigquery.datatransfer.v1.DataSourceParameter)
      com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceParameter_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceParameter_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.class,
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder.class);
    }

    // Construct using com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.newBuilder()
    private Builder() {
      maybeForceBuilderInitialization();
    }

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
      maybeForceBuilderInitialization();
    }

    private void maybeForceBuilderInitialization() {
      if (com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders) {
        getMinValueFieldBuilder();
        getMaxValueFieldBuilder();
        getFieldsFieldBuilder();
      }
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      paramId_ = "";
      displayName_ = "";
      description_ = "";
      type_ = 0;
      required_ = false;
      repeated_ = false;
      validationRegex_ = "";
      allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      minValue_ = null;
      if (minValueBuilder_ != null) {
        minValueBuilder_.dispose();
        minValueBuilder_ = null;
      }
      maxValue_ = null;
      if (maxValueBuilder_ != null) {
        maxValueBuilder_.dispose();
        maxValueBuilder_ = null;
      }
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
      } else {
        fields_ = null;
        fieldsBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000400);
      validationDescription_ = "";
      validationHelpUrl_ = "";
      immutable_ = false;
      recurse_ = false;
      deprecated_ = false;
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataTransferProto
          .internal_static_google_cloud_bigquery_datatransfer_v1_DataSourceParameter_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter
        getDefaultInstanceForType() {
      return com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter build() {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter buildPartial() {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter result =
          new com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter result) {
      if (fieldsBuilder_ == null) {
        if (((bitField0_ & 0x00000400) != 0)) {
          fields_ = java.util.Collections.unmodifiableList(fields_);
          bitField0_ = (bitField0_ & ~0x00000400);
        }
        result.fields_ = fields_;
      } else {
        result.fields_ = fieldsBuilder_.build();
      }
    }

    private void buildPartial0(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.paramId_ = paramId_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        result.displayName_ = displayName_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        result.description_ = description_;
      }
      if (((from_bitField0_ & 0x00000008) != 0)) {
        result.type_ = type_;
      }
      if (((from_bitField0_ & 0x00000010) != 0)) {
        result.required_ = required_;
      }
      if (((from_bitField0_ & 0x00000020) != 0)) {
        result.repeated_ = repeated_;
      }
      if (((from_bitField0_ & 0x00000040) != 0)) {
        result.validationRegex_ = validationRegex_;
      }
      if (((from_bitField0_ & 0x00000080) != 0)) {
        allowedValues_.makeImmutable();
        result.allowedValues_ = allowedValues_;
      }
      int to_bitField0_ = 0;
      if (((from_bitField0_ & 0x00000100) != 0)) {
        result.minValue_ = minValueBuilder_ == null ? minValue_ : minValueBuilder_.build();
        to_bitField0_ |= 0x00000001;
      }
      if (((from_bitField0_ & 0x00000200) != 0)) {
        result.maxValue_ = maxValueBuilder_ == null ? maxValue_ : maxValueBuilder_.build();
        to_bitField0_ |= 0x00000002;
      }
      if (((from_bitField0_ & 0x00000800) != 0)) {
        result.validationDescription_ = validationDescription_;
      }
      if (((from_bitField0_ & 0x00001000) != 0)) {
        result.validationHelpUrl_ = validationHelpUrl_;
      }
      if (((from_bitField0_ & 0x00002000) != 0)) {
        result.immutable_ = immutable_;
      }
      if (((from_bitField0_ & 0x00004000) != 0)) {
        result.recurse_ = recurse_;
      }
      if (((from_bitField0_ & 0x00008000) != 0)) {
        result.deprecated_ = deprecated_;
      }
      result.bitField0_ |= to_bitField0_;
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter) {
        return mergeFrom((com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter other) {
      if (other
          == com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance())
        return this;
      if (!other.getParamId().isEmpty()) {
        paramId_ = other.paramId_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.getDisplayName().isEmpty()) {
        displayName_ = other.displayName_;
        bitField0_ |= 0x00000002;
        onChanged();
      }
      if (!other.getDescription().isEmpty()) {
        description_ = other.description_;
        bitField0_ |= 0x00000004;
        onChanged();
      }
      if (other.type_ != 0) {
        setTypeValue(other.getTypeValue());
      }
      if (other.getRequired() != false) {
        setRequired(other.getRequired());
      }
      if (other.getRepeated() != false) {
        setRepeated(other.getRepeated());
      }
      if (!other.getValidationRegex().isEmpty()) {
        validationRegex_ = other.validationRegex_;
        bitField0_ |= 0x00000040;
        onChanged();
      }
      if (!other.allowedValues_.isEmpty()) {
        if (allowedValues_.isEmpty()) {
          allowedValues_ = other.allowedValues_;
          bitField0_ |= 0x00000080;
        } else {
          ensureAllowedValuesIsMutable();
          allowedValues_.addAll(other.allowedValues_);
        }
        onChanged();
      }
      if (other.hasMinValue()) {
        mergeMinValue(other.getMinValue());
      }
      if (other.hasMaxValue()) {
        mergeMaxValue(other.getMaxValue());
      }
      if (fieldsBuilder_ == null) {
        if (!other.fields_.isEmpty()) {
          if (fields_.isEmpty()) {
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000400);
          } else {
            ensureFieldsIsMutable();
            fields_.addAll(other.fields_);
          }
          onChanged();
        }
      } else {
        if (!other.fields_.isEmpty()) {
          if (fieldsBuilder_.isEmpty()) {
            fieldsBuilder_.dispose();
            fieldsBuilder_ = null;
            fields_ = other.fields_;
            bitField0_ = (bitField0_ & ~0x00000400);
            fieldsBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getFieldsFieldBuilder()
                    : null;
          } else {
            fieldsBuilder_.addAllMessages(other.fields_);
          }
        }
      }
      if (!other.getValidationDescription().isEmpty()) {
        validationDescription_ = other.validationDescription_;
        bitField0_ |= 0x00000800;
        onChanged();
      }
      if (!other.getValidationHelpUrl().isEmpty()) {
        validationHelpUrl_ = other.validationHelpUrl_;
        bitField0_ |= 0x00001000;
        onChanged();
      }
      if (other.getImmutable() != false) {
        setImmutable(other.getImmutable());
      }
      if (other.getRecurse() != false) {
        setRecurse(other.getRecurse());
      }
      if (other.getDeprecated() != false) {
        setDeprecated(other.getDeprecated());
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                paramId_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                displayName_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000002;
                break;
              } // case 18
            case 26:
              {
                description_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000004;
                break;
              } // case 26
            case 32:
              {
                type_ = input.readEnum();
                bitField0_ |= 0x00000008;
                break;
              } // case 32
            case 40:
              {
                required_ = input.readBool();
                bitField0_ |= 0x00000010;
                break;
              } // case 40
            case 48:
              {
                repeated_ = input.readBool();
                bitField0_ |= 0x00000020;
                break;
              } // case 48
            case 58:
              {
                validationRegex_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000040;
                break;
              } // case 58
            case 66:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureAllowedValuesIsMutable();
                allowedValues_.add(s);
                break;
              } // case 66
            case 74:
              {
                input.readMessage(getMinValueFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000100;
                break;
              } // case 74
            case 82:
              {
                input.readMessage(getMaxValueFieldBuilder().getBuilder(), extensionRegistry);
                bitField0_ |= 0x00000200;
                break;
              } // case 82
            case 90:
              {
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter m =
                    input.readMessage(
                        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.parser(),
                        extensionRegistry);
                if (fieldsBuilder_ == null) {
                  ensureFieldsIsMutable();
                  fields_.add(m);
                } else {
                  fieldsBuilder_.addMessage(m);
                }
                break;
              } // case 90
            case 98:
              {
                validationDescription_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000800;
                break;
              } // case 98
            case 106:
              {
                validationHelpUrl_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00001000;
                break;
              } // case 106
            case 112:
              {
                immutable_ = input.readBool();
                bitField0_ |= 0x00002000;
                break;
              } // case 112
            case 120:
              {
                recurse_ = input.readBool();
                bitField0_ |= 0x00004000;
                break;
              } // case 120
            case 160:
              {
                deprecated_ = input.readBool();
                bitField0_ |= 0x00008000;
                break;
              } // case 160
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object paramId_ = "";
    /**
     *
     *
     * <pre>
     * Parameter identifier.
     * </pre>
     *
     * <code>string param_id = 1;</code>
     *
     * @return The paramId.
     */
    public java.lang.String getParamId() {
      java.lang.Object ref = paramId_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        paramId_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter identifier.
     * </pre>
     *
     * <code>string param_id = 1;</code>
     *
     * @return The bytes for paramId.
     */
    public com.google.protobuf.ByteString getParamIdBytes() {
      java.lang.Object ref = paramId_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        paramId_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter identifier.
     * </pre>
     *
     * <code>string param_id = 1;</code>
     *
     * @param value The paramId to set.
     * @return This builder for chaining.
     */
    public Builder setParamId(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      paramId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter identifier.
     * </pre>
     *
     * <code>string param_id = 1;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearParamId() {
      paramId_ = getDefaultInstance().getParamId();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter identifier.
     * </pre>
     *
     * <code>string param_id = 1;</code>
     *
     * @param value The bytes for paramId to set.
     * @return This builder for chaining.
     */
    public Builder setParamIdBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      paramId_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private java.lang.Object displayName_ = "";
    /**
     *
     *
     * <pre>
     * Parameter display name in the user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The displayName.
     */
    public java.lang.String getDisplayName() {
      java.lang.Object ref = displayName_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        displayName_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter display name in the user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return The bytes for displayName.
     */
    public com.google.protobuf.ByteString getDisplayNameBytes() {
      java.lang.Object ref = displayName_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        displayName_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter display name in the user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayName(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter display name in the user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDisplayName() {
      displayName_ = getDefaultInstance().getDisplayName();
      bitField0_ = (bitField0_ & ~0x00000002);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter display name in the user interface.
     * </pre>
     *
     * <code>string display_name = 2;</code>
     *
     * @param value The bytes for displayName to set.
     * @return This builder for chaining.
     */
    public Builder setDisplayNameBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      displayName_ = value;
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private java.lang.Object description_ = "";
    /**
     *
     *
     * <pre>
     * Parameter description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The description.
     */
    public java.lang.String getDescription() {
      java.lang.Object ref = description_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        description_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return The bytes for description.
     */
    public com.google.protobuf.ByteString getDescriptionBytes() {
      java.lang.Object ref = description_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        description_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Parameter description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The description to set.
     * @return This builder for chaining.
     */
    public Builder setDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDescription() {
      description_ = getDefaultInstance().getDescription();
      bitField0_ = (bitField0_ & ~0x00000004);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter description.
     * </pre>
     *
     * <code>string description = 3;</code>
     *
     * @param value The bytes for description to set.
     * @return This builder for chaining.
     */
    public Builder setDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      description_ = value;
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private int type_ = 0;
    /**
     *
     *
     * <pre>
     * Parameter type.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
     *
     * @return The enum numeric value on the wire for type.
     */
    @java.lang.Override
    public int getTypeValue() {
      return type_;
    }
    /**
     *
     *
     * <pre>
     * Parameter type.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
     *
     * @param value The enum numeric value on the wire for type to set.
     * @return This builder for chaining.
     */
    public Builder setTypeValue(int value) {
      type_ = value;
      bitField0_ |= 0x00000008;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter type.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
     *
     * @return The type.
     */
    @java.lang.Override
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type getType() {
      com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type result =
          com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.forNumber(type_);
      return result == null
          ? com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type.UNRECOGNIZED
          : result;
    }
    /**
     *
     *
     * <pre>
     * Parameter type.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
     *
     * @param value The type to set.
     * @return This builder for chaining.
     */
    public Builder setType(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type value) {
      if (value == null) {
        throw new NullPointerException();
      }
      bitField0_ |= 0x00000008;
      type_ = value.getNumber();
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Parameter type.
     * </pre>
     *
     * <code>.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Type type = 4;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearType() {
      bitField0_ = (bitField0_ & ~0x00000008);
      type_ = 0;
      onChanged();
      return this;
    }

    private boolean required_;
    /**
     *
     *
     * <pre>
     * Is parameter required.
     * </pre>
     *
     * <code>bool required = 5;</code>
     *
     * @return The required.
     */
    @java.lang.Override
    public boolean getRequired() {
      return required_;
    }
    /**
     *
     *
     * <pre>
     * Is parameter required.
     * </pre>
     *
     * <code>bool required = 5;</code>
     *
     * @param value The required to set.
     * @return This builder for chaining.
     */
    public Builder setRequired(boolean value) {

      required_ = value;
      bitField0_ |= 0x00000010;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Is parameter required.
     * </pre>
     *
     * <code>bool required = 5;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRequired() {
      bitField0_ = (bitField0_ & ~0x00000010);
      required_ = false;
      onChanged();
      return this;
    }

    private boolean repeated_;
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool repeated = 6;</code>
     *
     * @return The repeated.
     */
    @java.lang.Override
    public boolean getRepeated() {
      return repeated_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool repeated = 6;</code>
     *
     * @param value The repeated to set.
     * @return This builder for chaining.
     */
    public Builder setRepeated(boolean value) {

      repeated_ = value;
      bitField0_ |= 0x00000020;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool repeated = 6;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRepeated() {
      bitField0_ = (bitField0_ & ~0x00000020);
      repeated_ = false;
      onChanged();
      return this;
    }

    private java.lang.Object validationRegex_ = "";
    /**
     *
     *
     * <pre>
     * Regular expression which can be used for parameter validation.
     * </pre>
     *
     * <code>string validation_regex = 7;</code>
     *
     * @return The validationRegex.
     */
    public java.lang.String getValidationRegex() {
      java.lang.Object ref = validationRegex_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationRegex_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression which can be used for parameter validation.
     * </pre>
     *
     * <code>string validation_regex = 7;</code>
     *
     * @return The bytes for validationRegex.
     */
    public com.google.protobuf.ByteString getValidationRegexBytes() {
      java.lang.Object ref = validationRegex_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationRegex_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Regular expression which can be used for parameter validation.
     * </pre>
     *
     * <code>string validation_regex = 7;</code>
     *
     * @param value The validationRegex to set.
     * @return This builder for chaining.
     */
    public Builder setValidationRegex(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationRegex_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which can be used for parameter validation.
     * </pre>
     *
     * <code>string validation_regex = 7;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationRegex() {
      validationRegex_ = getDefaultInstance().getValidationRegex();
      bitField0_ = (bitField0_ & ~0x00000040);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Regular expression which can be used for parameter validation.
     * </pre>
     *
     * <code>string validation_regex = 7;</code>
     *
     * @param value The bytes for validationRegex to set.
     * @return This builder for chaining.
     */
    public Builder setValidationRegexBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationRegex_ = value;
      bitField0_ |= 0x00000040;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList allowedValues_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureAllowedValuesIsMutable() {
      if (!allowedValues_.isModifiable()) {
        allowedValues_ = new com.google.protobuf.LazyStringArrayList(allowedValues_);
      }
      bitField0_ |= 0x00000080;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @return A list containing the allowedValues.
     */
    public com.google.protobuf.ProtocolStringList getAllowedValuesList() {
      allowedValues_.makeImmutable();
      return allowedValues_;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @return The count of allowedValues.
     */
    public int getAllowedValuesCount() {
      return allowedValues_.size();
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param index The index of the element to return.
     * @return The allowedValues at the given index.
     */
    public java.lang.String getAllowedValues(int index) {
      return allowedValues_.get(index);
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the allowedValues at the given index.
     */
    public com.google.protobuf.ByteString getAllowedValuesBytes(int index) {
      return allowedValues_.getByteString(index);
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param index The index to set the value at.
     * @param value The allowedValues to set.
     * @return This builder for chaining.
     */
    public Builder setAllowedValues(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedValuesIsMutable();
      allowedValues_.set(index, value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param value The allowedValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedValues(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureAllowedValuesIsMutable();
      allowedValues_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param values The allowedValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllAllowedValues(java.lang.Iterable<java.lang.String> values) {
      ensureAllowedValuesIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, allowedValues_);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearAllowedValues() {
      allowedValues_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000080);
      ;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * All possible values for the parameter.
     * </pre>
     *
     * <code>repeated string allowed_values = 8;</code>
     *
     * @param value The bytes of the allowedValues to add.
     * @return This builder for chaining.
     */
    public Builder addAllowedValuesBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureAllowedValuesIsMutable();
      allowedValues_.add(value);
      bitField0_ |= 0x00000080;
      onChanged();
      return this;
    }

    private com.google.protobuf.DoubleValue minValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        minValueBuilder_;
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     *
     * @return Whether the minValue field is set.
     */
    public boolean hasMinValue() {
      return ((bitField0_ & 0x00000100) != 0);
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     *
     * @return The minValue.
     */
    public com.google.protobuf.DoubleValue getMinValue() {
      if (minValueBuilder_ == null) {
        return minValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : minValue_;
      } else {
        return minValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public Builder setMinValue(com.google.protobuf.DoubleValue value) {
      if (minValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        minValue_ = value;
      } else {
        minValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public Builder setMinValue(com.google.protobuf.DoubleValue.Builder builderForValue) {
      if (minValueBuilder_ == null) {
        minValue_ = builderForValue.build();
      } else {
        minValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000100;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public Builder mergeMinValue(com.google.protobuf.DoubleValue value) {
      if (minValueBuilder_ == null) {
        if (((bitField0_ & 0x00000100) != 0)
            && minValue_ != null
            && minValue_ != com.google.protobuf.DoubleValue.getDefaultInstance()) {
          getMinValueBuilder().mergeFrom(value);
        } else {
          minValue_ = value;
        }
      } else {
        minValueBuilder_.mergeFrom(value);
      }
      if (minValue_ != null) {
        bitField0_ |= 0x00000100;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public Builder clearMinValue() {
      bitField0_ = (bitField0_ & ~0x00000100);
      minValue_ = null;
      if (minValueBuilder_ != null) {
        minValueBuilder_.dispose();
        minValueBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public com.google.protobuf.DoubleValue.Builder getMinValueBuilder() {
      bitField0_ |= 0x00000100;
      onChanged();
      return getMinValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    public com.google.protobuf.DoubleValueOrBuilder getMinValueOrBuilder() {
      if (minValueBuilder_ != null) {
        return minValueBuilder_.getMessageOrBuilder();
      } else {
        return minValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : minValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies minimum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue min_value = 9;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        getMinValueFieldBuilder() {
      if (minValueBuilder_ == null) {
        minValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.DoubleValue,
                com.google.protobuf.DoubleValue.Builder,
                com.google.protobuf.DoubleValueOrBuilder>(
                getMinValue(), getParentForChildren(), isClean());
        minValue_ = null;
      }
      return minValueBuilder_;
    }

    private com.google.protobuf.DoubleValue maxValue_;
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        maxValueBuilder_;
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     *
     * @return Whether the maxValue field is set.
     */
    public boolean hasMaxValue() {
      return ((bitField0_ & 0x00000200) != 0);
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     *
     * @return The maxValue.
     */
    public com.google.protobuf.DoubleValue getMaxValue() {
      if (maxValueBuilder_ == null) {
        return maxValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : maxValue_;
      } else {
        return maxValueBuilder_.getMessage();
      }
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public Builder setMaxValue(com.google.protobuf.DoubleValue value) {
      if (maxValueBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        maxValue_ = value;
      } else {
        maxValueBuilder_.setMessage(value);
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public Builder setMaxValue(com.google.protobuf.DoubleValue.Builder builderForValue) {
      if (maxValueBuilder_ == null) {
        maxValue_ = builderForValue.build();
      } else {
        maxValueBuilder_.setMessage(builderForValue.build());
      }
      bitField0_ |= 0x00000200;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public Builder mergeMaxValue(com.google.protobuf.DoubleValue value) {
      if (maxValueBuilder_ == null) {
        if (((bitField0_ & 0x00000200) != 0)
            && maxValue_ != null
            && maxValue_ != com.google.protobuf.DoubleValue.getDefaultInstance()) {
          getMaxValueBuilder().mergeFrom(value);
        } else {
          maxValue_ = value;
        }
      } else {
        maxValueBuilder_.mergeFrom(value);
      }
      if (maxValue_ != null) {
        bitField0_ |= 0x00000200;
        onChanged();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public Builder clearMaxValue() {
      bitField0_ = (bitField0_ & ~0x00000200);
      maxValue_ = null;
      if (maxValueBuilder_ != null) {
        maxValueBuilder_.dispose();
        maxValueBuilder_ = null;
      }
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public com.google.protobuf.DoubleValue.Builder getMaxValueBuilder() {
      bitField0_ |= 0x00000200;
      onChanged();
      return getMaxValueFieldBuilder().getBuilder();
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    public com.google.protobuf.DoubleValueOrBuilder getMaxValueOrBuilder() {
      if (maxValueBuilder_ != null) {
        return maxValueBuilder_.getMessageOrBuilder();
      } else {
        return maxValue_ == null ? com.google.protobuf.DoubleValue.getDefaultInstance() : maxValue_;
      }
    }
    /**
     *
     *
     * <pre>
     * For integer and double values specifies maximum allowed value.
     * </pre>
     *
     * <code>.google.protobuf.DoubleValue max_value = 10;</code>
     */
    private com.google.protobuf.SingleFieldBuilderV3<
            com.google.protobuf.DoubleValue,
            com.google.protobuf.DoubleValue.Builder,
            com.google.protobuf.DoubleValueOrBuilder>
        getMaxValueFieldBuilder() {
      if (maxValueBuilder_ == null) {
        maxValueBuilder_ =
            new com.google.protobuf.SingleFieldBuilderV3<
                com.google.protobuf.DoubleValue,
                com.google.protobuf.DoubleValue.Builder,
                com.google.protobuf.DoubleValueOrBuilder>(
                getMaxValue(), getParentForChildren(), isClean());
        maxValue_ = null;
      }
      return maxValueBuilder_;
    }

    private java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter> fields_ =
        java.util.Collections.emptyList();

    private void ensureFieldsIsMutable() {
      if (!((bitField0_ & 0x00000400) != 0)) {
        fields_ =
            new java.util.ArrayList<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>(
                fields_);
        bitField0_ |= 0x00000400;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        fieldsBuilder_;

    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
        getFieldsList() {
      if (fieldsBuilder_ == null) {
        return java.util.Collections.unmodifiableList(fields_);
      } else {
        return fieldsBuilder_.getMessageList();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public int getFieldsCount() {
      if (fieldsBuilder_ == null) {
        return fields_.size();
      } else {
        return fieldsBuilder_.getCount();
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getFields(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessage(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder setFields(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.set(index, value);
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder setFields(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.set(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder addFields(com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder addFields(
        int index, com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter value) {
      if (fieldsBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureFieldsIsMutable();
        fields_.add(index, value);
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, value);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder addFields(
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder addFields(
        int index,
        com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder builderForValue) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.add(index, builderForValue.build());
        onChanged();
      } else {
        fieldsBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder addAllFields(
        java.lang.Iterable<? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter>
            values) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, fields_);
        onChanged();
      } else {
        fieldsBuilder_.addAllMessages(values);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder clearFields() {
      if (fieldsBuilder_ == null) {
        fields_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000400);
        onChanged();
      } else {
        fieldsBuilder_.clear();
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public Builder removeFields(int index) {
      if (fieldsBuilder_ == null) {
        ensureFieldsIsMutable();
        fields_.remove(index);
        onChanged();
      } else {
        fieldsBuilder_.remove(index);
      }
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder getFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder().getBuilder(index);
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder
        getFieldsOrBuilder(int index) {
      if (fieldsBuilder_ == null) {
        return fields_.get(index);
      } else {
        return fieldsBuilder_.getMessageOrBuilder(index);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public java.util.List<
            ? extends com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        getFieldsOrBuilderList() {
      if (fieldsBuilder_ != null) {
        return fieldsBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(fields_);
      }
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder
        addFieldsBuilder() {
      return getFieldsFieldBuilder()
          .addBuilder(
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder addFieldsBuilder(
        int index) {
      return getFieldsFieldBuilder()
          .addBuilder(
              index,
              com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.getDefaultInstance());
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>repeated .google.cloud.bigquery.datatransfer.v1.DataSourceParameter fields = 11;</code>
     */
    public java.util.List<com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder>
        getFieldsBuilderList() {
      return getFieldsFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
            com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>
        getFieldsFieldBuilder() {
      if (fieldsBuilder_ == null) {
        fieldsBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter.Builder,
                com.google.cloud.bigquery.datatransfer.v1.DataSourceParameterOrBuilder>(
                fields_, ((bitField0_ & 0x00000400) != 0), getParentForChildren(), isClean());
        fields_ = null;
      }
      return fieldsBuilder_;
    }

    private java.lang.Object validationDescription_ = "";
    /**
     *
     *
     * <pre>
     * Description of the requirements for this field, in case the user input does
     * not fulfill the regex pattern or min/max values.
     * </pre>
     *
     * <code>string validation_description = 12;</code>
     *
     * @return The validationDescription.
     */
    public java.lang.String getValidationDescription() {
      java.lang.Object ref = validationDescription_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationDescription_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the requirements for this field, in case the user input does
     * not fulfill the regex pattern or min/max values.
     * </pre>
     *
     * <code>string validation_description = 12;</code>
     *
     * @return The bytes for validationDescription.
     */
    public com.google.protobuf.ByteString getValidationDescriptionBytes() {
      java.lang.Object ref = validationDescription_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationDescription_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * Description of the requirements for this field, in case the user input does
     * not fulfill the regex pattern or min/max values.
     * </pre>
     *
     * <code>string validation_description = 12;</code>
     *
     * @param value The validationDescription to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDescription(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationDescription_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the requirements for this field, in case the user input does
     * not fulfill the regex pattern or min/max values.
     * </pre>
     *
     * <code>string validation_description = 12;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationDescription() {
      validationDescription_ = getDefaultInstance().getValidationDescription();
      bitField0_ = (bitField0_ & ~0x00000800);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Description of the requirements for this field, in case the user input does
     * not fulfill the regex pattern or min/max values.
     * </pre>
     *
     * <code>string validation_description = 12;</code>
     *
     * @param value The bytes for validationDescription to set.
     * @return This builder for chaining.
     */
    public Builder setValidationDescriptionBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationDescription_ = value;
      bitField0_ |= 0x00000800;
      onChanged();
      return this;
    }

    private java.lang.Object validationHelpUrl_ = "";
    /**
     *
     *
     * <pre>
     * URL to a help document to further explain the naming requirements.
     * </pre>
     *
     * <code>string validation_help_url = 13;</code>
     *
     * @return The validationHelpUrl.
     */
    public java.lang.String getValidationHelpUrl() {
      java.lang.Object ref = validationHelpUrl_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        validationHelpUrl_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL to a help document to further explain the naming requirements.
     * </pre>
     *
     * <code>string validation_help_url = 13;</code>
     *
     * @return The bytes for validationHelpUrl.
     */
    public com.google.protobuf.ByteString getValidationHelpUrlBytes() {
      java.lang.Object ref = validationHelpUrl_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        validationHelpUrl_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }
    /**
     *
     *
     * <pre>
     * URL to a help document to further explain the naming requirements.
     * </pre>
     *
     * <code>string validation_help_url = 13;</code>
     *
     * @param value The validationHelpUrl to set.
     * @return This builder for chaining.
     */
    public Builder setValidationHelpUrl(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      validationHelpUrl_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL to a help document to further explain the naming requirements.
     * </pre>
     *
     * <code>string validation_help_url = 13;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearValidationHelpUrl() {
      validationHelpUrl_ = getDefaultInstance().getValidationHelpUrl();
      bitField0_ = (bitField0_ & ~0x00001000);
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * URL to a help document to further explain the naming requirements.
     * </pre>
     *
     * <code>string validation_help_url = 13;</code>
     *
     * @param value The bytes for validationHelpUrl to set.
     * @return This builder for chaining.
     */
    public Builder setValidationHelpUrlBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      validationHelpUrl_ = value;
      bitField0_ |= 0x00001000;
      onChanged();
      return this;
    }

    private boolean immutable_;
    /**
     *
     *
     * <pre>
     * Cannot be changed after initial creation.
     * </pre>
     *
     * <code>bool immutable = 14;</code>
     *
     * @return The immutable.
     */
    @java.lang.Override
    public boolean getImmutable() {
      return immutable_;
    }
    /**
     *
     *
     * <pre>
     * Cannot be changed after initial creation.
     * </pre>
     *
     * <code>bool immutable = 14;</code>
     *
     * @param value The immutable to set.
     * @return This builder for chaining.
     */
    public Builder setImmutable(boolean value) {

      immutable_ = value;
      bitField0_ |= 0x00002000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Cannot be changed after initial creation.
     * </pre>
     *
     * <code>bool immutable = 14;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImmutable() {
      bitField0_ = (bitField0_ & ~0x00002000);
      immutable_ = false;
      onChanged();
      return this;
    }

    private boolean recurse_;
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool recurse = 15;</code>
     *
     * @return The recurse.
     */
    @java.lang.Override
    public boolean getRecurse() {
      return recurse_;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool recurse = 15;</code>
     *
     * @param value The recurse to set.
     * @return This builder for chaining.
     */
    public Builder setRecurse(boolean value) {

      recurse_ = value;
      bitField0_ |= 0x00004000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * Deprecated. This field has no effect.
     * </pre>
     *
     * <code>bool recurse = 15;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearRecurse() {
      bitField0_ = (bitField0_ & ~0x00004000);
      recurse_ = false;
      onChanged();
      return this;
    }

    private boolean deprecated_;
    /**
     *
     *
     * <pre>
     * If true, it should not be used in new transfers, and it should not be
     * visible to users.
     * </pre>
     *
     * <code>bool deprecated = 20;</code>
     *
     * @return The deprecated.
     */
    @java.lang.Override
    public boolean getDeprecated() {
      return deprecated_;
    }
    /**
     *
     *
     * <pre>
     * If true, it should not be used in new transfers, and it should not be
     * visible to users.
     * </pre>
     *
     * <code>bool deprecated = 20;</code>
     *
     * @param value The deprecated to set.
     * @return This builder for chaining.
     */
    public Builder setDeprecated(boolean value) {

      deprecated_ = value;
      bitField0_ |= 0x00008000;
      onChanged();
      return this;
    }
    /**
     *
     *
     * <pre>
     * If true, it should not be used in new transfers, and it should not be
     * visible to users.
     * </pre>
     *
     * <code>bool deprecated = 20;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearDeprecated() {
      bitField0_ = (bitField0_ & ~0x00008000);
      deprecated_ = false;
      onChanged();
      return this;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.bigquery.datatransfer.v1.DataSourceParameter)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.bigquery.datatransfer.v1.DataSourceParameter)
  private static final com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter
      DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter();
  }

  public static com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<DataSourceParameter> PARSER =
      new com.google.protobuf.AbstractParser<DataSourceParameter>() {
        @java.lang.Override
        public DataSourceParameter parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<DataSourceParameter> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<DataSourceParameter> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.bigquery.datatransfer.v1.DataSourceParameter getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
