/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.pathtemplate.ValidationException;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;

public class RunName
implements ResourceName {
    private static final PathTemplate PROJECT_TRANSFER_CONFIG_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}/runs/{run}");
    private static final PathTemplate PROJECT_LOCATION_TRANSFER_CONFIG_RUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}");
    private volatile Map<String, String> fieldValuesMap;
    private PathTemplate pathTemplate;
    private String fixedValue;
    private final String project;
    private final String transferConfig;
    private final String run;
    private final String location;

    @Deprecated
    protected RunName() {
        this.project = null;
        this.transferConfig = null;
        this.run = null;
        this.location = null;
    }

    private RunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
        this.location = null;
        this.pathTemplate = PROJECT_TRANSFER_CONFIG_RUN;
    }

    private RunName(ProjectLocationTransferConfigRunBuilder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
        this.pathTemplate = PROJECT_LOCATION_TRANSFER_CONFIG_RUN;
    }

    public String getProject() {
        return this.project;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public String getRun() {
        return this.run;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public static Builder newProjectTransferConfigRunBuilder() {
        return new Builder();
    }

    public static ProjectLocationTransferConfigRunBuilder newProjectLocationTransferConfigRunBuilder() {
        return new ProjectLocationTransferConfigRunBuilder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static RunName of(String project, String transferConfig, String run) {
        return RunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build();
    }

    public static RunName ofProjectTransferConfigRunName(String project, String transferConfig, String run) {
        return RunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build();
    }

    public static RunName ofProjectLocationTransferConfigRunName(String project, String location, String transferConfig, String run) {
        return RunName.newProjectLocationTransferConfigRunBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).setRun(run).build();
    }

    public static String format(String project, String transferConfig, String run) {
        return RunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build().toString();
    }

    public static String formatProjectTransferConfigRunName(String project, String transferConfig, String run) {
        return RunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build().toString();
    }

    public static String formatProjectLocationTransferConfigRunName(String project, String location, String transferConfig, String run) {
        return RunName.newProjectLocationTransferConfigRunBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).setRun(run).build().toString();
    }

    public static RunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        if (PROJECT_TRANSFER_CONFIG_RUN.matches(formattedString)) {
            Map matchMap = PROJECT_TRANSFER_CONFIG_RUN.match(formattedString);
            return RunName.ofProjectTransferConfigRunName((String)matchMap.get("project"), (String)matchMap.get("transfer_config"), (String)matchMap.get("run"));
        }
        if (PROJECT_LOCATION_TRANSFER_CONFIG_RUN.matches(formattedString)) {
            Map matchMap = PROJECT_LOCATION_TRANSFER_CONFIG_RUN.match(formattedString);
            return RunName.ofProjectLocationTransferConfigRunName((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("transfer_config"), (String)matchMap.get("run"));
        }
        throw new ValidationException("RunName.parse: formattedString not in valid format", new Object[0]);
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_TRANSFER_CONFIG_RUN.matches(formattedString) || PROJECT_LOCATION_TRANSFER_CONFIG_RUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            RunName runName = this;
            synchronized (runName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.transferConfig != null) {
                        fieldMapBuilder.put((Object)"transfer_config", (Object)this.transferConfig);
                    }
                    if (this.run != null) {
                        fieldMapBuilder.put((Object)"run", (Object)this.run);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return this.fixedValue != null ? this.fixedValue : this.pathTemplate.instantiate(this.getFieldValuesMap());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            RunName that = (RunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.transferConfig, that.transferConfig) && Objects.equals(this.run, that.run) && Objects.equals(this.location, that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.fixedValue);
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.transferConfig);
        h *= 1000003;
        h ^= Objects.hashCode(this.run);
        h *= 1000003;
        return h ^= Objects.hashCode(this.location);
    }

    public static class ProjectLocationTransferConfigRunBuilder {
        private String project;
        private String location;
        private String transferConfig;
        private String run;

        protected ProjectLocationTransferConfigRunBuilder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public String getRun() {
            return this.run;
        }

        public ProjectLocationTransferConfigRunBuilder setProject(String project) {
            this.project = project;
            return this;
        }

        public ProjectLocationTransferConfigRunBuilder setLocation(String location) {
            this.location = location;
            return this;
        }

        public ProjectLocationTransferConfigRunBuilder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public ProjectLocationTransferConfigRunBuilder setRun(String run) {
            this.run = run;
            return this;
        }

        public RunName build() {
            return new RunName(this);
        }
    }

    public static class Builder {
        private String project;
        private String transferConfig;
        private String run;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder(RunName runName) {
            Preconditions.checkArgument((boolean)Objects.equals(runName.pathTemplate, PROJECT_TRANSFER_CONFIG_RUN), (Object)"toBuilder is only supported when RunName has the pattern of projects/{project}/transferConfigs/{transfer_config}/runs/{run}");
            this.project = runName.project;
            this.transferConfig = runName.transferConfig;
            this.run = runName.run;
        }

        public RunName build() {
            return new RunName(this);
        }
    }
}

