/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class ProjectTransferConfigName
extends TransferConfigName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String transferConfig;

    @Override
    public String getProject() {
        return this.project;
    }

    @Override
    public String getTransferConfig() {
        return this.transferConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    @Override
    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectTransferConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
    }

    public static ProjectTransferConfigName of(String project, String transferConfig) {
        return ProjectTransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build();
    }

    public static String format(String project, String transferConfig) {
        return ProjectTransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build().toString();
    }

    public static ProjectTransferConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectTransferConfigName.parse: formattedString not in valid format");
        return ProjectTransferConfigName.of((String)matchMap.get("project"), (String)matchMap.get("transfer_config"));
    }

    public static List<ProjectTransferConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectTransferConfigName> list = new ArrayList<ProjectTransferConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectTransferConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectTransferConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectTransferConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectTransferConfigName projectTransferConfigName = this;
            synchronized (projectTransferConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"transferConfig", (Object)this.transferConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    @Override
    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Override
    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "transfer_config", this.transferConfig});
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectTransferConfigName) {
            ProjectTransferConfigName that = (ProjectTransferConfigName)o;
            return this.project.equals(that.project) && this.transferConfig.equals(that.transferConfig);
        }
        return false;
    }

    @Override
    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.transferConfig.hashCode();
    }

    public static class Builder
    extends TransferConfigName.Builder {
        private String project;
        private String transferConfig;

        @Override
        public String getProject() {
            return this.project;
        }

        @Override
        public String getTransferConfig() {
            return this.transferConfig;
        }

        @Override
        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        @Override
        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectTransferConfigName projectTransferConfigName) {
            this.project = projectTransferConfigName.project;
            this.transferConfig = projectTransferConfigName.transferConfig;
        }

        @Override
        public ProjectTransferConfigName build() {
            return new ProjectTransferConfigName(this);
        }
    }
}

