/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class ProjectDataSourceName
extends DataSourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dataSources/{data_source}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String dataSource;

    public String getProject() {
        return this.project;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectDataSourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataSource = (String)Preconditions.checkNotNull((Object)builder.getDataSource());
    }

    public static ProjectDataSourceName of(String project, String dataSource) {
        return ProjectDataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build();
    }

    public static String format(String project, String dataSource) {
        return ProjectDataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build().toString();
    }

    public static ProjectDataSourceName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectDataSourceName.parse: formattedString not in valid format");
        return ProjectDataSourceName.of((String)matchMap.get("project"), (String)matchMap.get("data_source"));
    }

    public static List<ProjectDataSourceName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectDataSourceName> list = new ArrayList<ProjectDataSourceName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectDataSourceName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectDataSourceName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectDataSourceName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectDataSourceName projectDataSourceName = this;
            synchronized (projectDataSourceName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"dataSource", (Object)this.dataSource);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "data_source", this.dataSource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectDataSourceName) {
            ProjectDataSourceName that = (ProjectDataSourceName)o;
            return this.project.equals(that.project) && this.dataSource.equals(that.dataSource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.dataSource.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataSource;

        public String getProject() {
            return this.project;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectDataSourceName projectDataSourceName) {
            this.project = projectDataSourceName.project;
            this.dataSource = projectDataSourceName.dataSource;
        }

        public ProjectDataSourceName build() {
            return new ProjectDataSourceName(this);
        }
    }
}

