/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.bigquery.datatransfer.v1.RunName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@Deprecated
public class LocationRunName
extends RunName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/transferConfigs/{transfer_config}/runs/{run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String transferConfig;
    private final String run;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public String getRun() {
        return this.run;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
    }

    public static LocationRunName of(String project, String location, String transferConfig, String run) {
        return LocationRunName.newBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).setRun(run).build();
    }

    public static String format(String project, String location, String transferConfig, String run) {
        return LocationRunName.newBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).setRun(run).build().toString();
    }

    public static LocationRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationRunName.parse: formattedString not in valid format");
        return LocationRunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("transfer_config"), (String)matchMap.get("run"));
    }

    public static List<LocationRunName> parseList(List<String> formattedStrings) {
        ArrayList<LocationRunName> list = new ArrayList<LocationRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationRunName locationRunName = this;
            synchronized (locationRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"transferConfig", (Object)this.transferConfig);
                    fieldMapBuilder.put((Object)"run", (Object)this.run);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "transfer_config", this.transferConfig, "run", this.run});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationRunName) {
            LocationRunName that = (LocationRunName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.transferConfig.equals(that.transferConfig) && this.run.equals(that.run);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.transferConfig.hashCode();
        h *= 1000003;
        return h ^= this.run.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String transferConfig;
        private String run;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationRunName locationRunName) {
            this.project = locationRunName.project;
            this.location = locationRunName.location;
            this.transferConfig = locationRunName.transferConfig;
            this.run = locationRunName.run;
        }

        public LocationRunName build() {
            return new LocationRunName(this);
        }
    }
}

