/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class LocationTransferConfigName
extends TransferConfigName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/transferConfigs/{transfer_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String transferConfig;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationTransferConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
    }

    public static LocationTransferConfigName of(String project, String location, String transferConfig) {
        return LocationTransferConfigName.newBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).build();
    }

    public static String format(String project, String location, String transferConfig) {
        return LocationTransferConfigName.newBuilder().setProject(project).setLocation(location).setTransferConfig(transferConfig).build().toString();
    }

    public static LocationTransferConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationTransferConfigName.parse: formattedString not in valid format");
        return LocationTransferConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("transfer_config"));
    }

    public static List<LocationTransferConfigName> parseList(List<String> formattedStrings) {
        ArrayList<LocationTransferConfigName> list = new ArrayList<LocationTransferConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LocationTransferConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LocationTransferConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LocationTransferConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LocationTransferConfigName locationTransferConfigName = this;
            synchronized (locationTransferConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"transferConfig", (Object)this.transferConfig);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    @Deprecated
    public ResourceNameType getType() {
        throw new UnsupportedOperationException("LocationTransferConfigName.getType() not supported");
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "transfer_config", this.transferConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationTransferConfigName) {
            LocationTransferConfigName that = (LocationTransferConfigName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.transferConfig.equals(that.transferConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        return h ^= this.transferConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String transferConfig;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationTransferConfigName locationTransferConfigName) {
            this.project = locationTransferConfigName.project;
            this.location = locationTransferConfigName.location;
            this.transferConfig = locationTransferConfigName.transferConfig;
        }

        public LocationTransferConfigName build() {
            return new LocationTransferConfigName(this);
        }
    }
}

