/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.cloud.bigquery.datatransfer.v1.RunName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class ProjectRunName
extends RunName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}/runs/{run}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String transferConfig;
    private final String run;

    public String getProject() {
        return this.project;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public String getRun() {
        return this.run;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private ProjectRunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
        this.run = (String)Preconditions.checkNotNull((Object)builder.getRun());
    }

    public static ProjectRunName of(String project, String transferConfig, String run) {
        return ProjectRunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build();
    }

    public static String format(String project, String transferConfig, String run) {
        return ProjectRunName.newBuilder().setProject(project).setTransferConfig(transferConfig).setRun(run).build().toString();
    }

    public static ProjectRunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "ProjectRunName.parse: formattedString not in valid format");
        return ProjectRunName.of((String)matchMap.get("project"), (String)matchMap.get("transfer_config"), (String)matchMap.get("run"));
    }

    public static List<ProjectRunName> parseList(List<String> formattedStrings) {
        ArrayList<ProjectRunName> list = new ArrayList<ProjectRunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProjectRunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProjectRunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProjectRunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProjectRunName projectRunName = this;
            synchronized (projectRunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"transferConfig", (Object)this.transferConfig);
                    fieldMapBuilder.put((Object)"run", (Object)this.run);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "transfer_config", this.transferConfig, "run", this.run});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ProjectRunName) {
            ProjectRunName that = (ProjectRunName)o;
            return this.project.equals(that.project) && this.transferConfig.equals(that.transferConfig) && this.run.equals(that.run);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.transferConfig.hashCode();
        h *= 1000003;
        return h ^= this.run.hashCode();
    }

    public static class Builder {
        private String project;
        private String transferConfig;
        private String run;

        public String getProject() {
            return this.project;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public String getRun() {
            return this.run;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        public Builder setRun(String run) {
            this.run = run;
            return this;
        }

        private Builder() {
        }

        private Builder(ProjectRunName projectRunName) {
            this.project = projectRunName.project;
            this.transferConfig = projectRunName.transferConfig;
            this.run = projectRunName.run;
        }

        public ProjectRunName build() {
            return new ProjectRunName(this);
        }
    }
}

