/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.cloud.bigquery.datatransfer.v1.LocationName;
import com.google.cloud.bigquery.datatransfer.v1.ProjectName;
import com.google.common.base.Preconditions;

public class ParentNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public LocationName getLocationName() {
        if (this.resourceName instanceof LocationName) {
            return (LocationName)this.resourceName;
        }
        return null;
    }

    public ProjectName getProjectName() {
        if (this.resourceName instanceof ProjectName) {
            return (ProjectName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private ParentNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static ParentNameOneof parse(String resourceNameString) {
        if (LocationName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(LocationName.parse(resourceNameString));
        }
        if (ProjectName.isParsableFrom(resourceNameString)) {
            return new ParentNameOneof(ProjectName.parse(resourceNameString));
        }
        return new ParentNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static ParentNameOneof from(LocationName locationName) {
        return new ParentNameOneof(locationName);
    }

    public static ParentNameOneof from(ProjectName projectName) {
        return new ParentNameOneof(projectName);
    }

    public static ParentNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new ParentNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof ParentNameOneof) {
            ParentNameOneof that = (ParentNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

