/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.cloud.bigquery.datatransfer.v1.LocationTransferConfigName;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigName;
import com.google.common.base.Preconditions;

public class TransferConfigNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public LocationTransferConfigName getLocationTransferConfigName() {
        if (this.resourceName instanceof LocationTransferConfigName) {
            return (LocationTransferConfigName)this.resourceName;
        }
        return null;
    }

    public TransferConfigName getTransferConfigName() {
        if (this.resourceName instanceof TransferConfigName) {
            return (TransferConfigName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private TransferConfigNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static TransferConfigNameOneof parse(String resourceNameString) {
        if (LocationTransferConfigName.isParsableFrom(resourceNameString)) {
            return new TransferConfigNameOneof(LocationTransferConfigName.parse(resourceNameString));
        }
        if (TransferConfigName.isParsableFrom(resourceNameString)) {
            return new TransferConfigNameOneof(TransferConfigName.parse(resourceNameString));
        }
        return new TransferConfigNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static TransferConfigNameOneof from(LocationTransferConfigName locationTransferConfigName) {
        return new TransferConfigNameOneof(locationTransferConfigName);
    }

    public static TransferConfigNameOneof from(TransferConfigName transferConfigName) {
        return new TransferConfigNameOneof(transferConfigName);
    }

    public static TransferConfigNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new TransferConfigNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TransferConfigNameOneof) {
            TransferConfigNameOneof that = (TransferConfigNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

