/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.TransferConfigNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class TransferConfigName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/transferConfigs/{transfer_config}");
    private final String project;
    private final String transferConfig;

    public String getProject() {
        return this.project;
    }

    public String getTransferConfig() {
        return this.transferConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private TransferConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.transferConfig = (String)Preconditions.checkNotNull((Object)builder.getTransferConfig());
    }

    public static TransferConfigName of(String project, String transferConfig) {
        return TransferConfigName.newBuilder().setProject(project).setTransferConfig(transferConfig).build();
    }

    @Deprecated
    public static TransferConfigName create(String project, String transferConfig) {
        return TransferConfigName.of(project, transferConfig);
    }

    public static TransferConfigName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "TransferConfigName.parse: formattedString not in valid format");
        return TransferConfigName.of((String)matchMap.get("project"), (String)matchMap.get("transfer_config"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return TransferConfigNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "transfer_config", this.transferConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof TransferConfigName) {
            TransferConfigName that = (TransferConfigName)o;
            return this.project.equals(that.project) && this.transferConfig.equals(that.transferConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.transferConfig.hashCode();
    }

    public static class Builder {
        private String project;
        private String transferConfig;

        public String getProject() {
            return this.project;
        }

        public String getTransferConfig() {
            return this.transferConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setTransferConfig(String transferConfig) {
            this.transferConfig = transferConfig;
            return this;
        }

        private Builder() {
        }

        private Builder(TransferConfigName transferConfigName) {
            this.project = transferConfigName.project;
            this.transferConfig = transferConfigName.transferConfig;
        }

        public TransferConfigName build() {
            return new TransferConfigName(this);
        }
    }
}

