/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.api.resourcenames.UntypedResourceName;
import com.google.cloud.bigquery.datatransfer.v1.LocationRunName;
import com.google.cloud.bigquery.datatransfer.v1.RunName;
import com.google.common.base.Preconditions;

public class RunNameOneof
implements ResourceName {
    private final ResourceName resourceName;

    public LocationRunName getLocationRunName() {
        if (this.resourceName instanceof LocationRunName) {
            return (LocationRunName)this.resourceName;
        }
        return null;
    }

    public RunName getRunName() {
        if (this.resourceName instanceof RunName) {
            return (RunName)this.resourceName;
        }
        return null;
    }

    public UntypedResourceName getUntypedResourceName() {
        if (this.resourceName instanceof UntypedResourceName) {
            return (UntypedResourceName)this.resourceName;
        }
        return null;
    }

    public ResourceName getResourceName() {
        return this.resourceName;
    }

    public ResourceNameType getType() {
        return this.getResourceName().getType();
    }

    private RunNameOneof(ResourceName resourceName) {
        this.resourceName = (ResourceName)Preconditions.checkNotNull((Object)resourceName);
    }

    public static RunNameOneof parse(String resourceNameString) {
        if (LocationRunName.isParsableFrom(resourceNameString)) {
            return new RunNameOneof(LocationRunName.parse(resourceNameString));
        }
        if (RunName.isParsableFrom(resourceNameString)) {
            return new RunNameOneof(RunName.parse(resourceNameString));
        }
        return new RunNameOneof((ResourceName)UntypedResourceName.parse((String)resourceNameString));
    }

    public static RunNameOneof from(LocationRunName locationRunName) {
        return new RunNameOneof(locationRunName);
    }

    public static RunNameOneof from(RunName runName) {
        return new RunNameOneof(runName);
    }

    public static RunNameOneof fromUntyped(UntypedResourceName untypedResourceName) {
        return new RunNameOneof((ResourceName)untypedResourceName);
    }

    public String toString() {
        return this.getResourceName().toString();
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof RunNameOneof) {
            RunNameOneof that = (RunNameOneof)o;
            return this.resourceName.equals(that.resourceName);
        }
        return false;
    }

    public int hashCode() {
        return this.resourceName.hashCode();
    }
}

