/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.LocationNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class LocationName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}");
    private final String project;
    private final String location;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private LocationName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
    }

    public static LocationName of(String project, String location) {
        return LocationName.newBuilder().setProject(project).setLocation(location).build();
    }

    @Deprecated
    public static LocationName create(String project, String location) {
        return LocationName.of(project, location);
    }

    public static LocationName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "LocationName.parse: formattedString not in valid format");
        return LocationName.of((String)matchMap.get("project"), (String)matchMap.get("location"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return LocationNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LocationName) {
            LocationName that = (LocationName)o;
            return this.project.equals(that.project) && this.location.equals(that.location);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.location.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        private Builder() {
        }

        private Builder(LocationName locationName) {
            this.project = locationName.project;
            this.location = locationName.location;
        }

        public LocationName build() {
            return new LocationName(this);
        }
    }
}

