/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.bigquery.datatransfer.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.api.resourcenames.ResourceNameType;
import com.google.cloud.bigquery.datatransfer.v1.DataSourceNameType;
import com.google.common.base.Preconditions;
import java.util.Map;

public class DataSourceName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/dataSources/{data_source}");
    private final String project;
    private final String dataSource;

    public String getProject() {
        return this.project;
    }

    public String getDataSource() {
        return this.dataSource;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private DataSourceName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.dataSource = (String)Preconditions.checkNotNull((Object)builder.getDataSource());
    }

    public static DataSourceName of(String project, String dataSource) {
        return DataSourceName.newBuilder().setProject(project).setDataSource(dataSource).build();
    }

    @Deprecated
    public static DataSourceName create(String project, String dataSource) {
        return DataSourceName.of(project, dataSource);
    }

    public static DataSourceName parse(String formattedString) {
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "DataSourceName.parse: formattedString not in valid format");
        return DataSourceName.of((String)matchMap.get("project"), (String)matchMap.get("data_source"));
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    public ResourceNameType getType() {
        return DataSourceNameType.instance();
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "data_source", this.dataSource});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof DataSourceName) {
            DataSourceName that = (DataSourceName)o;
            return this.project.equals(that.project) && this.dataSource.equals(that.dataSource);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        return h ^= this.dataSource.hashCode();
    }

    public static class Builder {
        private String project;
        private String dataSource;

        public String getProject() {
            return this.project;
        }

        public String getDataSource() {
            return this.dataSource;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setDataSource(String dataSource) {
            this.dataSource = dataSource;
            return this;
        }

        private Builder() {
        }

        private Builder(DataSourceName dataSourceName) {
            this.project = dataSourceName.project;
            this.dataSource = dataSourceName.dataSource;
        }

        public DataSourceName build() {
            return new DataSourceName(this);
        }
    }
}

