/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class LunName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOLUME_LUN = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/volumes/{volume}/luns/{lun}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String volume;
    private final String lun;

    @Deprecated
    protected LunName() {
        this.project = null;
        this.location = null;
        this.volume = null;
        this.lun = null;
    }

    private LunName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.volume = (String)Preconditions.checkNotNull((Object)builder.getVolume());
        this.lun = (String)Preconditions.checkNotNull((Object)builder.getLun());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getLun() {
        return this.lun;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static LunName of(String project, String location, String volume, String lun) {
        return LunName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setLun(lun).build();
    }

    public static String format(String project, String location, String volume, String lun) {
        return LunName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setLun(lun).build().toString();
    }

    public static LunName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOLUME_LUN.validatedMatch(formattedString, "LunName.parse: formattedString not in valid format");
        return LunName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("volume"), (String)matchMap.get("lun"));
    }

    public static List<LunName> parseList(List<String> formattedStrings) {
        ArrayList<LunName> list = new ArrayList<LunName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(LunName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<LunName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (LunName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOLUME_LUN.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            LunName lunName = this;
            synchronized (lunName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.volume != null) {
                        fieldMapBuilder.put((Object)"volume", (Object)this.volume);
                    }
                    if (this.lun != null) {
                        fieldMapBuilder.put((Object)"lun", (Object)this.lun);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOLUME_LUN.instantiate(new String[]{"project", this.project, "location", this.location, "volume", this.volume, "lun", this.lun});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            LunName that = (LunName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.volume, that.volume) && Objects.equals(this.lun, that.lun);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.volume);
        h *= 1000003;
        return h ^= Objects.hashCode(this.lun);
    }

    public static class Builder {
        private String project;
        private String location;
        private String volume;
        private String lun;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getLun() {
            return this.lun;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder setLun(String lun) {
            this.lun = lun;
            return this;
        }

        private Builder(LunName lunName) {
            this.project = lunName.project;
            this.location = lunName.location;
            this.volume = lunName.volume;
            this.lun = lunName.lun;
        }

        public LunName build() {
            return new LunName(this);
        }
    }
}

