/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SshKeyName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_SSH_KEY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/sshKeys/{ssh_key}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String sshKey;

    @Deprecated
    protected SshKeyName() {
        this.project = null;
        this.location = null;
        this.sshKey = null;
    }

    private SshKeyName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.sshKey = (String)Preconditions.checkNotNull((Object)builder.getSshKey());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getSshKey() {
        return this.sshKey;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SshKeyName of(String project, String location, String sshKey) {
        return SshKeyName.newBuilder().setProject(project).setLocation(location).setSshKey(sshKey).build();
    }

    public static String format(String project, String location, String sshKey) {
        return SshKeyName.newBuilder().setProject(project).setLocation(location).setSshKey(sshKey).build().toString();
    }

    public static SshKeyName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_SSH_KEY.validatedMatch(formattedString, "SshKeyName.parse: formattedString not in valid format");
        return SshKeyName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("ssh_key"));
    }

    public static List<SshKeyName> parseList(List<String> formattedStrings) {
        ArrayList<SshKeyName> list = new ArrayList<SshKeyName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SshKeyName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SshKeyName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SshKeyName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_SSH_KEY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SshKeyName sshKeyName = this;
            synchronized (sshKeyName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.sshKey != null) {
                        fieldMapBuilder.put((Object)"ssh_key", (Object)this.sshKey);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_SSH_KEY.instantiate(new String[]{"project", this.project, "location", this.location, "ssh_key", this.sshKey});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            SshKeyName that = (SshKeyName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.sshKey, that.sshKey);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.sshKey);
    }

    public static class Builder {
        private String project;
        private String location;
        private String sshKey;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getSshKey() {
            return this.sshKey;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setSshKey(String sshKey) {
            this.sshKey = sshKey;
            return this;
        }

        private Builder(SshKeyName sshKeyName) {
            this.project = sshKeyName.project;
            this.location = sshKeyName.location;
            this.sshKey = sshKeyName.sshKey;
        }

        public SshKeyName build() {
            return new SshKeyName(this);
        }
    }
}

