/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class VolumeSnapshotName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_VOLUME_SNAPSHOT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/volumes/{volume}/snapshots/{snapshot}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String volume;
    private final String snapshot;

    @Deprecated
    protected VolumeSnapshotName() {
        this.project = null;
        this.location = null;
        this.volume = null;
        this.snapshot = null;
    }

    private VolumeSnapshotName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.volume = (String)Preconditions.checkNotNull((Object)builder.getVolume());
        this.snapshot = (String)Preconditions.checkNotNull((Object)builder.getSnapshot());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getVolume() {
        return this.volume;
    }

    public String getSnapshot() {
        return this.snapshot;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static VolumeSnapshotName of(String project, String location, String volume, String snapshot) {
        return VolumeSnapshotName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setSnapshot(snapshot).build();
    }

    public static String format(String project, String location, String volume, String snapshot) {
        return VolumeSnapshotName.newBuilder().setProject(project).setLocation(location).setVolume(volume).setSnapshot(snapshot).build().toString();
    }

    public static VolumeSnapshotName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_VOLUME_SNAPSHOT.validatedMatch(formattedString, "VolumeSnapshotName.parse: formattedString not in valid format");
        return VolumeSnapshotName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("volume"), (String)matchMap.get("snapshot"));
    }

    public static List<VolumeSnapshotName> parseList(List<String> formattedStrings) {
        ArrayList<VolumeSnapshotName> list = new ArrayList<VolumeSnapshotName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(VolumeSnapshotName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<VolumeSnapshotName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (VolumeSnapshotName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_VOLUME_SNAPSHOT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            VolumeSnapshotName volumeSnapshotName = this;
            synchronized (volumeSnapshotName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.volume != null) {
                        fieldMapBuilder.put((Object)"volume", (Object)this.volume);
                    }
                    if (this.snapshot != null) {
                        fieldMapBuilder.put((Object)"snapshot", (Object)this.snapshot);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_VOLUME_SNAPSHOT.instantiate(new String[]{"project", this.project, "location", this.location, "volume", this.volume, "snapshot", this.snapshot});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            VolumeSnapshotName that = (VolumeSnapshotName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.volume, that.volume) && Objects.equals(this.snapshot, that.snapshot);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.volume);
        h *= 1000003;
        return h ^= Objects.hashCode(this.snapshot);
    }

    public static class Builder {
        private String project;
        private String location;
        private String volume;
        private String snapshot;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getVolume() {
            return this.volume;
        }

        public String getSnapshot() {
            return this.snapshot;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setVolume(String volume) {
            this.volume = volume;
            return this;
        }

        public Builder setSnapshot(String snapshot) {
            this.snapshot = snapshot;
            return this;
        }

        private Builder(VolumeSnapshotName volumeSnapshotName) {
            this.project = volumeSnapshotName.project;
            this.location = volumeSnapshotName.location;
            this.volume = volumeSnapshotName.volume;
            this.snapshot = volumeSnapshotName.snapshot;
        }

        public VolumeSnapshotName build() {
            return new VolumeSnapshotName(this);
        }
    }
}

