/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.baremetalsolution.v2;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ProvisioningConfigName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_PROVISIONING_CONFIG = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/provisioningConfigs/{provisioning_config}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String provisioningConfig;

    @Deprecated
    protected ProvisioningConfigName() {
        this.project = null;
        this.location = null;
        this.provisioningConfig = null;
    }

    private ProvisioningConfigName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.provisioningConfig = (String)Preconditions.checkNotNull((Object)builder.getProvisioningConfig());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getProvisioningConfig() {
        return this.provisioningConfig;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ProvisioningConfigName of(String project, String location, String provisioningConfig) {
        return ProvisioningConfigName.newBuilder().setProject(project).setLocation(location).setProvisioningConfig(provisioningConfig).build();
    }

    public static String format(String project, String location, String provisioningConfig) {
        return ProvisioningConfigName.newBuilder().setProject(project).setLocation(location).setProvisioningConfig(provisioningConfig).build().toString();
    }

    public static ProvisioningConfigName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_PROVISIONING_CONFIG.validatedMatch(formattedString, "ProvisioningConfigName.parse: formattedString not in valid format");
        return ProvisioningConfigName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("provisioning_config"));
    }

    public static List<ProvisioningConfigName> parseList(List<String> formattedStrings) {
        ArrayList<ProvisioningConfigName> list = new ArrayList<ProvisioningConfigName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ProvisioningConfigName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ProvisioningConfigName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ProvisioningConfigName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_PROVISIONING_CONFIG.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ProvisioningConfigName provisioningConfigName = this;
            synchronized (provisioningConfigName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.provisioningConfig != null) {
                        fieldMapBuilder.put((Object)"provisioning_config", (Object)this.provisioningConfig);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_PROVISIONING_CONFIG.instantiate(new String[]{"project", this.project, "location", this.location, "provisioning_config", this.provisioningConfig});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ProvisioningConfigName that = (ProvisioningConfigName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.provisioningConfig, that.provisioningConfig);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        return h ^= Objects.hashCode(this.provisioningConfig);
    }

    public static class Builder {
        private String project;
        private String location;
        private String provisioningConfig;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getProvisioningConfig() {
            return this.provisioningConfig;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setProvisioningConfig(String provisioningConfig) {
            this.provisioningConfig = provisioningConfig;
            return this;
        }

        private Builder(ProvisioningConfigName provisioningConfigName) {
            this.project = provisioningConfigName.project;
            this.location = provisioningConfigName.location;
            this.provisioningConfig = provisioningConfigName.provisioningConfig;
        }

        public ProvisioningConfigName build() {
            return new ProvisioningConfigName(this);
        }
    }
}

