/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.assuredworkloads.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class ViolationName
implements ResourceName {
    private static final PathTemplate ORGANIZATION_LOCATION_WORKLOAD_VIOLATION = PathTemplate.createWithoutUrlEncoding((String)"organizations/{organization}/locations/{location}/workloads/{workload}/violations/{violation}");
    private volatile Map<String, String> fieldValuesMap;
    private final String organization;
    private final String location;
    private final String workload;
    private final String violation;

    @Deprecated
    protected ViolationName() {
        this.organization = null;
        this.location = null;
        this.workload = null;
        this.violation = null;
    }

    private ViolationName(Builder builder) {
        this.organization = (String)Preconditions.checkNotNull((Object)builder.getOrganization());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.workload = (String)Preconditions.checkNotNull((Object)builder.getWorkload());
        this.violation = (String)Preconditions.checkNotNull((Object)builder.getViolation());
    }

    public String getOrganization() {
        return this.organization;
    }

    public String getLocation() {
        return this.location;
    }

    public String getWorkload() {
        return this.workload;
    }

    public String getViolation() {
        return this.violation;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static ViolationName of(String organization, String location, String workload, String violation) {
        return ViolationName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).setViolation(violation).build();
    }

    public static String format(String organization, String location, String workload, String violation) {
        return ViolationName.newBuilder().setOrganization(organization).setLocation(location).setWorkload(workload).setViolation(violation).build().toString();
    }

    public static ViolationName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = ORGANIZATION_LOCATION_WORKLOAD_VIOLATION.validatedMatch(formattedString, "ViolationName.parse: formattedString not in valid format");
        return ViolationName.of((String)matchMap.get("organization"), (String)matchMap.get("location"), (String)matchMap.get("workload"), (String)matchMap.get("violation"));
    }

    public static List<ViolationName> parseList(List<String> formattedStrings) {
        ArrayList<ViolationName> list = new ArrayList<ViolationName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(ViolationName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<ViolationName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (ViolationName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return ORGANIZATION_LOCATION_WORKLOAD_VIOLATION.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            ViolationName violationName = this;
            synchronized (violationName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.organization != null) {
                        fieldMapBuilder.put((Object)"organization", (Object)this.organization);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.workload != null) {
                        fieldMapBuilder.put((Object)"workload", (Object)this.workload);
                    }
                    if (this.violation != null) {
                        fieldMapBuilder.put((Object)"violation", (Object)this.violation);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return ORGANIZATION_LOCATION_WORKLOAD_VIOLATION.instantiate(new String[]{"organization", this.organization, "location", this.location, "workload", this.workload, "violation", this.violation});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            ViolationName that = (ViolationName)o;
            return Objects.equals(this.organization, that.organization) && Objects.equals(this.location, that.location) && Objects.equals(this.workload, that.workload) && Objects.equals(this.violation, that.violation);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.organization);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.workload);
        h *= 1000003;
        return h ^= Objects.hashCode(this.violation);
    }

    public static class Builder {
        private String organization;
        private String location;
        private String workload;
        private String violation;

        protected Builder() {
        }

        public String getOrganization() {
            return this.organization;
        }

        public String getLocation() {
            return this.location;
        }

        public String getWorkload() {
            return this.workload;
        }

        public String getViolation() {
            return this.violation;
        }

        public Builder setOrganization(String organization) {
            this.organization = organization;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setWorkload(String workload) {
            this.workload = workload;
            return this;
        }

        public Builder setViolation(String violation) {
            this.violation = violation;
            return this;
        }

        private Builder(ViolationName violationName) {
            this.organization = violationName.organization;
            this.location = violationName.location;
            this.workload = violationName.workload;
            this.violation = violationName.violation;
        }

        public ViolationName build() {
            return new ViolationName(this);
        }
    }
}

