/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class SavedQueryName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_DATASET_SAVED_QUERY = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/savedQueries/{saved_query}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String savedQuery;

    @Deprecated
    protected SavedQueryName() {
        this.project = null;
        this.location = null;
        this.dataset = null;
        this.savedQuery = null;
    }

    private SavedQueryName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.savedQuery = (String)Preconditions.checkNotNull((Object)builder.getSavedQuery());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getSavedQuery() {
        return this.savedQuery;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static SavedQueryName of(String project, String location, String dataset, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setSavedQuery(savedQuery).build();
    }

    public static String format(String project, String location, String dataset, String savedQuery) {
        return SavedQueryName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setSavedQuery(savedQuery).build().toString();
    }

    public static SavedQueryName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_DATASET_SAVED_QUERY.validatedMatch(formattedString, "SavedQueryName.parse: formattedString not in valid format");
        return SavedQueryName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("saved_query"));
    }

    public static List<SavedQueryName> parseList(List<String> formattedStrings) {
        ArrayList<SavedQueryName> list = new ArrayList<SavedQueryName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(SavedQueryName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<SavedQueryName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (SavedQueryName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_DATASET_SAVED_QUERY.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            SavedQueryName savedQueryName = this;
            synchronized (savedQueryName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.dataset != null) {
                        fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    }
                    if (this.savedQuery != null) {
                        fieldMapBuilder.put((Object)"saved_query", (Object)this.savedQuery);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_DATASET_SAVED_QUERY.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "saved_query", this.savedQuery});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            SavedQueryName that = (SavedQueryName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.dataset, that.dataset) && Objects.equals(this.savedQuery, that.savedQuery);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.dataset);
        h *= 1000003;
        return h ^= Objects.hashCode(this.savedQuery);
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String savedQuery;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getSavedQuery() {
            return this.savedQuery;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setSavedQuery(String savedQuery) {
            this.savedQuery = savedQuery;
            return this;
        }

        private Builder(SavedQueryName savedQueryName) {
            this.project = savedQueryName.project;
            this.location = savedQueryName.location;
            this.dataset = savedQueryName.dataset;
            this.savedQuery = savedQueryName.savedQuery;
        }

        public SavedQueryName build() {
            return new SavedQueryName(this);
        }
    }
}

