/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1beta1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

public class AnnotationSpecName
implements ResourceName {
    private static final PathTemplate PATH_TEMPLATE = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/datasets/{dataset}/annotationSpecs/{annotation_spec}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String dataset;
    private final String annotationSpec;

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getDataset() {
        return this.dataset;
    }

    public String getAnnotationSpec() {
        return this.annotationSpec;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    private AnnotationSpecName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.dataset = (String)Preconditions.checkNotNull((Object)builder.getDataset());
        this.annotationSpec = (String)Preconditions.checkNotNull((Object)builder.getAnnotationSpec());
    }

    public static AnnotationSpecName of(String project, String location, String dataset, String annotationSpec) {
        return AnnotationSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setAnnotationSpec(annotationSpec).build();
    }

    public static String format(String project, String location, String dataset, String annotationSpec) {
        return AnnotationSpecName.newBuilder().setProject(project).setLocation(location).setDataset(dataset).setAnnotationSpec(annotationSpec).build().toString();
    }

    public static AnnotationSpecName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PATH_TEMPLATE.validatedMatch(formattedString, "AnnotationSpecName.parse: formattedString not in valid format");
        return AnnotationSpecName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("dataset"), (String)matchMap.get("annotation_spec"));
    }

    public static List<AnnotationSpecName> parseList(List<String> formattedStrings) {
        ArrayList<AnnotationSpecName> list = new ArrayList<AnnotationSpecName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(AnnotationSpecName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<AnnotationSpecName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (AnnotationSpecName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PATH_TEMPLATE.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            AnnotationSpecName annotationSpecName = this;
            synchronized (annotationSpecName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    fieldMapBuilder.put((Object)"project", (Object)this.project);
                    fieldMapBuilder.put((Object)"location", (Object)this.location);
                    fieldMapBuilder.put((Object)"dataset", (Object)this.dataset);
                    fieldMapBuilder.put((Object)"annotationSpec", (Object)this.annotationSpec);
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PATH_TEMPLATE.instantiate(new String[]{"project", this.project, "location", this.location, "dataset", this.dataset, "annotation_spec", this.annotationSpec});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof AnnotationSpecName) {
            AnnotationSpecName that = (AnnotationSpecName)o;
            return this.project.equals(that.project) && this.location.equals(that.location) && this.dataset.equals(that.dataset) && this.annotationSpec.equals(that.annotationSpec);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= this.project.hashCode();
        h *= 1000003;
        h ^= this.location.hashCode();
        h *= 1000003;
        h ^= this.dataset.hashCode();
        h *= 1000003;
        return h ^= this.annotationSpec.hashCode();
    }

    public static class Builder {
        private String project;
        private String location;
        private String dataset;
        private String annotationSpec;

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getDataset() {
            return this.dataset;
        }

        public String getAnnotationSpec() {
            return this.annotationSpec;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setDataset(String dataset) {
            this.dataset = dataset;
            return this;
        }

        public Builder setAnnotationSpec(String annotationSpec) {
            this.annotationSpec = annotationSpec;
            return this;
        }

        private Builder() {
        }

        private Builder(AnnotationSpecName annotationSpecName) {
            this.project = annotationSpecName.project;
            this.location = annotationSpecName.location;
            this.dataset = annotationSpecName.dataset;
            this.annotationSpec = annotationSpecName.annotationSpec;
        }

        public AnnotationSpecName build() {
            return new AnnotationSpecName(this);
        }
    }
}

