/*
 * Copyright 2025 Google LLC
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     https://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
// Generated by the protocol buffer compiler.  DO NOT EDIT!
// source: google/cloud/aiplatform/v1/custom_job.proto

// Protobuf Java Version: 3.25.5
package com.google.cloud.aiplatform.v1;

/**
 *
 *
 * <pre>
 * The spec of a Container.
 * </pre>
 *
 * Protobuf type {@code google.cloud.aiplatform.v1.ContainerSpec}
 */
public final class ContainerSpec extends com.google.protobuf.GeneratedMessageV3
    implements
    // @@protoc_insertion_point(message_implements:google.cloud.aiplatform.v1.ContainerSpec)
    ContainerSpecOrBuilder {
  private static final long serialVersionUID = 0L;

  // Use ContainerSpec.newBuilder() to construct.
  private ContainerSpec(com.google.protobuf.GeneratedMessageV3.Builder<?> builder) {
    super(builder);
  }

  private ContainerSpec() {
    imageUri_ = "";
    command_ = com.google.protobuf.LazyStringArrayList.emptyList();
    args_ = com.google.protobuf.LazyStringArrayList.emptyList();
    env_ = java.util.Collections.emptyList();
  }

  @java.lang.Override
  @SuppressWarnings({"unused"})
  protected java.lang.Object newInstance(UnusedPrivateParameter unused) {
    return new ContainerSpec();
  }

  public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_ContainerSpec_descriptor;
  }

  @java.lang.Override
  protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
      internalGetFieldAccessorTable() {
    return com.google.cloud.aiplatform.v1.CustomJobProto
        .internal_static_google_cloud_aiplatform_v1_ContainerSpec_fieldAccessorTable
        .ensureFieldAccessorsInitialized(
            com.google.cloud.aiplatform.v1.ContainerSpec.class,
            com.google.cloud.aiplatform.v1.ContainerSpec.Builder.class);
  }

  public static final int IMAGE_URI_FIELD_NUMBER = 1;

  @SuppressWarnings("serial")
  private volatile java.lang.Object imageUri_ = "";

  /**
   *
   *
   * <pre>
   * Required. The URI of a container image in the Container Registry that is to
   * be run on each worker replica.
   * </pre>
   *
   * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The imageUri.
   */
  @java.lang.Override
  public java.lang.String getImageUri() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      return (java.lang.String) ref;
    } else {
      com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
      java.lang.String s = bs.toStringUtf8();
      imageUri_ = s;
      return s;
    }
  }

  /**
   *
   *
   * <pre>
   * Required. The URI of a container image in the Container Registry that is to
   * be run on each worker replica.
   * </pre>
   *
   * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
   *
   * @return The bytes for imageUri.
   */
  @java.lang.Override
  public com.google.protobuf.ByteString getImageUriBytes() {
    java.lang.Object ref = imageUri_;
    if (ref instanceof java.lang.String) {
      com.google.protobuf.ByteString b =
          com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
      imageUri_ = b;
      return b;
    } else {
      return (com.google.protobuf.ByteString) ref;
    }
  }

  public static final int COMMAND_FIELD_NUMBER = 2;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList command_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The command to be invoked when the container is started.
   * It overrides the entrypoint instruction in Dockerfile when provided.
   * </pre>
   *
   * <code>repeated string command = 2;</code>
   *
   * @return A list containing the command.
   */
  public com.google.protobuf.ProtocolStringList getCommandList() {
    return command_;
  }

  /**
   *
   *
   * <pre>
   * The command to be invoked when the container is started.
   * It overrides the entrypoint instruction in Dockerfile when provided.
   * </pre>
   *
   * <code>repeated string command = 2;</code>
   *
   * @return The count of command.
   */
  public int getCommandCount() {
    return command_.size();
  }

  /**
   *
   *
   * <pre>
   * The command to be invoked when the container is started.
   * It overrides the entrypoint instruction in Dockerfile when provided.
   * </pre>
   *
   * <code>repeated string command = 2;</code>
   *
   * @param index The index of the element to return.
   * @return The command at the given index.
   */
  public java.lang.String getCommand(int index) {
    return command_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The command to be invoked when the container is started.
   * It overrides the entrypoint instruction in Dockerfile when provided.
   * </pre>
   *
   * <code>repeated string command = 2;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the command at the given index.
   */
  public com.google.protobuf.ByteString getCommandBytes(int index) {
    return command_.getByteString(index);
  }

  public static final int ARGS_FIELD_NUMBER = 3;

  @SuppressWarnings("serial")
  private com.google.protobuf.LazyStringArrayList args_ =
      com.google.protobuf.LazyStringArrayList.emptyList();

  /**
   *
   *
   * <pre>
   * The arguments to be passed when starting the container.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return A list containing the args.
   */
  public com.google.protobuf.ProtocolStringList getArgsList() {
    return args_;
  }

  /**
   *
   *
   * <pre>
   * The arguments to be passed when starting the container.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @return The count of args.
   */
  public int getArgsCount() {
    return args_.size();
  }

  /**
   *
   *
   * <pre>
   * The arguments to be passed when starting the container.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the element to return.
   * @return The args at the given index.
   */
  public java.lang.String getArgs(int index) {
    return args_.get(index);
  }

  /**
   *
   *
   * <pre>
   * The arguments to be passed when starting the container.
   * </pre>
   *
   * <code>repeated string args = 3;</code>
   *
   * @param index The index of the value to return.
   * @return The bytes of the args at the given index.
   */
  public com.google.protobuf.ByteString getArgsBytes(int index) {
    return args_.getByteString(index);
  }

  public static final int ENV_FIELD_NUMBER = 4;

  @SuppressWarnings("serial")
  private java.util.List<com.google.cloud.aiplatform.v1.EnvVar> env_;

  /**
   *
   *
   * <pre>
   * Environment variables to be passed to the container.
   * Maximum limit is 100.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
   */
  @java.lang.Override
  public java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * Environment variables to be passed to the container.
   * Maximum limit is 100.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
   */
  @java.lang.Override
  public java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
      getEnvOrBuilderList() {
    return env_;
  }

  /**
   *
   *
   * <pre>
   * Environment variables to be passed to the container.
   * Maximum limit is 100.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
   */
  @java.lang.Override
  public int getEnvCount() {
    return env_.size();
  }

  /**
   *
   *
   * <pre>
   * Environment variables to be passed to the container.
   * Maximum limit is 100.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EnvVar getEnv(int index) {
    return env_.get(index);
  }

  /**
   *
   *
   * <pre>
   * Environment variables to be passed to the container.
   * Maximum limit is 100.
   * </pre>
   *
   * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
   */
  @java.lang.Override
  public com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index) {
    return env_.get(index);
  }

  private byte memoizedIsInitialized = -1;

  @java.lang.Override
  public final boolean isInitialized() {
    byte isInitialized = memoizedIsInitialized;
    if (isInitialized == 1) return true;
    if (isInitialized == 0) return false;

    memoizedIsInitialized = 1;
    return true;
  }

  @java.lang.Override
  public void writeTo(com.google.protobuf.CodedOutputStream output) throws java.io.IOException {
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 1, imageUri_);
    }
    for (int i = 0; i < command_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 2, command_.getRaw(i));
    }
    for (int i = 0; i < args_.size(); i++) {
      com.google.protobuf.GeneratedMessageV3.writeString(output, 3, args_.getRaw(i));
    }
    for (int i = 0; i < env_.size(); i++) {
      output.writeMessage(4, env_.get(i));
    }
    getUnknownFields().writeTo(output);
  }

  @java.lang.Override
  public int getSerializedSize() {
    int size = memoizedSize;
    if (size != -1) return size;

    size = 0;
    if (!com.google.protobuf.GeneratedMessageV3.isStringEmpty(imageUri_)) {
      size += com.google.protobuf.GeneratedMessageV3.computeStringSize(1, imageUri_);
    }
    {
      int dataSize = 0;
      for (int i = 0; i < command_.size(); i++) {
        dataSize += computeStringSizeNoTag(command_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getCommandList().size();
    }
    {
      int dataSize = 0;
      for (int i = 0; i < args_.size(); i++) {
        dataSize += computeStringSizeNoTag(args_.getRaw(i));
      }
      size += dataSize;
      size += 1 * getArgsList().size();
    }
    for (int i = 0; i < env_.size(); i++) {
      size += com.google.protobuf.CodedOutputStream.computeMessageSize(4, env_.get(i));
    }
    size += getUnknownFields().getSerializedSize();
    memoizedSize = size;
    return size;
  }

  @java.lang.Override
  public boolean equals(final java.lang.Object obj) {
    if (obj == this) {
      return true;
    }
    if (!(obj instanceof com.google.cloud.aiplatform.v1.ContainerSpec)) {
      return super.equals(obj);
    }
    com.google.cloud.aiplatform.v1.ContainerSpec other =
        (com.google.cloud.aiplatform.v1.ContainerSpec) obj;

    if (!getImageUri().equals(other.getImageUri())) return false;
    if (!getCommandList().equals(other.getCommandList())) return false;
    if (!getArgsList().equals(other.getArgsList())) return false;
    if (!getEnvList().equals(other.getEnvList())) return false;
    if (!getUnknownFields().equals(other.getUnknownFields())) return false;
    return true;
  }

  @java.lang.Override
  public int hashCode() {
    if (memoizedHashCode != 0) {
      return memoizedHashCode;
    }
    int hash = 41;
    hash = (19 * hash) + getDescriptor().hashCode();
    hash = (37 * hash) + IMAGE_URI_FIELD_NUMBER;
    hash = (53 * hash) + getImageUri().hashCode();
    if (getCommandCount() > 0) {
      hash = (37 * hash) + COMMAND_FIELD_NUMBER;
      hash = (53 * hash) + getCommandList().hashCode();
    }
    if (getArgsCount() > 0) {
      hash = (37 * hash) + ARGS_FIELD_NUMBER;
      hash = (53 * hash) + getArgsList().hashCode();
    }
    if (getEnvCount() > 0) {
      hash = (37 * hash) + ENV_FIELD_NUMBER;
      hash = (53 * hash) + getEnvList().hashCode();
    }
    hash = (29 * hash) + getUnknownFields().hashCode();
    memoizedHashCode = hash;
    return hash;
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(java.nio.ByteBuffer data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      java.nio.ByteBuffer data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      com.google.protobuf.ByteString data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      com.google.protobuf.ByteString data,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(byte[] data)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      byte[] data, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws com.google.protobuf.InvalidProtocolBufferException {
    return PARSER.parseFrom(data, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(java.io.InputStream input)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseDelimitedFrom(
      java.io.InputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseDelimitedFrom(
      java.io.InputStream input, com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseDelimitedWithIOException(
        PARSER, input, extensionRegistry);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input) throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(PARSER, input);
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec parseFrom(
      com.google.protobuf.CodedInputStream input,
      com.google.protobuf.ExtensionRegistryLite extensionRegistry)
      throws java.io.IOException {
    return com.google.protobuf.GeneratedMessageV3.parseWithIOException(
        PARSER, input, extensionRegistry);
  }

  @java.lang.Override
  public Builder newBuilderForType() {
    return newBuilder();
  }

  public static Builder newBuilder() {
    return DEFAULT_INSTANCE.toBuilder();
  }

  public static Builder newBuilder(com.google.cloud.aiplatform.v1.ContainerSpec prototype) {
    return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
  }

  @java.lang.Override
  public Builder toBuilder() {
    return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
  }

  @java.lang.Override
  protected Builder newBuilderForType(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
    Builder builder = new Builder(parent);
    return builder;
  }

  /**
   *
   *
   * <pre>
   * The spec of a Container.
   * </pre>
   *
   * Protobuf type {@code google.cloud.aiplatform.v1.ContainerSpec}
   */
  public static final class Builder extends com.google.protobuf.GeneratedMessageV3.Builder<Builder>
      implements
      // @@protoc_insertion_point(builder_implements:google.cloud.aiplatform.v1.ContainerSpec)
      com.google.cloud.aiplatform.v1.ContainerSpecOrBuilder {
    public static final com.google.protobuf.Descriptors.Descriptor getDescriptor() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_ContainerSpec_descriptor;
    }

    @java.lang.Override
    protected com.google.protobuf.GeneratedMessageV3.FieldAccessorTable
        internalGetFieldAccessorTable() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_ContainerSpec_fieldAccessorTable
          .ensureFieldAccessorsInitialized(
              com.google.cloud.aiplatform.v1.ContainerSpec.class,
              com.google.cloud.aiplatform.v1.ContainerSpec.Builder.class);
    }

    // Construct using com.google.cloud.aiplatform.v1.ContainerSpec.newBuilder()
    private Builder() {}

    private Builder(com.google.protobuf.GeneratedMessageV3.BuilderParent parent) {
      super(parent);
    }

    @java.lang.Override
    public Builder clear() {
      super.clear();
      bitField0_ = 0;
      imageUri_ = "";
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
      } else {
        env_ = null;
        envBuilder_.clear();
      }
      bitField0_ = (bitField0_ & ~0x00000008);
      return this;
    }

    @java.lang.Override
    public com.google.protobuf.Descriptors.Descriptor getDescriptorForType() {
      return com.google.cloud.aiplatform.v1.CustomJobProto
          .internal_static_google_cloud_aiplatform_v1_ContainerSpec_descriptor;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ContainerSpec getDefaultInstanceForType() {
      return com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance();
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ContainerSpec build() {
      com.google.cloud.aiplatform.v1.ContainerSpec result = buildPartial();
      if (!result.isInitialized()) {
        throw newUninitializedMessageException(result);
      }
      return result;
    }

    @java.lang.Override
    public com.google.cloud.aiplatform.v1.ContainerSpec buildPartial() {
      com.google.cloud.aiplatform.v1.ContainerSpec result =
          new com.google.cloud.aiplatform.v1.ContainerSpec(this);
      buildPartialRepeatedFields(result);
      if (bitField0_ != 0) {
        buildPartial0(result);
      }
      onBuilt();
      return result;
    }

    private void buildPartialRepeatedFields(com.google.cloud.aiplatform.v1.ContainerSpec result) {
      if (envBuilder_ == null) {
        if (((bitField0_ & 0x00000008) != 0)) {
          env_ = java.util.Collections.unmodifiableList(env_);
          bitField0_ = (bitField0_ & ~0x00000008);
        }
        result.env_ = env_;
      } else {
        result.env_ = envBuilder_.build();
      }
    }

    private void buildPartial0(com.google.cloud.aiplatform.v1.ContainerSpec result) {
      int from_bitField0_ = bitField0_;
      if (((from_bitField0_ & 0x00000001) != 0)) {
        result.imageUri_ = imageUri_;
      }
      if (((from_bitField0_ & 0x00000002) != 0)) {
        command_.makeImmutable();
        result.command_ = command_;
      }
      if (((from_bitField0_ & 0x00000004) != 0)) {
        args_.makeImmutable();
        result.args_ = args_;
      }
    }

    @java.lang.Override
    public Builder clone() {
      return super.clone();
    }

    @java.lang.Override
    public Builder setField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.setField(field, value);
    }

    @java.lang.Override
    public Builder clearField(com.google.protobuf.Descriptors.FieldDescriptor field) {
      return super.clearField(field);
    }

    @java.lang.Override
    public Builder clearOneof(com.google.protobuf.Descriptors.OneofDescriptor oneof) {
      return super.clearOneof(oneof);
    }

    @java.lang.Override
    public Builder setRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, int index, java.lang.Object value) {
      return super.setRepeatedField(field, index, value);
    }

    @java.lang.Override
    public Builder addRepeatedField(
        com.google.protobuf.Descriptors.FieldDescriptor field, java.lang.Object value) {
      return super.addRepeatedField(field, value);
    }

    @java.lang.Override
    public Builder mergeFrom(com.google.protobuf.Message other) {
      if (other instanceof com.google.cloud.aiplatform.v1.ContainerSpec) {
        return mergeFrom((com.google.cloud.aiplatform.v1.ContainerSpec) other);
      } else {
        super.mergeFrom(other);
        return this;
      }
    }

    public Builder mergeFrom(com.google.cloud.aiplatform.v1.ContainerSpec other) {
      if (other == com.google.cloud.aiplatform.v1.ContainerSpec.getDefaultInstance()) return this;
      if (!other.getImageUri().isEmpty()) {
        imageUri_ = other.imageUri_;
        bitField0_ |= 0x00000001;
        onChanged();
      }
      if (!other.command_.isEmpty()) {
        if (command_.isEmpty()) {
          command_ = other.command_;
          bitField0_ |= 0x00000002;
        } else {
          ensureCommandIsMutable();
          command_.addAll(other.command_);
        }
        onChanged();
      }
      if (!other.args_.isEmpty()) {
        if (args_.isEmpty()) {
          args_ = other.args_;
          bitField0_ |= 0x00000004;
        } else {
          ensureArgsIsMutable();
          args_.addAll(other.args_);
        }
        onChanged();
      }
      if (envBuilder_ == null) {
        if (!other.env_.isEmpty()) {
          if (env_.isEmpty()) {
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000008);
          } else {
            ensureEnvIsMutable();
            env_.addAll(other.env_);
          }
          onChanged();
        }
      } else {
        if (!other.env_.isEmpty()) {
          if (envBuilder_.isEmpty()) {
            envBuilder_.dispose();
            envBuilder_ = null;
            env_ = other.env_;
            bitField0_ = (bitField0_ & ~0x00000008);
            envBuilder_ =
                com.google.protobuf.GeneratedMessageV3.alwaysUseFieldBuilders
                    ? getEnvFieldBuilder()
                    : null;
          } else {
            envBuilder_.addAllMessages(other.env_);
          }
        }
      }
      this.mergeUnknownFields(other.getUnknownFields());
      onChanged();
      return this;
    }

    @java.lang.Override
    public final boolean isInitialized() {
      return true;
    }

    @java.lang.Override
    public Builder mergeFrom(
        com.google.protobuf.CodedInputStream input,
        com.google.protobuf.ExtensionRegistryLite extensionRegistry)
        throws java.io.IOException {
      if (extensionRegistry == null) {
        throw new java.lang.NullPointerException();
      }
      try {
        boolean done = false;
        while (!done) {
          int tag = input.readTag();
          switch (tag) {
            case 0:
              done = true;
              break;
            case 10:
              {
                imageUri_ = input.readStringRequireUtf8();
                bitField0_ |= 0x00000001;
                break;
              } // case 10
            case 18:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureCommandIsMutable();
                command_.add(s);
                break;
              } // case 18
            case 26:
              {
                java.lang.String s = input.readStringRequireUtf8();
                ensureArgsIsMutable();
                args_.add(s);
                break;
              } // case 26
            case 34:
              {
                com.google.cloud.aiplatform.v1.EnvVar m =
                    input.readMessage(
                        com.google.cloud.aiplatform.v1.EnvVar.parser(), extensionRegistry);
                if (envBuilder_ == null) {
                  ensureEnvIsMutable();
                  env_.add(m);
                } else {
                  envBuilder_.addMessage(m);
                }
                break;
              } // case 34
            default:
              {
                if (!super.parseUnknownField(input, extensionRegistry, tag)) {
                  done = true; // was an endgroup tag
                }
                break;
              } // default:
          } // switch (tag)
        } // while (!done)
      } catch (com.google.protobuf.InvalidProtocolBufferException e) {
        throw e.unwrapIOException();
      } finally {
        onChanged();
      } // finally
      return this;
    }

    private int bitField0_;

    private java.lang.Object imageUri_ = "";

    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in the Container Registry that is to
     * be run on each worker replica.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The imageUri.
     */
    public java.lang.String getImageUri() {
      java.lang.Object ref = imageUri_;
      if (!(ref instanceof java.lang.String)) {
        com.google.protobuf.ByteString bs = (com.google.protobuf.ByteString) ref;
        java.lang.String s = bs.toStringUtf8();
        imageUri_ = s;
        return s;
      } else {
        return (java.lang.String) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in the Container Registry that is to
     * be run on each worker replica.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return The bytes for imageUri.
     */
    public com.google.protobuf.ByteString getImageUriBytes() {
      java.lang.Object ref = imageUri_;
      if (ref instanceof String) {
        com.google.protobuf.ByteString b =
            com.google.protobuf.ByteString.copyFromUtf8((java.lang.String) ref);
        imageUri_ = b;
        return b;
      } else {
        return (com.google.protobuf.ByteString) ref;
      }
    }

    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in the Container Registry that is to
     * be run on each worker replica.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUri(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in the Container Registry that is to
     * be run on each worker replica.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearImageUri() {
      imageUri_ = getDefaultInstance().getImageUri();
      bitField0_ = (bitField0_ & ~0x00000001);
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * Required. The URI of a container image in the Container Registry that is to
     * be run on each worker replica.
     * </pre>
     *
     * <code>string image_uri = 1 [(.google.api.field_behavior) = REQUIRED];</code>
     *
     * @param value The bytes for imageUri to set.
     * @return This builder for chaining.
     */
    public Builder setImageUriBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      imageUri_ = value;
      bitField0_ |= 0x00000001;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList command_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureCommandIsMutable() {
      if (!command_.isModifiable()) {
        command_ = new com.google.protobuf.LazyStringArrayList(command_);
      }
      bitField0_ |= 0x00000002;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @return A list containing the command.
     */
    public com.google.protobuf.ProtocolStringList getCommandList() {
      command_.makeImmutable();
      return command_;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @return The count of command.
     */
    public int getCommandCount() {
      return command_.size();
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param index The index of the element to return.
     * @return The command at the given index.
     */
    public java.lang.String getCommand(int index) {
      return command_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the command at the given index.
     */
    public com.google.protobuf.ByteString getCommandBytes(int index) {
      return command_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param index The index to set the value at.
     * @param value The command to set.
     * @return This builder for chaining.
     */
    public Builder setCommand(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.set(index, value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param value The command to add.
     * @return This builder for chaining.
     */
    public Builder addCommand(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param values The command to add.
     * @return This builder for chaining.
     */
    public Builder addAllCommand(java.lang.Iterable<java.lang.String> values) {
      ensureCommandIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, command_);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearCommand() {
      command_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000002);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The command to be invoked when the container is started.
     * It overrides the entrypoint instruction in Dockerfile when provided.
     * </pre>
     *
     * <code>repeated string command = 2;</code>
     *
     * @param value The bytes of the command to add.
     * @return This builder for chaining.
     */
    public Builder addCommandBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureCommandIsMutable();
      command_.add(value);
      bitField0_ |= 0x00000002;
      onChanged();
      return this;
    }

    private com.google.protobuf.LazyStringArrayList args_ =
        com.google.protobuf.LazyStringArrayList.emptyList();

    private void ensureArgsIsMutable() {
      if (!args_.isModifiable()) {
        args_ = new com.google.protobuf.LazyStringArrayList(args_);
      }
      bitField0_ |= 0x00000004;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return A list containing the args.
     */
    public com.google.protobuf.ProtocolStringList getArgsList() {
      args_.makeImmutable();
      return args_;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return The count of args.
     */
    public int getArgsCount() {
      return args_.size();
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the element to return.
     * @return The args at the given index.
     */
    public java.lang.String getArgs(int index) {
      return args_.get(index);
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index of the value to return.
     * @return The bytes of the args at the given index.
     */
    public com.google.protobuf.ByteString getArgsBytes(int index) {
      return args_.getByteString(index);
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param index The index to set the value at.
     * @param value The args to set.
     * @return This builder for chaining.
     */
    public Builder setArgs(int index, java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.set(index, value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The args to add.
     * @return This builder for chaining.
     */
    public Builder addArgs(java.lang.String value) {
      if (value == null) {
        throw new NullPointerException();
      }
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param values The args to add.
     * @return This builder for chaining.
     */
    public Builder addAllArgs(java.lang.Iterable<java.lang.String> values) {
      ensureArgsIsMutable();
      com.google.protobuf.AbstractMessageLite.Builder.addAll(values, args_);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @return This builder for chaining.
     */
    public Builder clearArgs() {
      args_ = com.google.protobuf.LazyStringArrayList.emptyList();
      bitField0_ = (bitField0_ & ~0x00000004);
      ;
      onChanged();
      return this;
    }

    /**
     *
     *
     * <pre>
     * The arguments to be passed when starting the container.
     * </pre>
     *
     * <code>repeated string args = 3;</code>
     *
     * @param value The bytes of the args to add.
     * @return This builder for chaining.
     */
    public Builder addArgsBytes(com.google.protobuf.ByteString value) {
      if (value == null) {
        throw new NullPointerException();
      }
      checkByteStringIsUtf8(value);
      ensureArgsIsMutable();
      args_.add(value);
      bitField0_ |= 0x00000004;
      onChanged();
      return this;
    }

    private java.util.List<com.google.cloud.aiplatform.v1.EnvVar> env_ =
        java.util.Collections.emptyList();

    private void ensureEnvIsMutable() {
      if (!((bitField0_ & 0x00000008) != 0)) {
        env_ = new java.util.ArrayList<com.google.cloud.aiplatform.v1.EnvVar>(env_);
        bitField0_ |= 0x00000008;
      }
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EnvVar,
            com.google.cloud.aiplatform.v1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
        envBuilder_;

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.EnvVar> getEnvList() {
      if (envBuilder_ == null) {
        return java.util.Collections.unmodifiableList(env_);
      } else {
        return envBuilder_.getMessageList();
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public int getEnvCount() {
      if (envBuilder_ == null) {
        return env_.size();
      } else {
        return envBuilder_.getCount();
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.EnvVar getEnv(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessage(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder setEnv(int index, com.google.cloud.aiplatform.v1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.set(index, value);
        onChanged();
      } else {
        envBuilder_.setMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder setEnv(
        int index, com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.set(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.setMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(value);
        onChanged();
      } else {
        envBuilder_.addMessage(value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder addEnv(int index, com.google.cloud.aiplatform.v1.EnvVar value) {
      if (envBuilder_ == null) {
        if (value == null) {
          throw new NullPointerException();
        }
        ensureEnvIsMutable();
        env_.add(index, value);
        onChanged();
      } else {
        envBuilder_.addMessage(index, value);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder addEnv(com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder addEnv(
        int index, com.google.cloud.aiplatform.v1.EnvVar.Builder builderForValue) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.add(index, builderForValue.build());
        onChanged();
      } else {
        envBuilder_.addMessage(index, builderForValue.build());
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder addAllEnv(
        java.lang.Iterable<? extends com.google.cloud.aiplatform.v1.EnvVar> values) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        com.google.protobuf.AbstractMessageLite.Builder.addAll(values, env_);
        onChanged();
      } else {
        envBuilder_.addAllMessages(values);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder clearEnv() {
      if (envBuilder_ == null) {
        env_ = java.util.Collections.emptyList();
        bitField0_ = (bitField0_ & ~0x00000008);
        onChanged();
      } else {
        envBuilder_.clear();
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public Builder removeEnv(int index) {
      if (envBuilder_ == null) {
        ensureEnvIsMutable();
        env_.remove(index);
        onChanged();
      } else {
        envBuilder_.remove(index);
      }
      return this;
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.EnvVar.Builder getEnvBuilder(int index) {
      return getEnvFieldBuilder().getBuilder(index);
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.EnvVarOrBuilder getEnvOrBuilder(int index) {
      if (envBuilder_ == null) {
        return env_.get(index);
      } else {
        return envBuilder_.getMessageOrBuilder(index);
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public java.util.List<? extends com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
        getEnvOrBuilderList() {
      if (envBuilder_ != null) {
        return envBuilder_.getMessageOrBuilderList();
      } else {
        return java.util.Collections.unmodifiableList(env_);
      }
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.EnvVar.Builder addEnvBuilder() {
      return getEnvFieldBuilder()
          .addBuilder(com.google.cloud.aiplatform.v1.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public com.google.cloud.aiplatform.v1.EnvVar.Builder addEnvBuilder(int index) {
      return getEnvFieldBuilder()
          .addBuilder(index, com.google.cloud.aiplatform.v1.EnvVar.getDefaultInstance());
    }

    /**
     *
     *
     * <pre>
     * Environment variables to be passed to the container.
     * Maximum limit is 100.
     * </pre>
     *
     * <code>repeated .google.cloud.aiplatform.v1.EnvVar env = 4;</code>
     */
    public java.util.List<com.google.cloud.aiplatform.v1.EnvVar.Builder> getEnvBuilderList() {
      return getEnvFieldBuilder().getBuilderList();
    }

    private com.google.protobuf.RepeatedFieldBuilderV3<
            com.google.cloud.aiplatform.v1.EnvVar,
            com.google.cloud.aiplatform.v1.EnvVar.Builder,
            com.google.cloud.aiplatform.v1.EnvVarOrBuilder>
        getEnvFieldBuilder() {
      if (envBuilder_ == null) {
        envBuilder_ =
            new com.google.protobuf.RepeatedFieldBuilderV3<
                com.google.cloud.aiplatform.v1.EnvVar,
                com.google.cloud.aiplatform.v1.EnvVar.Builder,
                com.google.cloud.aiplatform.v1.EnvVarOrBuilder>(
                env_, ((bitField0_ & 0x00000008) != 0), getParentForChildren(), isClean());
        env_ = null;
      }
      return envBuilder_;
    }

    @java.lang.Override
    public final Builder setUnknownFields(final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.setUnknownFields(unknownFields);
    }

    @java.lang.Override
    public final Builder mergeUnknownFields(
        final com.google.protobuf.UnknownFieldSet unknownFields) {
      return super.mergeUnknownFields(unknownFields);
    }

    // @@protoc_insertion_point(builder_scope:google.cloud.aiplatform.v1.ContainerSpec)
  }

  // @@protoc_insertion_point(class_scope:google.cloud.aiplatform.v1.ContainerSpec)
  private static final com.google.cloud.aiplatform.v1.ContainerSpec DEFAULT_INSTANCE;

  static {
    DEFAULT_INSTANCE = new com.google.cloud.aiplatform.v1.ContainerSpec();
  }

  public static com.google.cloud.aiplatform.v1.ContainerSpec getDefaultInstance() {
    return DEFAULT_INSTANCE;
  }

  private static final com.google.protobuf.Parser<ContainerSpec> PARSER =
      new com.google.protobuf.AbstractParser<ContainerSpec>() {
        @java.lang.Override
        public ContainerSpec parsePartialFrom(
            com.google.protobuf.CodedInputStream input,
            com.google.protobuf.ExtensionRegistryLite extensionRegistry)
            throws com.google.protobuf.InvalidProtocolBufferException {
          Builder builder = newBuilder();
          try {
            builder.mergeFrom(input, extensionRegistry);
          } catch (com.google.protobuf.InvalidProtocolBufferException e) {
            throw e.setUnfinishedMessage(builder.buildPartial());
          } catch (com.google.protobuf.UninitializedMessageException e) {
            throw e.asInvalidProtocolBufferException().setUnfinishedMessage(builder.buildPartial());
          } catch (java.io.IOException e) {
            throw new com.google.protobuf.InvalidProtocolBufferException(e)
                .setUnfinishedMessage(builder.buildPartial());
          }
          return builder.buildPartial();
        }
      };

  public static com.google.protobuf.Parser<ContainerSpec> parser() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.protobuf.Parser<ContainerSpec> getParserForType() {
    return PARSER;
  }

  @java.lang.Override
  public com.google.cloud.aiplatform.v1.ContainerSpec getDefaultInstanceForType() {
    return DEFAULT_INSTANCE;
  }
}
