/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class TensorboardExperimentName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_TENSORBOARD_EXPERIMENT = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/tensorboards/{tensorboard}/experiments/{experiment}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String tensorboard;
    private final String experiment;

    @Deprecated
    protected TensorboardExperimentName() {
        this.project = null;
        this.location = null;
        this.tensorboard = null;
        this.experiment = null;
    }

    private TensorboardExperimentName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.tensorboard = (String)Preconditions.checkNotNull((Object)builder.getTensorboard());
        this.experiment = (String)Preconditions.checkNotNull((Object)builder.getExperiment());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getTensorboard() {
        return this.tensorboard;
    }

    public String getExperiment() {
        return this.experiment;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static TensorboardExperimentName of(String project, String location, String tensorboard, String experiment) {
        return TensorboardExperimentName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).build();
    }

    public static String format(String project, String location, String tensorboard, String experiment) {
        return TensorboardExperimentName.newBuilder().setProject(project).setLocation(location).setTensorboard(tensorboard).setExperiment(experiment).build().toString();
    }

    public static TensorboardExperimentName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_TENSORBOARD_EXPERIMENT.validatedMatch(formattedString, "TensorboardExperimentName.parse: formattedString not in valid format");
        return TensorboardExperimentName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("tensorboard"), (String)matchMap.get("experiment"));
    }

    public static List<TensorboardExperimentName> parseList(List<String> formattedStrings) {
        ArrayList<TensorboardExperimentName> list = new ArrayList<TensorboardExperimentName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(TensorboardExperimentName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<TensorboardExperimentName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (TensorboardExperimentName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            TensorboardExperimentName tensorboardExperimentName = this;
            synchronized (tensorboardExperimentName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.tensorboard != null) {
                        fieldMapBuilder.put((Object)"tensorboard", (Object)this.tensorboard);
                    }
                    if (this.experiment != null) {
                        fieldMapBuilder.put((Object)"experiment", (Object)this.experiment);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_TENSORBOARD_EXPERIMENT.instantiate(new String[]{"project", this.project, "location", this.location, "tensorboard", this.tensorboard, "experiment", this.experiment});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null || this.getClass() == o.getClass()) {
            TensorboardExperimentName that = (TensorboardExperimentName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.tensorboard, that.tensorboard) && Objects.equals(this.experiment, that.experiment);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.tensorboard);
        h *= 1000003;
        return h ^= Objects.hashCode(this.experiment);
    }

    public static class Builder {
        private String project;
        private String location;
        private String tensorboard;
        private String experiment;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getTensorboard() {
            return this.tensorboard;
        }

        public String getExperiment() {
            return this.experiment;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setTensorboard(String tensorboard) {
            this.tensorboard = tensorboard;
            return this;
        }

        public Builder setExperiment(String experiment) {
            this.experiment = experiment;
            return this;
        }

        private Builder(TensorboardExperimentName tensorboardExperimentName) {
            this.project = tensorboardExperimentName.project;
            this.location = tensorboardExperimentName.location;
            this.tensorboard = tensorboardExperimentName.tensorboard;
            this.experiment = tensorboardExperimentName.experiment;
        }

        public TensorboardExperimentName build() {
            return new TensorboardExperimentName(this);
        }
    }
}

