/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.api.pathtemplate.PathTemplate;
import com.google.api.resourcenames.ResourceName;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;

public class NasTrialDetailName
implements ResourceName {
    private static final PathTemplate PROJECT_LOCATION_NAS_JOB_NAS_TRIAL_DETAIL = PathTemplate.createWithoutUrlEncoding((String)"projects/{project}/locations/{location}/nasJobs/{nas_job}/nasTrialDetails/{nas_trial_detail}");
    private volatile Map<String, String> fieldValuesMap;
    private final String project;
    private final String location;
    private final String nasJob;
    private final String nasTrialDetail;

    @Deprecated
    protected NasTrialDetailName() {
        this.project = null;
        this.location = null;
        this.nasJob = null;
        this.nasTrialDetail = null;
    }

    private NasTrialDetailName(Builder builder) {
        this.project = (String)Preconditions.checkNotNull((Object)builder.getProject());
        this.location = (String)Preconditions.checkNotNull((Object)builder.getLocation());
        this.nasJob = (String)Preconditions.checkNotNull((Object)builder.getNasJob());
        this.nasTrialDetail = (String)Preconditions.checkNotNull((Object)builder.getNasTrialDetail());
    }

    public String getProject() {
        return this.project;
    }

    public String getLocation() {
        return this.location;
    }

    public String getNasJob() {
        return this.nasJob;
    }

    public String getNasTrialDetail() {
        return this.nasTrialDetail;
    }

    public static Builder newBuilder() {
        return new Builder();
    }

    public Builder toBuilder() {
        return new Builder(this);
    }

    public static NasTrialDetailName of(String project, String location, String nasJob, String nasTrialDetail) {
        return NasTrialDetailName.newBuilder().setProject(project).setLocation(location).setNasJob(nasJob).setNasTrialDetail(nasTrialDetail).build();
    }

    public static String format(String project, String location, String nasJob, String nasTrialDetail) {
        return NasTrialDetailName.newBuilder().setProject(project).setLocation(location).setNasJob(nasJob).setNasTrialDetail(nasTrialDetail).build().toString();
    }

    public static NasTrialDetailName parse(String formattedString) {
        if (formattedString.isEmpty()) {
            return null;
        }
        Map matchMap = PROJECT_LOCATION_NAS_JOB_NAS_TRIAL_DETAIL.validatedMatch(formattedString, "NasTrialDetailName.parse: formattedString not in valid format");
        return NasTrialDetailName.of((String)matchMap.get("project"), (String)matchMap.get("location"), (String)matchMap.get("nas_job"), (String)matchMap.get("nas_trial_detail"));
    }

    public static List<NasTrialDetailName> parseList(List<String> formattedStrings) {
        ArrayList<NasTrialDetailName> list = new ArrayList<NasTrialDetailName>(formattedStrings.size());
        for (String formattedString : formattedStrings) {
            list.add(NasTrialDetailName.parse(formattedString));
        }
        return list;
    }

    public static List<String> toStringList(List<NasTrialDetailName> values) {
        ArrayList<String> list = new ArrayList<String>(values.size());
        for (NasTrialDetailName value : values) {
            if (value == null) {
                list.add("");
                continue;
            }
            list.add(value.toString());
        }
        return list;
    }

    public static boolean isParsableFrom(String formattedString) {
        return PROJECT_LOCATION_NAS_JOB_NAS_TRIAL_DETAIL.matches(formattedString);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> getFieldValuesMap() {
        if (this.fieldValuesMap == null) {
            NasTrialDetailName nasTrialDetailName = this;
            synchronized (nasTrialDetailName) {
                if (this.fieldValuesMap == null) {
                    ImmutableMap.Builder fieldMapBuilder = ImmutableMap.builder();
                    if (this.project != null) {
                        fieldMapBuilder.put((Object)"project", (Object)this.project);
                    }
                    if (this.location != null) {
                        fieldMapBuilder.put((Object)"location", (Object)this.location);
                    }
                    if (this.nasJob != null) {
                        fieldMapBuilder.put((Object)"nas_job", (Object)this.nasJob);
                    }
                    if (this.nasTrialDetail != null) {
                        fieldMapBuilder.put((Object)"nas_trial_detail", (Object)this.nasTrialDetail);
                    }
                    this.fieldValuesMap = fieldMapBuilder.build();
                }
            }
        }
        return this.fieldValuesMap;
    }

    public String getFieldValue(String fieldName) {
        return this.getFieldValuesMap().get(fieldName);
    }

    public String toString() {
        return PROJECT_LOCATION_NAS_JOB_NAS_TRIAL_DETAIL.instantiate(new String[]{"project", this.project, "location", this.location, "nas_job", this.nasJob, "nas_trial_detail", this.nasTrialDetail});
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o != null && this.getClass() == o.getClass()) {
            NasTrialDetailName that = (NasTrialDetailName)o;
            return Objects.equals(this.project, that.project) && Objects.equals(this.location, that.location) && Objects.equals(this.nasJob, that.nasJob) && Objects.equals(this.nasTrialDetail, that.nasTrialDetail);
        }
        return false;
    }

    public int hashCode() {
        int h = 1;
        h *= 1000003;
        h ^= Objects.hashCode(this.project);
        h *= 1000003;
        h ^= Objects.hashCode(this.location);
        h *= 1000003;
        h ^= Objects.hashCode(this.nasJob);
        h *= 1000003;
        return h ^= Objects.hashCode(this.nasTrialDetail);
    }

    public static class Builder {
        private String project;
        private String location;
        private String nasJob;
        private String nasTrialDetail;

        protected Builder() {
        }

        public String getProject() {
            return this.project;
        }

        public String getLocation() {
            return this.location;
        }

        public String getNasJob() {
            return this.nasJob;
        }

        public String getNasTrialDetail() {
            return this.nasTrialDetail;
        }

        public Builder setProject(String project) {
            this.project = project;
            return this;
        }

        public Builder setLocation(String location) {
            this.location = location;
            return this;
        }

        public Builder setNasJob(String nasJob) {
            this.nasJob = nasJob;
            return this;
        }

        public Builder setNasTrialDetail(String nasTrialDetail) {
            this.nasTrialDetail = nasTrialDetail;
            return this;
        }

        private Builder(NasTrialDetailName nasTrialDetailName) {
            this.project = nasTrialDetailName.project;
            this.location = nasTrialDetailName.location;
            this.nasJob = nasTrialDetailName.nasJob;
            this.nasTrialDetail = nasTrialDetailName.nasTrialDetail;
        }

        public NasTrialDetailName build() {
            return new NasTrialDetailName(this);
        }
    }
}

