/*
 * Decompiled with CFR 0.152.
 */
package com.google.cloud.aiplatform.v1;

import com.google.cloud.aiplatform.v1.ErrorAnalysisAnnotationOrBuilder;
import com.google.cloud.aiplatform.v1.EvaluatedAnnotationProto;
import com.google.protobuf.AbstractMessage;
import com.google.protobuf.AbstractMessageLite;
import com.google.protobuf.AbstractParser;
import com.google.protobuf.ByteString;
import com.google.protobuf.CodedInputStream;
import com.google.protobuf.CodedOutputStream;
import com.google.protobuf.Descriptors;
import com.google.protobuf.ExtensionRegistryLite;
import com.google.protobuf.GeneratedMessageV3;
import com.google.protobuf.Internal;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.MessageLite;
import com.google.protobuf.MessageOrBuilder;
import com.google.protobuf.Parser;
import com.google.protobuf.ProtocolMessageEnum;
import com.google.protobuf.RepeatedFieldBuilderV3;
import com.google.protobuf.UninitializedMessageException;
import com.google.protobuf.UnknownFieldSet;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public final class ErrorAnalysisAnnotation
extends GeneratedMessageV3
implements ErrorAnalysisAnnotationOrBuilder {
    private static final long serialVersionUID = 0L;
    public static final int ATTRIBUTED_ITEMS_FIELD_NUMBER = 1;
    private List<AttributedItem> attributedItems_;
    public static final int QUERY_TYPE_FIELD_NUMBER = 2;
    private int queryType_ = 0;
    public static final int OUTLIER_SCORE_FIELD_NUMBER = 3;
    private double outlierScore_ = 0.0;
    public static final int OUTLIER_THRESHOLD_FIELD_NUMBER = 4;
    private double outlierThreshold_ = 0.0;
    private byte memoizedIsInitialized = (byte)-1;
    private static final ErrorAnalysisAnnotation DEFAULT_INSTANCE = new ErrorAnalysisAnnotation();
    private static final Parser<ErrorAnalysisAnnotation> PARSER = new AbstractParser<ErrorAnalysisAnnotation>(){

        public ErrorAnalysisAnnotation parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            Builder builder = ErrorAnalysisAnnotation.newBuilder();
            try {
                builder.mergeFrom(input, extensionRegistry);
            }
            catch (InvalidProtocolBufferException e) {
                throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (UninitializedMessageException e) {
                throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            catch (IOException e) {
                throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
            }
            return builder.buildPartial();
        }
    };

    private ErrorAnalysisAnnotation(GeneratedMessageV3.Builder<?> builder) {
        super(builder);
    }

    private ErrorAnalysisAnnotation() {
        this.attributedItems_ = Collections.emptyList();
        this.queryType_ = 0;
    }

    protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
        return new ErrorAnalysisAnnotation();
    }

    public final UnknownFieldSet getUnknownFields() {
        return this.unknownFields;
    }

    public static final Descriptors.Descriptor getDescriptor() {
        return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
    }

    protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
        return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_fieldAccessorTable.ensureFieldAccessorsInitialized(ErrorAnalysisAnnotation.class, Builder.class);
    }

    @Override
    public List<AttributedItem> getAttributedItemsList() {
        return this.attributedItems_;
    }

    @Override
    public List<? extends AttributedItemOrBuilder> getAttributedItemsOrBuilderList() {
        return this.attributedItems_;
    }

    @Override
    public int getAttributedItemsCount() {
        return this.attributedItems_.size();
    }

    @Override
    public AttributedItem getAttributedItems(int index) {
        return this.attributedItems_.get(index);
    }

    @Override
    public AttributedItemOrBuilder getAttributedItemsOrBuilder(int index) {
        return this.attributedItems_.get(index);
    }

    @Override
    public int getQueryTypeValue() {
        return this.queryType_;
    }

    @Override
    public QueryType getQueryType() {
        QueryType result = QueryType.forNumber(this.queryType_);
        return result == null ? QueryType.UNRECOGNIZED : result;
    }

    @Override
    public double getOutlierScore() {
        return this.outlierScore_;
    }

    @Override
    public double getOutlierThreshold() {
        return this.outlierThreshold_;
    }

    public final boolean isInitialized() {
        byte isInitialized = this.memoizedIsInitialized;
        if (isInitialized == 1) {
            return true;
        }
        if (isInitialized == 0) {
            return false;
        }
        this.memoizedIsInitialized = 1;
        return true;
    }

    public void writeTo(CodedOutputStream output) throws IOException {
        for (int i = 0; i < this.attributedItems_.size(); ++i) {
            output.writeMessage(1, (MessageLite)this.attributedItems_.get(i));
        }
        if (this.queryType_ != QueryType.QUERY_TYPE_UNSPECIFIED.getNumber()) {
            output.writeEnum(2, this.queryType_);
        }
        if (Double.doubleToRawLongBits(this.outlierScore_) != 0L) {
            output.writeDouble(3, this.outlierScore_);
        }
        if (Double.doubleToRawLongBits(this.outlierThreshold_) != 0L) {
            output.writeDouble(4, this.outlierThreshold_);
        }
        this.getUnknownFields().writeTo(output);
    }

    public int getSerializedSize() {
        int size = this.memoizedSize;
        if (size != -1) {
            return size;
        }
        size = 0;
        for (int i = 0; i < this.attributedItems_.size(); ++i) {
            size += CodedOutputStream.computeMessageSize((int)1, (MessageLite)((MessageLite)this.attributedItems_.get(i)));
        }
        if (this.queryType_ != QueryType.QUERY_TYPE_UNSPECIFIED.getNumber()) {
            size += CodedOutputStream.computeEnumSize((int)2, (int)this.queryType_);
        }
        if (Double.doubleToRawLongBits(this.outlierScore_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)3, (double)this.outlierScore_);
        }
        if (Double.doubleToRawLongBits(this.outlierThreshold_) != 0L) {
            size += CodedOutputStream.computeDoubleSize((int)4, (double)this.outlierThreshold_);
        }
        this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
        return size;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof ErrorAnalysisAnnotation)) {
            return super.equals(obj);
        }
        ErrorAnalysisAnnotation other = (ErrorAnalysisAnnotation)obj;
        if (!this.getAttributedItemsList().equals(other.getAttributedItemsList())) {
            return false;
        }
        if (this.queryType_ != other.queryType_) {
            return false;
        }
        if (Double.doubleToLongBits(this.getOutlierScore()) != Double.doubleToLongBits(other.getOutlierScore())) {
            return false;
        }
        if (Double.doubleToLongBits(this.getOutlierThreshold()) != Double.doubleToLongBits(other.getOutlierThreshold())) {
            return false;
        }
        return this.getUnknownFields().equals((Object)other.getUnknownFields());
    }

    public int hashCode() {
        if (this.memoizedHashCode != 0) {
            return this.memoizedHashCode;
        }
        int hash = 41;
        hash = 19 * hash + ErrorAnalysisAnnotation.getDescriptor().hashCode();
        if (this.getAttributedItemsCount() > 0) {
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getAttributedItemsList().hashCode();
        }
        hash = 37 * hash + 2;
        hash = 53 * hash + this.queryType_;
        hash = 37 * hash + 3;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getOutlierScore()));
        hash = 37 * hash + 4;
        hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getOutlierThreshold()));
        this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
        return hash;
    }

    public static ErrorAnalysisAnnotation parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data);
    }

    public static ErrorAnalysisAnnotation parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ErrorAnalysisAnnotation parseFrom(ByteString data) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data);
    }

    public static ErrorAnalysisAnnotation parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ErrorAnalysisAnnotation parseFrom(byte[] data) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data);
    }

    public static ErrorAnalysisAnnotation parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
        return (ErrorAnalysisAnnotation)PARSER.parseFrom(data, extensionRegistry);
    }

    public static ErrorAnalysisAnnotation parseFrom(InputStream input) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
    }

    public static ErrorAnalysisAnnotation parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ErrorAnalysisAnnotation parseDelimitedFrom(InputStream input) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
    }

    public static ErrorAnalysisAnnotation parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public static ErrorAnalysisAnnotation parseFrom(CodedInputStream input) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
    }

    public static ErrorAnalysisAnnotation parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
        return (ErrorAnalysisAnnotation)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
    }

    public Builder newBuilderForType() {
        return ErrorAnalysisAnnotation.newBuilder();
    }

    public static Builder newBuilder() {
        return DEFAULT_INSTANCE.toBuilder();
    }

    public static Builder newBuilder(ErrorAnalysisAnnotation prototype) {
        return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
    }

    public Builder toBuilder() {
        return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
    }

    protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
        Builder builder = new Builder(parent);
        return builder;
    }

    public static ErrorAnalysisAnnotation getDefaultInstance() {
        return DEFAULT_INSTANCE;
    }

    public static Parser<ErrorAnalysisAnnotation> parser() {
        return PARSER;
    }

    public Parser<ErrorAnalysisAnnotation> getParserForType() {
        return PARSER;
    }

    public ErrorAnalysisAnnotation getDefaultInstanceForType() {
        return DEFAULT_INSTANCE;
    }

    public static final class Builder
    extends GeneratedMessageV3.Builder<Builder>
    implements ErrorAnalysisAnnotationOrBuilder {
        private int bitField0_;
        private List<AttributedItem> attributedItems_ = Collections.emptyList();
        private RepeatedFieldBuilderV3<AttributedItem, AttributedItem.Builder, AttributedItemOrBuilder> attributedItemsBuilder_;
        private int queryType_ = 0;
        private double outlierScore_;
        private double outlierThreshold_;

        public static final Descriptors.Descriptor getDescriptor() {
            return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_fieldAccessorTable.ensureFieldAccessorsInitialized(ErrorAnalysisAnnotation.class, Builder.class);
        }

        private Builder() {
        }

        private Builder(GeneratedMessageV3.BuilderParent parent) {
            super(parent);
        }

        public Builder clear() {
            super.clear();
            this.bitField0_ = 0;
            if (this.attributedItemsBuilder_ == null) {
                this.attributedItems_ = Collections.emptyList();
            } else {
                this.attributedItems_ = null;
                this.attributedItemsBuilder_.clear();
            }
            this.bitField0_ &= 0xFFFFFFFE;
            this.queryType_ = 0;
            this.outlierScore_ = 0.0;
            this.outlierThreshold_ = 0.0;
            return this;
        }

        public Descriptors.Descriptor getDescriptorForType() {
            return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_descriptor;
        }

        public ErrorAnalysisAnnotation getDefaultInstanceForType() {
            return ErrorAnalysisAnnotation.getDefaultInstance();
        }

        public ErrorAnalysisAnnotation build() {
            ErrorAnalysisAnnotation result = this.buildPartial();
            if (!result.isInitialized()) {
                throw Builder.newUninitializedMessageException((Message)result);
            }
            return result;
        }

        public ErrorAnalysisAnnotation buildPartial() {
            ErrorAnalysisAnnotation result = new ErrorAnalysisAnnotation(this);
            this.buildPartialRepeatedFields(result);
            if (this.bitField0_ != 0) {
                this.buildPartial0(result);
            }
            this.onBuilt();
            return result;
        }

        private void buildPartialRepeatedFields(ErrorAnalysisAnnotation result) {
            if (this.attributedItemsBuilder_ == null) {
                if ((this.bitField0_ & 1) != 0) {
                    this.attributedItems_ = Collections.unmodifiableList(this.attributedItems_);
                    this.bitField0_ &= 0xFFFFFFFE;
                }
                result.attributedItems_ = this.attributedItems_;
            } else {
                result.attributedItems_ = this.attributedItemsBuilder_.build();
            }
        }

        private void buildPartial0(ErrorAnalysisAnnotation result) {
            int from_bitField0_ = this.bitField0_;
            if ((from_bitField0_ & 2) != 0) {
                result.queryType_ = this.queryType_;
            }
            if ((from_bitField0_ & 4) != 0) {
                result.outlierScore_ = this.outlierScore_;
            }
            if ((from_bitField0_ & 8) != 0) {
                result.outlierThreshold_ = this.outlierThreshold_;
            }
        }

        public Builder clone() {
            return (Builder)super.clone();
        }

        public Builder setField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.setField(field, value);
        }

        public Builder clearField(Descriptors.FieldDescriptor field) {
            return (Builder)super.clearField(field);
        }

        public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
            return (Builder)super.clearOneof(oneof);
        }

        public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
            return (Builder)super.setRepeatedField(field, index, value);
        }

        public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
            return (Builder)super.addRepeatedField(field, value);
        }

        public Builder mergeFrom(Message other) {
            if (other instanceof ErrorAnalysisAnnotation) {
                return this.mergeFrom((ErrorAnalysisAnnotation)other);
            }
            super.mergeFrom(other);
            return this;
        }

        public Builder mergeFrom(ErrorAnalysisAnnotation other) {
            if (other == ErrorAnalysisAnnotation.getDefaultInstance()) {
                return this;
            }
            if (this.attributedItemsBuilder_ == null) {
                if (!other.attributedItems_.isEmpty()) {
                    if (this.attributedItems_.isEmpty()) {
                        this.attributedItems_ = other.attributedItems_;
                        this.bitField0_ &= 0xFFFFFFFE;
                    } else {
                        this.ensureAttributedItemsIsMutable();
                        this.attributedItems_.addAll(other.attributedItems_);
                    }
                    this.onChanged();
                }
            } else if (!other.attributedItems_.isEmpty()) {
                if (this.attributedItemsBuilder_.isEmpty()) {
                    this.attributedItemsBuilder_.dispose();
                    this.attributedItemsBuilder_ = null;
                    this.attributedItems_ = other.attributedItems_;
                    this.bitField0_ &= 0xFFFFFFFE;
                    this.attributedItemsBuilder_ = alwaysUseFieldBuilders ? this.getAttributedItemsFieldBuilder() : null;
                } else {
                    this.attributedItemsBuilder_.addAllMessages((Iterable)other.attributedItems_);
                }
            }
            if (other.queryType_ != 0) {
                this.setQueryTypeValue(other.getQueryTypeValue());
            }
            if (other.getOutlierScore() != 0.0) {
                this.setOutlierScore(other.getOutlierScore());
            }
            if (other.getOutlierThreshold() != 0.0) {
                this.setOutlierThreshold(other.getOutlierThreshold());
            }
            this.mergeUnknownFields(other.getUnknownFields());
            this.onChanged();
            return this;
        }

        public final boolean isInitialized() {
            return true;
        }

        public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            if (extensionRegistry == null) {
                throw new NullPointerException();
            }
            try {
                boolean done = false;
                block12: while (!done) {
                    int tag = input.readTag();
                    switch (tag) {
                        case 0: {
                            done = true;
                            continue block12;
                        }
                        case 10: {
                            AttributedItem m = (AttributedItem)input.readMessage(AttributedItem.parser(), extensionRegistry);
                            if (this.attributedItemsBuilder_ == null) {
                                this.ensureAttributedItemsIsMutable();
                                this.attributedItems_.add(m);
                                continue block12;
                            }
                            this.attributedItemsBuilder_.addMessage((AbstractMessage)m);
                            continue block12;
                        }
                        case 16: {
                            this.queryType_ = input.readEnum();
                            this.bitField0_ |= 2;
                            continue block12;
                        }
                        case 25: {
                            this.outlierScore_ = input.readDouble();
                            this.bitField0_ |= 4;
                            continue block12;
                        }
                        case 33: {
                            this.outlierThreshold_ = input.readDouble();
                            this.bitField0_ |= 8;
                            continue block12;
                        }
                    }
                    if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                    done = true;
                }
            }
            catch (InvalidProtocolBufferException e) {
                throw e.unwrapIOException();
            }
            finally {
                this.onChanged();
            }
            return this;
        }

        private void ensureAttributedItemsIsMutable() {
            if ((this.bitField0_ & 1) == 0) {
                this.attributedItems_ = new ArrayList<AttributedItem>(this.attributedItems_);
                this.bitField0_ |= 1;
            }
        }

        @Override
        public List<AttributedItem> getAttributedItemsList() {
            if (this.attributedItemsBuilder_ == null) {
                return Collections.unmodifiableList(this.attributedItems_);
            }
            return this.attributedItemsBuilder_.getMessageList();
        }

        @Override
        public int getAttributedItemsCount() {
            if (this.attributedItemsBuilder_ == null) {
                return this.attributedItems_.size();
            }
            return this.attributedItemsBuilder_.getCount();
        }

        @Override
        public AttributedItem getAttributedItems(int index) {
            if (this.attributedItemsBuilder_ == null) {
                return this.attributedItems_.get(index);
            }
            return (AttributedItem)this.attributedItemsBuilder_.getMessage(index);
        }

        public Builder setAttributedItems(int index, AttributedItem value) {
            if (this.attributedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.set(index, value);
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.setMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder setAttributedItems(int index, AttributedItem.Builder builderForValue) {
            if (this.attributedItemsBuilder_ == null) {
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.set(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.setMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributedItems(AttributedItem value) {
            if (this.attributedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.add(value);
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.addMessage((AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributedItems(int index, AttributedItem value) {
            if (this.attributedItemsBuilder_ == null) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.add(index, value);
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.addMessage(index, (AbstractMessage)value);
            }
            return this;
        }

        public Builder addAttributedItems(AttributedItem.Builder builderForValue) {
            if (this.attributedItemsBuilder_ == null) {
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.add(builderForValue.build());
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.addMessage((AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAttributedItems(int index, AttributedItem.Builder builderForValue) {
            if (this.attributedItemsBuilder_ == null) {
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.add(index, builderForValue.build());
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.addMessage(index, (AbstractMessage)builderForValue.build());
            }
            return this;
        }

        public Builder addAllAttributedItems(Iterable<? extends AttributedItem> values) {
            if (this.attributedItemsBuilder_ == null) {
                this.ensureAttributedItemsIsMutable();
                AbstractMessageLite.Builder.addAll(values, this.attributedItems_);
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.addAllMessages(values);
            }
            return this;
        }

        public Builder clearAttributedItems() {
            if (this.attributedItemsBuilder_ == null) {
                this.attributedItems_ = Collections.emptyList();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.clear();
            }
            return this;
        }

        public Builder removeAttributedItems(int index) {
            if (this.attributedItemsBuilder_ == null) {
                this.ensureAttributedItemsIsMutable();
                this.attributedItems_.remove(index);
                this.onChanged();
            } else {
                this.attributedItemsBuilder_.remove(index);
            }
            return this;
        }

        public AttributedItem.Builder getAttributedItemsBuilder(int index) {
            return (AttributedItem.Builder)this.getAttributedItemsFieldBuilder().getBuilder(index);
        }

        @Override
        public AttributedItemOrBuilder getAttributedItemsOrBuilder(int index) {
            if (this.attributedItemsBuilder_ == null) {
                return this.attributedItems_.get(index);
            }
            return (AttributedItemOrBuilder)this.attributedItemsBuilder_.getMessageOrBuilder(index);
        }

        @Override
        public List<? extends AttributedItemOrBuilder> getAttributedItemsOrBuilderList() {
            if (this.attributedItemsBuilder_ != null) {
                return this.attributedItemsBuilder_.getMessageOrBuilderList();
            }
            return Collections.unmodifiableList(this.attributedItems_);
        }

        public AttributedItem.Builder addAttributedItemsBuilder() {
            return (AttributedItem.Builder)this.getAttributedItemsFieldBuilder().addBuilder((AbstractMessage)AttributedItem.getDefaultInstance());
        }

        public AttributedItem.Builder addAttributedItemsBuilder(int index) {
            return (AttributedItem.Builder)this.getAttributedItemsFieldBuilder().addBuilder(index, (AbstractMessage)AttributedItem.getDefaultInstance());
        }

        public List<AttributedItem.Builder> getAttributedItemsBuilderList() {
            return this.getAttributedItemsFieldBuilder().getBuilderList();
        }

        private RepeatedFieldBuilderV3<AttributedItem, AttributedItem.Builder, AttributedItemOrBuilder> getAttributedItemsFieldBuilder() {
            if (this.attributedItemsBuilder_ == null) {
                this.attributedItemsBuilder_ = new RepeatedFieldBuilderV3(this.attributedItems_, (this.bitField0_ & 1) != 0, (AbstractMessage.BuilderParent)this.getParentForChildren(), this.isClean());
                this.attributedItems_ = null;
            }
            return this.attributedItemsBuilder_;
        }

        @Override
        public int getQueryTypeValue() {
            return this.queryType_;
        }

        public Builder setQueryTypeValue(int value) {
            this.queryType_ = value;
            this.bitField0_ |= 2;
            this.onChanged();
            return this;
        }

        @Override
        public QueryType getQueryType() {
            QueryType result = QueryType.forNumber(this.queryType_);
            return result == null ? QueryType.UNRECOGNIZED : result;
        }

        public Builder setQueryType(QueryType value) {
            if (value == null) {
                throw new NullPointerException();
            }
            this.bitField0_ |= 2;
            this.queryType_ = value.getNumber();
            this.onChanged();
            return this;
        }

        public Builder clearQueryType() {
            this.bitField0_ &= 0xFFFFFFFD;
            this.queryType_ = 0;
            this.onChanged();
            return this;
        }

        @Override
        public double getOutlierScore() {
            return this.outlierScore_;
        }

        public Builder setOutlierScore(double value) {
            this.outlierScore_ = value;
            this.bitField0_ |= 4;
            this.onChanged();
            return this;
        }

        public Builder clearOutlierScore() {
            this.bitField0_ &= 0xFFFFFFFB;
            this.outlierScore_ = 0.0;
            this.onChanged();
            return this;
        }

        @Override
        public double getOutlierThreshold() {
            return this.outlierThreshold_;
        }

        public Builder setOutlierThreshold(double value) {
            this.outlierThreshold_ = value;
            this.bitField0_ |= 8;
            this.onChanged();
            return this;
        }

        public Builder clearOutlierThreshold() {
            this.bitField0_ &= 0xFFFFFFF7;
            this.outlierThreshold_ = 0.0;
            this.onChanged();
            return this;
        }

        public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.setUnknownFields(unknownFields);
        }

        public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
            return (Builder)super.mergeUnknownFields(unknownFields);
        }
    }

    public static final class AttributedItem
    extends GeneratedMessageV3
    implements AttributedItemOrBuilder {
        private static final long serialVersionUID = 0L;
        public static final int ANNOTATION_RESOURCE_NAME_FIELD_NUMBER = 1;
        private volatile Object annotationResourceName_ = "";
        public static final int DISTANCE_FIELD_NUMBER = 2;
        private double distance_ = 0.0;
        private byte memoizedIsInitialized = (byte)-1;
        private static final AttributedItem DEFAULT_INSTANCE = new AttributedItem();
        private static final Parser<AttributedItem> PARSER = new AbstractParser<AttributedItem>(){

            public AttributedItem parsePartialFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
                Builder builder = AttributedItem.newBuilder();
                try {
                    builder.mergeFrom(input, extensionRegistry);
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (UninitializedMessageException e) {
                    throw e.asInvalidProtocolBufferException().setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                catch (IOException e) {
                    throw new InvalidProtocolBufferException(e).setUnfinishedMessage((MessageLite)builder.buildPartial());
                }
                return builder.buildPartial();
            }
        };

        private AttributedItem(GeneratedMessageV3.Builder<?> builder) {
            super(builder);
        }

        private AttributedItem() {
            this.annotationResourceName_ = "";
        }

        protected Object newInstance(GeneratedMessageV3.UnusedPrivateParameter unused) {
            return new AttributedItem();
        }

        public final UnknownFieldSet getUnknownFields() {
            return this.unknownFields;
        }

        public static final Descriptors.Descriptor getDescriptor() {
            return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
        }

        protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
            return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_fieldAccessorTable.ensureFieldAccessorsInitialized(AttributedItem.class, Builder.class);
        }

        @Override
        public String getAnnotationResourceName() {
            Object ref = this.annotationResourceName_;
            if (ref instanceof String) {
                return (String)ref;
            }
            ByteString bs = (ByteString)ref;
            String s = bs.toStringUtf8();
            this.annotationResourceName_ = s;
            return s;
        }

        @Override
        public ByteString getAnnotationResourceNameBytes() {
            Object ref = this.annotationResourceName_;
            if (ref instanceof String) {
                ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                this.annotationResourceName_ = b;
                return b;
            }
            return (ByteString)ref;
        }

        @Override
        public double getDistance() {
            return this.distance_;
        }

        public final boolean isInitialized() {
            byte isInitialized = this.memoizedIsInitialized;
            if (isInitialized == 1) {
                return true;
            }
            if (isInitialized == 0) {
                return false;
            }
            this.memoizedIsInitialized = 1;
            return true;
        }

        public void writeTo(CodedOutputStream output) throws IOException {
            if (!GeneratedMessageV3.isStringEmpty((Object)this.annotationResourceName_)) {
                GeneratedMessageV3.writeString((CodedOutputStream)output, (int)1, (Object)this.annotationResourceName_);
            }
            if (Double.doubleToRawLongBits(this.distance_) != 0L) {
                output.writeDouble(2, this.distance_);
            }
            this.getUnknownFields().writeTo(output);
        }

        public int getSerializedSize() {
            int size = this.memoizedSize;
            if (size != -1) {
                return size;
            }
            size = 0;
            if (!GeneratedMessageV3.isStringEmpty((Object)this.annotationResourceName_)) {
                size += GeneratedMessageV3.computeStringSize((int)1, (Object)this.annotationResourceName_);
            }
            if (Double.doubleToRawLongBits(this.distance_) != 0L) {
                size += CodedOutputStream.computeDoubleSize((int)2, (double)this.distance_);
            }
            this.memoizedSize = size += this.getUnknownFields().getSerializedSize();
            return size;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (!(obj instanceof AttributedItem)) {
                return super.equals(obj);
            }
            AttributedItem other = (AttributedItem)obj;
            if (!this.getAnnotationResourceName().equals(other.getAnnotationResourceName())) {
                return false;
            }
            if (Double.doubleToLongBits(this.getDistance()) != Double.doubleToLongBits(other.getDistance())) {
                return false;
            }
            return this.getUnknownFields().equals((Object)other.getUnknownFields());
        }

        public int hashCode() {
            if (this.memoizedHashCode != 0) {
                return this.memoizedHashCode;
            }
            int hash = 41;
            hash = 19 * hash + AttributedItem.getDescriptor().hashCode();
            hash = 37 * hash + 1;
            hash = 53 * hash + this.getAnnotationResourceName().hashCode();
            hash = 37 * hash + 2;
            hash = 53 * hash + Internal.hashLong((long)Double.doubleToLongBits(this.getDistance()));
            this.memoizedHashCode = hash = 29 * hash + this.getUnknownFields().hashCode();
            return hash;
        }

        public static AttributedItem parseFrom(ByteBuffer data) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data);
        }

        public static AttributedItem parseFrom(ByteBuffer data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AttributedItem parseFrom(ByteString data) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data);
        }

        public static AttributedItem parseFrom(ByteString data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AttributedItem parseFrom(byte[] data) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data);
        }

        public static AttributedItem parseFrom(byte[] data, ExtensionRegistryLite extensionRegistry) throws InvalidProtocolBufferException {
            return (AttributedItem)PARSER.parseFrom(data, extensionRegistry);
        }

        public static AttributedItem parseFrom(InputStream input) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input);
        }

        public static AttributedItem parseFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AttributedItem parseDelimitedFrom(InputStream input) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input);
        }

        public static AttributedItem parseDelimitedFrom(InputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseDelimitedWithIOException(PARSER, (InputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public static AttributedItem parseFrom(CodedInputStream input) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input);
        }

        public static AttributedItem parseFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
            return (AttributedItem)GeneratedMessageV3.parseWithIOException(PARSER, (CodedInputStream)input, (ExtensionRegistryLite)extensionRegistry);
        }

        public Builder newBuilderForType() {
            return AttributedItem.newBuilder();
        }

        public static Builder newBuilder() {
            return DEFAULT_INSTANCE.toBuilder();
        }

        public static Builder newBuilder(AttributedItem prototype) {
            return DEFAULT_INSTANCE.toBuilder().mergeFrom(prototype);
        }

        public Builder toBuilder() {
            return this == DEFAULT_INSTANCE ? new Builder() : new Builder().mergeFrom(this);
        }

        protected Builder newBuilderForType(GeneratedMessageV3.BuilderParent parent) {
            Builder builder = new Builder(parent);
            return builder;
        }

        public static AttributedItem getDefaultInstance() {
            return DEFAULT_INSTANCE;
        }

        public static Parser<AttributedItem> parser() {
            return PARSER;
        }

        public Parser<AttributedItem> getParserForType() {
            return PARSER;
        }

        public AttributedItem getDefaultInstanceForType() {
            return DEFAULT_INSTANCE;
        }

        public static final class Builder
        extends GeneratedMessageV3.Builder<Builder>
        implements AttributedItemOrBuilder {
            private int bitField0_;
            private Object annotationResourceName_ = "";
            private double distance_;

            public static final Descriptors.Descriptor getDescriptor() {
                return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
            }

            protected GeneratedMessageV3.FieldAccessorTable internalGetFieldAccessorTable() {
                return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_fieldAccessorTable.ensureFieldAccessorsInitialized(AttributedItem.class, Builder.class);
            }

            private Builder() {
            }

            private Builder(GeneratedMessageV3.BuilderParent parent) {
                super(parent);
            }

            public Builder clear() {
                super.clear();
                this.bitField0_ = 0;
                this.annotationResourceName_ = "";
                this.distance_ = 0.0;
                return this;
            }

            public Descriptors.Descriptor getDescriptorForType() {
                return EvaluatedAnnotationProto.internal_static_google_cloud_aiplatform_v1_ErrorAnalysisAnnotation_AttributedItem_descriptor;
            }

            public AttributedItem getDefaultInstanceForType() {
                return AttributedItem.getDefaultInstance();
            }

            public AttributedItem build() {
                AttributedItem result = this.buildPartial();
                if (!result.isInitialized()) {
                    throw Builder.newUninitializedMessageException((Message)result);
                }
                return result;
            }

            public AttributedItem buildPartial() {
                AttributedItem result = new AttributedItem(this);
                if (this.bitField0_ != 0) {
                    this.buildPartial0(result);
                }
                this.onBuilt();
                return result;
            }

            private void buildPartial0(AttributedItem result) {
                int from_bitField0_ = this.bitField0_;
                if ((from_bitField0_ & 1) != 0) {
                    result.annotationResourceName_ = this.annotationResourceName_;
                }
                if ((from_bitField0_ & 2) != 0) {
                    result.distance_ = this.distance_;
                }
            }

            public Builder clone() {
                return (Builder)super.clone();
            }

            public Builder setField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.setField(field, value);
            }

            public Builder clearField(Descriptors.FieldDescriptor field) {
                return (Builder)super.clearField(field);
            }

            public Builder clearOneof(Descriptors.OneofDescriptor oneof) {
                return (Builder)super.clearOneof(oneof);
            }

            public Builder setRepeatedField(Descriptors.FieldDescriptor field, int index, Object value) {
                return (Builder)super.setRepeatedField(field, index, value);
            }

            public Builder addRepeatedField(Descriptors.FieldDescriptor field, Object value) {
                return (Builder)super.addRepeatedField(field, value);
            }

            public Builder mergeFrom(Message other) {
                if (other instanceof AttributedItem) {
                    return this.mergeFrom((AttributedItem)other);
                }
                super.mergeFrom(other);
                return this;
            }

            public Builder mergeFrom(AttributedItem other) {
                if (other == AttributedItem.getDefaultInstance()) {
                    return this;
                }
                if (!other.getAnnotationResourceName().isEmpty()) {
                    this.annotationResourceName_ = other.annotationResourceName_;
                    this.bitField0_ |= 1;
                    this.onChanged();
                }
                if (other.getDistance() != 0.0) {
                    this.setDistance(other.getDistance());
                }
                this.mergeUnknownFields(other.getUnknownFields());
                this.onChanged();
                return this;
            }

            public final boolean isInitialized() {
                return true;
            }

            public Builder mergeFrom(CodedInputStream input, ExtensionRegistryLite extensionRegistry) throws IOException {
                if (extensionRegistry == null) {
                    throw new NullPointerException();
                }
                try {
                    boolean done = false;
                    block10: while (!done) {
                        int tag = input.readTag();
                        switch (tag) {
                            case 0: {
                                done = true;
                                continue block10;
                            }
                            case 10: {
                                this.annotationResourceName_ = input.readStringRequireUtf8();
                                this.bitField0_ |= 1;
                                continue block10;
                            }
                            case 17: {
                                this.distance_ = input.readDouble();
                                this.bitField0_ |= 2;
                                continue block10;
                            }
                        }
                        if (super.parseUnknownField(input, extensionRegistry, tag)) continue;
                        done = true;
                    }
                }
                catch (InvalidProtocolBufferException e) {
                    throw e.unwrapIOException();
                }
                finally {
                    this.onChanged();
                }
                return this;
            }

            @Override
            public String getAnnotationResourceName() {
                Object ref = this.annotationResourceName_;
                if (!(ref instanceof String)) {
                    ByteString bs = (ByteString)ref;
                    String s = bs.toStringUtf8();
                    this.annotationResourceName_ = s;
                    return s;
                }
                return (String)ref;
            }

            @Override
            public ByteString getAnnotationResourceNameBytes() {
                Object ref = this.annotationResourceName_;
                if (ref instanceof String) {
                    ByteString b = ByteString.copyFromUtf8((String)((String)ref));
                    this.annotationResourceName_ = b;
                    return b;
                }
                return (ByteString)ref;
            }

            public Builder setAnnotationResourceName(String value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                this.annotationResourceName_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            public Builder clearAnnotationResourceName() {
                this.annotationResourceName_ = AttributedItem.getDefaultInstance().getAnnotationResourceName();
                this.bitField0_ &= 0xFFFFFFFE;
                this.onChanged();
                return this;
            }

            public Builder setAnnotationResourceNameBytes(ByteString value) {
                if (value == null) {
                    throw new NullPointerException();
                }
                AttributedItem.checkByteStringIsUtf8((ByteString)value);
                this.annotationResourceName_ = value;
                this.bitField0_ |= 1;
                this.onChanged();
                return this;
            }

            @Override
            public double getDistance() {
                return this.distance_;
            }

            public Builder setDistance(double value) {
                this.distance_ = value;
                this.bitField0_ |= 2;
                this.onChanged();
                return this;
            }

            public Builder clearDistance() {
                this.bitField0_ &= 0xFFFFFFFD;
                this.distance_ = 0.0;
                this.onChanged();
                return this;
            }

            public final Builder setUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.setUnknownFields(unknownFields);
            }

            public final Builder mergeUnknownFields(UnknownFieldSet unknownFields) {
                return (Builder)super.mergeUnknownFields(unknownFields);
            }
        }
    }

    public static interface AttributedItemOrBuilder
    extends MessageOrBuilder {
        public String getAnnotationResourceName();

        public ByteString getAnnotationResourceNameBytes();

        public double getDistance();
    }

    public static enum QueryType implements ProtocolMessageEnum
    {
        QUERY_TYPE_UNSPECIFIED(0),
        ALL_SIMILAR(1),
        SAME_CLASS_SIMILAR(2),
        SAME_CLASS_DISSIMILAR(3),
        UNRECOGNIZED(-1);

        public static final int QUERY_TYPE_UNSPECIFIED_VALUE = 0;
        public static final int ALL_SIMILAR_VALUE = 1;
        public static final int SAME_CLASS_SIMILAR_VALUE = 2;
        public static final int SAME_CLASS_DISSIMILAR_VALUE = 3;
        private static final Internal.EnumLiteMap<QueryType> internalValueMap;
        private static final QueryType[] VALUES;
        private final int value;

        public final int getNumber() {
            if (this == UNRECOGNIZED) {
                throw new IllegalArgumentException("Can't get the number of an unknown enum value.");
            }
            return this.value;
        }

        @Deprecated
        public static QueryType valueOf(int value) {
            return QueryType.forNumber(value);
        }

        public static QueryType forNumber(int value) {
            switch (value) {
                case 0: {
                    return QUERY_TYPE_UNSPECIFIED;
                }
                case 1: {
                    return ALL_SIMILAR;
                }
                case 2: {
                    return SAME_CLASS_SIMILAR;
                }
                case 3: {
                    return SAME_CLASS_DISSIMILAR;
                }
            }
            return null;
        }

        public static Internal.EnumLiteMap<QueryType> internalGetValueMap() {
            return internalValueMap;
        }

        public final Descriptors.EnumValueDescriptor getValueDescriptor() {
            if (this == UNRECOGNIZED) {
                throw new IllegalStateException("Can't get the descriptor of an unrecognized enum value.");
            }
            return (Descriptors.EnumValueDescriptor)QueryType.getDescriptor().getValues().get(this.ordinal());
        }

        public final Descriptors.EnumDescriptor getDescriptorForType() {
            return QueryType.getDescriptor();
        }

        public static final Descriptors.EnumDescriptor getDescriptor() {
            return (Descriptors.EnumDescriptor)ErrorAnalysisAnnotation.getDescriptor().getEnumTypes().get(0);
        }

        public static QueryType valueOf(Descriptors.EnumValueDescriptor desc) {
            if (desc.getType() != QueryType.getDescriptor()) {
                throw new IllegalArgumentException("EnumValueDescriptor is not for this type.");
            }
            if (desc.getIndex() == -1) {
                return UNRECOGNIZED;
            }
            return VALUES[desc.getIndex()];
        }

        private QueryType(int value) {
            this.value = value;
        }

        static {
            internalValueMap = new Internal.EnumLiteMap<QueryType>(){

                public QueryType findValueByNumber(int number) {
                    return QueryType.forNumber(number);
                }
            };
            VALUES = QueryType.values();
        }
    }
}

